
--- Please follow the below comments to insert SQL statements.

--------- BEGIN - GENERATED CODE, PLEASE DO NOT MODIFY ---------

SET NOCOUNT ON

DECLARE @LogDate AS BIGINT = dbo.GetUnixTime(GETUTCDATE())
DECLARE @queryId AS INTEGER = 160
DECLARE @surveyXML NVARCHAR(MAX)

--------- END - GENERATED CODE ---------


--------- BEGIN SURVEY QUERY ---------
--------- Insert your SQL statements here 
-- Gives full and Non-full backup Info about each agent for past 6 weeks.

CREATE TABLE #TblURL (WebConsoleURL NVARCHAR(MAX), CommcellConsoleURL NVARCHAR(MAX))

IF EXISTS (SELECT 1 FROM APP_Client WHERE id = 2 AND ReleaseId < 15)
       INSERT INTO #TblURL
       SELECT (SELECT TOP 1 CAST(value AS NVARCHAR(MAX)) FROM GXGlobalParam WHERE name = 'WebConsoleURL' AND LEN(CAST(value AS NVARCHAR(MAX))) > 0),
              (SELECT TOP 1 CAST(value AS NVARCHAR(MAX)) FROM GXGlobalParam WHERE name = 'CommcellConsoleUrl' AND LEN(CAST(value AS NVARCHAR(MAX))) > 0)
ELSE
       EXEC sp_executesql N'INSERT INTO #TblURL\
       SELECT (SELECT TOP 1 value FROM GXGlobalParam WHERE name = ''WebConsoleURL'' AND LEN(value) > 0 AND Modified = 0),\
              (SELECT TOP 1 value FROM GXGlobalParam WHERE name = ''CommcellConsoleUrl'' AND LEN(value) > 0 AND Modified = 0)' 

SET @surveyXML = (
       SELECT SUBSTRING(WebConsoleURL, 0, PATINDEX('%webconsole%', WebConsoleURL) + LEN('webconsole')) AS '@URL',
              SUBSTRING(CommcellConsoleURL, 0, PATINDEX('%console%', CommcellConsoleURL) + LEN('console')) AS '@CommcellConsoleURL'
       FROM   #TblURL
       FOR XML PATH('WebConsole')
)

DROP TABLE #TblURL


--------- END SURVEY QUERY ---------

--------- BEGIN - GENERATED CODE, PLEASE DO NOT MODIFY ---------

DECLARE @EndTime AS BIGINT = dbo.GetUnixTime(GETUTCDATE())
SET @outputXML = 
(
	SELECT
		@queryId AS '@QueryId',
		@EndTime AS '@LogDate',
		(@EndTime - @LogDate) AS '@QueryRunningTime',
		@surveyXML
	FOR XML PATH('Rpt_CSSXMLDATA')
)

SET NOCOUNT OFF

--------- END - GENERATED CODE ---------	
