--- Please follow the below comments to insert SQL statements.
-- Client version query
--------- BEGIN - GENERATED CODE, PLEASE DO NOT MODIFY ---------

SET NOCOUNT ON

DECLARE @LogDate AS BIGINT = dbo.GetUnixTime(GETUTCDATE())
DECLARE @queryId AS INTEGER = 117
DECLARE @surveyXML  NVARCHAR(MAX)

--------- END - GENERATED CODE ---------



--------- BEGIN SURVEY QUERY ---------

--------- Insert your SQL statements here 
DECLARE @diff INT = DATEDIFF(SECOND, GETUTCDATE(), GETDATE())
DECLARE @tempCostCategory XML 
DECLARE @tempCostCategory1 NVARCHAR(MAX) 
DECLARE @csReleaseId INT = (SELECT releaseId FROM APP_Client WITH (NOLOCK) WHERE id = 2)

IF OBJECT_ID('tempdb..#DisksPerMA') IS NOT NULL DROP TABLE #DisksPerMA
IF OBJECT_ID('tempdb..#LibraryMA') IS NOT NULL DROP TABLE #LibraryMA
IF OBJECT_ID('tempdb..#StoragePoolMA') IS NOT NULL DROP TABLE #StoragePoolMA
IF OBJECT_ID('tempdb..#HyperScaleMediaSide') IS NOT NULL DROP TABLE #HyperScaleMediaSide
IF OBJECT_ID('tempdb..#HyperScaleUsage') IS NOT NULL DROP TABLE #HyperScaleUsage
IF OBJECT_ID('tempdb..#HyperScaleJobs') IS NOT NULL DROP TABLE #HyperScaleJobs
IF OBJECT_ID('tempdb..#MountPathProp') IS NOT NULL DROP TABLE #MountPathProp
IF OBJECT_ID('tempdb..#MountPathSize') IS NOT NULL DROP TABLE #MountPathSize
IF OBJECT_ID('tempdb..#LibraryHardDrive') IS NOT NULL DROP TABLE #LibraryHardDrive

CREATE TABLE #DisksPerMA (MediaAgentId INT, NumOfDisks INT)
CREATE TABLE #LibraryMA (LibraryId INT, MediaAgent NVARCHAR(256))
CREATE TABLE #StoragePoolMA (StoragePoolId INT, LibraryId INT, MediaAgentId INT, MediaAgent NVARCHAR(256))
CREATE TABLE #HyperScaleMediaSide (ApplianceType INT, StoragePoolId INT, LibraryId INT, MediaSideId INT, HyperScaleVersion INT)
CREATE TABLE #HyperScaleUsage (ApplianceType INT, NumStoragePools INT, NumMediaAgents INT, 
	TotalSpaceMB BIGINT, FreeSpaceMB BIGINT, DataWrittenMB BIGINT, NumClients INT, NumVMs INT, NumMAs1To12Disks INT, NumMAs13To24Disks INT, HyperScaleVersion INT)
CREATE TABLE #HyperScaleJobs (ApplianceType INT, jobId INT, commCellId INT, HyperScaleVersion INT)

CREATE TABLE #MountPathProp (LibraryId INT, MediaSideId INT, MountPathId INT, MountPathName NVARCHAR(1024), BaseFolder NVARCHAR(1024), DeviceName NVARCHAR(128),
	IsEnabled INT, IsOffline INT, OfflineReason INT, OfflineTimeStamp INT,
	MaxConcurrentWriters INT, TotalSpaceMB BIGINT, FreeBytesMB BIGINT, MagneticSpaceRsrvInMB BIGINT)

CREATE TABLE #MountPathSize (MediaSideId INT, DataWrittenMB BIGINT)

CREATE TABLE #LibraryHardDrive (LibraryId INT, MediaSideId INT, TotalSpaceMB BIGINT, FreeBytesMB BIGINT, FreeBytesMBRange BIGINT, HardDrive NVARCHAR(1024), RowId INT, Shared INT)

DECLARE @RangeMB INT = 250
DECLARE @UpdateCloudMountPathSize INT = 0
DECLARE @MountPathsNotShareDiskSpace INT = 0

SELECT	@UpdateCloudMountPathSize = value FROM MMConfigs WITH(NOLOCK) WHERE name = 'MMCONFIG_INCLUDE_CLOUD_MOUNTPATHS_FOR_SIZE_UPDATES'
SELECT  @MountPathsNotShareDiskSpace = value FROM MMConfigs WITH(NOLOCK) WHERE name = 'MMCONFIG_MOUNTPATHS_DONOT_SHARE_DISK_SPACE'

IF @csReleaseId >= 15
    INSERT  INTO #MountPathProp
    SELECT  L.LibraryId,
            MS.MediaSideId,
            MP.MountPathId,
            MP.MountPathName,
            MPT.MountPathName,
            (SELECT AliasName FROM MMDevice WHERE DeviceId = MP.DeviceId),
            MP.IsEnabled,
            ((1 - MP.IsEnabled) | MP.IsOffline),
            CASE WHEN MP.IsEnabled = 0 THEN 2 ELSE MP.OfflineReason END,
            CASE WHEN MP.OfflineTimeStamp > 0 THEN MP.OfflineTimeStamp + @diff ELSE 0 END,
            MP.MaxConcurrentWriters,
            CASE WHEN MP.MountPathTypeId = 7 AND MP.MaxDataToWriteMB > 0 AND @UpdateCloudMountPathSize = 1 THEN CAST(MP.MaxDataToWriteMB AS BIGINT) 
                 WHEN MP.MountPathTypeId = 7 AND MS.TotalSpaceMB = 1048576 THEN -1 ELSE MS.TotalSpaceMB END,
            CASE WHEN MP.MountPathTypeId = 7 AND MS.TotalSpaceMB = 1048576 THEN -1 ELSE MS.FreeBytesMB END,
            MP.MagneticSpaceRsrvInMB
    FROM    MMS2getMountPathNameGUIView MP WITH (NOLOCK)
			INNER JOIN MMMountPath MPT WITH (NOLOCK) ON MP.MountPathId = MPT.MountPathId
            INNER JOIN MMLibrary L WITH (NOLOCK) ON MP.LibraryId = L.LibraryId
            INNER JOIN MMMediaSide MS WITH (NOLOCK) ON MP.MediaSideId = MS.MediaSideId
    WHERE   MP.MountPathId > 0 AND MP.MountPathName <> 'CVDiskFolder' AND L.LibraryId > 0 AND L.LibraryTypeId != 8
ELSE
    INSERT  INTO #MountPathProp
    SELECT  L.LibraryId,
            MS.MediaSideId,
            MP.MountPathId,
            CASE 
                WHEN MP.MountPathTypeId = 1
                THEN ISNULL((SELECT TOP 1 A.FriendlyName 
                            FROM MMCenteraInfo A WITH (NOLOCK)
                            INNER JOIN MMMountPathToStorageDevice B WITH (NOLOCK) ON A.CenteraId = B.CenteraId 
                            WHERE B.MountPathId = MP.MountPathId), 'Unavailable')
                WHEN MP.MountPathTypeId IN (4, 5, 7) AND S.MountPathId IS NOT NULL
                THEN S.Folder
                ELSE MP.MountPathName
            END,
            MP.MountPathName,
            (SELECT AliasName FROM MMDevice WHERE DeviceId = S.DeviceId),
            MP.IsEnabled,
            ((1 - MP.IsEnabled) | MP.IsOffline),
            CASE WHEN MP.IsEnabled = 0 THEN 2 ELSE MP.OfflineReason END,
            CASE WHEN MP.OfflineTimeStamp > 0 THEN MP.OfflineTimeStamp + @diff ELSE 0 END,
            MP.MaxConcurrentWriters,
            CASE WHEN MP.MountPathTypeId = 7 AND MS.TotalSpaceMB = 1048576 THEN -1 ELSE MS.TotalSpaceMB END,
            CASE WHEN MP.MountPathTypeId = 7 AND MS.TotalSpaceMB = 1048576 THEN -1 ELSE MS.FreeBytesMB END,
            MP.MagneticSpaceRsrvInMB
    FROM    MMMountPath MP WITH (NOLOCK)
            INNER JOIN MMLibrary L WITH (NOLOCK) ON MP.LibraryId = L.LibraryId
            INNER JOIN MMMediaSide MS WITH (NOLOCK) ON MP.MediaSideId = MS.MediaSideId
            LEFT OUTER JOIN (
                SELECT  c.MountPathId, DC.DeviceId, DC.Folder
                FROM    (SELECT a.MountPathId, a.DeviceId
                        FROM    MMMountPathToStorageDevice a WITH (NOLOCK),
                                MMDeviceController b WITH (NOLOCK)
                        WHERE   a.DeviceId = b.DeviceId
                        GROUP BY a.MountPathId, a.DeviceId
                        HAVING COUNT(b.DeviceControllerId) = 1) c
                        INNER JOIN MMDeviceController DC WITH (NOLOCK) ON DC.DeviceId = c.DeviceId
                ) S ON S.MountPathId = MP.MountPathId
    WHERE   MP.MountPathId > 0 AND MP.MountPathName <> 'CVDiskFolder' AND L.LibraryId > 0 AND L.LibraryTypeId != 8

UPDATE	MP SET IsOffline |= 1, OfflineReason = CASE WHEN MP.OfflineReason NOT IN (2,4) THEN 4 ELSE MP.OfflineReason END
FROM	#MountPathProp MP
        INNER JOIN (
            SELECT  a.MountPathId, 
                    MAX((1-b.DeviceControllerEnabled) | (1-b.DeviceAccessible) | (1-c.DeviceEnabled) | c.DeviceBroken) AS Offline
            FROM    MMMountPathToStorageDevice a WITH (NOLOCK)
                    INNER JOIN (
                        SELECT DeviceId, MAX(DeviceControllerEnabled) AS DeviceControllerEnabled, MAX(DeviceAccessible) AS DeviceAccessible
                        FROM   MMDeviceController WITH (NOLOCK)
                        GROUP BY DeviceId
                    ) b  ON a.DeviceId = b.DeviceId
                    INNER JOIN MMDevice c WITH (NOLOCK) ON b.DeviceId = c.DeviceId
            WHERE   a.DeviceId = b.DeviceId
            GROUP BY a.MountPathId
            ) T ON MP.MountPathId = T.MountPathId
WHERE	T.Offline > 0

INSERT  INTO #MountPathSize
SELECT	MediaSideId, SUM(CAST(PhysicalBytesMB AS BIGINT)) AS DataWrittenMB
FROM	MMVolume WITH (NOLOCK)
WHERE	RecordingFormatId = 10001 AND (Attributes & 512) = 0 AND SiloStatus <> 3
GROUP BY MediaSideId

INSERT  INTO #LibraryHardDrive
SELECT	T.LibraryId, T.MediaSideId, T.TotalSpaceMB, T.FreeBytesMB, T.FreeBytesMBRange, T.HardDrive,
		ROW_NUMBER() OVER (PARTITION BY T.TotalSpaceMB, T.FreeBytesMBRange, T.HardDrive ORDER BY T.MediaSideId) AS RowId, 0
FROM            
        (SELECT  MP.LibraryId, MP.MediaSideId, MS.TotalSpaceMB, MS.FreeBytesMB, @RangeMB*(MS.FreeBytesMB/@RangeMB) AS FreeBytesMBRange, 
                CASE WHEN Folder LIKE '\\%\%' THEN SUBSTRING(Folder, 1, CHARINDEX('\', Folder, 3)-1) 
                     WHEN Folder LIKE '/%/%'  THEN SUBSTRING(Folder, 1, CHARINDEX('/', Folder, 2)-1) 
                     WHEN Folder LIKE '%:\%'  THEN SUBSTRING(Folder, 1, CHARINDEX(':\', Folder, 0)) 
                     ELSE Folder 
                END AS HardDrive
        FROM    MMMediaSide MS WITH (NOLOCK)
                INNER JOIN MMMountPath MP WITH (NOLOCK) ON MS.MediaSideId = MP.MediaSideId
                INNER JOIN (
					SELECT MPSD.MountPathId, MAX(DC.Folder) AS Folder
                    FROM   MMMountPathToStorageDevice MPSD WITH (NOLOCK)
                            INNER JOIN MMDeviceController DC WITH (NOLOCK) ON MPSD.DeviceId = DC.DeviceId AND DC.Folder <> ''
                    GROUP BY MPSD.MountPathId) F ON MP.MountPathId = F.MountPathId
 		WHERE   MP.MountPathTypeId <> 7 AND MS.TotalSpaceMB > 0
 		) T

INSERT  INTO #LibraryHardDrive
SELECT	T.LibraryId, T.MediaSideId, T.TotalSpaceMB, T.FreeBytesMB, T.FreeBytesMBRange, T.HardDrive,
		ROW_NUMBER() OVER (PARTITION BY T.TotalSpaceMB, T.FreeBytesMBRange, T.HardDrive ORDER BY T.MediaSideId) AS RowId, 0
FROM            
        (SELECT MP.LibraryId, MP.MediaSideId, MS.TotalSpaceMB, MS.FreeBytesMB, @RangeMB*(MS.FreeBytesMB/@RangeMB) AS FreeBytesMBRange, 
                F.IP AS HardDrive
        FROM    MMMediaSide MS WITH (NOLOCK)
                INNER JOIN MMMountPath MP WITH (NOLOCK) ON MS.MediaSideId = MP.MediaSideId AND MP.IsOffline = 0
                INNER JOIN (
					SELECT MPSD.MountPathId, MAX(SUBSTRING(DC.UserName, 0, CHARINDEX('//', DC.UserName))) AS IP
                    FROM   MMMountPathToStorageDevice MPSD WITH (NOLOCK)
                            INNER JOIN MMDeviceController DC WITH (NOLOCK) ON MPSD.DeviceId = DC.DeviceId AND DC.Folder <> ''
							INNER JOIN MMDevice D WITH (NOLOCK) ON DC.DeviceId = D.DeviceId AND D.DeviceTypeId = 59
                    GROUP BY MPSD.MountPathId) F ON MP.MountPathId = F.MountPathId
 		WHERE   MP.MountPathTypeId = 7 AND MP.IsOffline = 0 AND MS.TotalSpaceMB > 0
 		) T

IF @MountPathsNotShareDiskSpace = 0
	UPDATE  T SET Shared = 1
	FROM    #LibraryHardDrive T
	        INNER JOIN (
	            SELECT  TotalSpaceMB, FreeBytesMBRange, HardDrive
	            FROM    #LibraryHardDrive
	            WHERE   RowId = 2
	        ) S ON T.TotalSpaceMB = S.TotalSpaceMB AND T.FreeBytesMBRange = S.FreeBytesMBRange AND T.HardDrive = S.HardDrive

INSERT  INTO #LibraryHardDrive
SELECT  MP.LibraryId, MP.MediaSideId, MS.TotalSpaceMB, MS.FreeBytesMB, MS.FreeBytesMB, MAX(CNTR.FriendlyName), 1, 0
FROM    MMMediaSide MS WITH (NOLOCK)
        INNER JOIN MMMountPath MP WITH (NOLOCK) ON MS.MediaSideId = MP.MediaSideId
        INNER JOIN MMMountPathToStorageDevice MPSD WITH (NOLOCK) ON MP.MountPathId = MPSD.MountPathId AND MP.MountPathName <> 'CVDiskFolder' 
        INNER JOIN MMCenteraInfo CNTR WITH (NOLOCK) ON MPSD.CenteraId = CNTR.CenteraId AND CNTR.CenteraId > 0
GROUP BY MP.LibraryId, MP.MediaSideId, MS.TotalSpaceMB, MS.FreeBytesMB, MS.FreeBytesMB


IF OBJECT_ID('tempdb..#StoragePool') IS NOT NULL DROP TABLE #StoragePool
CREATE TABLE #StoragePool (
	StoragePoolId     integer,
	StoragePoolName   nvarchar(255),
	StoragePoolType   integer,
	SIDBStoreId       integer,
	ClientGroupName   nvarchar(512),
	Libraries         varchar(1024),
	LibraryType       integer,
	NumMediaAgents    integer,
	TotalControllers  integer,
	ActiveControllers integer,
	LibOfflineReason  integer,
	MPOfflineReason   integer,
	MAOfflineReason   integer,
	MountPathType     integer,
	StatusCode        integer,
	DeviceTypeId      integer,
	LibrarySubType	  integer
)

IF @csReleaseId >= 16 AND OBJECT_ID('MMGetStoragePools', 'P') IS NOT NULL
BEGIN
	DECLARE @procRevision NVARCHAR(20) = ''
	SELECT	@procRevision = revision FROM GxDBVersions WITH(NOLOCK) WHERE name = 'MMGetStoragePools'

	DECLARE	@n INT = 1, @p INT = 1, @q INT = 1
	DECLARE @r VARCHAR(20) = '', @s VARCHAR(20) = ''

	IF @procRevision LIKE 'v%'
	BEGIN
		SET @procRevision = @procRevision+'.'
		SET @q = CHARINDEX('.', @procRevision, @p+1)
		WHILE @q > 0
		BEGIN
			SET @s = SUBSTRING(@procRevision, @p+1, @q-@p-1)
			IF  @n <= 4
				SET @r += (CASE @q-@p-1 WHEN 1 THEN '000' WHEN 2 THEN '00' WHEN 3 THEN '0' ELSE '' END + @s)
			ELSE
				SET @r += (CASE @q-@p-1 WHEN 1 THEN '0' ELSE '' END + @s)
			
			SET @n += 1
			SET @p = @q
			SET @q = CHARINDEX('.', @procRevision, @p+1)
		END
		SET @procRevision = @r
	END	

	IF	ISNUMERIC(@procRevision) = 0
		SET @procRevision = '9223372036854775807'
		
	DECLARE @procRevNum BIGINT = CAST(@procRevision AS BIGINT)
		
	IF  @procRevNum < 00010001000200160000
	    ALTER TABLE #StoragePool DROP COLUMN LibrarySubType
		
	IF  @procRevNum < 00010001000200140000
	    ALTER TABLE #StoragePool DROP COLUMN DeviceTypeId


	IF	@procRevNum < 00010001000200080601
		ALTER TABLE #StoragePool DROP COLUMN StatusCode
	
	IF	@procRevNum < 00010001000200070000
		ALTER TABLE #StoragePool DROP COLUMN MountPathType

	INSERT INTO #StoragePool
	EXEC MMGetStoragePools

	INSERT	INTO #StoragePoolMA
	SELECT	SPL.StoragePoolId, MPL.LibraryId, CL.id, CL.name
	FROM	#StoragePool SPL
			INNER JOIN MMMasterPool MPL WITH (NOLOCK) ON MPL.LibraryId IN (SELECT * FROM dbo.SplitIDs(SPL.Libraries))
			INNER JOIN MMDrivePool DPL WITH (NOLOCK) ON MPL.MasterPoolId = DPL.MasterPoolId
			INNER JOIN APP_Client CL WITH (NOLOCK) ON DPL.ClientId = CL.id
	ORDER BY SPL.StoragePoolId, CL.name

	INSERT	INTO #HyperScaleMediaSide
	SELECT	DISTINCT AT.ApplianceType, MA.StoragePoolId, MA.LibraryId, MPT.MediaSideId,
			CASE 
				WHEN SDS.Flags & 2048 = 2048 THEN 1 -- MM_STORAGEPOOLINFO_GLUSTER_SP	2048
				WHEN SDS.Flags & 4096 = 4096 THEN 2 -- MM_STORAGEPOOLINFO_HEDVIG_SP		4096
			END
	FROM	MMMountPath MPT WITH (NOLOCK)
			INNER JOIN #StoragePoolMA MA ON MPT.LibraryId = MA.LibraryId
			INNER JOIN (
				SELECT	EntityId, intVal AS ApplianceType 
				FROM	MMEntityProp WITH (NOLOCK)
				WHERE	propertyName = 'MediaAgentApplianceType' AND EntityType = 10
				) AT ON MA.MediaAgentId = AT.EntityId
			INNER JOIN MMSDSStoragePool SDS ON SDS.GDSPId = MA.StoragePoolId AND MPT.LibraryId = SDS.LibraryId
			INNER JOIN MMMountPathToStorageDevice MSD WITH (NOLOCK) ON MSD.MountPathId = MPT.MountPathId
			INNER JOIN MMDiskHWInfo DHW WITH (NOLOCK) ON DHW.deviceId = MSD.DeviceId AND MA.MediaAgentId = DHW.hostId

	INSERT	INTO #HyperScaleUsage
	SELECT	HS.ApplianceType, 0, 0, SUM(MS.TotalSpaceMB), SUM(MS.FreeBytesMB), SUM(ISNULL(W.DataWrittenMB, 0)), 0, 0, 0, 0, HS.HyperScaleVersion
	FROM	MMMediaSide MS WITH (NOLOCK)
			INNER JOIN #HyperScaleMediaSide HS ON MS.MediaSideId = HS.MediaSideId
			LEFT OUTER JOIN (
				SELECT	MediaSideId, SUM(CAST(PhysicalBytesMB AS BIGINT)) AS DataWrittenMB
				FROM	MMVolume WITH (NOLOCK)
				WHERE	SiloStatus <> 3
				GROUP BY MediaSideId
				) W ON HS.MediaSideId = W.MediaSideId
	GROUP BY HS.ApplianceType, HS.HyperScaleVersion

	UPDATE	T SET NumStoragePools = S.NumStoragePools, NumMediaAgents = S.NumMediaAgents
	FROM	#HyperScaleUsage T
			INNER JOIN (
				SELECT	HS.ApplianceType, COUNT(DISTINCT HS.StoragePoolId) AS NumStoragePools, COUNT(DISTINCT MA.MediaAgentId) AS NumMediaAgents, HS.HyperScaleVersion
				FROM	#HyperScaleMediaSide HS
						INNER JOIN #StoragePoolMA MA ON HS.StoragePoolId = MA.StoragePoolId
						INNER JOIN MMSDSStoragePool SDS WITH (NOLOCK) ON SDS.GDSPId = MA.StoragePoolId
						INNER JOIN MMMountPath MP WITH (NOLOCK) ON MP.LibraryId = SDS.LibraryId
						INNER JOIN MMMountPathToStorageDevice MSD WITH (NOLOCK) ON MSD.MountPathId = MP.MountPathId
						INNER JOIN MMDiskHWInfo DHW WITH (NOLOCK) ON DHW.deviceId = MSD.DeviceId AND MA.MediaAgentId = DHW.hostId
				GROUP BY HS.ApplianceType, HS.HyperScaleVersion
			) S ON T.ApplianceType = S.ApplianceType AND T.HyperScaleVersion = S.HyperScaleVersion
	
	INSERT	INTO #HyperScaleJobs
	SELECT	HS.ApplianceType, ACM.jobId, ACM.commCellId, HS.HyperScaleVersion
	FROM	archChunkMapping ACM WITH (NOLOCK)
			INNER JOIN archChunk AC WITH (NOLOCK) ON ACM.archChunkId = AC.id AND ACM.chunkCommCellId = AC.commCellId
			INNER JOIN MMVolume V WITH (NOLOCK) ON AC.volumeId = V.VolumeId
			INNER JOIN #HyperScaleMediaSide HS ON V.MediaSideId = HS.MediaSideId
	WHERE	ACM.flags&256 = 0
	GROUP BY HS.ApplianceType, ACM.jobId, ACM.commCellId, HS.HyperScaleVersion
	
	UPDATE	T SET NumClients = S.NumClients
	FROM	#HyperScaleUsage T
			INNER JOIN (
				SELECT	J.ApplianceType, COUNT(DISTINCT A.clientId) AS NumClients, J.HyperScaleVersion
				FROM	APP_Application A WITH (NOLOCK)
						INNER JOIN JMBkpStats B WITH (NOLOCK) ON A.id = B.appId
						INNER JOIN #HyperScaleJobs J ON B.jobId = J.jobId AND B.commCellId = J.commCellId
				WHERE	A.subclientStatus&(2|4) = 0 AND A.appTypeId <> 106
				GROUP BY J.ApplianceType, J.HyperScaleVersion
			) S ON T.ApplianceType = S.ApplianceType AND T.HyperScaleVersion = S.HyperScaleVersion

	UPDATE	T SET NumVMs = S.NumVMs
	FROM	#HyperScaleUsage T
			INNER JOIN (
				SELECT	J.ApplianceType, COUNT(DISTINCT VM.VMclientId) AS NumVMs, J.HyperScaleVersion
				FROM	APP_VMProp VM WITH (NOLOCK)
						INNER JOIN #HyperScaleJobs J ON VM.jobId = J.jobId AND VM.commCellId = J.commCellId
				GROUP BY J.ApplianceType, J.HyperScaleVersion
			) S ON T.ApplianceType = S.ApplianceType AND T.HyperScaleVersion = S.HyperScaleVersion

	UPDATE	T SET NumMAs1To12Disks = S.NumMAs1To12Disks,
			NumMAs13To24Disks = S.NumMAs13To24Disks
	FROM	#HyperScaleUsage T
			INNER JOIN (
				SELECT SUM(CASE WHEN [diskCount] <= 12 THEN 1 ELSE 0 END) AS [NumMAs1To12Disks],
						SUM(CASE WHEN [diskCount] > 12 AND [diskCount] <= 24 THEN 1 ELSE 0 END) AS [NumMAs13To24Disks], 
					[ApplianceType], [HyperScaleVersion] 
				FROM (SELECT HW.hostId AS [hostId], 
							COUNT(HW.diskId) AS [diskCount],
							HM.ApplianceType AS [ApplianceType],
							HM.HyperScaleVersion AS [HyperScaleVersion]
							FROM MMDiskHWInfo HW
							INNER JOIN #StoragePoolMA MA ON MA.MediaAgentId = HW.hostId
							INNER JOIN #HyperScaleMediaSide HM ON HM.LibraryId = MA.LibraryId
							INNER JOIN MMMountPath MP WITH (NOLOCK) ON MP.LibraryId = MA.LibraryId
							INNER JOIN MMMountPathToStorageDevice MSD WITH (NOLOCK) ON MSD.MountPathId = MP.MountPathId AND HW.deviceId = MSD.DeviceId
						WHERE deviceOSPath NOT LIKE '/ws/ddb' AND flags&1 = 1
						GROUP BY hostId, ApplianceType, HyperScaleVersion) AS TMP
				GROUP BY TMP.[ApplianceType], TMP.HyperScaleVersion
			) S ON T.ApplianceType = S.ApplianceType AND T.HyperScaleVersion = S.HyperScaleVersion

END

INSERT	INTO #LibraryMA
SELECT	MPL.LibraryId, CL.name
FROM	MMMasterPool MPL WITH (NOLOCK)
		INNER JOIN MMDrivePool DPL WITH (NOLOCK) ON MPL.MasterPoolId = DPL.MasterPoolId
		INNER JOIN APP_Client CL WITH (NOLOCK) ON DPL.ClientId = CL.id
ORDER BY MPL.LibraryId, CL.name

IF OBJECT_ID('MMDiskHWInfo', 'U') IS NOT NULL
BEGIN
    IF COL_LENGTH('MMDiskHWInfo', 'mountPathUsageType') IS NULL
	INSERT  INTO #DisksPerMA
	SELECT  hostId, COUNT(diskId)
	FROM    MMDiskHWInfo WITH (NOLOCK)
        WHERE   deviceOSPath NOT LIKE '/ws/ddb' AND flags&1 = 1
	GROUP BY hostId
    ELSE
         EXEC sp_executesql N'INSERT INTO #DisksPerMA SELECT hostId, COUNT(diskId) FROM MMDiskHWInfo WITH (NOLOCK) WHERE mountPathUsageType = 2 AND flags&1 = 1 GROUP BY hostId'
END

IF EXISTS (select * from sysobjects where id = object_id(N'[dbo].[BLCostCategory]') and OBJECTPROPERTY(id, N'IsTable') = 1)
BEGIN 
    SET @tempCostCategory = (
    SELECT L.LibraryId AS '@LibraryId',
            D.DriveID AS '@DriveId',
            D.AliasName AS '@DriveName',
            1 - (DriveSoftState & DriveEnabled & (1 - CleaningRequired) & (1 - DriveBroken)) AS '@Offline',
            D.OfflineReason AS '@OfflineReason',
            CASE WHEN D.OfflineTimeStamp > 0 THEN D.OfflineTimeStamp + @diff ELSE 0 END AS '@OfflineTimeStamp',
            DT.RatedThroughputInMBPerSec AS '@RatedThroughputMbps',
            D.DriveVendor AS '@Manufacturer', 
            D.DriveModel AS '@Model', 
            DT.DriveTypeName AS '@Type',
            D.SerialNumber AS '@SerialNumber',
            D.FirmwareRevision AS '@FirmwareRevision', 
             CASE WHEN DT.CostCategoryId > 0 THEN C.DisplayName ELSE 'Not Defined' END AS '@CostCategory'
    FROM    MMDrive D WITH (NOLOCK)
            INNER JOIN MMDriveType DT WITH (NOLOCK) ON D.DriveTypeId = DT.DriveTypeId
            INNER JOIN (
                SELECT	DISTINCT DC.DriveID, MP.LibraryId
                FROM	MMDriveController DC WITH (NOLOCK)
                	INNER JOIN MMDrivePool DP WITH (NOLOCK) ON DC.DrivePoolID = DP.DrivePoolID
                	INNER JOIN MMMasterPool MP WITH (NOLOCK) ON DP.MasterPoolId = MP.MasterPoolID
                ) DL ON D.DriveID = DL.DriveID
            INNER JOIN MMLibrary L WITH (NOLOCK) ON L.LibraryId = DL.LibraryId
            INNER JOIN BLCostCategory C WITH (NOLOCK) ON DT.CostCategoryId = C.CostCategoryID
    WHERE   D.DriveTypeId <> 10001 AND L.LibraryId > 0 AND L.LibraryTypeId != 8
    ORDER BY L.LibraryId, D.DriveID
    FOR XML PATH('Drive'), TYPE)    

    SET @tempCostCategory1 = (SELECT DisplayName FROM BLCostCategory
            WHERE CostCategoryID IN (SELECT CostCategoryID FROM MMMediaType WITH (NOLOCK) WHERE MediaTypeId = 10001))
END
ELSE
BEGIN
    SET @tempCostCategory = (
    SELECT  L.LibraryId AS '@LibraryId',
            D.DriveID AS '@DriveId',
            D.AliasName AS '@DriveName',
            1 - (DriveSoftState & DriveEnabled & (1 - CleaningRequired) & (1 - DriveBroken)) AS '@Offline',
            D.OfflineReason AS '@OfflineReason',
            CASE WHEN D.OfflineTimeStamp > 0 THEN D.OfflineTimeStamp + @diff ELSE 0 END AS '@OfflineTimeStamp',
            DT.RatedThroughputInMBPerSec AS '@RatedThroughputMbps',
            D.DriveVendor AS '@Manufacturer', 
            D.DriveModel AS '@Model', 
            DT.DriveTypeName AS '@Type',
            D.SerialNumber AS '@SerialNumber',
            D.FirmwareRevision AS '@FirmwareRevision', 
            'Not Defined' AS '@CostCategory'
    FROM    MMDrive D WITH (NOLOCK)
            INNER JOIN MMDriveType DT WITH (NOLOCK) ON D.DriveTypeId = DT.DriveTypeId
            INNER JOIN (
                SELECT	DISTINCT DC.DriveID, MP.LibraryId
                FROM	MMDriveController DC WITH (NOLOCK)
                	INNER JOIN MMDrivePool DP WITH (NOLOCK) ON DC.DrivePoolID = DP.DrivePoolID
                	INNER JOIN MMMasterPool MP WITH (NOLOCK) ON DP.MasterPoolId = MP.MasterPoolID
                ) DL ON D.DriveID = DL.DriveID
            INNER JOIN MMLibrary L WITH (NOLOCK) ON L.LibraryId = DL.LibraryId
    WHERE   D.DriveTypeId <> 10001 AND L.LibraryId > 0 AND L.LibraryTypeId != 8
    ORDER BY L.LibraryId, D.DriveID
    FOR XML PATH('Drive'), TYPE)

    SET @tempCostCategory1 = 'Not Defined'
END

CREATE TABLE #ClientVersion(ClientId INT, Version NVARCHAR(MAX))
DECLARE @sqlstr NVARCHAR(MAX)

IF object_id('Commserv.dbo.PatchSPVersion') IS NOT NULL
BEGIN
	IF EXISTS(SELECT 1 FROM SYS.COLUMNS WHERE NAME = N'UPNumber' AND OBJECT_ID = OBJECT_ID(N'simInstalledPackages'))
	BEGIN
		SET @sqlstr = 
		'INSERT INTO #ClientVersion
			SELECT sip.ClientID, 
			      (CAST(COALESCE(psp.SPMajor, 0) AS VARCHAR(10)) + ''.'' + CAST(COALESCE(sip.UPNumber, 0) AS VARCHAR(10))) AS Version 
			FROM    simInstalledPackages sip WITH (NOLOCK)
			JOIN 	PatchSPVersion psp WITH (NOLOCK) ON psp.id = sip.SPVersionID
			WHERE   sip.simPackageID IN (SELECT id FROM simPackage WITH (NOLOCK) WHERE Name = ''MediaAgent'')'
	END
	ELSE
	BEGIN
		SET @sqlstr = 
		'INSERT INTO #ClientVersion
			SELECT sip.ClientID, 
			      (CAST(COALESCE(psp.SPMajor, 0) AS VARCHAR(10)) + 
			      CASE WHEN SpMinorVersion > 0 THEN ''.'' + CAST(SpMinorVersion AS VARCHAR) ELSE '''' END) AS Version 
			FROM    simInstalledPackages sip WITH (NOLOCK)
			JOIN 	PatchSPVersion psp WITH (NOLOCK) ON psp.id = sip.SPVersionID
			WHERE   sip.simPackageID IN (SELECT id FROM simPackage WITH (NOLOCK) WHERE Name = ''MediaAgent'')'
	END
END
ELSE
BEGIN
	SET @sqlstr = 
	'INSERT INTO #ClientVersion
		SELECT ClientID, 
	          (CASE WHEN HighestSP > 0 THEN CAST(HighestSP AS VARCHAR(20)) ELSE '''' END 
	          +CASE WHEN SpMinorVersion > 0 THEN ''.'' + CAST(SpMinorVersion AS VARCHAR) ELSE '''' END) AS Version 
	    FROM    simInstalledPackages WITH (NOLOCK)
	    WHERE   simPackageID IN (SELECT id FROM simPackage WITH (NOLOCK) WHERE Name = ''MediaAgent'')'
END

EXEC sp_executesql @sqlstr

CREATE TABLE #MetallicContainers (
	DeviceId			INTEGER,
	LicenseType			INTEGER,
	RegionName			VARCHAR(64),
	RegionDisplayName	VARCHAR(256),
	StorageClass		INTEGER,
	ReplicationType		INTEGER,
	CredentialId		INTEGER,
	Container			VARCHAR(64),
	StorageAccount		VARCHAR(64),
	ApplicationId		VARCHAR(64)
)

IF @csReleaseId >= 16 AND OBJECT_ID('MMGetMetallicStorage', 'P') IS NOT NULL
BEGIN
	INSERT INTO #MetallicContainers
	EXEC MMGetMetallicStorage
END

IF NOT EXISTS(SELECT 1 FROM tempdb.sys.columns WHERE [object_id]=OBJECT_ID('tempdb..#StoragePool') AND name='DeviceTypeId')
	ALTER TABLE #StoragePool ADD DeviceTypeId INTEGER

SET @surveyXML = (SELECT
    (SELECT MA.ClientId AS '@MAClientId',
            CL.name AS '@MediaAgentName', 
            ISNULL(T.ApplianceType, 0) AS '@ApplianceType',
            1 - (MmHostSoftState & MmHostEnabled) AS '@Offline',
            MA.OfflineReason AS '@OfflineReason',
             CASE WHEN MA.OfflineTimeStamp > 0 THEN MA.OfflineTimeStamp + @diff ELSE 0 END AS '@OfflineTimeStamp',
            dbo.GetClientOSName(CL.id,NULL) AS '@OSName',
            (R.release + '.' + ISNULL(V.Version, '0.0')) AS '@ReleaseVersion',
            ISNULL(W.DataWrittenLastWeek, 0) AS '@DataWrittenLastWeek',
            D.NumOfDisks AS '@NumOfDisks'
    FROM    MMHost MA WITH (NOLOCK)
            INNER JOIN APP_Client CL WITH (NOLOCK) ON CL.id = MA.ClientId AND CL.id > 1
            INNER JOIN simAllGalaxyRel R WITH (NOLOCK) ON R.id = CL.releaseId 
            LEFT OUTER JOIN #ClientVersion V ON V.ClientId = MA.ClientId
            LEFT OUTER JOIN (
                SELECT  ClientId, SUM(DataWritten) AS DataWrittenLastWeek
                FROM    MMDriveHistory WITH (NOLOCK)
                WHERE   HistoryType = 1
                    AND TimeStart > DATEADD(DAY, -7, GETUTCDATE())
                GROUP BY ClientId
                ) W ON MA.ClientId = W.ClientId
            LEFT OUTER JOIN (
                SELECT  EntityId, intVal AS ApplianceType
                FROM    MMEntityProp WITH (NOLOCK)
                WHERE   propertyName = 'MediaAgentApplianceType' AND entityType = 10
                ) T ON MA.ClientId = T.EntityId
            LEFT OUTER JOIN #DisksPerMA D ON MA.ClientId = D.MediaAgentId
   FOR XML PATH('MediaAgent'), TYPE),

    (SELECT L.LibraryId AS '@LibraryId',
            L.AliasName AS '@LibraryName',
			L.LibraryEnabled AS '@Enabled',
            CASE WHEN CL.LibraryId IS NULL THEN L.LibraryTypeId ELSE -3 END AS '@LibraryTypeId',
            1 - (L.LibrarySoftState & L.LibraryEnabled & (1 - L.LibraryBroken) & LC.OnLine) AS '@Offline',
            L.LibraryStatusReason AS '@OfflineReason',
            CASE WHEN L.OfflineTimeStamp > 0 THEN L.OfflineTimeStamp + @diff ELSE 0 END AS '@OfflineTimeStamp',
            ISNULL(W.DataWrittenLastWeek, 0) AS '@DataWrittenLastWeek',
			ISNULL(HD.TotalSpaceMB, ISNULL(F.TotalSpaceMB, -1)) AS '@TotalSpaceMB',
            ISNULL(HD.FreeBytesMB, ISNULL(F.FreeBytesMB, -1)) AS '@FreeSpaceMB',
            ISNULL(DW.DataWrittenMB, -1) AS '@DataWrittenMB',
            L.LowWaterMarkMB AS '@LowWaterMark',
            ISNULL(SG.ScratchPoolsBelowLWM, 0) AS '@ScratchPoolsBelowLWM',
            ISNULL(S.SpareInLibrary, 0) AS '@SpareInLibrary',
            ISNULL(S.SpareTotal, 0) AS '@SpareTotal',
            ISNULL(CL.CloudVendorTypeId, L.LibraryVendor) AS '@Manufacturer', 
            L.LibraryModel AS '@Model', 
            L.SerialNumber AS '@SerialNumber',
            L.FirmwareRevision AS '@FirmwareRevision',
            ISNULL(TS.Slots, 0) AS '@Slots',
            ISNULL(TS.Slots, 0) - ISNULL(TS.OccupiedSlots, 0) AS '@EmptySlots',
            CASE WHEN (L.ExtendedAttributes & 33554432) /* MMS2_HIDE_LIBRARY*/ = 0 THEN 0 ELSE 1 END AS '@Hidden',
            L.LibraryInstallTime AS '@LibraryInstallTime',
			ISNULL(NM.NumMediaAgents, 0) AS '@NumMediaAgents',
            LTRIM(STUFF((SELECT ', ' + CONVERT(VARCHAR(256), LM.MediaAgent) FROM #LibraryMA LM 
					WHERE LM.LibraryId = L.LibraryId FOR XML PATH ('')), 1, 1, '')) AS '@MediaAgents'
    FROM    MMLibrary L WITH (NOLOCK)
            INNER JOIN (
                SELECT  LibraryId, MAX(LibraryControllerSoftState & LibraryControllerEnabled & LibraryControllerActive) AS OnLine
                FROM    MMLibraryController WITH (NOLOCK)
                GROUP BY LibraryId
                ) LC ON L.LibraryId = LC.LibraryId
            LEFT OUTER JOIN (
                SELECT  MP.LibraryId, CAST(MAX(D.DeviceTypeId) AS VARCHAR(16)) AS CloudVendorTypeId
                FROM    MMMountPath MP WITH (NOLOCK)
                        INNER JOIN MMMountPathToStorageDevice MPD WITH (NOLOCK) ON MP.MountPathId = MPD.MountPathId
                        INNER JOIN MMDevice D WITH (NOLOCK) ON MPD.DeviceId = D.DeviceId
                WHERE   MountPathTypeId = 7 AND MountPathName <> 'CVDiskFolder' AND D.DeviceTypeId <> 59
                GROUP BY MP.LibraryId
                ) CL ON L.LibraryId = CL.LibraryId
            LEFT OUTER JOIN (
                SELECT  LibraryId, COUNT(SpareGroupId) AS ScratchPoolsBelowLWM
                FROM    MMSpareGroup WITH (NOLOCK)
                WHERE   SpareGroupType IN (1, 2) AND IsLowWaterMark > 0
                GROUP BY LibraryId
                ) SG ON L.LibraryId =  SG.LibraryId
            LEFT OUTER JOIN (
                SELECT  DISTINCT M.LibraryId, 
						CASE WHEN MP.MountPathTypeId = 7 AND MAX(MS.TotalSpaceMB) = 1048576 THEN -1 ELSE SUM(CAST(MS.TotalSpaceMB AS BIGINT)) END AS TotalSpaceMB, 
						CASE WHEN MP.MountPathTypeId = 7 AND MAX(MS.TotalSpaceMB) = 1048576 THEN -1 ELSE SUM(CAST(MS.FreeBytesMB AS BIGINT)) END AS FreeBytesMB
                FROM    MMMediaSide MS WITH (NOLOCK)
						INNER JOIN MMMountPath MP WITH (NOLOCK) ON MP.MediaSideId = MS.MediaSideId
                        INNER JOIN MMMedia M WITH (NOLOCK) ON MS.MediaId = M.MediaId
                        LEFT OUTER JOIN (
                            SELECT  MediaSideId FROM MMVolume WITH (NOLOCK) 
                            WHERE VolumeFlags IN (1, 5, 7) AND RecordingFormatId <> 10001
                            ) V ON MS.MediaSideId = V.MediaSideId
                WHERE   (M.MediaTypeId = 10001 OR V.MediaSideId IS NOT NULL)
                GROUP BY M.LibraryId, MP.MountPathTypeId
                ) F ON L.LibraryId = F.LibraryId
            LEFT OUTER JOIN (
                SELECT  LibraryId, SUM(TotalSpaceMB) AS TotalSpaceMB, SUM(FreeBytesMB) AS FreeBytesMB 
                FROM    (SELECT  LibraryId, MediaSideId, TotalSpaceMB, FreeBytesMB, 
                        ROW_NUMBER() OVER (PARTITION BY LibraryId, FreeBytesMBRange, HardDrive ORDER BY MediaSideId) AS RowId
                        FROM    #LibraryHardDrive) LHD
                WHERE   RowId = 1
                GROUP BY LibraryId
                ) HD ON L.LibraryId = HD.LibraryId
            LEFT OUTER JOIN (
                SELECT  LibraryId, SUM(DataWrittenMB) AS DataWrittenMB
                FROM    #MountPathSize MPS
						INNER JOIN MMMountPath MPT ON MPS.MediaSideId = MPT.MediaSideId
                GROUP BY LibraryId
                ) DW ON L.LibraryId = DW.LibraryId
            LEFT OUTER JOIN (
                SELECT  MP.LibraryID, SUM(DH.DataWritten) AS DataWrittenLastWeek
                FROM    MMDriveHistory DH WITH (NOLOCK)
                        INNER JOIN MMDrive D WITH (NOLOCK) ON DH.DriveID = D.DriveID
                        INNER JOIN MMMasterPool MP WITH (NOLOCK) ON D.MasterPoolID = MP.MasterPoolId
                WHERE   DH.HistoryType = 1
                    AND DH.TimeStart > DATEADD(DAY, -7, GETUTCDATE())
                GROUP BY MP.LibraryID
                ) W ON L.LibraryID = W.LibraryId
            LEFT OUTER JOIN (
                SELECT  LibraryId, COUNT(*) AS SpareTotal, SUM(CASE WHEN MediaLocation IN (1, 2) THEN 1 ELSE 0 END) AS SpareInLibrary
                FROM    MMMedia WITH (NOLOCK)
                WHERE   IsInMediaGroup = 0 
                    AND SpareGroupId IN (SELECT SpareGroupId FROM MMSpareGroup WITH (NOLOCK) WHERE SpareGroupType IN (1, 2))
                GROUP BY LibraryId
                ) S ON L.LibraryID = S.LibraryId
            LEFT OUTER JOIN (           
                SELECT  B.LibraryId, COUNT(*) AS Slots, SUM(IsOccupied) AS OccupiedSlots
                FROM    MMSlot SL WITH (NOLOCK) INNER JOIN MMBay B WITH (NOLOCK) ON SL.BayId = B.BayId
                WHERE   SL.SlotType = 1
                GROUP BY B.LibraryId
                ) TS ON L.LibraryId = TS.LibraryId
            LEFT OUTER JOIN (
				SELECT	LibraryId, COUNT(*) AS NumMediaAgents
				FROM	#LibraryMA
				GROUP BY LibraryId
				) NM ON L.LibraryId = NM.LibraryId
    WHERE   L.LibraryId > 0 AND L.LibraryTypeId != 8
    FOR XML PATH('Library'), TYPE),

    (SELECT LC.ClientId AS '@MAClientId',
            LC.LibraryId AS '@LibraryId',
            LC.LibraryControllerId AS '@ControllerId',
            LC.LibraryControllerName AS '@ControllerName',
            LC.LibraryControllerActive AS '@Active',
            LC.LibraryControllerEnabled AS '@Enabled',
            LC.SCSIId AS '@SCSIAddress'
    FROM    MMLibraryController LC WITH (NOLOCK)
            INNER JOIN MMLibrary L WITH (NOLOCK) ON L.LibraryId = LC.LibraryId
    WHERE   L.LibraryTypeId NOT IN (8)
    FOR XML PATH('LibraryController'), TYPE),

    (SELECT MP.LibraryId AS '@LibraryId',
            MountPathId AS '@MountPathId',
            MountPathName AS '@MountPathName',
            BaseFolder AS '@BaseFolder',
            DeviceName AS '@DeviceName',
            HD.HardDrive AS '@HardDrive',
            ISNULL(HD.Shared, 0) AS '@HardDriveShared',
            IsEnabled AS '@Enabled',
            IsOffline AS '@Offline',
            OfflineReason AS '@OfflineReason',
            OfflineTimeStamp AS '@OfflineTimeStamp',
            MaxConcurrentWriters AS '@MaxConcurrentWriters',
            MP.TotalSpaceMB AS '@TotalSpaceMB',
            CASE WHEN MP.FreeBytesMB < 0 AND MP.TotalSpaceMB > ISNULL(W.DataWrittenMB, 0) THEN (MP.TotalSpaceMB - ISNULL(W.DataWrittenMB, 0)) ELSE MP.FreeBytesMB END AS '@FreeSpaceMB',
            MagneticSpaceRsrvInMB AS '@ReservedSpaceMB',
            ISNULL(W.DataWrittenMB, 0) AS '@DataWrittenMB',
            @tempCostCategory1 AS '@CostCategory'
    FROM    #MountPathProp MP WITH (NOLOCK)
            LEFT OUTER JOIN #LibraryHardDrive HD ON MP.MediaSideId = HD.MediaSideId
            LEFT OUTER JOIN #MountPathSize W ON MP.MediaSideId = W.MediaSideId
    ORDER BY MP.LibraryId, MountPathId
    FOR XML PATH('MountPath'), TYPE),

    @tempCostCategory ,
    
    (SELECT DC.DriveID AS '@DriveId',
            DC.DriveID AS '@ControllerId',
            MAX(DC.DriveControllerSoftState&DC.DriveControllerSoftState&DC.DriveAccessible) AS '@Active'
    FROM    MMDriveController DC WITH (NOLOCK)
            INNER JOIN MMDrive D WITH (NOLOCK) ON D.DriveID = DC.DriveID
    WHERE   D.DriveTypeId <> 10001
    GROUP BY DC.DriveID
    FOR XML PATH('DriveController'), TYPE),

    (SELECT PL.StoragePoolId AS '@StoragePoolId',
            PL.StoragePoolName AS '@StoragePoolName',
            PL.StoragePoolType AS '@StoragePoolType',
            PL.Libraries AS '@LibraryIds',
            PL.LibraryType AS '@LibraryType',
            PL.TotalControllers AS '@TotalControllers',
            PL.ActiveControllers AS '@ActiveControllers',
            PL.LibOfflineReason AS '@LibOfflineReason',
            PL.MPOfflineReason AS '@MPOfflineReason',
            PL.MAOfflineReason AS '@MAOfflineReason',
            ISNULL(HS.ApplianceType, 0) AS '@ApplianceType',
            PL.NumMediaAgents AS '@NumMediaAgents',
            LTRIM(STUFF((SELECT ', ' + CONVERT(VARCHAR(256), PM.MediaAgent) FROM #StoragePoolMA PM 
                   WHERE PM.StoragePoolId = PL.StoragePoolId FOR XML PATH ('')), 1, 1, '')) AS '@MediaAgents',
			ISNULL(PL.DeviceTypeId,0) AS '@DeviceTypeId'
    FROM    #StoragePool PL
            LEFT OUTER JOIN (
		SELECT StoragePoolId, SUM(DISTINCT ApplianceType) AS ApplianceType
		FROM #HyperScaleMediaSide
		GROUP BY StoragePoolId) HS ON PL.StoragePoolId = HS.StoragePoolId
    FOR XML PATH('StoragePool'), TYPE),
    
    (SELECT ApplianceType AS '@ApplianceType',
            NumStoragePools AS '@NumStoragePools',
            NumMediaAgents AS '@NumMediaAgents',
            TotalSpaceMB AS '@TotalSpaceMB', 
            FreeSpaceMB AS '@FreeSpaceMB', 
            DataWrittenMB AS '@DataWrittenMB', 
            NumClients AS '@NumClients', 
            NumVMs AS '@NumVMs',
			NumMAs1To12Disks AS '@NumMAs1To12Disks',
			NumMAs13To24Disks AS '@NumMAs13To24Disks',
			HyperScaleVersion AS '@HyperScaleVersion'
    FROM    #HyperScaleUsage
    FOR XML PATH('HyperScaleUsage'), TYPE),

	(SELECT DeviceId AS '@ContainerId',
            Container AS '@ContainerName'
    FROM    #MetallicContainers
    FOR XML PATH('MetallicContainer'), TYPE)

FOR XML PATH ('MediaManagementSummary')
-- Replace <<RESULTS_NAME>> with specific name
)

DROP TABLE #clientVersion
DROP TABLE #DisksPerMA
DROP TABLE #StoragePool
DROP TABLE #StoragePoolMA
DROP TABLE #LibraryMA
DROP TABLE #HyperScaleMediaSide
DROP TABLE #HyperScaleUsage
DROP TABLE #HyperScaleJobs
DROP TABLE #MountPathProp
DROP TABLE #MountPathSize
DROP TABLE #LibraryHardDrive
DROP TABLE #MetallicContainers

--------- END SURVEY QUERY ---------
--select CAST(@surveyXML AS XML)

--------- BEGIN - GENERATED CODE, PLEASE DO NOT MODIFY ---------

DECLARE @EndTime AS BIGINT = dbo.GetUnixTime(GETUTCDATE())
SET @outputXML = 
(
    SELECT
        @queryId AS '@QueryId',
        @EndTime AS '@LogDate',
        (@EndTime - @LogDate) AS '@QueryRunningTime',
        @surveyXML
    FOR XML PATH('Rpt_CSSXMLDATA')
)

SET NOCOUNT OFF

--------- END - GENERATED CODE ---------
