--- Please follow the below comments to insert SQL statements.
-- Client version query
--------- BEGIN - GENERATED CODE, PLEASE DO NOT MODIFY ---------

SET NOCOUNT ON

DECLARE @LogDate AS BIGINT = dbo.GetUnixTime(GETUTCDATE())
DECLARE @queryId AS INTEGER = 93
DECLARE @surveyXML  NVARCHAR(MAX)

--------- END - GENERATED CODE ---------



--------- BEGIN SURVEY QUERY ---------

--------- Insert your SQL statements here 

DECLARE @csReleaseId INT
SELECT	@csReleaseId = releaseId FROM APP_Client WITH (NOLOCK) WHERE id = 2
DECLARE @sqlstr NVARCHAR(MAX)

CREATE TABLE #LibWWM (LibraryId INT, WarningWaterMark INT)

IF ( @csReleaseId < 15)        
	INSERT INTO #LibWWM SELECT LibraryId, 100 FROM MMLibrary WITH (NOLOCK) WHERE LibraryId > 0 AND LibraryTypeId IN (1,2,3,4,5)
ELSE
BEGIN
	SET @sqlstr = 
	N'INSERT INTO #LibWWM SELECT LibraryId, WarningWaterMark FROM MMLibrary WITH (NOLOCK) WHERE LibraryId > 0 AND LibraryTypeId IN (1,2,3,4,5)'               
	EXEC sp_executesql @sqlstr
END


SET @surveyXML = (SELECT
	(SELECT	L.LibraryId AS '@LibraryId', 
			L.AliasName AS '@LibraryName', 
			L.LibraryEnabled AS '@LibraryEnabled', 
			L.LibraryTypeId AS '@LibraryTypeId', 
			L.LowWaterMarkMB AS '@LowWaterMarkMB', 
			L.LibraryAttribute AS '@LibraryAttribute', 
			L.MountTimeoutSec AS '@MountTimeoutSec', 
			L.UnmountTimeoutSec AS '@UnmountTimeoutSec', 
			MT.MediaTypeName AS '@DefaultMediaTypeName',
			L.UseWithinDaysInSec AS '@UseWithinDaysInSec', 
			L.DriveCleanIntervalInSec AS '@DriveCleanIntervalInSec',  
			L.VMSDirection AS '@VMSDirection',
			L.CacheMountPeriodInSec AS '@CacheMountPeriodInSec',
			L.StdAlnMedRetentionTime AS '@StdAlnMedRetentionTime', 
			L.TURIntervalInSec AS '@TURIntervalInSec', 
			L.ConfigParams AS '@ConfigParams', 
			L.StdAlnChkIntervalInSec AS '@StdAlnChkIntervalInSec', 
			L.ReadRetryIntervalInSec AS '@ReadRetryIntervalInSec', 
			L.ReadRetryAttempts AS '@ReadRetryAttempts', 
			CASE WHEN L.StartVMSElementAddress = 0 THEN 0
				 ELSE L.StartVMSElementAddress - ISNULL(SEA.StartElementAddress, 0)
			END AS '@StartVMSElementAddress', 
			L.ExtendedAttributes AS '@ExtendedAttributes', 
			L.ThresholdPercentage AS '@ThresholdPercentage', 
			L.ThresholdVariation AS '@ThresholdVariation', 
			W.WarningWaterMark AS '@WarningWaterMark',
			MPL.MaxSwitchForHost AS '@MaxSwitchForHost'
	FROM	MMLibrary L WITH (NOLOCK)
			INNER JOIN (SELECT LibraryId, SUM(MaxSwitchForHost) AS MaxSwitchForHost FROM MMMasterPool WITH (NOLOCK) GROUP BY LibraryId) MPL ON MPL.LibraryId = L.LibraryId
			INNER JOIN MMMediaType MT WITH (NOLOCK) ON MT.MediaTypeId = L.DefaultMediaTypeId
			INNER JOIN #LibWWM W ON W.LibraryId = L.LibraryId
			LEFT OUTER JOIN (SELECT	B.LibraryId, MIN(S.ElementAddress) AS StartElementAddress
							FROM	MMBay B WITH (NOLOCK) INNER JOIN MMSlot S WITH (NOLOCK) ON B.BayId = S.BayId
							GROUP BY B.LibraryId) SEA ON SEA.LibraryId = L.LibraryId
	WHERE	L.LibraryId > 0 AND L.LibraryTypeId IN (1,2,3,4,5)
	FOR XML PATH('Library'), TYPE),

	(SELECT	LibraryId AS '@LibraryId', 
			MP.MountPathId AS '@MountPathId', 
			CASE 
				WHEN MP.MountPathTypeId = 1
				THEN ISNULL((SELECT TOP 1 A.FriendlyName 
							FROM MMCenteraInfo A WITH (NOLOCK) INNER JOIN MMMountPathToStorageDevice B WITH (NOLOCK) ON A.CenteraId = B.CenteraId 
							WHERE B.MountPathId = MP.MountPathId), 'Unavailable')
				WHEN MP.MountPathTypeId IN (4, 5, 7) AND S.MountPathId IS NOT NULL
				THEN S.Folder
				ELSE MP.MountPathName
			END AS '@MountPathName', 
			IsEnabled AS '@IsEnabled', 
			MaxConcurrentWriters AS '@MaxConcurrentWriters', 
			MaxDataToWriteMB AS '@MaxDataToWriteMB', 
			MagneticSpaceRsrvInMB AS '@MagneticSpaceRsrvInMB', 
			Attribute AS '@Attribute', 
			MagneticChunkFileIncrSizeMB AS '@MagneticChunkFileIncrSizeMB',
			MD.DeviceEnabled AS '@DeviceEnabled'
	FROM	MMMountPath MP WITH (NOLOCK) 
			INNER JOIN MMMountPathToStorageDevice MPSD WITH (NOLOCK) ON MP.MountPathId = MPSD.MountPathId
			INNER JOIN MMDevice MD WITH (NOLOCK) ON MPSD.DeviceId = MD.DeviceId
			LEFT OUTER JOIN 
				(SELECT	c.MountPathId, DC.Folder
				FROM	(SELECT	a.MountPathId, a.DeviceId
						FROM	MMMountPathToStorageDevice a WITH (NOLOCK),
								MMDeviceController b WITH (NOLOCK)
						WHERE	a.DeviceId = b.DeviceId
						GROUP BY a.MountPathId, a.DeviceId
						HAVING COUNT(b.DeviceControllerId) = 1) c
						INNER JOIN MMDeviceController DC WITH (NOLOCK) ON DC.DeviceId = c.DeviceId
						) S ON S.MountPathId = MP.MountPathId
	WHERE	MP.MountPathId > 0
	FOR XML PATH('MountPath'), TYPE)

FOR XML PATH ('LibraryAudit')
-- Replace <<RESULTS_NAME>> with specific name
)

DROP TABLE #LibWWM

--------- END SURVEY QUERY ---------

--------- BEGIN - GENERATED CODE, PLEASE DO NOT MODIFY ---------

DECLARE @EndTime AS BIGINT = dbo.GetUnixTime(GETUTCDATE())
SET @outputXML = 
(
	SELECT
		@queryId AS '@QueryId',
		@EndTime AS '@LogDate',
		(@EndTime - @LogDate) AS '@QueryRunningTime',
		@surveyXML
	FOR XML PATH('Rpt_CSSXMLDATA')
)
SET NOCOUNT OFF

--------- END - GENERATED CODE ---------