--- Please follow the below comments to insert SQL statements.
-- Client version query
--------- BEGIN - GENERATED CODE, PLEASE DO NOT MODIFY ---------

SET NOCOUNT ON

DECLARE @LogDate AS BIGINT = dbo.GetUnixTime(GETUTCDATE())
DECLARE @queryId AS INTEGER = 88
DECLARE @surveyXML NVARCHAR(MAX)

--------- END - GENERATED CODE ---------



--------- BEGIN SURVEY QUERY ---------

--------- Insert your SQL statements here 
-- MediaAgent Audit - Display differences from a user selected MediaAgent

DECLARE @csReleaseId INT
SELECT	@csReleaseId = releaseId FROM APP_Client WITH (NOLOCK) WHERE id = 2
DECLARE @sqlstr NVARCHAR(MAX)

DECLARE @TblNWErrorRetry TABLE 
(
		ClientId INT, RetryFlag INT, RetryFrequency INT, RetryCount INT
)

INSERT	INTO @TblNWErrorRetry
SELECT	P.ClientId, ISNULL([NW Err Retry Flag], 0), ISNULL([NW Err Retry Frequency], 0), ISNULL([NW Err Retry Count], 0)
FROM	(SELECT	MH.ClientId, CP.attrName, CAST (CP.attrVal AS INT) AS IntVal
		FROM	MMHost MH WITH (NOLOCK)
				INNER JOIN APP_ClientProp CP WITH (NOLOCK) 
			ON CP.componentNameId = MH.ClientId AND CP.modified = 0
		WHERE	CP.attrName IN ('NW Err Retry Flag', 'NW Err Retry Frequency', 'NW Err Retry Count')) AS S
		PIVOT (MAX(S.IntVal) FOR S.attrName IN ([NW Err Retry Flag], [NW Err Retry Frequency], [NW Err Retry Count])) AS P

CREATE TABLE #TblCatlogOptions 
(
		ClientId INT, AccessPathEnabled INT, UseNetworkShare INT, AccessPathFlags INT, IdxCleanupPct INT,
		IdxCacheServerClientId INT, IdxMinFreeSpaceMB INT, IdxFreeSpaceWarningMB INT,
		IdxCacheFlags INT, IdxPoolIsShared INT, IdxRetentionDays INT
)
			
-- MA created in/after v11
IF ( @csReleaseId >= 16)            
INSERT	INTO #TblCatlogOptions
SELECT	ClientId, 
		[Idx: cache enabled], -1, -1, 
		[Idx: cleanup percent], -1, 
		[Idx: min space], 
		[Idx: alert space], -1, -1,
		[Idx: age days]
FROM	
	(SELECT	MH.ClientId, CP.attrName, CASE WHEN CAST(CP.attrVal AS FLOAT) < 4294967295 THEN CAST(CP.attrVal AS FLOAT) ELSE -1 END AS attrVal
	FROM	MMHost MH WITH (NOLOCK)
			INNER JOIN APP_ClientProp CP WITH (NOLOCK) ON CP.componentNameId = MH.ClientId
	WHERE	CP.attrName IN ('Idx: cache enabled', 'Idx: cleanup percent', 'Idx: alert space', 'Idx: min space', 'Idx: age days') 
		AND ISNUMERIC(CP.attrVal) = 1 AND CP.modified = 0) S
	PIVOT
	(
		MAX(attrVal)
		FOR attrName IN ([Idx: cache enabled], [Idx: cleanup percent], [Idx: alert space], [Idx: min space], [Idx: age days])
	) P

-- MA created before v11
INSERT	INTO #TblCatlogOptions
SELECT	IAP.ClientId,
		IAP.Enabled, 
		CASE WHEN LEFT(IAP.Path, 2) = '\\' THEN 1 ELSE 0 END,
		IAP.Flags,
		IC.AgeingPercentDiskspace, 
		IC.CatalogServerClientId, 
		IC.DiskFreeThresholdMB, 
		IC.DiskFreeWarningThreshholdMB,
		IC.flags,
		IP.IsShared, 
		IP.AgeingNoOfDays
FROM	MMHost MH WITH (NOLOCK)
		INNER JOIN IdxAccessPath IAP WITH (NOLOCK) ON IAP.ClientId = MH.ClientId
		INNER JOIN IdxCache IC WITH (NOLOCK) ON IC.IdxCacheId = IAP.IdxCacheId AND IC.IdxCacheType = 1
		INNER JOIN IdxPool IP WITH (NOLOCK) ON IP.IdxPoolId = IC.IdxPoolId
		LEFT OUTER JOIN #TblCatlogOptions T ON T.ClientId = MH.ClientId
WHERE	T.ClientId IS NULL

CREATE TABLE #TblFirewallOptions 
(
		ClientId INT, IsTrivialConfig INT, NetworkWithCS INT, ConnectionWithCS INT, ProxyClientIdCS INT,
		NetworkWithMA INT, ConnectionWithMA INT, ProxyClientIdMA INT,
		KeepAliveSeconds INT, TunnelInitSeconds INT, ForeceSSL INT, LockDown INT, 
		BindOpenPortsOnly INT, IsDMZ INT, IsRoamingClient INT, ExtendedProp XML, DefaultOutgoingProtocol INT
)

IF ( @csReleaseId < 15)            
	INSERT	INTO #TblFirewallOptions
	SELECT	MH.ClientId, 0, 0, 0, 0, 0, 0, 0,
			ISNULL(FWO.keepAliveSeconds, 0),
			ISNULL(FWO.tunnelInitSeconds, 0),
			ISNULL(FWO.foreceSSL, 0),
			ISNULL(FWO.lockDown, 0),	
			ISNULL(FWO.bindOpenPortsOnly, 0),
			ISNULL(FWO.isDMZ, 0),
			0,
			CAST (CP.stringVal AS XML),
			0
	FROM	MMHost MH WITH (NOLOCK)
			LEFT OUTER JOIN APP_FirewallOptions FWO WITH (NOLOCK) ON FWO.clientId = MH.ClientId
			LEFT OUTER JOIN APP_ComponentProp CP WITH (NOLOCK) ON CP.componentId = MH.ClientId AND CP.propertyTypeId = 2101 AND CP.modified = 0
ELSE
BEGIN     
	SET @sqlstr = N'                                          
INSERT	INTO #TblFirewallOptions
SELECT	MH.ClientId, 
		ISNULL(FWT.isTrivialConfig, 0),
		ISNULL(FWT.networkWithCS, 0),
		ISNULL(FWT.connectionWithCS, 0),
		ISNULL(FWT.proxyClientIdCS, 0),
		ISNULL(FWT.networkWithMA, 0),
		ISNULL(FWT.connectionWithMA, 0),
		ISNULL(FWT.proxyClientIdMA, 0),
		ISNULL(FWO.keepAliveSeconds, 0),
		ISNULL(FWO.tunnelInitSeconds, 0),
		ISNULL(FWO.foreceSSL, 0),
		ISNULL(FWO.lockDown, 0),	
		ISNULL(FWO.bindOpenPortsOnly, 0),
		ISNULL(FWO.isDMZ, 0),
		ISNULL(FWO.isRoamingClient, 0),
		CAST (CP.stringVal AS XML),
		0
FROM	MMHost MH WITH (NOLOCK)
		LEFT OUTER JOIN App_FWTrivialConfig FWT WITH (NOLOCK) ON FWT.clientId = MH.ClientId
		LEFT OUTER JOIN APP_FirewallOptions FWO WITH (NOLOCK) ON FWO.clientId = MH.ClientId
		LEFT OUTER JOIN APP_ComponentProp CP WITH (NOLOCK) ON CP.componentId = MH.ClientId AND CP.propertyTypeId = 2101 AND CP.modified = 0'

	EXEC sp_executesql @sqlstr
END

UPDATE	#TblFirewallOptions
SET		DefaultOutgoingProtocol = (
			SELECT TOP 1 ref.value('@defaultOutgoingProtocol', 'NVARCHAR(1)')
			FROM ExtendedProp.nodes('App_FirewallExtendedProperties') R(ref))
WHERE	ExtendedProp IS NOT NULL

DECLARE @TblNWThrottleOptions TABLE 
(
		ClientId INT, Enabled INT, ShareBandwidth INT, Options XML, 
		DaysOfWeek VARCHAR(8), StartTime VARCHAR(8), EndTime VARCHAR(8), IsAbsolute INT, 
		SendEnabled INT, SendRate INT, SendRatePct INT, 
		RecvEnabled INT, RecvRate INT, RecvRatePct INT
)

INSERT	INTO @TblNWThrottleOptions
SELECT	MH.ClientId, 1, 
		CASE WHEN NTO.NetworkThrottleOptions.exist('/App_ThrottleScheduleOptionList') = 1
			 THEN (SELECT TOP 1 ref.value('@shareBandwidth', 'NVARCHAR(1)')
					 FROM NTO.NetworkThrottleOptions.nodes('App_ThrottleScheduleOptionList') R(ref))
			 ELSE (SELECT TOP 1 ref.value('@shareBandwidth', 'NVARCHAR(1)')
					 FROM NTO.NetworkThrottleOptions.nodes('EVGui_ThrottleScheduleOptionList') R(ref))
		END,
		CASE WHEN NTO.NetworkThrottleOptions.exist('/App_ThrottleScheduleOptionList') = 1
			 THEN NTO.NetworkThrottleOptions.query('/App_ThrottleScheduleOptionList/throttle')
			 ELSE NTO.NetworkThrottleOptions.query('/EVGui_ThrottleScheduleOptionList/throttle')
		END,
		'','','',0,0, 0,0,0,0,0
FROM	MMHost MH WITH (NOLOCK)
		INNER JOIN APP_ClientProp CP WITH (NOLOCK) ON CP.componentNameId = MH.ClientId AND CP.attrName='Network Throttle Enabled' AND CP.modified = 0
		INNER JOIN APP_NetworkThrottleOptions NTO WITH (NOLOCK) ON NTO.clientId = MH.ClientId

UPDATE	@TblNWThrottleOptions
SET		DaysOfWeek	= (SELECT TOP 1 ref.value('@days', 'INT') FROM Options.nodes('throttle') R(ref)),
		StartTime	= (SELECT TOP 1 ref.value('@startTime', 'NVARCHAR(8)') FROM Options.nodes('throttle') R(ref)),
		EndTime		= (SELECT TOP 1 ref.value('@endTime', 'NVARCHAR(8)') FROM Options.nodes('throttle') R(ref)),
		IsAbsolute	= (SELECT TOP 1 ref.value('@isAbsolute', 'INT') FROM Options.nodes('throttle') R(ref)),
		SendEnabled	= (SELECT TOP 1 ref.value('@sendEnabled', 'INT') FROM Options.nodes('throttle') R(ref)),
		SendRate	= (SELECT TOP 1 ref.value('@sendRate', 'INT') FROM Options.nodes('throttle') R(ref)),
		SendRatePct	= (SELECT TOP 1 ref.value('@sendRatePercent', 'INT') FROM Options.nodes('throttle') R(ref)),
		RecvEnabled	= (SELECT TOP 1 ref.value('@receiveEnabled', 'INT') FROM Options.nodes('throttle') R(ref)),
		RecvRate	= (SELECT TOP 1 ref.value('@recvRate', 'INT') FROM Options.nodes('throttle') R(ref)),
		RecvRatePct	= (SELECT TOP 1 ref.value('@recvRatePercent', 'INT') FROM Options.nodes('throttle') R(ref))


SET @surveyXML =
	(SELECT	MH.ClientId AS '@MAClientID', 
			CL.name AS '@MediaAgentName', 
			R.release + V.Version AS '@MAReleaseVersion',
			MH.MmHostEnabled AS '@MAEnabled', 
			MH.Attribute AS '@MAAttribute', 
			MH.ScanIntervalInSec AS '@ScanIntervalInSec',
			MH.MaxReservations AS '@MaxReservations',
			ISNULL(NER.RetryFlag, 1) AS '@NwErrorRetryFlag',
			ISNULL(NER.RetryFrequency, 30) AS '@NwErrorRetryFrequency',
			ISNULL(NER.RetryCount, 40) AS '@NwErrorRetryCount',
			ISNULL(IC.AccessPathEnabled, -1) AS '@AccessPathEnabled', 
			ISNULL(IC.UseNetworkShare, -1) AS '@UseNetworkShare',
			ISNULL(IC.AccessPathFlags, -1) AS '@AccessPathFlags',
			100 - ISNULL(IC.IdxCleanupPct, 15) AS '@IdxCleanupPct', 
			ISNULL(IC.IdxCacheServerClientId, -1) AS '@IdxCacheServerClientId', 
			ISNULL(IC.IdxMinFreeSpaceMB, -1) AS '@IdxMinFreeSpaceMB', 
			ISNULL(IC.IdxFreeSpaceWarningMB, -1) AS '@IdxFreeSpaceWarningMB',
			ISNULL(IC.IdxCacheFlags, -1) AS '@IdxCacheFlags',
			ISNULL(IC.IdxPoolIsShared, -1) AS '@IdxPoolIsShared', 
			ISNULL(IC.IdxRetentionDays, 15) AS '@IdxRetentionDays',
			FWO.IsTrivialConfig AS '@FirewallSettings',
			FWO.NetworkWithCS AS '@FwNetworkWithCS', 
			FWO.ConnectionWithCS AS '@FwConnectionWithCS', 
			CASE WHEN FWO.ProxyClientIdCS > 0 THEN 1 ELSE 0 END AS '@FwUseRemoteProxyCS',
			FWO.NetworkWithMA AS '@FwNetworkWithMA', 
			FWO.ConnectionWithMA AS '@FwConnectionWithMA', 
			CASE WHEN FWO.ProxyClientIdMA > 0 THEN 1 ELSE 0 END AS '@FwUseRemoteProxyMA',
			FWO.KeepAliveSeconds AS '@FwKeepAliveSeconds',
			FWO.TunnelInitSeconds AS '@FwTunnelInitSeconds',
			FWO.ForeceSSL AS '@FwForeceSSL',
			FWO.LockDown AS '@FwLockDown',		
			FWO.BindOpenPortsOnly AS '@FwBindOpenPortsOnly',
			FWO.IsDMZ AS '@FwIsDMZ',
			FWO.IsRoamingClient AS '@FwIsRoamingClient',
			ISNULL(FWO.DefaultOutgoingProtocol, 0) AS '@FwDefOutgoingProtocol',
			ISNULL(NTO.Enabled, 0) AS '@NwThrottlingEnabled', 
			ISNULL(NTO.ShareBandwidth, 0) AS '@NwShareBandwidth', 
			ISNULL(NTO.DaysOfWeek, '') AS '@NwDaysOfWeek', 
			ISNULL(NTO.StartTime, '') AS '@NwStartTime',  
			ISNULL(NTO.EndTime, '') AS '@NwEndTime', 
			ISNULL(NTO.IsAbsolute, 0) AS '@NwIsAbsolute', 
			ISNULL(NTO.SendEnabled, 0) AS '@NwSendEnabled', 
			ISNULL(NTO.SendRate, 0 )AS '@NwSendRate', 
			ISNULL(NTO.SendRatePct, 0) AS '@NwSendRatePct', 
			ISNULL(NTO.RecvEnabled, 0) AS '@NwRecvEnabled', 
			ISNULL(NTO.RecvRate, 0) AS '@NwRecvRate', 
			ISNULL(NTO.RecvRatePct, 0) AS '@NwRecvRatePct'
			
	FROM	MMHost MH WITH (NOLOCK)
			INNER JOIN APP_Client CL WITH (NOLOCK) ON CL.id = MH.ClientId
			INNER JOIN simAllGalaxyRel R WITH (NOLOCK) ON R.id = CL.releaseId 
			INNER JOIN #TblCatlogOptions IC WITH (NOLOCK) ON IC.ClientId = MH.ClientId
			INNER JOIN (SELECT ClientID, 
							  (CASE WHEN HighestSP > 0 THEN '.' + CAST(HighestSP AS VARCHAR(20)) ELSE '' END 
							  +CASE WHEN SpMinorVersion > 0 THEN CHAR(96 + SpMinorVersion) ELSE '' END) AS Version 
						FROM	simInstalledPackages WITH (NOLOCK)
						WHERE	simPackageID IN (SELECT id FROM simPackage WITH (NOLOCK) WHERE Name = 'MediaAgent')) V
						ON V.ClientId = MH.ClientId
			LEFT OUTER JOIN @TblNWErrorRetry NER ON NER.clientId = MH.ClientId
			INNER JOIN #TblFirewallOptions FWO ON FWO.clientId = MH.ClientId
			LEFT OUTER JOIN @TblNWThrottleOptions NTO ON NTO.clientId = MH.ClientId

	FOR XML PATH ('MediaAgentProp') 
	-- Replace <<RESULTS_NAME>> with specific name
	)

DROP TABLE #TblFirewallOptions
DROP TABLE #TblCatlogOptions

--------- END SURVEY QUERY ---------

--------- BEGIN - GENERATED CODE, PLEASE DO NOT MODIFY ---------

DECLARE @EndTime AS BIGINT = dbo.GetUnixTime(GETUTCDATE())
SET @outputXML = 
(
	SELECT
		@queryId AS '@QueryId',
		@EndTime AS '@LogDate',
		(@EndTime - @LogDate) AS '@QueryRunningTime',
		@surveyXML
	FOR XML PATH('Rpt_CSSXMLDATA')
)
SET NOCOUNT OFF

--------- END - GENERATED CODE ---------