--- Please follow the below comments to insert SQL statements.
-- Client version query
--------- BEGIN - GENERATED CODE, PLEASE DO NOT MODIFY ---------

SET NOCOUNT ON

DECLARE @LogDate AS BIGINT = dbo.GetUnixTime(GETUTCDATE())
DECLARE @queryId AS INTEGER = 63
DECLARE @surveyXML NVARCHAR(MAX)

--------- END - GENERATED CODE ---------



--------- BEGIN SURVEY QUERY ---------

--------- Insert your SQL statements here 

-- Display differences from a user selected storage policy

DECLARE @nreleaseId INT =1
DECLARE @nstring NVARCHAR(MAX)
DECLARE @DedupStoreUsage XML
SET @nreleaseId =(SELECT releaseId from APP_Client WITH (NOLOCK) where id =2)

IF object_id('tempdb.dbo.#tmpCopyInfo') is not null DROP TABLE #tmpCopyInfo 
	CREATE TABLE #tmpCopyInfo 
(
	[ArchPolicyID] [int] NOT NULL,
	[StoragePolicyName] [nvarchar](256) NOT NULL,
	[NumberOfStreams] [int] NOT NULL,
	[StoragePolicytype] [int] NOT NULL,
	[StoragePolicyFlags] [int] NOT NULL,
	[IncrementalPolicyId] [int] NOT NULL,
	[SIBlockSizeKB] [int] NOT NULL,
	[AuxCopyAlertGB] [int] NOT NULL,
	[AuxCopyAlertDays] [int] NOT NULL,
	[TimeZoneType] [int] NOT NULL,
	[NumberOfCopies] [int] NOT NULL,
	[NumberOfSnapCopies] [int] NOT NULL,
	[ArchCopyID] [int] NOT NULL,
	[CopyName] [nvarchar](256) NOT NULL,
	[IsSnapcopy] [int] NOT NULL,
	[Type] [int] NOT NULL,
	[MaxMultiplex] [int] NOT NULL,
	[Flags] [int] NOT NULL,
	[DedupeFlags] [int] NOT NULL,
	[ExtendedFlags] [int] NOT NULL,
	[WaitForIfOffline] [int] NOT NULL,
	[WaitForIfBusy] [int] NOT NULL,
	[SilosInCache] [int] NOT NULL,
	[DrivePoolType] [int] NOT NULL,
	[NewStorePeriodType] [int] NOT NULL,
	[NewStoreNumPeriod] [int] NOT NULL,
	[NewStoreSizeTB] [int] NOT NULL,
	[MaxCorruptPartitions] [int] NOT NULL,
	[SIDBStoreFlags] [int] NOT NULL,
	[DDBPartitions] [int] NOT NULL,
	[MRFlags] [int] NOT NULL,
	[MRDaysAfterWritten] [int] NOT NULL,
	[MRDaysBeforeAged] [int] NOT NULL,
	[MRPercentage] [int] NOT NULL,
	[RetentionDays] [int] NOT NULL,
	[RetentionCycles] [int] NOT NULL,
	[ArchiverRetentionDays] [int] NOT NULL,
	[RetentionJobs] [int] NOT NULL,
	[AgingFlags] [int] NOT NULL,
	[ExtRetentionRule] [int] NOT NULL,
	[ExtRetentionDays] [int] NOT NULL,
	[ExtRetentionGraceDays] [int] NOT NULL,
	[CIEnabled] [int] NOT NULL,
	[CIType] [int] NOT NULL,
	[CIFlags] [int] NOT NULL,
	[CISubclientAssoc] [int] NOT NULL,
	[CISourceCopyId] [int] NOT NULL,
	[CIDeferredDays] [int] NOT NULL,
	[CIRetentionDays] [int] NOT NULL,
	[CINumberPeriod] [int] NOT NULL,
	[CIDayNumber] [int] NOT NULL,
	[CIMinDocSizeKB] [int] NOT NULL,
	[CIMaxDocSizeKB] [int] NOT NULL,
	[CIIncludeDocTypes] [nvarchar] (max) NOT NULL,
	[CIExcludeDocTypes] [nvarchar] (max) NOT NULL,
	[CIEntityIds] [nvarchar] (max) NOT NULL,
	[CIFilterSelected] [int] NOT NULL,
	[BCEnabled] [int] NOT NULL,
	[BCType] [int] NOT NULL,
	[BCFlags] [int] NOT NULL,
	[BCSourceCopyId] [int] NOT NULL,
	[BCDeferredDays] [int] NOT NULL,
	[BCNumberPeriod] [int] NOT NULL,
	[BCDayNumber] [int] NOT NULL,
)


SET @nstring =N''

IF(@nreleaseId =14)
BEGIN

SET @nstring =@nstring +N'
		INSERT INTO #tmpCopyInfo	
			-- Include your select columns here
			SELECT
				AG.ID,
				AG.name,
				AG.maxStreams, 
				AG.type,
				AG.flags,
				AG.incrSP,
				AG.SIBlockSizeKB,
				AG.AuxCopyAlertGB,
				AG.AuxCopyAlertDays,
				AG.TimeZoneType,
				C.NumberOfCopies,
				C.NumberOfSnapCopies,
				
				AGC.ID,
				AGC.name,				
				AGC.isSnapCopy,
				AGC.type, 
				AGC.maxMultiplex,
				AGC.flags,
				AGC.dedupeFlags,
				0,
				AGC.WaitForIfOffline,
				AGC.WaitForIfBusy,
				AGC.SilosInCache,
				DPL.DrivePoolType,
				AT.periodType, 
				AT.numPeriod, 
				AT.dataSizeGB/1024,
				0,
				ISNULL(SI.flags, 0),
				(SELECT COUNT(*) FROM IdxSIDBSubStore WITH (NOLOCK) WHERE SIDBStoreId = AGC.SIDBStoreId AND SIDBStoreId > 0),

				ISNULL(MR.flags, 0),
				ISNULL(MR.daysAfterWritten, 0),
				ISNULL(MR.daysBeforeAged, 0),
				ISNULL(MR.percentage, 0),

				AGR.retentionDays,
				AGR.fullCycles,
				AGR.archiverRetDays,
				0,
				AGR.flags,
				
				ISNULL(ARE.retentionRule, 0),
				ISNULL(ARE.retentionDays, 0),
				ISNULL(ARE.GraceDays, 0),
			
				ISNULL(ACIR.enabled, 0),
				ISNULL(ACIR.type, 0),
				ISNULL(ACIR.flags, 0),
				(SELECT COUNT(*) FROM archContentIndexingApp WITH (NOLOCK) WHERE archGroupId = ACIR.archGroupId AND clientId > 0),
				ISNULL(ACIR.sourceCopyId, 0),
				ISNULL(ACIR.deferredDays, 0),
				ISNULL(ACIR.retentionDays, 0),
				ISNULL(ACIR.numPeriod, 0),
				ISNULL(ACIR.dayNumber, 0),
				ISNULL(ACIR.minDocSizeKB, 0),
				ISNULL(ACIR.maxDocSizeKB, 0),
				ISNULL(ACIR.includeDocTypes, ''''),
				ISNULL(ACIR.excludeDocTypes, ''''),
				ISNULL(ACIR.entityIds, ''''),
				0,
				
				ISNULL(AMSP.enabled, 0),
				ISNULL(AMSP.type, 0),
				ISNULL(AMSP.flags, 0),
				ISNULL(AMSP.SourceCopyId, 0),
				ISNULL(AMSP.deferredDays, 0),
				ISNULL(AMSP.numPeriod, 0),
				ISNULL(AMSP.dayNumber, 0)
				
				FROM  archGroup AG WITH (NOLOCK) 
					INNER JOIN (SELECT archGroupId, COUNT(*) AS NumberOfCopies, SUM(isSnapCopy) AS NumberOfSnapCopies
						FROM archGroupCopy WITH (NOLOCK) WHERE type IN (1, 2, 3) AND (flags & 524288) = 0 
						GROUP BY archGroupId) C ON AG.id = C.archGroupId
					INNER JOIN archGroupCopy AGC WITH (NOLOCK) ON AG.id = AGC.archGroupId AND AGC.id IN (AG.defaultCopy, AG.defaultSnapCopy) AND AG.id > 1
					INNER JOIN archTask AT WITH (NOLOCK) ON AT.id = AGC.sealStoreTaskId
					INNER JOIN MMDataPath DPT WITH (NOLOCK) ON AGC.id = DPT.CopyId AND (DPT.Flag & 1) > 0
					INNER JOIN MMDrivePool DPL WITH (NOLOCK) ON DPT.DrivePoolId = DPL.DrivePoolId
					INNER JOIN archAgingRule AGR WITH (NOLOCK) ON AGC.id = AGR.copyId
					LEFT OUTER JOIN IdxSIDBStore SI WITH (NOLOCK) ON SI.SIDBStoreId = AGC.SIDBStoreId AND AGC.SIDBStoreId > 0
					LEFT OUTER JOIN archAgingRuleExtended ARE WITH (NOLOCK) ON ARE.copyId = AGC.id
					LEFT OUTER JOIN archCopyMediaRefreshProp MR WITH (NOLOCK) ON MR.copyId = AGC.id
					LEFT OUTER JOIN archContentIndexingRules ACIR WITH (NOLOCK) ON ACIR.archGroupId = AG.id
					LEFT OUTER JOIN archMaterializeSnapshotProp AMSP WITH (NOLOCK) ON AMSP.archGroupId = AG.id
				ORDER BY AG.id'
END
ELSE IF(@nreleaseId >=15)
BEGIN
	SET @nstring =@nstring +N' 
		INSERT INTO #tmpCopyInfo	
			-- Include your select columns here
			SELECT
				AG.ID,
				AG.name,
				AG.maxStreams, 
				AG.type,
				AG.flags,
				AG.incrSP,
				AG.SIBlockSizeKB,
				AG.AuxCopyAlertGB,
				AG.AuxCopyAlertDays,
				AG.TimeZoneType,
				C.NumberOfCopies,
				C.NumberOfSnapCopies,
				
				AGC.ID,
				AGC.name,				
				AGC.isSnapCopy,
				AGC.type, 
				AGC.maxMultiplex,
				AGC.flags,
				AGC.dedupeFlags,
				AGC.extendedFlags,
				AGC.WaitForIfOffline,
				AGC.WaitForIfBusy,
				AGC.SilosInCache,
				DPL.DrivePoolType,
				AT.periodType, 
				AT.numPeriod, 
				AT.dataSizeGB/1024,
				AT.percentCorruptLimit,
				ISNULL(CSI.flags, 0),
				ISNULL(CSI.SubStoreCount, 0),

				ISNULL(MR.flags, 0),
				ISNULL(MR.daysAfterWritten, 0),
				ISNULL(MR.daysBeforeAged, 0),
				ISNULL(MR.percentage, 0),

				AGR.retentionDays,
				AGR.fullCycles,
				AGR.archiverRetDays,
				AGR.retentionJobs,
				AGR.flags,
				
				ISNULL(ARE.retentionRule, 0),
				ISNULL(ARE.retentionDays, 0),
				ISNULL(ARE.GraceDays, 0),
				
				ISNULL(ACIR.enabled, 0),
				ISNULL(ACIR.type, 0),
				ISNULL(ACIR.flags, 0),
				(SELECT COUNT(*) FROM archContentIndexingApp WITH (NOLOCK) WHERE archGroupId = ACIR.archGroupId AND clientId > 0),
				ISNULL(ACIR.sourceCopyId, 0),
				ISNULL(ACIR.deferredDays, 0),
				ISNULL(ACIR.retentionDays, 0),
				ISNULL(ACIR.numPeriod, 0),
				ISNULL(ACIR.dayNumber, 0),
				ISNULL(ACIR.minDocSizeKB, 0),
				ISNULL(ACIR.maxDocSizeKB, 0),
				ISNULL(ACIR.includeDocTypes, ''''),
				ISNULL(ACIR.excludeDocTypes, ''''),
				ISNULL(ACIR.entityIds, ''''),
				ISNULL(ACIR.filterSelected, 0),
				
				ISNULL(AMSP.enabled, 0),
				ISNULL(AMSP.type, 0),
				ISNULL(AMSP.flags, 0),
				ISNULL(AMSP.SourceCopyId, 0),
				ISNULL(AMSP.deferredDays, 0),
				ISNULL(AMSP.numPeriod, 0),
				ISNULL(AMSP.dayNumber, 0)
				
				FROM  archgroup AG WITH (NOLOCK)
					INNER JOIN (SELECT archGroupId, COUNT(*) AS NumberOfCopies, SUM(isSnapCopy) AS NumberOfSnapCopies
						FROM archGroupCopy WITH (NOLOCK) WHERE type IN (1, 2, 3) AND (flags & 524288) = 0 AND isActive = 1
						GROUP BY archGroupId) C ON AG.id = C.archGroupId
					INNER JOIN archGroupCopy AGC WITH (NOLOCK) ON AG.id = AGC.archGroupId AND AGC.id IN (AG.defaultCopy, AG.defaultSnapCopy) AND AG.id > 1
					INNER JOIN archTask AT WITH (NOLOCK) ON AT.id = AGC.sealStoreTaskId
					INNER JOIN MMDataPath DPT WITH (NOLOCK) ON AGC.id = DPT.CopyId AND (DPT.Flag & 1) > 0
					INNER JOIN MMDrivePool DPL WITH (NOLOCK) ON DPT.DrivePoolId = DPL.DrivePoolId
					INNER JOIN archAgingRule AGR WITH (NOLOCK) ON AGC.id = AGR.copyId
					LEFT OUTER JOIN
						(SELECT	CS.CopyID, MIN(SI.flags) AS flags, MAX(SI.SubStoreCount) AS SubStoreCount
						FROM	archCopySIDBStore CS WITH (READUNCOMMITTED) 
								INNER JOIN IdxSIDBStore SI WITH (NOLOCK) ON SI.SIDBStoreId = CS.SIDBStoreId AND CS.SIDBStoreId > 0 AND SI.SealedTime = 0
						GROUP BY CS.CopyID) CSI ON CSI.copyId = AGC.id 					
					LEFT OUTER JOIN archCopyMediaRefreshProp MR WITH (NOLOCK) ON MR.copyId = AGC.id
					LEFT OUTER JOIN archAgingRuleExtended ARE WITH (NOLOCK) ON ARE.copyId = AGC.id
					LEFT OUTER JOIN archContentIndexingRules ACIR WITH (NOLOCK) ON ACIR.archGroupId = AG.id
					LEFT OUTER JOIN archMaterializeSnapshotProp AMSP WITH (NOLOCK) ON AMSP.archGroupId = AG.id
				ORDER BY AG.id'
END

exec sp_executesql @nstring

SET @surveyXML = (
	SELECT
	(	SELECT
			ArchPolicyID as '@ID',
			StoragePolicyName as '@StoragePolicyName', 
			NumberOfStreams '@NumberofStreams', 
			StoragePolicytype as '@StoragePolicytype',
			StoragePolicyFlags as '@StoragePolicyFlags',
			IncrementalPolicyId as '@IncrementalPolicyId',
			SIBlockSizeKB as '@SIBlockSizeKB',
			AuxCopyAlertGB as '@AuxCopyAlertGB',
			AuxCopyAlertDays as '@AuxCopyAlertDays',
			TimeZoneType as '@TimeZoneType',
			NumberOfCopies AS '@NumberOfCopies',
			NumberOfSnapCopies AS '@NumberOfSnapCopies',

			ArchCopyID AS 'ArchiveGroupCopy/@ID',
			CopyName AS 'ArchiveGroupCopy/@CopyName',
			ArchPolicyID as 'ArchiveGroupCopy/@ArchGroupID',
			IsSnapcopy AS 'ArchiveGroupCopy/@IsSnapcopy',
			Type AS 'ArchiveGroupCopy/@Type', 
			MaxMultiplex AS 'ArchiveGroupCopy/@MaxMultiplex', 
			Flags AS 'ArchiveGroupCopy/@Flags',
			DedupeFlags AS 'ArchiveGroupCopy/@DedupeFlags',
			ExtendedFlags AS 'ArchiveGroupCopy/@ExtendedFlags',
			WaitForIfOffline AS 'ArchiveGroupCopy/@WaitForIfOffline',
			WaitForIfBusy AS 'ArchiveGroupCopy/@WaitForIfBusy',
			SilosInCache AS 'ArchiveGroupCopy/@SilosInCache',
			DrivePoolType AS 'ArchiveGroupCopy/@DrivePoolType',
			NewStorePeriodType AS 'ArchiveGroupCopy/@NewStorePeriodType',
			NewStoreNumPeriod AS 'ArchiveGroupCopy/@NewStoreNumPeriod',
			NewStoreSizeTB AS 'ArchiveGroupCopy/@NewStoreSizeTB',
			MaxCorruptPartitions AS 'ArchiveGroupCopy/@MaxCorruptPartitions',
			SIDBStoreFlags AS 'ArchiveGroupCopy/@SIDBStoreFlags',
			DDBPartitions AS 'ArchiveGroupCopy/@DDBPartitions',
			
			MRFlags AS 'ArchiveGroupCopy/@MRFlags',
			MRDaysAfterWritten AS 'ArchiveGroupCopy/@MRDaysAfterWritten',
			MRDaysBeforeAged AS 'ArchiveGroupCopy/@MRDaysBeforeAged',
			MRPercentage AS 'ArchiveGroupCopy/@MRPercentage',

			RetentionDays AS 'ArchiveGroupCopy/@RetentionDays',
			RetentionCycles AS 'ArchiveGroupCopy/@RetentionCycles' ,
			ArchiverRetentionDays AS 'ArchiveGroupCopy/@ArchiverRetentionDays',
			RetentionJobs AS 'ArchiveGroupCopy/@RetentionJobs',
			AgingFlags AS 'ArchiveGroupCopy/@AgingFlags',
			
			ArchCopyID AS 'ExtendedRetention/@CopyID',
			ExtRetentionRule AS 'ExtendedRetention/@RetentionRule',
			ExtRetentionDays AS 'ExtendedRetention/@RetentionDays',
			ExtRetentionGraceDays AS 'ExtendedRetention/@GraceDays',

			ArchPolicyID as 'BackupCopyInfo/@ArchGroupID',
			BCEnabled as 'BackupCopyInfo/@Enabled',
			BCType as 'BackupCopyInfo/@Type',
			BCFlags as 'BackupCopyInfo/@Flags',
			BCSourceCopyId as 'BackupCopyInfo/@SourceCopyId',
			BCDeferredDays as 'BackupCopyInfo/@DeferredDays',
			BCNumberPeriod as 'BackupCopyInfo/@NumberPeriod',
			BCDayNumber as 'BackupCopyInfo/@DayNumber',
			
			ArchPolicyID as 'ContentIndexing/@ArchGroupID',
			CIEnabled as 'ContentIndexing/@Enabled',
			CIType as 'ContentIndexing/@Type',
			CIFlags as 'ContentIndexing/@Flags',
			CISubclientAssoc as 'ContentIndexing/@SubclientAssoc',
			CISourceCopyId as 'ContentIndexing/@SourceCopyId',
			CIDeferredDays as 'ContentIndexing/@DeferredDays',
			CIRetentionDays as 'ContentIndexing/@RetentionDays',
			CINumberPeriod as 'ContentIndexing/@NumberPeriod',
			CIDayNumber as 'ContentIndexing/@DayNumber',
			CIMinDocSizeKB as 'ContentIndexing/@MinDocSizeKB',
			CIMaxDocSizeKB as 'ContentIndexing/@MaxDocSizeKB',
			CIIncludeDocTypes as 'ContentIndexing/@IncludeDocTypes',
			CIExcludeDocTypes as 'ContentIndexing/@ExcludeDocTypes',
			CIEntityIds as 'ContentIndexing/@EntityIds',
			CIFilterSelected as 'ContentIndexing/@FilterSelected'
			
			FROM  #tmpCopyInfo
			FOR XML PATH('ArchiveGroupInfo'), TYPE
		)
		FOR XML PATH ('StoragePoliciesDetails') 
	-- Replace <<RESULTS_NAME>> with specific name
	)

--------- END SURVEY QUERY ---------

--------- BEGIN - GENERATED CODE, PLEASE DO NOT MODIFY ---------

DECLARE @EndTime AS BIGINT = dbo.GetUnixTime(GETUTCDATE())
SET @outputXML = 
(
	SELECT
		@queryId AS '@QueryId',
		@EndTime AS '@LogDate',
		(@EndTime - @LogDate) AS '@QueryRunningTime',
		@surveyXML
	FOR XML PATH('Rpt_CSSXMLDATA')
)
SET NOCOUNT OFF

--------- END - GENERATED CODE ---------