--- Please follow the below comments to insert SQL statements.
--- Client Configuration Audit query
--------- BEGIN - GENERATED CODE, PLEASE DO NOT MODIFY ---------

SET NOCOUNT ON
SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED

DECLARE @LogDate AS BIGINT = dbo.GetUnixTime(GETUTCDATE())
DECLARE @queryId AS INTEGER = 180
DECLARE @surveyXML NVARCHAR(MAX)

--------- END - GENERATED CODE ---------



--------- BEGIN SURVEY QUERY ---------

--------- Insert your SQL statements here 
DECLARE	@CLIENT_TYPE_WINDOWS		VARCHAR(32) = 'Windows'
DECLARE	@CLIENT_TYPE_UNIX			VARCHAR(32) = 'UNIX'
DECLARE	@CLIENT_TYPE_NAS			VARCHAR(32) = 'NAS'
DECLARE	@CLIENT_TYPE_LAPTOP			VARCHAR(32) = 'Laptop'
DECLARE	@CLIENT_TYPE_VM				VARCHAR(32) = 'VM'
DECLARE	@CLIENT_TYPE_OUTLOOK_ADDIN	VARCHAR(32) = 'Outlook Add-in'
DECLARE	@CLIENT_TYPE_ANY			VARCHAR(32) = 'Any'

DECLARE	@SUBCLIENT_TYPE_OTHERS		VARCHAR(32) = ''
DECLARE	@SUBCLIENT_TYPE_DEFAULT		VARCHAR(32) = 'Default'
DECLARE	@SUBCLIENT_TYPE_CMDLINE		VARCHAR(32) = 'Command Line'
DECLARE	@SUBCLIENT_TYPE_LOGCMDLINE	VARCHAR(32) = 'Log Command Line'
DECLARE	@SUBCLIENT_TYPE_INDEXBACKUP	VARCHAR(32) = 'Index Backup'
DECLARE	@SUBCLIENT_TYPE_DDBBACKUP	VARCHAR(32) = 'DDB Backup'
DECLARE	@SUBCLIENT_TYPE_SILOBACKUP	VARCHAR(32) = 'SILO Backup'

DECLARE @sqlstr NVARCHAR(MAX)
DECLARE @csReleaseId INT
SELECT	@csReleaseId = releaseId FROM APP_Client WITH (NOLOCK) WHERE id = 2

CREATE TABLE #Parameter (
	ClientId INT, AppTypeId INT, InstanceId INT, BackupsetId INT, AppId INT, Category INT, 
	Property VARCHAR(64), Name NVARCHAR(1024), Value NVARCHAR(MAX), DefaultValue NVARCHAR(MAX))

CREATE TABLE #Client (
	id INT, name NVARCHAR(256), simOperatingSystemId INT, releaseId INT, 
	spaceCheckFlags INT, specialClientFlags INT, clientType VARCHAR(32))

CREATE TABLE #ClientProp (
	clientId INT, Name NVARCHAR(1024), Value NVARCHAR(MAX))

INSERT	INTO #Client
SELECT	CL.id, CL.name, simOperatingSystemId, releaseId, spaceCheckFlags, specialClientFlags, 
		CASE WHEN OA.componentNameId IS NOT NULL THEN @CLIENT_TYPE_OUTLOOK_ADDIN 
			 WHEN VM.componentNameId IS NOT NULL THEN @CLIENT_TYPE_VM
			 WHEN (CL.status & 0x1000) > 0 THEN @CLIENT_TYPE_LAPTOP
			 WHEN NAS.ClientId IS NOT NULL THEN @CLIENT_TYPE_NAS
			 WHEN OS.Type = 'Unix' THEN @CLIENT_TYPE_UNIX
			 WHEN OS.Type = 'Windows' THEN @CLIENT_TYPE_WINDOWS
			 ELSE OS.Type END
FROM	APP_Client CL 
	INNER JOIN simOperatingSystem OS ON CL.simOperatingSystemId = OS.id
	LEFT OUTER JOIN (
		SELECT	componentNameId FROM APP_ClientProp
		WHERE	attrName = 'Outlook Addin Client' AND attrVal = '1' AND modified = 0
		) OA ON CL.id = OA.componentNameId
	LEFT OUTER JOIN (
		SELECT	componentNameId FROM APP_ClientProp
		WHERE	attrName = 'Virtual Server Discovered Clients' AND attrVal = '1' AND modified = 0
		) VM ON CL.id = VM.componentNameId
	LEFT OUTER JOIN (
		SELECT DISTINCT ClientId FROM MMNDMPHostInfo
	) NAS ON CL.id = NAS.ClientId
WHERE	CL.id > 1 AND (CL.status&(2|4) = 0 OR VM.componentNameId IS NULL)

INSERT	INTO #ClientProp
SELECT	T.id, attrName, attrVal
FROM	APP_ClientProp CP INNER JOIN #Client T ON CP.componentNameId = T.id
WHERE	attrName IN (
		'SP Version Info',
		'Patch Location flag',
		'Enable Data Security',
		'Snap Backups Enabled',
		'NW Err Retry Flag',
		'NW Err Retry Frequency',
		'NW Err Retry Count',
		'Enable Email Web App',
		'Exclude From SLA',
		'JMPriority',
		'Throttle Jobs Enabled',
		'Throttle Jobs - Data Threshold',
		'Throttle Jobs - Log Threshold',
		'AgingDays',
		'DiskFullPercent',
		'JobResultsThresholdMB',
		'Encryption Settings', 
		'Encrypt: rsaPubKey',
		'Encrypt: rsaPriKeySF',
		'Encrypt: restoreAccess',
		'Encrypt: drToolAccess',
		'Encrypt: Type',
		'Encrypt: Key Length',
		'Content Indexing Enabled',
		'Enable DeDuplication',
		'Optimize for High Latency Networks',
		'Maximum Cache Buffer Size',
		'Enable Intelligent Block Alignment',
		'Client Max DB Cache Size',
		'Enable Client Signature Cache',
		'VPNEnableClient',
		'VPNEnableRouter',
		'VPNEnableRemoteClientAccess',


		'Job Results Dir Username',
		'URL for Compliance Search',
		'URL for End-User Search',
		'URL for Administrator',
		'WebURL',
		'Web Server for Search',
		'Snap Shot Engine',
		'DataPipeInterface',
		'Proxy Content Indexing',
		'timezone',
		'Alt Cache Partition',
		'Centera Resource File',
		'FLR Log Filepath',
		'Virtual Client',
		'Active Physical Node',
		'Proxy for Exchange',
		'UPDATE CACHE AGENT ID',
		'Collect Delegate Information',
		'Do not Single Instance Email Messages',
		'Proxy Filesystem Client Id',
		'platformdeleted 4',
		'Content Indexing Engine',
		'Sim OS Info',
		'Exchange Mining Tool Path',
		'Data Classification Installed on Client',
		'HotSpot',
		'NoPhysicalMachinePresent',
		'File Level Analytics License',
		'Global Zone Host',
		'RMS SMTP Address',
		'Decrypt RMS document User name',
		'Decrypt RMS document Pass word',
		'Decrypt RMS document during CI',
		'WBA Configuration Parameters',
		'WBA Override Global settings',
		'Mini SRM Agent',
		'Virtual Server Discovered Clients',
		'Outlook Addin Client',
		'SharePoint WebService URL',
		'SharePoint WebService User name',
		'SharePoint WebService User password',
		'SharePoint Online Content Indexing',
		'Access Control Collection',
		'Configure Cluster Client',
		'All Agents',
		'Vs Member Servers',
		'Base Install Folder',
		'Open VMS proxy client',
		'Open VMS User Name',
		'Open VMS User Password',
		'WebSearchClient Web Server Client',
		'DM2WebService Web Site Port',
		'DM2WebService Search Web Alias',
		'Web Search Server for Recall',
		'Web Search Server for Super Search',
		'Recall Service',
		'enableDLP',
		'dlpStolen',
		'dlpEnableClientKeys',
		'dlpScanIntervalMins',
		'dlpMinFileAgeMins',
		'enableRmDLP',
		'dlpRmOfflineDays',
		'dlpRmNow',
		'dlpEnableAutomaticDecryption',
		'dlpUnlockMethod',
		'Exchange Administrator User name',
		'Exchange Administrator Smtp Address',
		'System Drive Type',
		'IndexingV2',
		'Qsnap installed',
		'Is Client Description in HTML Format'
		)
	AND	modified = 0

-- old settings for encryption on client
INSERT	INTO #ClientProp
SELECT	CL.id, 'Encryption Settings', CP.attrVal
FROM	APP_ClientProp CP 
	INNER JOIN #Client CL ON CP.componentNameId = CL.id
	LEFT OUTER JOIN #ClientProp T ON CL.id = T.clientId AND T.Name = 'Encryption Settings'
WHERE	CP.attrName = 'Encrypt: encryption' AND T.clientId IS NULL

-- Category: 1 for Client Properties, 2 for Network Properties, 3 for Agent Properties, 
-- 4 for Instance Properties, 5 for Backupset Properties, 6 for Subclient Properties

-- Category 1 for Client Properties

INSERT	INTO #Parameter
SELECT	id, 0, 0, 0, 0, 1, 'Client Information', 
		'Client Type', clientType, ''
FROM	#Client

INSERT	INTO #Parameter
SELECT	clientId, 0, 0, 0, 0, 1, 'Version Information', 
		'Software Version', Value, ''
FROM	#ClientProp
WHERE	Name = 'SP Version Info' AND Value <> ''

INSERT	INTO #Parameter
SELECT	id, 0, 0, 0, 0, 1, 'Version Information', 
		'Software Version', CASE releaseId WHEN 14 THEN '9.0' WHEN 15 THEN '10.0' WHEN 16 THEN '11.0' ELSE 'N/A' END, ''
FROM	#Client C
	LEFT OUTER JOIN #Parameter P ON C.id = P.clientId AND P.Name = 'Software Version'
WHERE	P.clientId IS NULL

--Convert to dotted format
UPDATE #Parameter
SET Value = replace(Value, '.0 SP', '.')
WHERE Name = 'Software Version'
UPDATE #Parameter
SET Value = replace(Value, ' SP', '.')
WHERE Name = 'Software Version'
UPDATE #Parameter
SET Value = replace(Value, ' HPK', '.')
WHERE Name = 'Software Version'
UPDATE #Parameter
SET Value = replace(Value, '+', '')
WHERE Name = 'Software Version'
UPDATE #Parameter
SET Value = replace(Value, '-', '')
WHERE Name = 'Software Version'
UPDATE #Parameter
SET Value = replace(Value, 'a', '.1')
WHERE Name = 'Software Version'
UPDATE #Parameter
SET Value = replace(Value, 'b', '.2')
WHERE Name = 'Software Version'
UPDATE #Parameter
SET Value = 
	CASE LEN(Value) - LEN(REPLACE(Value, '.', '')) 
		WHEN 0 THEN Value + '.0.0'
		WHEN 1 THEN Value + '.0'
		WHEN 2 THEN Value
	END
WHERE Name = 'Software Version'

INSERT	INTO #Parameter
SELECT	clientId, 0, 0, 0, 0, 1, 'Update Information', 
		'Cache Source','CommServe', 'CommServe'
FROM	#ClientProp
WHERE	Name = 'Patch Location flag' AND Value <> '1'

INSERT	INTO #Parameter
SELECT	clientId, 0, 0, 0, 0, 1, 'Security - Privacy', 
		'Prevent administrators from viewing or downloading your data.', 'Yes', 'No'
FROM	#ClientProp
WHERE	Name = 'Enable Data Security' AND Value = '1'

INSERT	INTO #Parameter
SELECT	clientId, 0, 0, 0, 0, 1, 'Activity Control', 
		CASE opType WHEN 4 THEN 'Enable Backup' WHEN 5 THEN 'Enable Restore' ELSE 'Enable Data Aging' END, 'No', 'Yes'
FROM	JMJobAction A INNER JOIN #Client T ON A.clientId = T.id
WHERE	opType IN (4, 5, 10) AND action = 1 AND clientId > 0 AND appType = 0 AND appId = 1 AND clientGroupId = 0

-- Advanced Client Properties

INSERT	INTO #Parameter
SELECT	DISTINCT clientId, 0, 0, 0, 0, 1, 'General', 
		'Enable IntelliSnap', 'Yes', 'No'
FROM	#ClientProp
WHERE	Name = 'Snap Backups Enabled' AND Value <> '0'

INSERT	INTO #Parameter
SELECT	DISTINCT clientId, 0, 0, 0, 0, 1, 'General', 
		'Enable retry on netwoek errors', 'No', 'Yes'
FROM	#ClientProp
WHERE	Name = 'NW Err Retry Flag' AND (CAST(Value AS INT) & 1) = 0

INSERT	INTO #Parameter
SELECT	DISTINCT clientId, 0, 0, 0, 0, 1, 'General', 
		'Enable retry on netwoek errors - Retry Frequency (seconds)', Value, '30'
FROM	#ClientProp
WHERE	Name = 'NW Err Retry Frequency' AND Value <> '30'

INSERT	INTO #Parameter
SELECT	DISTINCT clientId, 0, 0, 0, 0, 1, 'General', 
		'Enable retry on netwoek errors - Retry Count', Value, '40'
FROM	#ClientProp
WHERE	Name = 'NW Err Retry Count' AND Value <> '40'

INSERT	INTO #Parameter
SELECT	DISTINCT clientId, 0, 0, 0, 0, 1, 'General', 
		'Enable Email reply/Forward', Value, '0'
FROM	#ClientProp
WHERE	Name = 'Enable Email Web App' AND Value <> '0'

INSERT	INTO #Parameter
SELECT	DISTINCT clientId, 0, 0, 0, 0, 1, 'General', 
		'Exclude from SLA and Strike Counts', Value, '0'
FROM	#ClientProp
WHERE	Name = 'Exclude From SLA' AND Value <> '0'

INSERT	INTO #Parameter
SELECT	DISTINCT clientId, 0, 0, 0, 0, 1, 'General', 
		'Job priority (0-9)', Value, '6'
FROM	#ClientProp
WHERE	Name = 'JMPriority' AND Value <> '6'

INSERT	INTO #Parameter
SELECT	DISTINCT clientId, 0, 0, 0, 0, 1, 'Job Configuration', 
		'Enable Job Throttle', 'Yes', 'No'
FROM	#ClientProp
WHERE	Name = 'Throttle Jobs Enabled' AND Value <> '0'

INSERT	INTO #Parameter
SELECT	DISTINCT clientId, 0, 0, 0, 0, 1, 'Job Configuration', 
		'Enable Job Throttle', 'Yes', 'No'
FROM	#ClientProp
WHERE	Name = 'Throttle Jobs Enabled' AND Value = '3'

INSERT	INTO #Parameter
SELECT	DISTINCT clientId, 0, 0, 0, 0, 1, 'Job Configuration', 
		'Enable Job Throttle: Data Threshold', Value, '0'
FROM	#ClientProp
WHERE	Name = 'Throttle Jobs: Data Threshold' AND Value <> '0'

INSERT	INTO #Parameter
SELECT	DISTINCT clientId, 0, 0, 0, 0, 1, 'Job Configuration', 
		'Enable Job Throttle: Log Threshold', Value, '0'
FROM	#ClientProp
WHERE	Name = 'Throttle Jobs: Log Threshold' AND Value <> '0'

INSERT	INTO #Parameter
SELECT	DISTINCT clientId, 0, 0, 0, 0, 1, 'Job Configuration', 
		'Prune Job Results after x days', Value, '7'
FROM	#ClientProp
WHERE	Name = 'AgingDays' AND Value <> '7'

INSERT	INTO #Parameter
SELECT	DISTINCT clientId, 0, 0, 0, 0, 1, 'Job Configuration', 
		'Prune Job Results when disk capacity reaches x%', Value, '90'
FROM	#ClientProp
WHERE	Name = 'DiskFullPercent' AND Value <> '90'

INSERT	INTO #Parameter
SELECT	DISTINCT clientId, 0, 0, 0, 0, 1, 'Job Configuration', 
		'Prune Job Results: Low space threshold on job results folder (MB)', Value, '500'
FROM	#ClientProp
WHERE	Name = 'JobResultsThresholdMB' AND Value <> '500'

INSERT	INTO #Parameter
SELECT	DISTINCT clientId, 0, 0, 0, 0, 1, 'Encryption', 
		'Encryption Settings', 
		CASE Value WHEN 0 THEN 'Use Storage Policy Settings' 
			WHEN 1 THEN 'Use client settings' 
			ELSE 'Do not encrypt' END, 'Do not encrypt'
FROM	#ClientProp
WHERE	Name = 'Encryption Settings' AND Value <> '2'

INSERT	INTO #Parameter
SELECT	DISTINCT CP.clientId, 0, 0, 0, 0, 1, 'Encryption', 
		'Cipher', 
		CASE WHEN Value = '1' THEN 'Old BlowFish' WHEN Value = '2' THEN 'BlowFish' 
		 	 WHEN Value = '3' THEN 'AES' WHEN Value = '4' THEN 'Serpent' 
		 	 WHEN Value = '5' THEN 'TwoFish' WHEN Value = '6' THEN '3-DES' 
		 	 WHEN Value = '8' THEN 'GOST' ELSE 'N/A'
		END, 'BlowFish'
FROM	#ClientProp CP 
	INNER JOIN (SELECT clientId FROM #ClientProp WHERE Name = 'Encryption Settings' AND Value = '1') C ON CP.clientId = C.clientId
WHERE	Name = 'Encrypt: Type' AND Value <> '2'

INSERT	INTO #Parameter
SELECT	DISTINCT CP.clientId, 0, 0, 0, 0, 1, 'Encryption', 
		'Key Length', Value, '128'
FROM	#ClientProp CP 
	INNER JOIN (SELECT clientId FROM #ClientProp WHERE Name = 'Encryption Settings' AND Value = '1') C ON CP.clientId = C.clientId
WHERE	Name = 'Encrypt: Key Length' AND Value <> '128'

INSERT	INTO #Parameter
SELECT	DISTINCT CP.clientId, 0, 0, 0, 0, 1, 'Encryption', 
		'Direct Media Access (External Restore Tools)', 
		CASE WHEN Value = '2' THEN 'No Access' ELSE 'Via Media Password' END, 'Via Media Password'
FROM	#ClientProp CP 
	INNER JOIN (SELECT clientId FROM #ClientProp WHERE Name = 'Encryption Settings' AND Value = '1') C ON CP.clientId = C.clientId
WHERE	Name = 'Encrypt: drToolAccess' AND Value <> '0'
		--'Encrypt: restoreAccess',

INSERT	INTO #Parameter
SELECT	DISTINCT clientId, 0, 0, 0, 0, 1, 'Content Indexing', 
		'Enable Content Indexing', 'Yes', 'No'
FROM	#ClientProp
WHERE	Name = 'Content Indexing Enabled' AND Value <> '0'

INSERT	INTO #Parameter
SELECT	DISTINCT clientId, 0, 0, 0, 0, 1, 'DeDuplication Options', 
		'Client Side DeDuplication', 
		CASE WHEN Value = '1' THEN 'Perform Client Side DeDuplication' ELSE 'Disable Client Side DeDuplication' END, 
		'Use Storage Policy Settings'
FROM	#ClientProp
WHERE	Name = 'Enable DeDuplication' AND Value <> '0'

INSERT	INTO #Parameter
SELECT	DISTINCT clientId, 0, 0, 0, 0, 1, 'DeDuplication Options', 
		'Enable Variable Content Alignment', 'Yes', 'No'
FROM	#ClientProp
WHERE	Name = 'Enable Intelligent Block Alignment' AND Value <> '0'

INSERT	INTO #Parameter
SELECT	DISTINCT clientId, 0, 0, 0, 0, 1, 'DeDuplication Options', 
		'Enable Client Side Disk Cache', 'Yes', 'No'
FROM	#ClientProp
WHERE	Name = 'Enable Client Signature Cache' AND Value <> '0'

INSERT	INTO #Parameter
SELECT	DISTINCT clientId, 0, 0, 0, 0, 1, 'DeDuplication Options', 
		'Enable High Latency Optimization', 'Yes', 'No'
FROM	#ClientProp
WHERE	Name = 'Optimize for High Latency Networks' AND Value <> '0'

INSERT	INTO #Parameter
SELECT	DISTINCT clientId, 0, 0, 0, 0, 1, 'DeDuplication Options', 
		'Limit the Max Cache size to x MB', Value, '4096'
FROM	#ClientProp
WHERE	Name = 'Client Max DB Cache Size' AND Value <> '4096'


-- Category 2 for Network Properties

CREATE TABLE #TblFirewallOptions 
(
		ClientId INT, IsTrivialConfig INT, NetworkWithCS INT, ConnectionWithCS INT, ProxyClientIdCS INT,
		NetworkWithMA INT, ConnectionWithMA INT, ProxyClientIdMA INT,
		KeepAliveSeconds INT, TunnelInitSeconds INT, ForeceSSL INT, LockDown INT, 
		BindOpenPortsOnly INT, IsDMZ INT, IsRoamingClient INT, ExtendedProp XML, DefaultOutgoingProtocol INT
)

IF	@csReleaseId < 15       
	INSERT	INTO #TblFirewallOptions
	SELECT	CL.id, 0, 0, 0, 0, 0, 0, 0,
			ISNULL(FWO.keepAliveSeconds, 0),
			ISNULL(FWO.tunnelInitSeconds, 0),
			ISNULL(FWO.foreceSSL, 0),
			ISNULL(FWO.lockDown, 0),	
			ISNULL(FWO.bindOpenPortsOnly, 0),
			ISNULL(FWO.isDMZ, 0),
			0,
			CAST (CP.stringVal AS XML),
			0
	FROM	#Client CL
			LEFT OUTER JOIN APP_FirewallOptions FWO WITH (NOLOCK) ON FWO.clientId = CL.id
			LEFT OUTER JOIN APP_ComponentProp CP WITH (NOLOCK) ON CP.componentId = CL.id AND CP.propertyTypeId = 2101 AND CP.modified = 0
ELSE
IF	@csReleaseId = 15            
BEGIN     
	SET @sqlstr = N'                                          
	INSERT	INTO #TblFirewallOptions
	SELECT	CL.id, 
			ISNULL(FWT.isTrivialConfig, 0),
			ISNULL(FWT.networkWithCS, 0),
			ISNULL(FWT.connectionWithCS, 0),
			ISNULL(FWT.proxyClientIdCS, 0),
			ISNULL(FWT.networkWithMA, 0),
			ISNULL(FWT.connectionWithMA, 0),
			ISNULL(FWT.proxyClientIdMA, 0),
			ISNULL(FWO.keepAliveSeconds, 0),
			ISNULL(FWO.tunnelInitSeconds, 0),
			ISNULL(FWO.foreceSSL, 0),
			ISNULL(FWO.lockDown, 0),	
			ISNULL(FWO.bindOpenPortsOnly, 0),
			ISNULL(FWO.isDMZ, 0),
			ISNULL(FWO.isRoamingClient, 0),
			CAST (CP.stringVal AS XML),
			0
	FROM	#Client CL
			LEFT OUTER JOIN App_FWTrivialConfig FWT WITH (NOLOCK) ON FWT.clientId = CL.id
			LEFT OUTER JOIN APP_FirewallOptions FWO WITH (NOLOCK) ON FWO.clientId = CL.id
			LEFT OUTER JOIN APP_ComponentProp CP WITH (NOLOCK) ON CP.componentId = CL.id AND CP.propertyTypeId = 2101 AND CP.modified = 0'

	EXEC sp_executesql @sqlstr
END
ELSE
IF	@csReleaseId > 15            
BEGIN     
	SET @sqlstr = N'                                          
	INSERT	INTO #TblFirewallOptions
	SELECT	CL.id, 
			ISNULL(FWT.isTrivialConfig, 0),
			ISNULL(FWT.networkWithCS, 0),
			ISNULL(FWT.connectionWithCS, 0),
			ISNULL(FWT.proxyClientIdCS, 0),
			ISNULL(FWT.networkWithMA, 0),
			ISNULL(FWT.connectionWithMA, 0),
			ISNULL(FWT.proxyClientIdMA, 0),
			ISNULL(FWO.keepAliveSeconds, 0),
			ISNULL(FWO.tunnelInitSeconds, 0),
			ISNULL(FWO.foreceSSL, 0),
			ISNULL(FWO.lockDown, 0),	
			ISNULL(FWO.bindOpenPortsOnly, 0),
			ISNULL(FWO.isDMZ, 0),
			ISNULL(FWO.isRoamingClient, 0),
			CAST (FWO.extendedProperties AS XML),
			0
	FROM	#Client CL
			LEFT OUTER JOIN App_FWTrivialConfig FWT WITH (NOLOCK) ON FWT.clientId = CL.id
			LEFT OUTER JOIN APP_FirewallOptions FWO WITH (NOLOCK) ON FWO.clientId = CL.id'

	EXEC sp_executesql @sqlstr
END

UPDATE	#TblFirewallOptions
SET		DefaultOutgoingProtocol = (
			SELECT TOP 1 ref.value('@defaultOutgoingProtocol', 'NVARCHAR(1)')
			FROM ExtendedProp.nodes('App_FirewallExtendedProperties') R(ref))
WHERE	ExtendedProp IS NOT NULL

INSERT	INTO #Parameter
SELECT	DISTINCT clientId, 0, 0, 0, 0, 2, 'Firewall Configuration', 
		'Configure Firewall Settings', CASE IsTrivialConfig WHEN 1 THEN 'Basic' WHEN 2 THEN 'Advanced' ELSE 'No' END, 'No'
FROM	#TblFirewallOptions
WHERE	IsTrivialConfig <> 0

INSERT	INTO #Parameter
SELECT	DISTINCT clientId, 0, 0, 0, 0, 2, 'Firewall Configuration', 
		'CommServe Connetivity', 
		CASE NetworkWithCS 
			WHEN 1 THEN 'Always in the same network as CommServe'
			WHEN 2 THEN 'Always outside of CommServe network' 
			WHEN 3 THEN 'May travel outside of CommServe network' 
			ELSE 'No'
		END, 'No'
FROM	#TblFirewallOptions
WHERE	NetworkWithCS <> 0

INSERT	INTO #Parameter
SELECT	DISTINCT clientId, 0, 0, 0, 0, 2, 'Firewall Configuration', 
		'CommServe Connetivity: When connecting from outside', 
		CASE ConnectionWithCS
			WHEN 1 THEN 'Open tunnel directly to CommServe'
			WHEN 2 THEN 'Use remote proxy' 
			ELSE 'No'
		END, 'No'
FROM	#TblFirewallOptions
WHERE	ConnectionWithCS <> 0

INSERT	INTO #Parameter
SELECT	DISTINCT clientId, 0, 0, 0, 0, 2, 'Firewall Configuration', 
		'MediAgent Connetivity', 
		CASE NetworkWithMA 
			WHEN 1 THEN 'Always in the same network as MediaAgent'
			WHEN 2 THEN 'Always outside of MediaAgent network' 
			WHEN 3 THEN 'May travel outside of MediaAgent network' 
			ELSE 'No'
		END, 'No'
FROM	#TblFirewallOptions
WHERE	NetworkWithMA <> 0

INSERT	INTO #Parameter
SELECT	DISTINCT clientId, 0, 0, 0, 0, 2, 'Firewall Configuration', 
		'MediAgent Connetivity: When connecting from outside', 
		CASE ConnectionWithMA 
			WHEN 1 THEN 'Open tunnel directly to MediaAgent'
			WHEN 2 THEN 'Use remote proxy' 
			ELSE 'No'
		END, 'No'
FROM	#TblFirewallOptions
WHERE	ConnectionWithMA <> 0

INSERT	INTO #Parameter
SELECT	DISTINCT clientId, 0, 0, 0, 0, 2, 'Firewall Configuration', 
		'Advanced Options: Keep-alive Interval (seconds)', 
		CAST(KeepAliveSeconds AS VARCHAR(32)), '600'
FROM	#TblFirewallOptions
WHERE	KeepAliveSeconds <> 600

INSERT	INTO #Parameter
SELECT	DISTINCT clientId, 0, 0, 0, 0, 2, 'Firewall Configuration', 
		'Advanced Options: Tunnel Init Interval (seconds)', 
		CAST(TunnelInitSeconds AS VARCHAR(32)), '30'
FROM	#TblFirewallOptions
WHERE	TunnelInitSeconds <> 30

INSERT	INTO #Parameter
SELECT	DISTINCT clientId, 0, 0, 0, 0, 2, 'Firewall Configuration', 
		'Advanced Options: Firewall Default Outgoing Tunnel Protocol', 
		CASE DefaultOutgoingProtocol WHEN 0 THEN 'Regular' WHEN 1 THEN 'Authenticated' WHEN 2 THEN 'Encrypted'ELSE 'Raw' END,
		'Regular'
FROM	#TblFirewallOptions
WHERE	DefaultOutgoingProtocol <> 0

INSERT	INTO #Parameter
SELECT	DISTINCT clientId, 0, 0, 0, 0, 2, 'Firewall Configuration', 
		'Advanced Options: Force SSL authentication in incoming tunnel connections', 'Yes', 'No'
FROM	#TblFirewallOptions
WHERE	ForeceSSL <> 0

INSERT	INTO #Parameter
SELECT	DISTINCT clientId, 0, 0, 0, 0, 2, 'Firewall Configuration', 
		'Advanced Options: Force per-client certificate based authentication', 'Yes', 'No'
FROM	#TblFirewallOptions
WHERE	LockDown <> 0

INSERT	INTO #Parameter
SELECT	DISTINCT clientId, 0, 0, 0, 0, 2, 'Firewall Configuration', 
		'Advanced Options: Bind all services to open ports only', 'Yes', 'No'
FROM	#TblFirewallOptions
WHERE	BindOpenPortsOnly <> 0

INSERT	INTO #Parameter
SELECT	DISTINCT clientId, 0, 0, 0, 0, 2, 'Firewall Configuration', 
		'Advanced Options: This computer is in DMZ and will work as a proxy', 'Yes', 'No'
FROM	#TblFirewallOptions
WHERE	IsDMZ <> 0

INSERT	INTO #Parameter
SELECT	DISTINCT clientId, 0, 0, 0, 0, 2, 'Firewall Configuration', 
		'Advanced Options: Roaming client', 'Yes', 'No'
FROM	#TblFirewallOptions
WHERE	IsRoamingClient <> 0


CREATE TABLE #TblNWThrottleOptions 
(
		ClientId INT, Enabled INT, ShareBandwidth INT, Options XML, 
		DaysOfWeek VARCHAR(8), StartTime VARCHAR(8), EndTime VARCHAR(8), IsAbsolute INT, 
		SendEnabled INT, SendRate INT, SendRatePct INT, 
		RecvEnabled INT, RecvRate INT, RecvRatePct INT
)

INSERT	INTO #TblNWThrottleOptions
SELECT	CL.id, 1, 
		CASE WHEN NTO.NetworkThrottleOptions.exist('/App_ThrottleScheduleOptionList') = 1
			 THEN (SELECT TOP 1 ref.value('@shareBandwidth', 'NVARCHAR(1)')
					 FROM NTO.NetworkThrottleOptions.nodes('App_ThrottleScheduleOptionList') R(ref))
			 ELSE (SELECT TOP 1 ref.value('@shareBandwidth', 'NVARCHAR(1)')
					 FROM NTO.NetworkThrottleOptions.nodes('EVGui_ThrottleScheduleOptionList') R(ref))
		END,
		CASE WHEN NTO.NetworkThrottleOptions.exist('/App_ThrottleScheduleOptionList') = 1
			 THEN NTO.NetworkThrottleOptions.query('/App_ThrottleScheduleOptionList/throttle')
			 ELSE NTO.NetworkThrottleOptions.query('/EVGui_ThrottleScheduleOptionList/throttle')
		END,
		'','','',0,0, 0,0,0,0,0
FROM	#Client CL
		INNER JOIN APP_ClientProp CP WITH (NOLOCK) ON CP.componentNameId = CL.id AND CP.attrName='Network Throttle Enabled' AND CP.modified = 0
		INNER JOIN APP_NetworkThrottleOptions NTO WITH (NOLOCK) ON NTO.clientId = CL.id

UPDATE	#TblNWThrottleOptions
SET		DaysOfWeek	= (SELECT TOP 1 ref.value('@days', 'INT') FROM Options.nodes('throttle') R(ref)),
		StartTime	= (SELECT TOP 1 ref.value('@startTime', 'NVARCHAR(8)') FROM Options.nodes('throttle') R(ref)),
		EndTime		= (SELECT TOP 1 ref.value('@endTime', 'NVARCHAR(8)') FROM Options.nodes('throttle') R(ref)),
		IsAbsolute	= (SELECT TOP 1 ref.value('@isAbsolute', 'INT') FROM Options.nodes('throttle') R(ref)),
		SendEnabled	= (SELECT TOP 1 ref.value('@sendEnabled', 'INT') FROM Options.nodes('throttle') R(ref)),
		SendRate	= (SELECT TOP 1 ref.value('@sendRate', 'INT') FROM Options.nodes('throttle') R(ref)),
		SendRatePct	= (SELECT TOP 1 ref.value('@sendRatePercent', 'INT') FROM Options.nodes('throttle') R(ref)),
		RecvEnabled	= (SELECT TOP 1 ref.value('@receiveEnabled', 'INT') FROM Options.nodes('throttle') R(ref)),
		RecvRate	= (SELECT TOP 1 ref.value('@recvRate', 'INT') FROM Options.nodes('throttle') R(ref)),
		RecvRatePct	= (SELECT TOP 1 ref.value('@recvRatePercent', 'INT') FROM Options.nodes('throttle') R(ref))

INSERT	INTO #Parameter
SELECT	DISTINCT clientId, 0, 0, 0, 0, 2, 'Network Throttle', 
		'Enable Network Throttling', 'Yes', 'No'
FROM	#TblNWThrottleOptions
WHERE	Enabled <> 0

INSERT	INTO #Parameter
SELECT	DISTINCT clientId, 0, 0, 0, 0, 2, 'Network Throttle', 
		'All clients share allocated bandwidth', 'Yes', 'No'
FROM	#TblNWThrottleOptions
WHERE	ShareBandwidth <> 0

INSERT	INTO #Parameter
SELECT	DISTINCT clientId, 0, 0, 0, 0, 2, 'VPN Config', 
		'Enable VPN Client on this computer', 'Yes', 'No'
FROM	#ClientProp
WHERE	Name = 'VPNEnableClient' AND Value = '1'

INSERT	INTO #Parameter
SELECT	DISTINCT clientId, 0, 0, 0, 0, 2, 'VPN Config', 
		'This computer works as VPN Router', 'Yes', 'No'
FROM	#ClientProp
WHERE	Name = 'VPNEnableRouter' AND Value = '1'


CREATE TABLE #TblFirewallRemoteAccess
(
	clientId INT, remoteAccessRules XML, allowAnyOwner INT, allowSpecificUsers INT, 
	configRemoteClientAccess INT, services INT
)
 
IF OBJECT_ID('App_FirewallRemoteAccess') IS NOT NULL
BEGIN
	CREATE	TABLE #VPNClient (id INT)
	
	INSERT	INTO #VPNClient
	SELECT	DISTINCT clientId
	FROM	#ClientProp
	WHERE	Name = 'VPNEnableRemoteClientAccess' AND Value = '1'

	SET @sqlstr = N'
	INSERT	INTO #TblFirewallRemoteAccess               
	SELECT	CL.id, CAST(CAST(remoteAccessRules AS TEXT) AS XML), 0, 0, 0, 0
	FROM	#VPNClient CL
			INNER JOIN App_FirewallRemoteAccess FRA WITH (NOLOCK) ON FRA.clientId = CL.id'

	EXEC sp_executesql @sqlstr

	DROP TABLE #VPNClient
END

UPDATE	#TblFirewallRemoteAccess
SET		allowAnyOwner =  ref.value('@allowAnyOwner', 'INT'), 
		allowSpecificUsers = ref.value('@allowSpecificUsers', 'INT'), 
		configRemoteClientAccess = ref.value('@configRemoteClientAccess', 'INT')
from #TblFirewallRemoteAccess
CROSS APPLY remoteAccessRules.nodes('App_RemoteClientAccess') R(ref)

UPDATE	#TblFirewallRemoteAccess
SET		services = S.services
FROM	#TblFirewallRemoteAccess T 
		INNER JOIN
		(SELECT	clientId, SUM(ref.value('@val', 'INT')) AS services
		FROM	#TblFirewallRemoteAccess
		CROSS APPLY remoteAccessRules.nodes('App_RemoteClientAccess/services') R(ref)
		GROUP BY clientId
		) S ON T.clientId = S.clientId
		
INSERT	INTO #Parameter
SELECT	DISTINCT clientId, 0, 0, 0, 0, 2, 'Remote Client Access', 
		'Allow connecting to client s services across firewall via proxy', 'Yes', 'No'
FROM	#ClientProp
WHERE	Name = 'VPNEnableRemoteClientAccess' AND Value = '1'

INSERT	INTO #Parameter
SELECT	DISTINCT clientId, 0, 0, 0, 0, 2, 'Remote Client Access',
		'services: Allow connections to this client s services', 
		CASE WHEN services&1 = 1 THEN ' RDP' ELSE '' END + CASE WHEN services&2 = 2THEN ' VNC' ELSE '' END + 
		CASE WHEN services&4 = 4 THEN ' SSH' ELSE '' END + CASE WHEN services&8 = 8THEN ' HTTPS' ELSE '' END, 
		'RDP'
FROM	#TblFirewallRemoteAccess
WHERE	services <> 1

INSERT	INTO #Parameter
SELECT	DISTINCT clientId, 0, 0, 0, 0, 2, 'Remote Client Access',
		'Users: Any owner for this client', 'Yes', 'No'
FROM	#TblFirewallRemoteAccess
WHERE	allowAnyOwner <> 0

INSERT	INTO #Parameter
SELECT	DISTINCT clientId, 0, 0, 0, 0, 2, 'Remote Client Access',
		'Users: Specify users or user groups', 'Yes', 'No'
FROM	#TblFirewallRemoteAccess
WHERE	allowSpecificUsers <> 0

-- Category 4 for Agent Properties

CREATE TABLE #AgentName (type INT, displayName VARCHAR(128))

INSERT	#AgentName
SELECT 	DISTINCT appTypeId, display_name FROM simAppTypeLicTypeMap WHERE appTypeId NOT IN (13,84) AND appTypeId < 600
UNION
SELECT 	13, 'NAS'
UNION
SELECT 	84, 'Continuous Data Replicator'

CREATE TABLE #AgentProp (
	clientId INT, appTypeId INT, Name NVARCHAR(1024), Value NVARCHAR(MAX))

INSERT	INTO #AgentProp
SELECT	N.clientId, N.appTypeId, P.attrName, P.attrVal
FROM	APP_iDAName N INNER JOIN APP_IDAProp P 
		ON N.id = P.componentNameId AND N.modified = 0 AND P.modified = 0
WHERE	P.attrName IN (
		'Enable OCS',
		'Enable Access Time Collection',
		'Enable Archive',
		'DM Max Simultaneous Data Recovery',
		'DM Time Btw Recall',
		'DM Time to wait after max',
		'Copy Backup Enabled',
		
		'Explorer Based End User Recall Enabled',
		'Is Recall MP enabled'
		) 
		OR P.attrName LIKE 'Auto discover % Instance'

INSERT	INTO #Parameter
SELECT	DISTINCT clientId, appTypeId, 0, 0, 0, 3, 'File System Properties', 
		'Enable Office Communication Server Backup', 'Yes', 'No'
FROM	#AgentProp
WHERE	Name = 'Enable OCS' AND Value <> '0'

INSERT	INTO #Parameter
SELECT	DISTINCT clientId, appTypeId, 0, 0, 0, 3, 'File System Properties', 
		'Track Access Time', 'Yes', 'No'
FROM	#AgentProp
WHERE	Name = 'Enable Access Time Collection' AND Value <> '0'

INSERT	INTO #Parameter
SELECT	DISTINCT clientId, appTypeId, 0, 0, 0, 3, displayName + ' Properties', 
		'Enable Archiving', 'Yes', 'No'
FROM	#AgentProp P INNER JOIN #AgentName N ON P.appTypeId = N.type
WHERE	P.Name = 'Enable Archive' AND Value <> '0'

INSERT	INTO #Parameter
SELECT	DISTINCT clientId, appTypeId, 0, 0, 0, 3, displayName + ' Properties', 
		'Stub Recovery Parameters', 'Yes', 'No'
FROM	#AgentProp P INNER JOIN #AgentName N ON P.appTypeId = N.type
WHERE	P.Name = 'DM Max Simultaneous Data Recovery' AND Value <> '-1'

INSERT	INTO #Parameter
SELECT	DISTINCT clientId, appTypeId, 0, 0, 0, 3, displayName + ' Properties', 
		'Maximum Stub Recovery', Value, '30'
FROM	#AgentProp P INNER JOIN #AgentName N ON P.appTypeId = N.type
WHERE	P.Name = 'DM Max Simultaneous Data Recovery' AND Value <> '30'

INSERT	INTO #Parameter
SELECT	DISTINCT clientId, appTypeId, 0, 0, 0, 3, displayName + ' Properties', 
		'Time between recall to count as successive in seconds.', Value, '10'
FROM	#AgentProp P INNER JOIN #AgentName N ON P.appTypeId = N.type
WHERE	P.Name = 'DM Time Btw Recall' AND Value <> '10'

INSERT	INTO #Parameter
SELECT	DISTINCT clientId, appTypeId, 0, 0, 0, 3, displayName + ' Properties', 
		'Time to wait afetr maximum successive recall limit is reached in seconds.', Value, '30'
FROM	#AgentProp P INNER JOIN #AgentName N ON P.appTypeId = N.type
WHERE	P.Name = 'DM Time to wait after max' AND Value <> '30'

INSERT	INTO #Parameter
SELECT	DISTINCT clientId, appTypeId, 0, 0, 0, 3, displayName + ' Properties', 
		'Enable Automatic Instance Discovery', 'Yes', 'No'
FROM	#AgentProp P INNER JOIN #AgentName N ON P.appTypeId = N.type
WHERE	P.Name LIKE 'Auto discover % Instance' AND Value <> '0'

INSERT	INTO #Parameter
SELECT	DISTINCT clientId, appTypeId, 0, 0, 0, 3, displayName + ' Properties', 
		'Copy backup', 'Yes', 'No'
FROM	#AgentProp P INNER JOIN #AgentName N ON P.appTypeId = N.type
WHERE	P.Name = 'Copy Backup Enabled' AND Value <> '0'

INSERT	INTO #Parameter
SELECT	DISTINCT clientId, appTypeId, 0, 0, 0, 3, displayName + ' Properties', 
		'Manage Content Automatically', 'Yes', 'No'
FROM	#AgentProp P INNER JOIN #AgentName N ON P.appTypeId = N.type
WHERE	P.Name = 'Manage content automatically' AND Value <> '0'

INSERT	INTO #Parameter
SELECT	A.clientId, A.appType, 0, 0, 0, 3, 'Activity Control', 
		CASE opType WHEN 4 THEN 'Enable Backup' WHEN 5 THEN 'Enable Restore' ELSE 'Enable Data Aging' END, 'No', 'Yes'
FROM	JMJobAction A 
		INNER JOIN #AgentProp P ON A.clientId = P.clientId AND A.appType = P.appTypeId
		INNER JOIN #Client CL ON P.clientId = CL.id
WHERE	A.opType IN (4, 5, 10) AND A.action = 1 AND A.clientId > 0 AND A.appType > 0 AND A.appId = 1 AND A.clientGroupId = 0

-- for Continuous Data Replicator

-- for Exchange Database
-- Backup Type: Incremental/Differental

-- for Exchange Mailbox
-- Exchange Online
-- Backup Deleted Item Retention

-- For DB2
-- Enable Database Discovery

-- For SQL Server
-- Auto Discovery Instances

-- for part1051
-- Autp delect new and deleted partitions

-- Object Link
-- Time interval for removing archived objects from the cache (Mins)

-- Continuous Data Replicator
-- Operational Parameters
-- Fan-In - Recovery Points

-- File Archiver
-- Stub Recovery Parameters
-- Erase archive data when stub is deleted

-- SharePoint Server
-- If SQL snap feature is not enabled, lock site collection for write access during Site Collection backups
-- Enable Offline Mining

DROP TABLE #AgentName
DROP TABLE #AgentProp

-- Collect instance, backupset and subclient parameters only when configured alid vsubclients exist

CREATE TABLE #Subclient (
	appId INT, clientId INT, appTypeId INT, instanceId INT, backupsetId INT, subclientStatus INT)

INSERT	INTO #Subclient
SELECT	id, clientId, appTypeId, instance, backupSet, subclientStatus
FROM	APP_Application
WHERE	appTypeId < 600 AND appTypeId NOT IN (72, 84, 85, 107, 121, 122, 127) 
	AND (appTypeId NOT IN (24, 25, 40, 47, 48, 50, 65, 66, 67, 68, 73, 75, 76) OR subclientStatus&8 = 0)
	AND subclientStatus&(2|4|16|32) = 0 
	AND (dataArchGrpId > 1 OR logArchGrpId > 1)

-- DELETE	#Subclient
-- FROM	APP_SubClientProp SP
-- WHERE	#Subclient.appId = SP.componentNameId
--	AND SP.attrName IN ('DDB Backup', 'Index SubClient', 'SILO Copy ID') AND SP.attrVal = '1' AND SP.modified = 0

-- Exclude instances of Migrated SRM Agent
DELETE	#Subclient
FROM	APP_InstanceName INST 
WHERE	#Subclient.InstanceId = INST.id AND (INST.status & 2048) <> 0

-- Exclude all dummy instances of UNIX DB agents
DELETE	#Subclient
FROM	APP_InstanceName INST
WHERE	#Subclient.InstanceId = INST.id AND (INST.status & 16) <> 0
	AND #Subclient.AppTypeId IN (3,22,37,61,62,79,80,103)

-- Exclude all dummy backupsets of UNIX DB agents
DELETE	#Subclient
FROM	APP_BackupSetName BS
WHERE	#Subclient.BackupsetId = BS.id AND (BS.status & 16) <> 0
	AND #Subclient.AppTypeId IN (3,22,37,61,62,79,80,103)


-- Category 4 for Instance Properties

CREATE TABLE #InstanceProp (
	instanceId INT, Name NVARCHAR(1024), Value NVARCHAR(MAX))

INSERT	INTO #InstanceProp
SELECT	instanceId, attrName, attrVal
FROM	APP_InstanceProp INNER JOIN #Subclient ON componentNameId = instanceId
WHERE	modified = 0 AND attrName IN (
		'Oracle Wallet authentication',
		'use Catalog Connect',
		'Oracle RMAN Cross Check',
		'Oracle CrossCheck Timeout',
		'Auto Backup Control File',
		'Oracle block size',
		'SYBASE Block Size',
		'SYBASE auto discovery',
		'MySQL auto discovery',
		''
		)

INSERT	INTO #Parameter
SELECT	DISTINCT clientId, appTypeId, P.instanceId, 0, 0, 4, 'Details', 
		'DataAging: Disable RMAN Crosscheck', 'Yes', 'No'
FROM	#InstanceProp P INNER JOIN #Subclient S ON P.instanceId = S.instanceId
WHERE	P.Name = 'Oracle RMAN Cross Check' AND P.Value <> '0'
INSERT	INTO #Parameter
SELECT	DISTINCT clientId, appTypeId, P.instanceId, 0, 0, 4, 'Details', 
		'Oracle Wallet Auto Login', 'Yes', 'No'
FROM	#InstanceProp P INNER JOIN #Subclient S ON P.instanceId = S.instanceId
WHERE	P.Name = 'Oracle Wallet authentication' AND P.Value <> '0'

INSERT	INTO #Parameter
SELECT	DISTINCT clientId, appTypeId, P.instanceId, 0, 0, 4, 'Details', 
		'Use Catalog Connect', 'Yes', 'No'
FROM	#InstanceProp P INNER JOIN #Subclient S ON P.instanceId = S.instanceId
WHERE	P.Name = 'use Catalog Connect' AND P.Value <> '0'

INSERT	INTO #Parameter
SELECT	DISTINCT clientId, appTypeId, P.instanceId, 0, 0, 4, 'Details', 
		'DataAging: Disable RMAN Crosscheck', 'Yes', 'No'
FROM	#InstanceProp P INNER JOIN #Subclient S ON P.instanceId = S.instanceId
WHERE	P.Name = 'Oracle RMAN Cross Check' AND P.Value <> '0'

INSERT	INTO #Parameter
SELECT	DISTINCT clientId, appTypeId, P.instanceId, 0, 0, 4, 'Details', 
		'DataAging: Cross Check Timeout (second)', P.Value, '600'
FROM	#InstanceProp P INNER JOIN #Subclient S ON P.instanceId = S.instanceId
WHERE	P.Name = 'Oracle CrossCheck Timeout' AND P.Value <> '600'

INSERT	INTO #Parameter
SELECT	DISTINCT clientId, appTypeId, P.instanceId, 0, 0, 4, 'Details', 
		'Control File Autobackup', CASE WHEN P.Value = '0' THEN 'Not Configured' WHEN P.Value = '1' THEN 'On' ELSE 'Off' END, 
		'Not Configured'
FROM	#InstanceProp P INNER JOIN #Subclient S ON P.instanceId = S.instanceId
WHERE	P.Name = 'Auto Backup Control File' AND P.Value <> '0'

INSERT	INTO #Parameter
SELECT	DISTINCT clientId, appTypeId, P.instanceId, 0, 0, 4, 'Details', 
		'blockSize', P.Value, '1048576'
FROM	#InstanceProp P INNER JOIN #Subclient S ON P.instanceId = S.instanceId
WHERE	P.Name = 'Oracle block size' AND P.Value <> '1048576'

INSERT	INTO #Parameter
SELECT	DISTINCT clientId, appTypeId, instanceId, backupsetId, S.appId, 4, 'Data Transfer Option', 
		'Software Compression (for Command Line Backup)', 
		CASE compressWhere WHEN 0 THEN 'On Client' WHEN 1 THEN 'On MediaAgent' 
		WHEN 2 THEN 'Use Storage Policy Settings' WHEN 4 THEN 'Off' ELSE 'Use Storage Policy Settings' END,
		'Use Storage Policy Settings'
FROM	archPipeConfig INNER JOIN #Subclient S ON S.appId = appNumber
WHERE	S.subclientStatus = 0x0040 AND compressWhere <> 2

INSERT	INTO #Parameter
SELECT	DISTINCT clientId, appTypeId, instanceId, 0, 0, 4, 'Data Transfer Option', 
		'Network Agents (for Command Line Backup)', CAST(numNWAgents AS VARCHAR(32)), '2'
FROM	archPipeConfig INNER JOIN #Subclient S ON S.appId = appNumber
WHERE	S.subclientStatus = 0x0040 AND numNWAgents <> 2

INSERT	INTO #Parameter
SELECT	DISTINCT clientId, appTypeId, instanceId, 0, 0, 4, 'Data Transfer Option', 
		'Throttle Network Bandwidth (MB/HR) (for Command Line Backup)', CAST(NWWriteSpeed AS VARCHAR(32)), '0'
FROM	archPipeConfig INNER JOIN #Subclient S ON S.appId = appNumber
WHERE	S.subclientStatus = 0x0040 AND NWWriteSpeed > 0

INSERT	INTO #Parameter
SELECT	DISTINCT clientId, appTypeId, P.instanceId, 0, 0, 4, 'General', 
		'Block Size', P.Value, '32768'
FROM	#InstanceProp P INNER JOIN #Subclient S ON P.instanceId = S.instanceId
WHERE	P.Name = 'SYBASE Block Size' AND P.Value <> '32768'

INSERT	INTO #Parameter
SELECT	DISTINCT clientId, appTypeId, P.instanceId, 0, 0, 4, 'General', 
		'Enable Aut Discovery', 'No', 'Yes'
FROM	#InstanceProp P INNER JOIN #Subclient S ON P.instanceId = S.instanceId
WHERE	P.Name LIKE '% auto discovery' AND Value <> '1'

INSERT	INTO #Parameter
SELECT	DISTINCT clientId, appTypeId, P.instanceId, 0, 0, 4, 'General', 
		'Aut detect new and deleted partitions', 'No', 'Yes'
FROM	#InstanceProp P INNER JOIN #Subclient S ON P.instanceId = S.instanceId
WHERE	P.Name = 'DB2 Auto Detect' AND Value <> '1'

-- DB2DPF
-- Connect as a Different User


-- MySQL
-- Storage Device - Log Backup: Number of Archive Log Backup Streams
-- Proxy Settings: Enable proxy backup, Always run transaction backups on source


DROP TABLE #InstanceProp


-- Category 5 for Backupset Properties

CREATE TABLE #BackupsetProp (
	backupsetId INT, Name NVARCHAR(1024), Value NVARCHAR(MAX))

INSERT	INTO #BackupsetProp
SELECT	backupsetId, attrName, attrVal
FROM	APP_BackupSetProp INNER JOIN #Subclient ON componentNameId = instanceId
WHERE	modified = 0 AND attrName IN (
		'Use Archive Bit',
		''
		)

-- NAS backupset
-- Image Backup Set


INSERT	INTO #Parameter
SELECT	DISTINCT clientId, appTypeId, instanceId, S.backupsetId, 0, 5, 'General', 
		'Job Options: Check archive bit during backups', 'Yes', 'No'
FROM	#BackupsetProp P INNER JOIN #Subclient S ON P.backupsetId = S.backupsetId
WHERE	P.Name = 'Use Archive Bit' AND P.Value <> '0'

DROP TABLE #BackupsetProp

-------------------------

CREATE TABLE #SubclientProp (
	appId INT, Name NVARCHAR(1024), Value NVARCHAR(MAX))

INSERT	INTO #SubclientProp
SELECT	appId, attrName, attrVal
FROM	APP_SubClientProp INNER JOIN #Subclient ON componentNameId = appId
WHERE	modified = 0 AND attrName IN (
		'Use VSS Enabled',
		'Use VSS for System State',
		'Use VSS Options',
		'Snap Failure Action',
		'System State',
		'System State on Full Backup Only',
		'Oracle Online Selective Full',
		'Oracle Backup Mode',
		'use global filters',
		'use cs setting for global filters',
		'use SCP filters',
		'Read Buffer Size',
		'Single Instancing Option',
		'Keep items past their expiration',
		'Days to keep items past their expiration',
		'Number of Synth Full Versions',
		'sys:pre PreIfind',
		'sys:post PostIfind',
		'sys:pre PreBackup',
		'sys:post PostBackup',
		'sys:pre PreSnap',
		'sys:post PostSnap',
		'sys: pre post option',
		'Enable Snap Backups',
		'Snap Engine',
		'Snap copy : use source on missing proxy',
		'Sybase Snap Backup copy uses dump based approach',
		'Full Failover to SP dataPaths',
		'Non-Full Failover to SP dataPaths',
		'sys:nStreams',
		'sys:UseMultipleStreamsWithinDrive',
		'Sybase Data backup streams',
		'Sybase Log backup streams',
		'SRM Data Collection Options',
		'Enable ACL Collection',
		'Use block level backup',
		'Enable metadata Collection',
		'Delete PST file only',
		'Use Change Journal',
		'Use Classic File Scan',
		'Use DC for FS backups',
		'Use Archive Bit',
		'Preserve File Access Times',
		'Exclude From SLA',
		'Oracle Data backup streams',
		'Oracle Data FPS',
		'Arch per bfs',
		'Oracle Max Open Files',
		'Oracle Max Backup Set Size',
		'Oracle Section size',
		'Light Out Script',
		'Oracle LOS Backup Warning',
		'Oracle LOS Backup Delay Min',
		'Oracle Use SQL Connect',
		'Oracle Skip read only',
		'Oracle Skip offline',
		'Oracle Set Validate',
		'Oracle Enable Table Browse',
		'Oracle Merge Incr Image Copy',
		'Oracle Skip inaccessible',
		'Oracle Resync Catalog',
		'Backup Archive Log',
		'Backup Archive Log Option',
		'Archive Log Deleting',
		'Oracle LOS disable Switch',
		'Oracle Log backup streams',
		'Oracle Use Rman For Log Backup',
		'Oracle Backup Archive Log Flag',
		'Oracle Delete Archive Log Flag',
		''
		)

INSERT	INTO #SubclientProp
SELECT	S.appId, 'Encrypt: encryption', ISNULL(SP.attrVal, '2')
FROM	#Subclient S
		INNER JOIN (SELECT clientId FROM #ClientProp WHERE Name = 'Encryption Settings' AND Value IN ('0', '1')) C ON S.clientId = C.clientId
		LEFT OUTER JOIN APP_SubClientProp SP ON S.appId = SP.componentNameId AND SP.attrName = 'Encrypt: encryption' AND SP.modified = 0

-- Subclient properties shown at instance/backupset level

INSERT	INTO #Parameter
SELECT	DISTINCT clientId, appTypeId, instanceId, 0, 0, 5, 'Deduplication', 
		'Enable Deduplication - Generate Signature (for Command Line Backup)', 
		CASE WHEN SP.Value = '1' THEN 'On Client' WHEN SP.Value = '2' THEN 'On MediaAgent' ELSE 'No' END, 
		'On Client'
FROM	#SubclientProp SP INNER JOIN #Subclient S ON SP.appId = S.appId
WHERE	S.subclientStatus & (64|4096) > 0 AND SP.Name = 'Single Instancing Option' AND SP.Value <> '1'


-- Category 6 for Subclient Properties

INSERT	INTO #Parameter
SELECT	clientId, appTypeId, instanceId, backupsetId, appId, 6, 'General', 
		'Subclient Type', 
		CASE WHEN T.SubclientType IS NOT NULL THEN T.SubclientType
			WHEN subclientStatus&4096 > 0 THEN @SUBCLIENT_TYPE_LOGCMDLINE
			WHEN subclientStatus&64 > 0 THEN @SUBCLIENT_TYPE_CMDLINE
			WHEN subclientStatus&8 > 0 THEN @SUBCLIENT_TYPE_DEFAULT
			ELSE @SUBCLIENT_TYPE_OTHERS END,
		@SUBCLIENT_TYPE_OTHERS
FROM	#Subclient
		LEFT OUTER JOIN (
		SELECT	componentNameId,
				CASE WHEN attrName = 'Index SubClient' THEN @SUBCLIENT_TYPE_INDEXBACKUP
					 WHEN attrName = 'DDB Backup' THEN @SUBCLIENT_TYPE_DDBBACKUP
					 WHEN attrName = 'SILO Copy ID' THEN @SUBCLIENT_TYPE_SILOBACKUP
					 ELSE NULL END AS SubclientType
		FROM	APP_SubClientProp
		WHERE	modified = 0 AND attrName IN ('Index SubClient', 'DDB Backup', 'SILO Copy ID') AND attrVal = '1'
		) T ON componentNameId = appId

INSERT	INTO #Parameter
SELECT	DISTINCT clientId, appTypeId, instanceId, backupsetId, SP.appId, 6, 'General', 
		'Use VSS', 'No', 'Yes'
FROM	#SubclientProp SP INNER JOIN #Subclient S ON SP.appId = S.appId
WHERE	SP.Name = 'Use VSS Enabled' AND SP.Value <> '1'

-- Delete Command Line Subclients
DELETE	#Subclient WHERE subclientStatus & (64|4096) > 0

INSERT	INTO #Parameter
SELECT	DISTINCT clientId, appTypeId, instanceId, backupsetId, SP.appId, 6, 'General', 
		'Use VSS Options', 
		CASE WHEN SP.Value = '1' THEN 'For all files' WHEN SP.Value = '2' THEN 'For locked files only' ELSE 'N/A' END, 
		'For locked files only'
FROM	#SubclientProp SP INNER JOIN #Subclient S ON SP.appId = S.appId
		INNER JOIN (SELECT appId FROM #SubclientProp WHERE Name = 'Use VSS Enabled' AND Value = '1') P ON SP.appId = P.appId
WHERE	SP.Name = 'Use VSS Options' AND SP.Value <> '2'

INSERT	INTO #Parameter
SELECT	DISTINCT clientId, appTypeId, instanceId, backupsetId, SP.appId, 6, 'General', 
		'If VSS Snap fails, the backup behavior should be', 
		CASE WHEN SP.Value = '1' THEN 'Fail the job' WHEN SP.Value = '2' THEN 'Continue and reset access time' 
			 WHEN SP.Value = '3' THEN 'Continue and do not reset access time' ELSE 'N/A' END, 
		'Yes'
FROM	#SubclientProp SP INNER JOIN #Parameter P ON SP.appId = P.appId AND P.Name = 'Use VSS Options' AND P.Value = 'For all files'
WHERE	SP.Name = 'Snap Failure Action' AND SP.Value <> '2'

INSERT	INTO #Parameter
SELECT	DISTINCT clientId, appTypeId, instanceId, backupsetId, SP.appId, 6, 'Content', 
		'Backup System State', 'No', 'Yes'
FROM	#SubclientProp SP INNER JOIN #Subclient S ON SP.appId = S.appId
WHERE	SP.Name = 'System State' AND SP.Value <> '1'

INSERT	INTO #Parameter
SELECT	DISTINCT clientId, appTypeId, instanceId, backupsetId, SP.appId, 6, 'Content', 
		'Only with Full backup', 'Yes', 'No'
FROM	#SubclientProp SP INNER JOIN #Subclient S ON SP.appId = S.appId
		INNER JOIN (SELECT appId FROM #SubclientProp WHERE Name = 'Backup System State' AND Value = '1') P ON SP.appId = P.appId
WHERE	SP.Name = 'System State on Full Backup Only' AND SP.Value <> '0'

INSERT	INTO #Parameter
SELECT	DISTINCT clientId, appTypeId, instanceId, backupsetId, SP.appId, 6, 'Content', 
		'Selective Online Full', 'No', 'Yes'
FROM	#SubclientProp SP INNER JOIN #Subclient S ON SP.appId = S.appId
WHERE	SP.Name = 'Oracle Online Selective Full' AND SP.Value <> '1'

INSERT	INTO #Parameter
SELECT	DISTINCT clientId, appTypeId, instanceId, backupsetId, SP.appId, 6, 'Content', 
		'Backup Mode', 
		CASE WHEN SP.Value = '0' THEN 'Online Database' WHEN SP.Value = '1' THEN 'Online Subset'
			 WHEN SP.Value = '2' THEN 'Offline Database' WHEN SP.Value = '3' THEN 'Online Consistent Database' ELSE 'N/A' END, 
		'Online Database'
FROM	#SubclientProp SP INNER JOIN #Subclient S ON SP.appId = S.appId
WHERE	SP.Name = 'Oracle Backup Mode' AND SP.Value <> '0'

INSERT	INTO #Parameter
SELECT	DISTINCT clientId, appTypeId, instanceId, backupsetId, SP.appId, 6, 'Content', 
		'Backup Control File', 'No', 'Yes'
FROM	#SubclientProp SP INNER JOIN #Subclient S ON SP.appId = S.appId
WHERE	SP.Name = 'Backup Control Files' AND SP.Value <> '0'

INSERT	INTO #Parameter
SELECT	DISTINCT clientId, appTypeId, instanceId, backupsetId, SP.appId, 6, 'Content', 
		'Backup SP File', 'Yes', 'No'
FROM	#SubclientProp SP INNER JOIN #Subclient S ON SP.appId = S.appId
WHERE	SP.Name = 'Oracle Backup SP File' AND SP.Value <> '0'

INSERT	INTO #Parameter
SELECT	DISTINCT clientId, appTypeId, instanceId, backupsetId, SP.appId, 6, 'Content', 
		'Backup Recovery Area', 'Yes', 'No'
FROM	#SubclientProp SP INNER JOIN #Subclient S ON SP.appId = S.appId
WHERE	SP.Name = 'Oracle Protect Backup Recovery Area' AND SP.Value <> '0'

INSERT	INTO #Parameter
SELECT	DISTINCT clientId, appTypeId, instanceId, backupsetId, SP.appId, 6, 'Filters', 
		'Include Global Filters', 
		CASE WHEN useFilters&1 = 1 THEN 'ON' WHEN useFilters&2 = 2 THEN 'Use Cell level policy'
		WHEN useFilters&4 = 4 THEN 'Use subclient policy filters' ELSE 'OFF' END, 
		'Use Cell level policy'
FROM	#SubclientProp SP INNER JOIN #Subclient S ON SP.appId = S.appId
		INNER JOIN (
			SELECT	appId, SUM(CASE WHEN Name = 'use global filters' THEN 1 WHEN Name = 'use SCP filters' THEN 2 ELSE 4 END) AS useFilters
			FROM	#SubclientProp 
			WHERE	Name IN ('use global filters', 'use cs setting for global filters', 'use SCP filters') AND Value = '1'
			GROUP BY appId
			) P ON SP.appId = P.appId
WHERE	SP.Name = 'use cs setting for global filters' AND SP.Value <> '1'

INSERT	INTO #Parameter
SELECT	DISTINCT clientId, appTypeId, instanceId, backupsetId, SP.appId, 6, 'Data Storage Policy', 
		'Storage Policy: Override Data Paths', 'Yes', 'No'
FROM	#SubclientProp SP INNER JOIN #Subclient S ON SP.appId = S.appId
WHERE	SP.Name = 'Full Failover to SP dataPaths' AND SP.Value <> '0'

INSERT	INTO #Parameter
SELECT	DISTINCT clientId, appTypeId, instanceId, backupsetId, SP.appId, 6, 'Data Storage Policy', 
		'Incremental Storage Policy: Override Data Paths', 'Yes', 'No'
FROM	#SubclientProp SP INNER JOIN #Subclient S ON SP.appId = S.appId
WHERE	SP.Name = 'Non-Full Failover to SP dataPaths' AND SP.Value <> '0'

INSERT	INTO #Parameter
SELECT	DISTINCT clientId, appTypeId, instanceId, backupsetId, SP.appId, 6, 'Data Storage Policy', 
		'Data threshold streams', SP.Value, '2'
FROM	#SubclientProp SP INNER JOIN #Subclient S ON SP.appId = S.appId
WHERE	SP.Name = 'Oracle Data backup streams' AND SP.Value <> '2'

INSERT	INTO #Parameter
SELECT	DISTINCT clientId, appTypeId, instanceId, backupsetId, SP.appId, 6, 'Data Storage Policy', 
		'Number of streams for data backup', SP.Value, '1'
FROM	#SubclientProp SP INNER JOIN #Subclient S ON SP.appId = S.appId
WHERE	SP.Name = 'Sybase Data backup streams' AND SP.Value <> '1'

INSERT	INTO #Parameter
SELECT	DISTINCT clientId, appTypeId, instanceId, backupsetId, SP.appId, 6, 'Data Storage Policy', 
		'Number of streams for transaction log', SP.Value, '1'
FROM	#SubclientProp SP INNER JOIN #Subclient S ON SP.appId = S.appId
WHERE	SP.Name = 'Sybase Log backup streams' AND SP.Value <> '1'

INSERT	INTO #Parameter
SELECT	DISTINCT clientId, appTypeId, instanceId, backupsetId, S.appId, 6, 'Data Transfer Option', 
		'Software Compression', 
		CASE compressWhere WHEN 0 THEN 'On Client' WHEN 1 THEN 'On MediaAgent' 
		WHEN 2 THEN 'Use Storage Policy Settings' WHEN 4 THEN 'Off' ELSE 'Use Storage Policy Settings' END,
		'Use Storage Policy Settings'
FROM	archPipeConfig C INNER JOIN #Subclient S ON C.appNumber = S.appId
WHERE	compressWhere <> 2

INSERT	INTO #Parameter
SELECT	DISTINCT clientId, appTypeId, instanceId, backupsetId, S.appId, 6, 'Data Transfer Option', 
		'Network Agents', CAST(numNWAgents AS VARCHAR(32)), '2'
FROM	archPipeConfig C INNER JOIN #Subclient S ON C.appNumber = S.appId
WHERE	numNWAgents <> 2

INSERT	INTO #Parameter
SELECT	DISTINCT clientId, appTypeId, instanceId, backupsetId, S.appId, 6, 'Data Transfer Option', 
		'Throttle Network Bandwidth (MB/HR)', CAST(NWWriteSpeed AS VARCHAR(32)), '0'
FROM	archPipeConfig C INNER JOIN #Subclient S ON C.appNumber = S.appId
WHERE	NWWriteSpeed > 0

INSERT	INTO #Parameter
SELECT	DISTINCT clientId, appTypeId, instanceId, backupsetId, SP.appId, 6, 'Deduplication', 
		'Application Read Size (KB)', SP.Value, '0'
FROM	#SubclientProp SP INNER JOIN #Subclient S ON SP.appId = S.appId
WHERE	SP.Name = 'Read Buffer Size' AND SP.Value <> '0'

INSERT	INTO #Parameter
SELECT	DISTINCT clientId, appTypeId, instanceId, backupsetId, SP.appId, 6, 'Deduplication', 
		'Enable Deduplication - Generate Signature', 
		CASE WHEN SP.Value = '1' THEN 'On Client' WHEN SP.Value = '2' THEN 'On MediaAgent' ELSE 'No' END, 
		'On Client'
FROM	#SubclientProp SP INNER JOIN #Subclient S ON SP.appId = S.appId
WHERE	SP.Name = 'Single Instancing Option' AND SP.Value <> '1'

INSERT	INTO #Parameter
SELECT	DISTINCT clientId, appTypeId, instanceId, backupsetId, SP.appId, 6, 'Encryption', 
		'Subclient Encryption Settings', 
		CASE WHEN SP.Value = '1' THEN 'Media Only (MediaAgent Side)' 
			 WHEN SP.Value = '2' THEN 'Network and Media (Agent Side)' 
			 WHEN SP.Value = '3' THEN 'Network Only (Agent Encrypts, MediaAgent Decrypts)' ELSE 'None' END, 
		'None'
FROM	#SubclientProp SP INNER JOIN #Subclient S ON SP.appId = S.appId
WHERE	SP.Name = 'Encrypt: encryption' AND SP.Value IN ('1', '2', '3')

INSERT	INTO #Parameter
SELECT	S.clientId, S.appTypeId, S.instanceId, S.backupsetId, S.appId, 6, 'Activity Control', 
		CASE opType WHEN 4 THEN 'Enable Backup' WHEN 5 THEN 'Enable Restore' ELSE 'Enable Data Aging' END, 'No', 'Yes'
FROM	JMJobAction A INNER JOIN #Subclient S ON A.appId = S.appId
WHERE	A.opType IN (4, 5, 10) AND A.action = 1 AND A.appId > 1 AND A.clientGroupId = 0

-- Advanced Subclient Properties

INSERT	INTO #Parameter
SELECT	DISTINCT clientId, appTypeId, instanceId, backupsetId, SP.appId, 6, 'Retention', 
		'For files deleted by user', 
		CASE WHEN SP.Value = '1' THEN 'Use storage policy copy retention' 
			 WHEN ISNULL(R.Value, '0') = '-1' THEN 'Retain Indefinitely' 
			 ELSE 'Use storage policy copy retention after'+ISNULL(R.Value, '0')+'days' END, 
		'Use storage policy copy retention' 
FROM	#SubclientProp SP INNER JOIN #Subclient S ON SP.appId = S.appId
		LEFT OUTER JOIN (
			SELECT	appId, Value FROM #SubclientProp 
			WHERE	Name = 'Days to keep items past their expiration' AND Value <> '0'
			) R ON SP.appId = R.appId
WHERE	SP.Name = 'Keep items past their expiration' AND SP.Value <> '1'

INSERT	INTO #Parameter
SELECT	DISTINCT clientId, appTypeId, instanceId, backupsetId, SP.appId, 6, 'Retention', 
		'Keep at least N previous versions', SP.Value, '0' 
FROM	#SubclientProp SP INNER JOIN #Subclient S ON SP.appId = S.appId
WHERE	SP.Name = 'Number of Synth Full Versions' AND SP.Value <> '0'

INSERT	INTO #Parameter
SELECT	DISTINCT clientId, appTypeId, instanceId, backupsetId, SP.appId, 6, 'Pre/Post Process', 
		'PreScan Process', SP.Value, '' 
FROM	#SubclientProp SP INNER JOIN #Subclient S ON SP.appId = S.appId
WHERE	SP.Name = 'sys:pre PreIfind' AND SP.Value <> ''

INSERT	INTO #Parameter
SELECT	DISTINCT clientId, appTypeId, instanceId, backupsetId, SP.appId, 6, 'Pre/Post Process', 
		'PostScan Process', SP.Value, '' 
FROM	#SubclientProp SP INNER JOIN #Subclient S ON SP.appId = S.appId
WHERE	SP.Name = 'sys:post PostIfind' AND SP.Value <> ''

INSERT	INTO #Parameter
SELECT	DISTINCT clientId, appTypeId, instanceId, backupsetId, SP.appId, 6, 'Pre/Post Process', 
		'PreBackup Process', SP.Value, '' 
FROM	#SubclientProp SP INNER JOIN #Subclient S ON SP.appId = S.appId
WHERE	SP.Name = 'sys:pre PreBackup' AND SP.Value <> ''

INSERT	INTO #Parameter
SELECT	DISTINCT clientId, appTypeId, instanceId, backupsetId, SP.appId, 6, 'Pre/Post Process', 
		'PostBackup Process', SP.Value, '' 
FROM	#SubclientProp SP INNER JOIN #Subclient S ON SP.appId = S.appId
WHERE	SP.Name = 'sys:post PostBackup' AND SP.Value <> ''

INSERT	INTO #Parameter
SELECT	DISTINCT clientId, appTypeId, instanceId, backupsetId, SP.appId, 6, 'Pre/Post Process', 
		'PreSnap Process', SP.Value, '' 
FROM	#SubclientProp SP INNER JOIN #Subclient S ON SP.appId = S.appId
WHERE	SP.Name = 'sys:pre PreSnap' AND SP.Value <> ''

INSERT	INTO #Parameter
SELECT	DISTINCT clientId, appTypeId, instanceId, backupsetId, SP.appId, 6, 'Pre/Post Process', 
		'PostSnap Process', SP.Value, '' 
FROM	#SubclientProp SP INNER JOIN #Subclient S ON SP.appId = S.appId
WHERE	SP.Name = 'sys:post PostSnap' AND SP.Value <> ''

INSERT	INTO #Parameter
SELECT	DISTINCT clientId, appTypeId, instanceId, backupsetId, SP.appId, 6, 'Pre/Post Process', 
		'Run PostScan Process for all attempts', SP.Value, '' 
FROM	#SubclientProp SP INNER JOIN #Subclient S ON SP.appId = S.appId
WHERE	SP.Name = 'sys: pre post option' AND CAST(SP.Value AS INT) & 1 <> 0

INSERT	INTO #Parameter
SELECT	DISTINCT clientId, appTypeId, instanceId, backupsetId, SP.appId, 6, 'Pre/Post Process', 
		'Run PostBackup Process for all attempts', SP.Value, '' 
FROM	#SubclientProp SP INNER JOIN #Subclient S ON SP.appId = S.appId
WHERE	SP.Name = 'sys: pre post option' AND CAST(SP.Value AS INT) & 2 <> 0

-- PreSnap Process: On Sourec or On Proxy
-- PostSnap Process: On Sourec or On Proxy

INSERT	INTO #Parameter
SELECT	DISTINCT clientId, appTypeId, instanceId, backupsetId, SP.appId, 6, 'IntelliSnap Operations', 
		'IntelliSnap', 'Yes', 'No'
FROM	#SubclientProp SP INNER JOIN #Subclient S ON SP.appId = S.appId
WHERE	SP.Name = 'Enable Snap Backups' AND SP.Value <> '0'

INSERT	INTO #Parameter
SELECT	DISTINCT clientId, appTypeId, instanceId, backupsetId, SP.appId, 6, 'IntelliSnap Operations', 
		'Snap Engine', 
		CASE WHEN SP.Value = '0' THEN 'None' 
			 WHEN SP.Value = '1' THEN 'Native' 
			 WHEN SP.Value = '2' THEN 'HDS Shadow Image' 
			 WHEN SP.Value = '3' THEN 'NetApp' 
			 WHEN SP.Value = '4' THEN 'EMC TimeFinder BCV' 
			 WHEN SP.Value = '5' THEN 'EMC TimeFinder Snap' 
			 WHEN SP.Value = '6' THEN 'EMC VNX / CLARiiON Snapview Snap' 
			 WHEN SP.Value = '7' THEN 'EMC VNX / CLARiiON Snapview Snap' 
			 WHEN SP.Value = '8' THEN 'HDS Copy on Write Snapshot' 
			 WHEN SP.Value = '9' THEN 'Dell Equallogic Snap' 
			 WHEN SP.Value = '10' THEN 'Data Replicator'
			 WHEN SP.Value = '11' THEN 'Data Replicator' 
			 WHEN SP.Value = '12' THEN 'HP EVA Snapshot' 
			 WHEN SP.Value = '13' THEN 'HP EVA Clone' 
			 WHEN SP.Value = '14' THEN 'IBM XIV Snap' 
			 WHEN SP.Value = '15' THEN 'Data Replicator' 
			 WHEN SP.Value = '16' THEN 'LSI Snapshot' 
			 WHEN SP.Value = '17' THEN 'LSI Volume Copy' 
			 WHEN SP.Value = '18' THEN 'Dell Equallogic Clone' 
			 WHEN SP.Value = '19' THEN 'EMC VNX / Celerra Snap' 
			 WHEN SP.Value = '20' THEN 'IBM SVC Space-efficient FlashCopy'
			 WHEN SP.Value = '21' THEN 'IBM SVC FlashCopy' 
			 WHEN SP.Value = '22' THEN 'Dell Compellent Snap' 
			 WHEN SP.Value = '23' THEN 'Auto Discover Snap' 
			 WHEN SP.Value = '24' THEN 'Auto Discover Clone' 
			 WHEN SP.Value = '25' THEN 'HP 3PAR Snap' 
			 WHEN SP.Value = '26' THEN 'HP 3PAR Clone' 
			 WHEN SP.Value = '27' THEN 'EMC Isilon Snap' 
			 WHEN SP.Value = '28' THEN 'EMC TimeFinder Clone' 
			 WHEN SP.Value = '29' THEN 'Fujitsu ETERNUS DX Snap' 
			 WHEN SP.Value = '30' THEN 'Fujitsu ETERNUS DX Clone' 
			 WHEN SP.Value = '31' THEN 'Nimble Storage CS-Series Snap' 
			 WHEN SP.Value = '32' THEN 'Nimble Storage CS-Series Clone' 
			 WHEN SP.Value = '33' THEN 'HDS Shadow Image CCI' 
			 WHEN SP.Value = '34' THEN 'HDS Thin Image CCI' 
			 WHEN SP.Value = '35' THEN 'Oracle ZFS Storage Snap' 
			 WHEN SP.Value = '36' THEN 'Oracle ZFS Storage Clone' 
			 WHEN SP.Value = '37' THEN 'DataCore Snap' 
			 WHEN SP.Value = '38' THEN 'DataCore Clone' 
			 WHEN SP.Value = '39' THEN 'Huawei OceanStor Snap' 
			 WHEN SP.Value = '40' THEN 'Huawei OceanStor Clone' 
			 WHEN SP.Value = '41' THEN 'Fujitsu ETERNUS DX SnapOPC+' 
			 WHEN SP.Value = '42' THEN 'INFINIDAT InfiniSnap' 
			 WHEN SP.Value = '43' THEN 'INFINIDAT InfiniClone' 
			 WHEN SP.Value = '44' THEN 'Nimble CS-Series Snap and Replicate' 
			 WHEN SP.Value = '45' THEN 'EMC VPLEX Snap' 
			 WHEN SP.Value = '46' THEN 'EMC VPLEX Clone' 
			 WHEN SP.Value = '47' THEN 'EMC TimeFinder VP Snap' 
			 WHEN SP.Value = '48' THEN 'Virtual Server Software Snap' 
			 WHEN SP.Value = '49' THEN 'NEC DynamicSnapVolume' 
			 WHEN SP.Value = '50' THEN 'NEC DynamicDataReplication' 
			 WHEN SP.Value = '51' THEN 'External Backup' 
			 WHEN SP.Value = '52' THEN 'PURE Storage Snap' 
			 WHEN SP.Value = '53' THEN 'Block Level Snap' 
			 WHEN SP.Value = '54' THEN 'NetApp E-Series PiT' 
			 WHEN SP.Value = '55' THEN 'Nutanix Snapshot' 
			 WHEN SP.Value = '56' THEN 'Nutanix Clone' 
			 ELSE 'N/A' END, 
		'None'
FROM	#SubclientProp SP INNER JOIN #Subclient S ON SP.appId = S.appId
WHERE	SP.Name = 'Snap Engine' AND SP.Value <> '0'

INSERT	INTO #Parameter
SELECT	DISTINCT clientId, appTypeId, instanceId, backupsetId, SP.appId, 6, 'IntelliSnap Operations', 
		'Use source if proxy is unreaachable', 'Yes', 'No'
FROM	#SubclientProp SP INNER JOIN #Subclient S ON SP.appId = S.appId
WHERE	SP.Name = 'Snap copy : use source on missing proxy' AND SP.Value <> '0'

INSERT	INTO #Parameter
SELECT	DISTINCT clientId, appTypeId, instanceId, backupsetId, SP.appId, 6, 'IntelliSnap Operations', 
		'Use Dumpbased Backup Copy', 
		CASE WHEN SP.Value = '1' THEN 'Use configured Sybase Instance for Backup Copy' 
			 WHEN SP.Value = '2' THEN 'Create Auxiliary Sybase server' ELSE 'No' END, 
		'No'
FROM	#SubclientProp SP INNER JOIN #Subclient S ON SP.appId = S.appId
WHERE	SP.Name = 'Sybase Snap Backup copy uses dump based approach' AND SP.Value <> '0'

INSERT	INTO #Parameter
SELECT	DISTINCT clientId, appTypeId, instanceId, backupsetId, SP.appId, 6, 'Advanced Options', 
		'Number of Data Readers', SP.Value, '2' 
FROM	#SubclientProp SP INNER JOIN #Subclient S ON SP.appId = S.appId
WHERE	SP.Name = 'sys:nStreams' AND SP.Value <> '2'

INSERT	INTO #Parameter
SELECT	DISTINCT clientId, appTypeId, instanceId, backupsetId, SP.appId, 6, 'Advanced Options', 
		'Allow multiple data readers within a drive or a mount point', 'Yes', 'No'
FROM	#SubclientProp SP INNER JOIN #Subclient S ON SP.appId = S.appId
WHERE	SP.Name = 'sys:UseMultipleStreamsWithinDrive' AND SP.Value <> '0'

INSERT	INTO #Parameter
SELECT	DISTINCT clientId, appTypeId, instanceId, backupsetId, SP.appId, 6, 'Advanced Options', 
		'Catalog additional file and system attributes', 'Yes', 'No'
FROM	#SubclientProp SP INNER JOIN #Subclient S ON SP.appId = S.appId
WHERE	SP.Name = 'SRM Data Collection Options' AND SP.Value <> '0'

INSERT	INTO #Parameter
SELECT	DISTINCT clientId, appTypeId, instanceId, backupsetId, SP.appId, 6, 'Advanced Options', 
		'Catalog ACL (end user access control list)', 'Yes', 'No'
FROM	#SubclientProp SP INNER JOIN #Subclient S ON SP.appId = S.appId
WHERE	SP.Name = 'Enable ACL Collection' AND SP.Value <> '0'

INSERT	INTO #Parameter
SELECT	DISTINCT clientId, appTypeId, instanceId, backupsetId, SP.appId, 6, 'Advanced Options', 
		'Optimize for file system with large number of small files (Block Level backup)', 'Yes', 'No'
FROM	#SubclientProp SP INNER JOIN #Subclient S ON SP.appId = S.appId
WHERE	SP.Name = 'Use block level backup' AND SP.Value <> '0'

INSERT	INTO #Parameter
SELECT	DISTINCT clientId, appTypeId, instanceId, backupsetId, SP.appId, 6, 'Advanced Options', 
		'Create file level index during backup', 'Yes', 'No'
FROM	#SubclientProp SP INNER JOIN #Subclient S ON SP.appId = S.appId
		INNER JOIN (SELECT appId FROM #SubclientProp WHERE Name = 'Use block level backup' AND Value = '1') T ON SP.appId = T.appId
WHERE	SP.Name = 'Enable metadata Collection' AND SP.Value <> '0'

INSERT	INTO #Parameter
SELECT	DISTINCT clientId, appTypeId, instanceId, backupsetId, SP.appId, 6, 'Advanced Options', 
		'Delete protected PSTs', 'Yes', 'No'
FROM	#SubclientProp SP INNER JOIN #Subclient S ON SP.appId = S.appId
WHERE	SP.Name = 'Delete PST file only' AND SP.Value <> '0'

INSERT	INTO #Parameter
SELECT	DISTINCT clientId, appTypeId, instanceId, backupsetId, SP.appId, 6, 'Advanced Options', 
		'Scan using', 
		CASE WHEN ScanFlag&1=1 THEN 'Change Journal' WHEN ScanFlag&2=2 THEN 'Recursive Scan' 
			 WHEN ScanFlag&4=4 THEN 'Optimized Scan' ELSE 'N/A' END, 
		'N/A'
FROM	(SELECT appId, 
				SUM(CASE WHEN Name = 'Use Change Journal' THEN 1 WHEN Name = 'Use Classic File Scan' THEN 2 
					WHEN Name = 'Use DC for FS backups' THEN 4 ELSE 0 END) AS ScanFlag
		FROM	#SubclientProp
		WHERE	Name IN ('Use Change Journal', 'Use Classic File Scan', 'Use DC for FS backups') AND Value = '1'
		GROUP BY appId
		) SP INNER JOIN #Subclient S ON SP.appId = S.appId
WHERE	SP.ScanFlag <> 0

INSERT	INTO #Parameter
SELECT	DISTINCT clientId, appTypeId, instanceId, backupsetId, SP.appId, 6, 'Advanced Options', 
		'Preserve File Access Time', 'Yes', 'No'
FROM	#SubclientProp SP INNER JOIN #Subclient S ON SP.appId = S.appId
		INNER JOIN (SELECT appId FROM #SubclientProp WHERE Name = 'Use Classic File Scan' AND Value = '1') T ON SP.appId = T.appId
WHERE	SP.Name = 'Preserve File Access Times' AND SP.Value <> '0'

INSERT	INTO #Parameter
SELECT	DISTINCT clientId, appTypeId, instanceId, backupsetId, SP.appId, 6, 'Advanced Options', 
		'Check archive bit during backups', 'Yes', 'No'
FROM	#SubclientProp SP INNER JOIN #Subclient S ON SP.appId = S.appId
		INNER JOIN (SELECT appId FROM #SubclientProp WHERE Name = 'Use Classic File Scan' AND Value = '1') T ON SP.appId = T.appId
WHERE	SP.Name = 'Use Archive Bit' AND SP.Value <> '0'

INSERT	INTO #Parameter
SELECT	DISTINCT clientId, appTypeId, instanceId, backupsetId, SP.appId, 6, 'Advanced Options', 
		'Exclude from SLA and Strike Counts', 'Yes', 'No'
FROM	#SubclientProp SP INNER JOIN #Subclient S ON SP.appId = S.appId
WHERE	SP.Name = 'Exclude From SLA' AND SP.Value <> '0'

INSERT	INTO #Parameter
SELECT	DISTINCT clientId, appTypeId, instanceId, backupsetId, SP.appId, 6, 'Advanced Options - Backup Arguments', 
		'RAMAN Multiplexing: Data Files (BFS)', SP.Value, '32'
FROM	#SubclientProp SP INNER JOIN #Subclient S ON SP.appId = S.appId
WHERE	SP.Name = 'Oracle Data FPS' AND SP.Value <> '32'

INSERT	INTO #Parameter
SELECT	DISTINCT clientId, appTypeId, instanceId, backupsetId, SP.appId, 6, 'Advanced Options - Backup Arguments', 
		'RAMAN Multiplexing: Archive Files (BFS)', SP.Value, '32'
FROM	#SubclientProp SP INNER JOIN #Subclient S ON SP.appId = S.appId
WHERE	SP.Name = 'Arch per bfs' AND SP.Value <> '32'

INSERT	INTO #Parameter
SELECT	DISTINCT clientId, appTypeId, instanceId, backupsetId, SP.appId, 6, 'Advanced Options - Backup Arguments', 
		'RAMAN Multiplexing: Maximum No. of Open Files', SP.Value, '8'
FROM	#SubclientProp SP INNER JOIN #Subclient S ON SP.appId = S.appId
WHERE	SP.Name = 'Oracle Max Open Files' AND SP.Value <> '8'

INSERT	INTO #Parameter
SELECT	DISTINCT clientId, appTypeId, instanceId, backupsetId, SP.appId, 6, 'Advanced Options - Backup Arguments', 
		'RAMAN Backupset Size: Maximum Size (KB)', SP.Value, '0'
FROM	#SubclientProp SP INNER JOIN #Subclient S ON SP.appId = S.appId
WHERE	SP.Name = 'Oracle Max Backup Set Size' AND SP.Value <> '0'

INSERT	INTO #Parameter
SELECT	DISTINCT clientId, appTypeId, instanceId, backupsetId, SP.appId, 6, 'Advanced Options - Backup Arguments', 
		'RAMAN Backupset Size: Section Size (KB)', SP.Value, '0'
FROM	#SubclientProp SP INNER JOIN #Subclient S ON SP.appId = S.appId
WHERE	SP.Name = 'Oracle Section size' AND SP.Value <> '0'

--		'Oracle Tag'

INSERT	INTO #Parameter
SELECT	DISTINCT clientId, appTypeId, instanceId, backupsetId, SP.appId, 6, 'Advanced Options - Offline Arguments', 
		'Run DataBase Shutdown/Startup(Lights Out) Script', 'Yes', 'No'
FROM	#SubclientProp SP INNER JOIN #Subclient S ON SP.appId = S.appId
		INNER JOIN (SELECT appId FROM #SubclientProp WHERE Name = 'Oracle Backup Mode' AND Value = '2') T ON SP.appId = T.appId
WHERE	SP.Name = 'Light Out Script' AND SP.Value <> '0'

INSERT	INTO #Parameter
SELECT	DISTINCT clientId, appTypeId, instanceId, backupsetId, SP.appId, 6, 'Advanced Options - Offline Arguments', 
		'Broadcast Warning Message to Users', 'Yes', 'No'
FROM	#SubclientProp SP INNER JOIN #Subclient S ON SP.appId = S.appId
		INNER JOIN (SELECT appId FROM #SubclientProp WHERE Name = 'Oracle Backup Mode' AND Value = '2') T ON SP.appId = T.appId
		INNER JOIN (SELECT appId FROM #SubclientProp WHERE Name = 'Light Out Script' AND Value = '1') U ON SP.appId = U.appId
WHERE	SP.Name = 'Oracle LOS Backup Warning' AND SP.Value <> '0'

INSERT	INTO #Parameter
SELECT	DISTINCT clientId, appTypeId, instanceId, backupsetId, SP.appId, 6, 'Advanced Options - Offline Arguments', 
		'Broadcast Warning Message to Users', SP.Value, '0'
FROM	#SubclientProp SP INNER JOIN #Subclient S ON SP.appId = S.appId
		INNER JOIN (SELECT appId FROM #SubclientProp WHERE Name = 'Oracle Backup Mode' AND Value = '2') T ON SP.appId = T.appId
		INNER JOIN (SELECT appId FROM #SubclientProp WHERE Name = 'Light Out Script' AND Value = '1') U ON SP.appId = U.appId
		INNER JOIN (SELECT appId FROM #SubclientProp WHERE Name = 'Oracle LOS Backup Warning' AND Value = '1') V ON SP.appId = V.appId
WHERE	SP.Name = 'Oracle LOS Backup Delay Min' AND SP.Value <> '0'

INSERT	INTO #Parameter
SELECT	DISTINCT clientId, appTypeId, instanceId, backupsetId, SP.appId, 6, 'Advanced Options - Offline Arguments', 
		'Use SQL Connect', 'Yes', 'No'
FROM	#SubclientProp SP INNER JOIN #Subclient S ON SP.appId = S.appId
WHERE	SP.Name = 'Oracle Use SQL Connect' AND SP.Value <> '0'

INSERT	INTO #Parameter
SELECT	DISTINCT clientId, appTypeId, instanceId, backupsetId, SP.appId, 6, 'Advanced Options - Options', 
		'TableSpace/DataFiles Options: Skip Read-Only', 'Yes', 'No'
FROM	#SubclientProp SP INNER JOIN #Subclient S ON SP.appId = S.appId
WHERE	SP.Name = 'Oracle Skip read only' AND SP.Value <> '0'

INSERT	INTO #Parameter
SELECT	DISTINCT clientId, appTypeId, instanceId, backupsetId, SP.appId, 6, 'Advanced Options - Options', 
		'TableSpace/DataFiles Options: Skip Offline', 'Yes', 'No'
FROM	#SubclientProp SP INNER JOIN #Subclient S ON SP.appId = S.appId
WHERE	SP.Name = 'Oracle Skip offline' AND SP.Value <> '0'

INSERT	INTO #Parameter
SELECT	DISTINCT clientId, appTypeId, instanceId, backupsetId, SP.appId, 6, 'Advanced Options - Options', 
		'Common Options: Validate', 'Yes', 'No'
FROM	#SubclientProp SP INNER JOIN #Subclient S ON SP.appId = S.appId
WHERE	SP.Name = 'Oracle Set Validate' AND SP.Value <> '0'

INSERT	INTO #Parameter
SELECT	DISTINCT clientId, appTypeId, instanceId, backupsetId, SP.appId, 6, 'Advanced Options - Options', 
		'Common Options: Enable Table Browse', 'Yes', 'No'
FROM	#SubclientProp SP INNER JOIN #Subclient S ON SP.appId = S.appId
WHERE	SP.Name = 'Oracle Enable Table Browse' AND SP.Value <> '0'

INSERT	INTO #Parameter
SELECT	DISTINCT clientId, appTypeId, instanceId, backupsetId, SP.appId, 6, 'Advanced Options - Options', 
		'Common Options: Merge Incremental Image Copies', 'Yes', 'No'
FROM	#SubclientProp SP INNER JOIN #Subclient S ON SP.appId = S.appId
WHERE	SP.Name = 'Oracle Merge Incr Image Copy' AND SP.Value <> '0'

INSERT	INTO #Parameter
SELECT	DISTINCT clientId, appTypeId, instanceId, backupsetId, SP.appId, 6, 'Advanced Options - Options', 
		'Common Options: Merge Incremental Image Copies', 'Yes', 'No'
FROM	#SubclientProp SP INNER JOIN #Subclient S ON SP.appId = S.appId
WHERE	SP.Name = 'Oracle Skip inaccessible' AND SP.Value <> '0'

INSERT	INTO #Parameter
SELECT	DISTINCT clientId, appTypeId, instanceId, backupsetId, SP.appId, 6, 'Advanced Options - Options', 
		'Common Options: Resync Recovery Catalog', 'Yes', 'No'
FROM	#SubclientProp SP INNER JOIN #Subclient S ON SP.appId = S.appId
WHERE	SP.Name = 'Oracle Resync Catalog' AND SP.Value <> '0'

INSERT	INTO #Parameter
SELECT	DISTINCT clientId, appTypeId, instanceId, backupsetId, SP.appId, 6, 'Log Backup', 
		'Backup Archive Log', 'Yes', 'No'
FROM	#SubclientProp SP INNER JOIN #Subclient S ON SP.appId = S.appId
WHERE	SP.Name = 'Backup Archive Log' AND SP.Value <> '0'

INSERT	INTO #Parameter
SELECT	DISTINCT clientId, appTypeId, instanceId, backupsetId, SP.appId, 6, 'Log Backup', 
		'Backup Archive Log', 
		CASE WHEN SP.Value = '1' THEN 'Backup Archive Log All' ELSE 'Backup Instance Archive Log' END, 
		'Backup Archive Log All'
FROM	#SubclientProp SP INNER JOIN #Subclient S ON SP.appId = S.appId
		INNER JOIN (SELECT appId FROM #SubclientProp WHERE Name = 'Backup Archive Log' AND Value = '1') U ON SP.appId = U.appId
WHERE	SP.Name = 'Backup Archive Log Option' --AND SP.Value <> '1'

INSERT	INTO #Parameter
SELECT	DISTINCT clientId, appTypeId, instanceId, backupsetId, SP.appId, 6, 'Log Backup', 
		'Backup Archive Log: Archive Delete', 'Yes', 'No'
FROM	#SubclientProp SP INNER JOIN #Subclient S ON SP.appId = S.appId
		INNER JOIN (SELECT appId FROM #SubclientProp WHERE Name = 'Backup Archive Log' AND Value = '1') U ON SP.appId = U.appId
WHERE	SP.Name = 'Archive Log Deleting' --AND SP.Value <> '0'

INSERT	INTO #Parameter
SELECT	DISTINCT clientId, appTypeId, instanceId, backupsetId, SP.appId, 6, 'Log Backup', 
		'Backup Archive Log: Disable Switch Current Log', 'Yes', 'No'
FROM	#SubclientProp SP INNER JOIN #Subclient S ON SP.appId = S.appId
		INNER JOIN (SELECT appId FROM #SubclientProp WHERE Name = 'Backup Archive Log' AND Value = '1') U ON SP.appId = U.appId
WHERE	SP.Name = 'Oracle LOS disable Switch' --AND SP.Value <> '0'

INSERT	INTO #Parameter
SELECT	DISTINCT clientId, appTypeId, instanceId, backupsetId, SP.appId, 6, 'Log Backup', 
		'Backup Archive Log: Log threshold streams', SP.Value, '1'
FROM	#SubclientProp SP INNER JOIN #Subclient S ON SP.appId = S.appId
		INNER JOIN (SELECT appId FROM #SubclientProp WHERE Name = 'Backup Archive Log' AND Value = '1') U ON SP.appId = U.appId
WHERE	SP.Name = 'Oracle Log backup streams' --AND SP.Value <> '1'

INSERT	INTO #Parameter
SELECT	DISTINCT clientId, appTypeId, instanceId, backupsetId, SP.appId, 6, 'Log Backup', 
		'Backup Archive Log: Use RMAN for Log Backup', 'Yes', 'No'
FROM	#SubclientProp SP INNER JOIN #Subclient S ON SP.appId = S.appId
		INNER JOIN (SELECT appId FROM #SubclientProp WHERE Name = 'Backup Archive Log' AND Value = '1') U ON SP.appId = U.appId
WHERE	SP.Name = 'Oracle Use Rman For Log Backup' --AND SP.Value <> '0'

INSERT	INTO #Parameter
SELECT	DISTINCT clientId, appTypeId, instanceId, backupsetId, SP.appId, 6, 'Log Backup', 
		'Backup Archive Log: Select ArchiveLog Destinations for Backup', 'Yes', 'No'
FROM	#SubclientProp SP INNER JOIN #Subclient S ON SP.appId = S.appId
		INNER JOIN (SELECT appId FROM #SubclientProp WHERE Name = 'Backup Archive Log' AND Value = '1') U ON SP.appId = U.appId
WHERE	SP.Name = 'Oracle Backup Archive Log Flag' --AND SP.Value <> '0'

INSERT	INTO #Parameter
SELECT	DISTINCT clientId, appTypeId, instanceId, backupsetId, SP.appId, 6, 'Log Backup', 
		'Backup Archive Log: Select ArchiveLog Destinations for Delete', 'Yes', 'No'
FROM	#SubclientProp SP INNER JOIN #Subclient S ON SP.appId = S.appId
		INNER JOIN (SELECT appId FROM #SubclientProp WHERE Name = 'Backup Archive Log' AND Value = '1') U ON SP.appId = U.appId
WHERE	SP.Name ='Oracle Delete Archive Log Flag' --AND SP.Value <> '0'


-- NySQL
-- Advanced Backup Options - Use Volume Copy (Block Level Backup - support partial restore for databases and schema objects)



DROP TABLE #Subclient
DROP TABLE #SubclientProp



SET @surveyXML =
	(
SELECT	
			ClientId AS '@ClientId', 
			AppTypeId AS '@AppTypeId', 
			InstanceId AS '@InstanceId', 
			BackupsetId AS '@BackupsetId',
			AppId AS '@AppId', 
			Category AS '@Category', 
			Property AS '@Property', 
			Name AS '@Name', 
			Value AS '@Value',
			DefaultValue AS '@Default'
	FROM	#Parameter

	FOR XML PATH ('ClientAudit') 
	-- Replace <<RESULTS_NAME>> with specific name
	)

DROP TABLE #Parameter
DROP TABLE #ClientProp
DROP TABLE #Client
DROP TABLE #TblFirewallOptions
DROP TABLE #TblNWThrottleOptions
DROP TABLE #TblFirewallRemoteAccess

--------- END SURVEY QUERY ---------

--------- BEGIN - GENERATED CODE, PLEASE DO NOT MODIFY ---------

DECLARE @EndTime AS BIGINT = dbo.GetUnixTime(GETUTCDATE())
SET @outputXML = 
(
	SELECT
		@queryId AS '@QueryId',
		@EndTime AS '@LogDate',
		(@EndTime - @LogDate) AS '@QueryRunningTime',
		@surveyXML
	FOR XML PATH('Rpt_CSSXMLDATA')
)
SET NOCOUNT OFF

--------- END - GENERATED CODE ---------