--Name:- Tape Media History
--Description:- Tape Media History

SET NOCOUNT ON
SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED

BEGIN TRY
	    
DECLARE @LogDate AS BIGINT = dbo.GetUnixTime(GETUTCDATE())
DECLARE @queryId AS INTEGER = 179
DECLARE @surveyXML NVARCHAR(MAX)
  
DECLARE @CurrentTime INT = dbo.GetUnixTime(GETUTCDATE())
DECLARE @LastCollectionTime INT = 0

IF OBJECT_ID(N'dbo.MMTapeStateHistory', N'U') IS NOT NULL
BEGIN

	SELECT  @LastCollectionTime = CAST(CAST(value AS VARCHAR(20)) AS INT) 
	FROM    GXGlobalParam WITH (NOLOCK)
	WHERE   name = 'CommservSurveyTapeStateStatsCollectionTime'
	  
	SET @surveyXML =
	(
		SELECT 
			HistoryId AS '@HistoryId',
			MediaId AS '@MediaId',
			BarCode AS '@BarCode',
			LibraryId AS '@LibraryId',
			LibraryName AS '@LibraryName',
			MediaLocation AS '@MediaLocation',
			MarkedForExport AS '@MarkedForExport',
			SlotId AS '@SlotId',
			SlotName AS '@SlotName',
			DriveId AS '@DriveId',
			DriveName AS '@DriveName',
			ContainerId AS '@ContainerId',
			ContainerName AS '@ContainerName',
			ExportLocationId AS '@ExportLocationId',
			ExportLocation AS '@ExportLocation',
			ExportTime AS '@ExportTime',
			ImportTime AS '@ImportTime',
			UpdateTime AS '@UpdateTime'
		FROM MMTapeStateHistory WHERE UpdateTime > @LastCollectionTime
		FOR XML PATH ('TapeMediaHistory')
	)
	IF NOT EXISTS (SELECT * FROM GXGlobalParam WHERE name = 'CommservSurveyTapeStateStatsCollectionTime')
	BEGIN
		IF EXISTS (SELECT * FROM APP_Client WITH(NOLOCK) WHERE id = 2 AND releaseId < 15)
			INSERT INTO GXGlobalParam (name, value) SELECT 'CommservSurveyTapeStateStatsCollectionTime', ''
		ELSE
			EXEC('INSERT INTO GXGlobalParam (name, value, created, modified) SELECT ''CommservSurveyTapeStateStatsCollectionTime'', '''', 0, 0')
	END

	
END

--SELECT CAST(@surveyXML AS XML)	
DECLARE @EndTime AS BIGINT = dbo.GetUnixTime(GETUTCDATE())
SET @outputXML = 
(
	SELECT
		@queryId AS '@QueryId',
		@EndTime AS '@LogDate',
		(@EndTime - @LogDate) AS '@QueryRunningTime',
		@surveyXML
	FOR XML PATH('Rpt_CSSXMLDATA')
)				

	 
END TRY
BEGIN CATCH	 
  DECLARE @ErrorMessage NVARCHAR(4000);  
  SET @ErrorMessage = ERROR_MESSAGE();
  RAISERROR(@ErrorMessage,16,1);
RETURN
END CATCH
IF OBJECT_ID(N'dbo.MMTapeStateHistory', N'U') IS NOT NULL
BEGIN
UPDATE  GXGlobalParam SET value = CAST(@CurrentTime AS VARCHAR(20)) WHERE name = 'CommservSurveyTapeStateStatsCollectionTime'
END

SET NOCOUNT OFF 