--- Please follow the below comments to insert SQL statements.
-- Client version query
--------- BEGIN - GENERATED CODE, PLEASE DO NOT MODIFY ---------

SET NOCOUNT ON
SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED

DECLARE @LogDate AS BIGINT = dbo.GetUnixTime(GETUTCDATE())
DECLARE @queryId AS INTEGER = 159
DECLARE @surveyXML NVARCHAR(MAX)

--------- END - GENERATED CODE ---------



--------- BEGIN SURVEY QUERY ---------

--------- Insert your SQL statements here 
-- CommCell Parameter Audit - Display differences of CommCell Parameters from a user selected CommCell

DECLARE @ReleaseId INT
SET	@ReleaseId = (SELECT releaseId FROM APP_Client WHERE id = 2)

CREATE TABLE #GlobalParam (name VARCHAR(64), Value NVARCHAR(MAX))

IF	@ReleaseId < 15
	INSERT INTO #GlobalParam SELECT name, CAST(value AS NVARCHAR(MAX)) FROM GXGlobalParam
ELSE
	EXEC sp_executesql N'INSERT INTO #GlobalParam SELECT DISTINCT name, value FROM GXGlobalParam WHERE modified = 0'


CREATE TABLE #Param (Category INT, Property VARCHAR(64), Name VARCHAR(256), Value VARCHAR(MAX), DefaultValue VARCHAR(MAX))


-- Category 1 for Global Filters

INSERT	INTO #Param
SELECT	1, '', 'Use Global Filters from Master CommCell', 
	ISNULL((SELECT value FROM #GlobalParam WHERE name = 'Use QNET Global Filters'), '0'), '0'
UNION ALL
SELECT	1, '', 'Use Global Filters on all Subclients', 
	ISNULL((SELECT value FROM #GlobalParam WHERE name = 'Use Global Filters for all Subclients'), '0'), '0'
UNION ALL
SELECT	1, 'Windows Filters', 'Exclude Global Filters', 
	ISNULL((SELECT value FROM #GlobalParam WHERE name = 'Windows FS Exclude Filters'), ''), ''
UNION ALL
SELECT	1, 'Windows Filters', 'Master CommCell Global Filters', 
	ISNULL((SELECT value FROM #GlobalParam WHERE name = 'CN_Windows FS Exclude Filters'), ''), ''
UNION ALL
SELECT	1, 'Windows File Archiver Filters', 'Exclude Global Filters', 
	ISNULL((SELECT value FROM #GlobalParam WHERE name = 'FSDM Exclude Filters'), ''), ''
UNION ALL
SELECT	1, 'Windows File Archiver Filters', 'Master CommCell Global Filters', 
	ISNULL((SELECT value FROM #GlobalParam WHERE name = 'CN_FSDM Exclude Filters'), ''), ''
UNION ALL
SELECT	1, 'Unix Filters', 'Exclude Global Filters', 
	ISNULL((SELECT value FROM #GlobalParam WHERE name = 'Unix FS Exclude Filters'), ''), ''
UNION ALL
SELECT	1, 'Unix Filters', 'Master CommCell Global Filters', 
	ISNULL((SELECT value FROM #GlobalParam WHERE name = 'CN_Unix FS Exclude Filters'), ''), ''
UNION ALL
SELECT	1, 'NetWare Filters', 'Exclude Global Filters', 
	ISNULL((SELECT value FROM #GlobalParam WHERE name = 'Netware FS Exclude Filters'), ''), ''
UNION ALL
SELECT	1, 'NetWare Filters', 'Master CommCell Global Filters', 
	ISNULL((SELECT value FROM #GlobalParam WHERE name = 'CN_Netware FS Exclude Filters'), ''), ''
UNION ALL
SELECT	1, 'Exchange Mailbox Filters', 'Exclude Global Filters', 
	ISNULL((SELECT value FROM #GlobalParam WHERE name = 'Exchange Mailbox NoFiles Filters'), ''), ''
UNION ALL
SELECT	1, 'Exchange Mailbox Filters', 'Master CommCell Global Filters', 
	ISNULL((SELECT value FROM #GlobalParam WHERE name = 'CN_Exchange Mailbox NoFiles Filters'), ''), ''
UNION ALL
SELECT	1, 'Exchange Mailbox Archiver Filters', 'Exclude Global Filters', 
	ISNULL((SELECT value FROM #GlobalParam WHERE name = 'Exchange DataMigrator NoFiles Filters'), ''), ''
UNION ALL
SELECT	1, 'Exchange Mailbox Archiver Filters', 'Master CommCell Global Filters', 
	ISNULL((SELECT value FROM #GlobalParam WHERE name = 'CN_Exchange DataMigrator NoFiles Filters'), ''), ''
UNION ALL
SELECT	1, 'Exchange Compliance Archiver Filters', 'Exclude Global Filters', 
	ISNULL((SELECT value FROM #GlobalParam WHERE name = 'Exchange Archiver NoFiles Filters'), ''), ''
UNION ALL
SELECT	1, 'Exchange Compliance Archiver Filters', 'Master CommCell Global Filters', 
	ISNULL((SELECT value FROM #GlobalParam WHERE name = 'CN_Exchange Archiver NoFiles Filters'), ''), '' 
UNION ALL
SELECT	1, 'Online Content Indexing for Exchange', 'Exclude Global Filters', 
	ISNULL((SELECT value FROM #GlobalParam WHERE name = 'Exchange Online CI NoFiles Filters'), ''), ''
UNION ALL
SELECT	1, 'Online Content Indexing for Exchange', 'Master CommCell Global Filters', 
	ISNULL((SELECT value FROM #GlobalParam WHERE name = 'CN_Exchange Online CI NoFiles Filters'), ''), ''
UNION ALL
SELECT	1, 'Content Indexing Filters', 'Exclude Global Filters', 
	ISNULL((SELECT value FROM #GlobalParam WHERE name = 'Content Indexing Exclude Filters'), ''), ''
UNION ALL
SELECT	1, 'Content Indexing Filters', 'Master CommCell Global Filters', 
	ISNULL((SELECT value FROM #GlobalParam WHERE name = 'CN_Content Indexing Exclude Filters'), ''), ''
UNION ALL
SELECT	1, 'Virtual Server Filters', 'Exclude Global Filters', 
	ISNULL((SELECT value FROM #GlobalParam WHERE name = 'Virtual Server Exclude Filters'), ''), ''
UNION ALL
SELECT	1, 'Virtual Server Filters', 'Master CommCell Global Filters', 
	ISNULL((SELECT value FROM #GlobalParam WHERE name = 'CN_Virtual Server Exclude Filters'), ''), ''

-- Category 4 for Browse/Search/Recover Options
INSERT	INTO #Param
SELECT  4, '', 
		CASE WHEN name = 'ShowAgedDataForBrowseAndRecovery' THEN 'Show aged data during browse and recovery'
			WHEN name = 'ConfirmKillNonRestartableRestores' THEN 'Disable confirmation message for restore jobs'
			WHEN name = 'AutoCopyPrecedence' THEN 'Automatically switch copy to read data from any copy'
			WHEN name = 'EndUserRestoreForBrowseAndRecovery' THEN 'Start End User restores in suspended state'
			WHEN name = 'ComplianceUserRestoreForBrowseAndRecovery' THEN 'Start Compliance restores in suspended state'
			WHEN name = 'RestoreAppleEncodedFileOnNonMacFS' THEN 'Recover Apple Resource Fork Data'
			WHEN name = 'Exchange Delegate Search' THEN 'Enable Exchange Delegate Search'
			WHEN name = 'Allow Selective Point in Time Restore' THEN 'Allow Point-in-time for SQL across cycles'
			ELSE name
		END, 
		Value, '0'
FROM	#GlobalParam
WHERE	name in ('ShowAgedDataForBrowseAndRecovery', 'ConfirmKillNonRestartableRestores', 
'AutoCopyPrecedence', 'EndUserRestoreForBrowseAndRecovery', 'ComplianceUserRestoreForBrowseAndRecovery',
'RestoreAppleEncodedFileOnNonMacFS', 'Exchange Delegate Search', 'Allow Selective Point in Time Restore')

-- Category 2 forJob Manager
INSERT	INTO #Param
SELECT	2, 'General', 'Job Alive Check Interval (Mins)', 
	ISNULL((SELECT CAST(CAST(value AS INT)/60 AS VARCHAR(20)) FROM #GlobalParam WHERE name = 'JobAliveInterval'), '2'), '2'
UNION ALL
SELECT	2, 'General', 'High Watermark Level', value, '500'
FROM	#GlobalParam WHERE name = 'JMJobActivityLevelHighWaterMark'
UNION ALL
SELECT	2, 'General', 'Queue jobs if other conflict jobs are active', 
	CASE WHEN ISNULL((SELECT value FROM #GlobalParam WHERE name = 'JobsQueuedIfJobsRunning'), '0') = '0' THEN 'No' ELSE 'Yes' END, 'No'
UNION ALL
SELECT	2, 'General', 'Queue jobs if activity is disabled', 
	CASE WHEN ISNULL((SELECT value FROM #GlobalParam WHERE name = 'JobsCompleteIfActivityDisabled'), '0') = '0' THEN 'No' ELSE 'Yes' END, 'No'
UNION ALL
SELECT	2, 'General', 'Allow running jobs to complete past the operation window', 
	CASE WHEN ISNULL((SELECT value FROM #GlobalParam WHERE name = 'JobsCompletePastOperationalWindow'), '0') = '0' THEN 'No' ELSE 'Yes' END, 'No'
UNION ALL
SELECT	2, 'General', 'Queue Scheduled Jobs', 
	CASE WHEN ISNULL((SELECT value FROM #GlobalParam WHERE name = 'RMQueueScheduledJob'), '0') = '0' THEN 'No' ELSE 'Yes' END, 'No'
UNION ALL
SELECT	2, 'General', 'Do not start backups on disabled clients', 
	CASE WHEN ISNULL((SELECT value FROM #GlobalParam WHERE name = 'JMDontStartBkpsOnDisabledAgents'), '0') = '0' THEN 'No' ELSE 'Yes' END, 'No'
UNION ALL
SELECT	2, 'General', 'Enable Multiplexing for Oracle', 
	CASE WHEN ISNULL((SELECT CAST(value AS INT)&1 FROM #GlobalParam WHERE name = 'JMEnableMultiplexingForOracleAgents'), 0) = 0 THEN 'No' ELSE 'Yes' END, 'No'
UNION ALL
SELECT	2, 'General', 'Enable Multiplexing for database agents (non-Oracle/RAC)', 
	CASE WHEN ISNULL((SELECT CAST(value AS INT)&2 FROM #GlobalParam WHERE name = 'JMEnableMultiplexingForOracleAgents'), 0) = 0 THEN 'No' ELSE 'Yes' END, 'No'
UNION ALL
SELECT	2, 'Job Pre-Emption Control', 'Restore Preempts Other Jobs', 
	CASE WHEN ISNULL((SELECT value FROM #GlobalParam WHERE name = 'RMRestoreInterruptOtherJobs'), '0') = '0' THEN 'No' ELSE 'Yes' END, 'No'
UNION ALL
SELECT	2, 'Job Pre-Emption Control', 'Backups Preempts Other Backups', 
	CASE WHEN ISNULL((SELECT value FROM #GlobalParam WHERE name = 'RMBackupInterruptBackup'), '0') = '0' THEN 'No' ELSE 'Yes' END, 'No'
UNION ALL
SELECT	2, 'Job Pre-Emption Control', 'Backups Preempts Auxiliary Copy', 
	CASE WHEN ISNULL((SELECT value FROM #GlobalParam WHERE name = 'RMOtherJobsInterruptAuxCopy'), '0') = '0' THEN 'No' ELSE 'Yes' END, 'No'
UNION ALL
SELECT	2, 'Job Priority', 'Priority Precedence', CASE WHEN value = '1' THEN 'Client' ELSE 'Agent Type' END, 'Client'
FROM	#GlobalParam WHERE name = 'JobPriorityPrecedence'
UNION ALL
SELECT	2, 'Priority by Job Type', 'Auxiliary Copy', 
	ISNULL((SELECT value FROM #GlobalParam WHERE name = 'JMAuxCopyCombinedPriority'), '0'), '0'
UNION ALL
SELECT	2, 'Priority by Job Type', 'Data Verification',
	ISNULL((SELECT value FROM #GlobalParam WHERE name = 'JMDataVerificationCombinedPriority'), '0'), '0'
UNION ALL
SELECT	2, 'Priority by Job Type', 'Information Management',
	ISNULL((SELECT value FROM #GlobalParam WHERE name = 'JMInfoMgmtCombinedPriority'), '0'), '0'
UNION ALL
SELECT	2, 'Priority by Job Type', 'Media Refresh',
	ISNULL((SELECT value FROM #GlobalParam WHERE name = 'JMMediaRefreshingCombinedPriority'), '0'), '0'
UNION ALL
SELECT	2, 'Priority by Job Type', 'Persistent Recovery',
	ISNULL((SELECT value FROM #GlobalParam WHERE name = 'JMPersistentRecoveryCombinedPriority'), '0'), '0'
UNION ALL
SELECT	2, 'Job Updates', 'State Update Interval for ContinuosDataReplicator',
	ISNULL((SELECT value FROM #GlobalParam WHERE name = 'Data Replication Update Interval Minutes'), '0'), '0'
UNION ALL
SELECT	2, 'Job Updates', 'State Update Interval for Data Classification', -- need to verify the name
	ISNULL((SELECT value FROM #GlobalParam WHERE name = 'Data Classification Update Interval Minutes'), '0'), '0'
UNION ALL
SELECT	2, 'Job Restarts', 'Start Phase Retry Interval (Mins)',
	ISNULL((SELECT CAST(CAST(value AS INT)/60 AS VARCHAR(20)) FROM #GlobalParam WHERE name = 'JMNetRetryPeriod'), '0'), '0'


DROP TABLE #GlobalParam 

INSERT	INTO #Param
SELECT  2, 'Priority by Agent Type', I.name, I.priority, '0'
FROM	APP_iDAType AS I INNER JOIN APP_iDATypePropLookup AS L
	 ON I.type = L.appType AND I.priority NOT IN ('Invalid Property', '0')

INSERT	INTO #Param
SELECT  2, 'Job Update Interval - Protection (Mins)', I.name, I.updateIntervalSec/60, '5'
FROM	APP_iDAType AS I INNER JOIN APP_iDATypePropLookup AS L
	 ON I.type = L.appType AND I.updateIntervalSec NOT IN ('Invalid Property', '300')

INSERT	INTO #Param
SELECT  2, 'Job Update Interval - Recovery (Mins)', I.name, I.updateRecoSec/60, '5'
FROM	APP_iDAType AS I INNER JOIN APP_iDATypePropLookup AS L
	 ON I.type = L.appType AND I.updateRecoSec NOT IN ('Invalid Property', '300')


CREATE TABLE #JobRestart (JobType VARCHAR(256), AppType INT, PhaseRestartable INT, PhaseMaxRestarts INT, 
		PhaseRestartInterval INT, PhaseCleanupTimeout INT, PhasePreemptable INT, 
		EnableTotalRunningTime INT, TotalRunningTime INT, KillJobIfRunningTimeExpires INT)

INSERT INTO #JobRestart
SELECT	'Auxiliary Copy', O.appTypeType, P.restartable, P.maxRestarts, P.restartInterval, P.cleanupTimeout, P.preemptable, 
		P.enableTotalRunningTime, P.totalRunningTime, P.killJobIfRunningTimeExpires
FROM	JMOpTable O INNER JOIN JMPhase P ON O.id = P.opTableId
WHERE	O.appTypeType = 1000 AND O.operation = 13 AND P.name = 'Auxiliary Copy'
UNION ALL
SELECT	'CDR (Data Management)', O.appTypeType, P.restartable, P.maxRestarts, P.restartInterval, P.cleanupTimeout, P.preemptable, 
		P.enableTotalRunningTime, P.totalRunningTime, P.killJobIfRunningTimeExpires
FROM	JMOpTable O INNER JOIN JMPhase P ON O.id = P.opTableId
WHERE	O.appTypeType = 84 AND O.operation = 56 AND P.name = 'Replicating'
UNION ALL
SELECT	'CommCell Migration '+P.name, O.appTypeType, P.restartable, P.maxRestarts, P.restartInterval, P.cleanupTimeout, P.preemptable, 
		P.enableTotalRunningTime, P.totalRunningTime, P.killJobIfRunningTimeExpires
FROM	JMOpTable O INNER JOIN JMPhase P ON O.id = P.opTableId
WHERE	O.appTypeType = 1000 AND O.operation IN (71, 72) AND P.name IN ('Import', 'Export')
UNION ALL
SELECT	'Data Aging', O.appTypeType, P.restartable, P.maxRestarts, P.restartInterval, P.cleanupTimeout, P.preemptable, 
		P.enableTotalRunningTime, P.totalRunningTime, P.killJobIfRunningTimeExpires
FROM	JMOpTable O INNER JOIN JMPhase P ON O.id = P.opTableId
WHERE	O.appTypeType = 1000 AND O.operation = 10 AND P.name = 'Data Aging'
UNION ALL
SELECT	'DeDup DB Reconstruction', O.appTypeType, P.restartable, P.maxRestarts, P.restartInterval, P.cleanupTimeout, P.preemptable, 
		P.enableTotalRunningTime, P.totalRunningTime, P.killJobIfRunningTimeExpires
FROM	JMOpTable O INNER JOIN JMPhase P ON O.id = P.opTableId
WHERE	O.appTypeType = 1000 AND O.operation = 80 AND P.name = 'Restore'
UNION ALL
SELECT	'Disaster Recover Backup', O.appTypeType, P.restartable, P.maxRestarts, P.restartInterval, P.cleanupTimeout, P.preemptable, 
		P.enableTotalRunningTime, P.totalRunningTime, P.killJobIfRunningTimeExpires
FROM	JMOpTable O INNER JOIN JMPhase P ON O.id = P.opTableId
WHERE	O.appTypeType = 1000 AND O.operation = 11 AND P.name = 'Backup'
UNION ALL
SELECT	'Download/Copy Updates', O.appTypeType, P.restartable, P.maxRestarts, P.restartInterval, P.cleanupTimeout, P.preemptable, 
		P.enableTotalRunningTime, P.totalRunningTime, P.killJobIfRunningTimeExpires
FROM	JMOpTable O INNER JOIN JMPhase P ON O.id = P.opTableId
WHERE	O.appTypeType = 1000 AND O.operation = 36 AND P.name = 'Download'
UNION ALL
SELECT	'Install Software', O.appTypeType, P.restartable, P.maxRestarts, P.restartInterval, P.cleanupTimeout, P.preemptable, 
		P.enableTotalRunningTime, P.totalRunningTime, P.killJobIfRunningTimeExpires
FROM	JMOpTable O INNER JOIN JMPhase P ON O.id = P.opTableId
WHERE	O.appTypeType = 1000 AND O.operation = 67 AND P.name = 'Install Client'
UNION ALL
SELECT	'Media Refresh', O.appTypeType, P.restartable, P.maxRestarts, P.restartInterval, P.cleanupTimeout, P.preemptable, 
		P.enableTotalRunningTime, P.totalRunningTime, P.killJobIfRunningTimeExpires
FROM	JMOpTable O INNER JOIN JMPhase P ON O.id = P.opTableId
WHERE	O.appTypeType = 1000 AND O.operation = 74 AND P.name = 'Media Refreshing'
UNION ALL
SELECT	'Offline Content Indexing', O.appTypeType, P.restartable, P.maxRestarts, P.restartInterval, P.cleanupTimeout, P.preemptable, 
		P.enableTotalRunningTime, P.totalRunningTime, P.killJobIfRunningTimeExpires
FROM	JMOpTable O INNER JOIN JMPhase P ON O.id = P.opTableId
WHERE	O.appTypeType = 1000 AND O.operation = 53 AND P.name = 'Content Index'
UNION ALL
SELECT	'SRM (Data Collection)', O.appTypeType, P.restartable, P.maxRestarts, P.restartInterval, P.cleanupTimeout, P.preemptable, 
		P.enableTotalRunningTime, P.totalRunningTime, P.killJobIfRunningTimeExpires
FROM	JMOpTable O INNER JOIN JMPhase P ON O.id = P.opTableId
WHERE	O.appTypeType = 600 AND O.operation = 58 AND P.name = 'Data Collection'
UNION ALL
SELECT	'Uninstall Software', O.appTypeType, P.restartable, P.maxRestarts, P.restartInterval, P.cleanupTimeout, P.preemptable, 
		P.enableTotalRunningTime, P.totalRunningTime, P.killJobIfRunningTimeExpires
FROM	JMOpTable O INNER JOIN JMPhase P ON O.id = P.opTableId
WHERE	O.appTypeType = 1000 AND O.operation = 68 AND P.name = 'Uninstall Client'
UNION ALL
SELECT	'Workflow', O.appTypeType, P.restartable, P.maxRestarts, P.restartInterval, P.cleanupTimeout, P.preemptable, 
		P.enableTotalRunningTime, P.totalRunningTime, P.killJobIfRunningTimeExpires
FROM	JMOpTable O INNER JOIN JMPhase P ON O.id = P.opTableId
WHERE	O.appTypeType = 1000 AND O.operation = 69 AND P.name = 'ForeignDataWF'
UNION ALL
SELECT	CASE WHEN O.operation = 4 THEN 'DB2 (Data Protection)' ELSE 'DB2 (Data Recovery)' END, 
		O.appTypeType, P.restartable, P.maxRestarts, P.restartInterval, P.cleanupTimeout, P.preemptable, 
		P.enableTotalRunningTime, P.totalRunningTime, P.killJobIfRunningTimeExpires
FROM	JMOpTable O INNER JOIN JMPhase P ON O.id = P.opTableId
WHERE	O.appTypeType = 37 AND O.operation IN (4, 5) AND P.name IN ('Data Backup', 'Data Restore')
UNION ALL
SELECT	CASE WHEN O.operation = 4 THEN 'Documentum (Data Protection)' ELSE 'Documentum (Data Recovery)' END, 
		O.appTypeType, P.restartable, P.maxRestarts, P.restartInterval, P.cleanupTimeout, P.preemptable, 
		P.enableTotalRunningTime, P.totalRunningTime, P.killJobIfRunningTimeExpires
FROM	JMOpTable O INNER JOIN JMPhase P ON O.id = P.opTableId
WHERE	O.appTypeType = 128 AND O.operation IN (4, 5) AND P.name IN ('Database Backup', 'Database Restore 1')
UNION ALL
SELECT	CASE WHEN O.operation = 4 THEN 'Exchange DB (Data Protection)' ELSE 'Exchange DB (Data Recovery)' END, 
		O.appTypeType, P.restartable, P.maxRestarts, P.restartInterval, P.cleanupTimeout, P.preemptable, 
		P.enableTotalRunningTime, P.totalRunningTime, P.killJobIfRunningTimeExpires
FROM	JMOpTable O INNER JOIN JMPhase P ON O.id = P.opTableId
WHERE	O.appTypeType = 53 AND O.operation IN (4, 5) AND P.name IN ('Database Backup', 'Database Restore')
UNION ALL
SELECT	CASE WHEN O.operation = 4 THEN 'File System and Indexing Based (Data Protection)' ELSE 'File System and Indexing Based (Data Recovery)' END, 
		O.appTypeType, P.restartable, P.maxRestarts, P.restartInterval, P.cleanupTimeout, P.preemptable, 
		P.enableTotalRunningTime, P.totalRunningTime, P.killJobIfRunningTimeExpires
FROM	JMOpTable O INNER JOIN JMPhase P ON O.id = P.opTableId
WHERE	O.appTypeType = 33 AND O.operation IN (4, 5) AND P.name IN ('Backup', 'Restore')
UNION ALL
SELECT	CASE WHEN O.operation = 4 THEN 'Informix DB (Data Protection)' ELSE 'Informix DB (Data Recovery)' END, 
		O.appTypeType, P.restartable, P.maxRestarts, P.restartInterval, P.cleanupTimeout, P.preemptable, 
		P.enableTotalRunningTime, P.totalRunningTime, P.killJobIfRunningTimeExpires
FROM	JMOpTable O INNER JOIN JMPhase P ON O.id = P.opTableId
WHERE	O.appTypeType = 3 AND O.operation IN (4, 5) AND P.name IN ('Database Backup', 'Database Restore')
UNION ALL
SELECT	CASE WHEN O.operation = 4 THEN 'Lotus Notes DB (Data Protection)' ELSE 'Lotus Notes DB (Data Recovery)' END, 
		O.appTypeType, P.restartable, P.maxRestarts, P.restartInterval, P.cleanupTimeout, P.preemptable, 
		P.enableTotalRunningTime, P.totalRunningTime, P.killJobIfRunningTimeExpires
FROM	JMOpTable O INNER JOIN JMPhase P ON O.id = P.opTableId
WHERE	O.appTypeType = 59 AND O.operation IN (4, 5) AND P.name IN ('Backup', 'Restore')
UNION ALL
SELECT	CASE WHEN O.operation = 4 THEN 'MySQL (Data Protection)' ELSE 'MySQL (Data Recovery)' END, 
		O.appTypeType, P.restartable, P.maxRestarts, P.restartInterval, P.cleanupTimeout, P.preemptable, 
		P.enableTotalRunningTime, P.totalRunningTime, P.killJobIfRunningTimeExpires
FROM	JMOpTable O INNER JOIN JMPhase P ON O.id = P.opTableId
WHERE	O.appTypeType = 104 AND O.operation IN (4, 5) AND P.name IN ('Backup', 'Restore')
UNION ALL
SELECT	CASE WHEN O.operation = 4 THEN 'Oracle DB (Data Protection)' ELSE 'Oracle DB (Data Recovery)' END, 
		O.appTypeType, P.restartable, P.maxRestarts, P.restartInterval, P.cleanupTimeout, P.preemptable, 
		P.enableTotalRunningTime, P.totalRunningTime, P.killJobIfRunningTimeExpires
FROM	JMOpTable O INNER JOIN JMPhase P ON O.id = P.opTableId
WHERE	O.appTypeType = 22 AND O.operation IN (4, 5) AND P.name IN ('Database Backup', 'Restore')
UNION ALL
SELECT	CASE WHEN O.operation = 4 THEN 'Other (Data Protection)' ELSE 'Other (Data Recovery)' END, 
		O.appTypeType, P.restartable, P.maxRestarts, P.restartInterval, P.cleanupTimeout, P.preemptable, 
		P.enableTotalRunningTime, P.totalRunningTime, P.killJobIfRunningTimeExpires
FROM	JMOpTable O INNER JOIN JMPhase P ON O.id = P.opTableId
WHERE	O.appTypeType = 1 AND O.operation IN (4, 5) AND P.name IN ('Backup', 'Restore')
UNION ALL
SELECT	CASE WHEN O.operation = 4 THEN 'PostgreSQL (Data Protection)' ELSE 'PostgreSQL (Data Recovery)' END, 
		O.appTypeType, P.restartable, P.maxRestarts, P.restartInterval, P.cleanupTimeout, P.preemptable, 
		P.enableTotalRunningTime, P.totalRunningTime, P.killJobIfRunningTimeExpires
FROM	JMOpTable O INNER JOIN JMPhase P ON O.id = P.opTableId
WHERE	O.appTypeType = 125 AND O.operation IN (4, 5) AND P.name IN ('Backup', 'Restore')
UNION ALL
SELECT	CASE WHEN O.operation = 4 THEN 'SAP for Oracle (Data Protection)' ELSE 'SAP for Oracle (Data Recovery)' END, 
		O.appTypeType, P.restartable, P.maxRestarts, P.restartInterval, P.cleanupTimeout, P.preemptable, 
		P.enableTotalRunningTime, P.totalRunningTime, P.killJobIfRunningTimeExpires
FROM	JMOpTable O INNER JOIN JMPhase P ON O.id = P.opTableId
WHERE	O.appTypeType = 61 AND O.operation IN (4, 5) AND P.name IN ('Database Backup', 'Restore')
UNION ALL
SELECT	CASE WHEN O.operation = 4 THEN 'SQL DB (Data Protection)' ELSE 'SQL DB (Data Recovery)' END, 
		O.appTypeType, P.restartable, P.maxRestarts, P.restartInterval, P.cleanupTimeout, P.preemptable, 
		P.enableTotalRunningTime, P.totalRunningTime, P.killJobIfRunningTimeExpires
FROM	JMOpTable O INNER JOIN JMPhase P ON O.id = P.opTableId
WHERE	O.appTypeType = 81 AND O.operation IN (4, 5) AND P.name IN ('Database Backup', 'Database Restore')
UNION ALL
SELECT	CASE WHEN O.operation = 4 THEN 'Sybase DB (Data Protection)' ELSE 'Sybase DB (Data Recovery)' END, 
		O.appTypeType, P.restartable, P.maxRestarts, P.restartInterval, P.cleanupTimeout, P.preemptable, 
		P.enableTotalRunningTime, P.totalRunningTime, P.killJobIfRunningTimeExpires
FROM	JMOpTable O INNER JOIN JMPhase P ON O.id = P.opTableId
WHERE	O.appTypeType = 5 AND O.operation IN (4, 5) AND P.name IN ('Database Backup', 'Database Restore')


INSERT INTO #Param
SELECT  2, 'Job Restart - Restartable', JobType, CAST(PhaseRestartable AS VARCHAR(256)), '1'
FROM	#JobRestart
WHERE	PhaseRestartable <> 1

INSERT INTO #Param
SELECT  2, 'Job Restart - Max Restarts', JobType, CAST(PhaseMaxRestarts AS VARCHAR(256)), '144'
FROM	#JobRestart
WHERE	AppType IN (100) AND PhaseMaxRestarts <> 5 OR AppType NOT IN (1000) AND PhaseMaxRestarts <> 144 

INSERT INTO #Param
SELECT  2, 'Job Restart - Restart Interval (Mins)', JobType, CAST(PhaseRestartInterval/60 AS VARCHAR(256)), '20'
FROM	#JobRestart
WHERE	PhaseRestartInterval/60 <> 20

INSERT INTO #Param
SELECT  2, 'Job Restart - Preemptable', JobType, CAST(PhasePreemptable AS VARCHAR(256)), '1'
FROM	#JobRestart
WHERE	PhasePreemptable <> 1

INSERT INTO #Param
SELECT  2, 'Job Restart - Enable Total Running Time', JobType, CAST(EnableTotalRunningTime AS VARCHAR(256)), '0'
FROM	#JobRestart
WHERE	EnableTotalRunningTime <> 0

INSERT INTO #Param
SELECT  2, 'Job Restart - Total Running Time', JobType, CAST(TotalRunningTime/3600 AS VARCHAR(20)) + ' hr(s) ' + CAST((TotalRunningTime%3600)/60 AS VARCHAR(20)) + ' min(s)', '6 hr(s) 0 min(s)'
FROM	#JobRestart
WHERE	EnableTotalRunningTime <> 0 AND TotalRunningTime <> 21600

INSERT INTO #Param
SELECT  2, 'Job Restart - Kill Job if Running Time Expires', JobType, CAST(KillJobIfRunningTimeExpires AS VARCHAR(256)), '0'
FROM	#JobRestart
WHERE	KillJobIfRunningTimeExpires <> 0

DROP TABLE #JobRestart


CREATE	TABLE #ErrorDecision (AppTypeGroupId INT, DecisionRuleEnabled INT, Decision INT, 
		Pattern NVARCHAR(MAX), AllErrorCodes INT, ErrorCodeFrom INT, ErrorCodeTo INT, Priority INT)

CREATE	TABLE #ErrorThreshold (AppTypeGroupId INT, ThresholdEnabled INT, Decision INT, 
		ApplyRuleOn INT, CountEnabled INT, ErrorCount INT, PctEnabled INT, Percentage INT)

INSERT INTO #ErrorDecision
SELECT	AppTypeId,
		Rulelist.r.value('@isEnabled', 'INT'),
		Rulelist.r.value('@jobDecision', 'INT'),
		Rulelist.r.value('@pattern', 'NVARCHAR(MAX)'),
		Rulelist.r.value('(errorCode)[1]/@allErrorCodes', 'INT'),	
		Rulelist.r.value('(errorCode)[1]/@fromValue', 'INT'),	
		Rulelist.r.value('(errorCode)[1]/@toValue', 'INT'),
		ROW_NUMBER() OVER (PARTITION BY AppTypeId ORDER BY (SELECT NULL))
FROM	APP_JobErrorDecisionRule
		CROSS APPLY decisionRule.nodes('/App_JobErrorDecisionRuleList/ruleList') AS Rulelist(r)
WHERE	isEnabled = 1 AND EntityId = 2 AND EntityType = 1 AND AppEntityType = 78 AND AppTypeId IN (34, 57)

INSERT INTO #ErrorThreshold
SELECT	AppTypeId,
		ThresholdList.t.value('@isEnabled', 'INT'),
		ThresholdList.t.value('@jobDecision', 'INT'),
		ThresholdList.t.value('@applyRuleOn', 'INT'),
		ThresholdList.t.value('@isCountEnabled', 'INT'),
		ThresholdList.t.value('@count', 'INT'),
		ThresholdList.t.value('@isPercentageEnabled', 'INT'),
		ThresholdList.t.value('@percentage', 'INT')
FROM	APP_JobErrorDecisionRule
		CROSS APPLY decisionRule.nodes('/App_JobErrorDecisionRuleList/thresholdList') AS ThresholdList(t)
WHERE	isEnabled = 1 AND EntityId = 2 AND EntityType = 1 AND AppEntityType = 78 AND AppTypeId IN (34, 57)

INSERT INTO #Param
SELECT  2, 'Job Status on Errors - ' + CASE AppTypeId WHEN 34 THEN 'Unix File System' WHEN 57 THEN 'Windows File System' ELSE '' END, 
		'Enabled', CASE isEnabled WHEN 1 THEN 'Yes' ELSE 'No' END, 'Yes'
FROM	APP_JobErrorDecisionRule
WHERE	EntityId = 2 AND EntityType = 1 AND AppEntityType = 78 AND AppTypeId IN (34, 57)

INSERT INTO #Param
SELECT  2, 'Job Status on Errors - ' + CASE AppTypeGroupId WHEN 34 THEN 'Unix File System' WHEN 57 THEN 'Windows File System' ELSE '' END, 
		'Error Decision - ' + CAST(Priority AS VARCHAR(8)), 
		'Priority = ' + CAST(Priority AS VARCHAR(8)) + ', File Pattern = ' + Pattern 
			+ ', System Error Code = ' + CASE WHEN AllErrorCodes = 1 THEN 'All' 
				ELSE CAST(ErrorCodeFrom AS VARCHAR(20)) + ' - ' + CAST(ErrorCodeTo AS VARCHAR(20)) END
			+ ', On Error Mark Job as = ' + CASE Decision WHEN 0 THEN 'Complete' WHEN 1 THEN 'Complete with Errors' ELSE 'Failed' END
			+ ', Enable = ' + CASE DecisionRuleEnabled WHEN 1 THEN 'Yes' ELSE 'No' END, 
		''
FROM	#ErrorDecision

;WITH ErrorThreshold (Property, Name, Value) AS
(
	SELECT  'Job Status on Errors - ' 
				+ CASE AppTypeGroupId WHEN 34 THEN 'Unix File System' WHEN 57 THEN 'Windows File System' ELSE '' END AS Property, 
			'Error Threshold' AS Name, 
			'Count = ' + CASE CountEnabled WHEN 1 THEN CAST(ErrorCount AS VARCHAR(8)) ELSE 'N/A' END
				+ ', Percentage = ' + CASE PctEnabled WHEN 1 THEN CAST(Percentage AS VARCHAR(8)) ELSE 'N/A' END
				+ ', On Error Mark Job as = ' + CASE Decision WHEN 0 THEN 'Complete' WHEN 1 THEN 'Complete with Errors' ELSE 'Failed' END
				+ ', Rule for = ' + CASE ApplyRuleOn WHEN 1 THEN 'All' ELSE 'Any' END
				+ ', Enable = ' + CASE ThresholdEnabled WHEN 1 THEN 'Yes' ELSE 'No' END AS Value
	FROM	#ErrorThreshold
)
INSERT INTO #Param
SELECT	2, P.Property, P.Name, 
		STUFF(
			(SELECT '; ' + Value FROM ErrorThreshold WHERE Property = P.Property AND Name = P.Name ORDER BY Value FOR XML PATH('')
			), 1, 2, '' ), 
		''
FROM	(SELECT DISTINCT Property, Name FROM ErrorThreshold) P

DROP TABLE #ErrorDecision
DROP TABLE #ErrorThreshold


-- Category 3 for Media Manager

CREATE TABLE #MMParams (Category VARCHAR(64), Parameter VARCHAR(256), Name VARCHAR(256), DefaultValue VARCHAR (32))

INSERT	INTO #MMParams (Category, Parameter, Name, DefaultValue) 
VALUES 
('Service Configuration', 'MMCONFIG_ALLOW_DP_CONFIG_WHEN_JOBS_RUNNING', 'Allow changes to datapath configuration even if jobs are running','0'),
('Service Configuration', 'MMCONFIG_MEDIA_EXPORT_REQUEST_UNBLOCK', 'Allow export request through commandline to succeed without waiting for media being removed from library.','0'),
('Service Configuration', 'MMS2_CONFIG_SRM_ARRAY_DATA_COLLECTION_INTERVAL', 'Array Management Data Collection Interval in hours','24'),
('Service Configuration', 'MMS2_CONFIG_AUTOMATIC_DRIVE_CLEANING_MINUTES', 'Automatic Drive Cleaning check interval in Minutes','20'),
('Service Configuration', 'MM_CONFIG_CREATE_DR_SP_FOR_NEW_LIBRARY', 'Create disaster recovery storage policy or copy when new library is configure','1'),
('Service Configuration', 'MMCONFIG_STORE_LIMIT_EVENT_DAYS_TO_CONSIDER', 'Days to consider for threshold event.','3'),
('Service Configuration', 'MMS2_CONFIG_DEDUP_PRUNE_BATCH_SIZE', 'Deduplication pruning batch size.','1000'),
('Service Configuration', 'MMS2_CONFIG_LOW_WATERMARK_THRESHOLD', 'Default low-water mark for newly-created Scratch Pools','20'),
('Service Configuration', 'MMCONFIGS_DEL_INCR_DIFF_NOT_FORCE_FULL_ON_NEXT_BACKUP', 'Deletion of jobs will not force full on next backup.','0'),
('Service Configuration', 'MMS2_CONFIG_DATAPATH_NOT_SHARING_INDEX_CACHE', 'Do not check for shared index cache when adding datapaths to storage policy copy','1'),
('Service Configuration', 'MMCONFIG_DO_NOT_MARK_MEDIA_FULL_ON_CRC_ERR', 'Do not mark media full when encountering CRC error.','0'),
('Service Configuration', 'MMS2_CONFIG_STRING_MM_EXPORT_RETRY_COUNT', 'Export Operation Retry Count','10'),
('Service Configuration', 'CCM_CONFIG_FAIL_MIGRATION_FOR_UNSUPPORTED_APPLICATIONS', 'Fail Commcell Migration for Unsupported applications','1'),
('Service Configuration', 'CCM_CONFIG_FAIL_MIGRATION_FOR_MISSING_APPIDS', 'Fail Commcell Migration if Subclient to export is deleted before export completes','1'),
('Service Configuration', 'MMS2_CONFIG_IGNORE_THRESHOLDS_FOR_VTL', 'Ignore media and drive use count thresholds for Virtual Tape Libraries.','1'),
('Service Configuration', 'MMCONFIG_IMPORT_ONLY_NONEXPORTED_MEDIA', 'Import only media that were not moved to IE Port as part of export operation','0'),
('Service Configuration', 'CCM_USE_DESTINATION_SCHEDULE_POLICY_WITH_SAME_NAME_IN_SOURCE', 'In CCM use destination schedule policy with same name in source','0'),
('Service Configuration', 'MMS2_CONFIG_STRING_MAGNETIC_MARKFULL_INTERVAL_HOURS', 'Interval (hours) between marking large disk volumes full.','8'),
('Service Configuration', 'MMCONFIG_ARCHGROUP_CLEANUP_INTERVAL_MINUTES', 'Interval (in minutes) to clean up deleted storage policies or copies.','30'),
('Service Configuration', 'MMS2_CONFIG_STRING_MAGNETIC_CONFIG_UPDATE_INTERVAL_MIN', 'Interval (Minutes) between disk space updates.','30'),
('Service Configuration', 'MMS2_CONFIG_MAGNETIC_VOLUME_SIZE_UPDATE_INTERVAL_MINUTES', 'Interval between volume size update requests.','120'),
('Service Configuration', 'MMS2_CONFIG_LANMA_KEEP_ALIVE_INTERVAL_MINUTES', 'LAN MediaAgent liveliness check interval in Minutes','30'),
('Service Configuration', 'MMS2_CONFIG_LANFREEMA_KEEP_ALIVE_INTERVAL_MINUTES', 'LAN-Free MediaAgent liveliness check interval in Minutes','1440'),
('Service Configuration', 'MMS2_CONFIG_LIBRARY_FAILOVER_INTERVAL_MINUTES', 'Library Arm Controller failover interval in Minutes','10'),
('Service Configuration', 'CCM_CONFIG_MAXIMUM_NUMBER_OF_ATTEMPTS_TO_PRODUCE_DUMPS_WITH_NO_CONSUMPTION', 'Maximum number of attempts to continue GRC export with no consumption','5'),
('Service Configuration', 'CCM_CONFIG_MAXIMUM_NUMBER_OF_DAYS_TO_PRODUCE_DUMPS_WITH_NO_CONSUMPTION', 'Maximum number of days to continue GRC export with no consumption','30'),
('Service Configuration', 'CCM_CONFIG_MAXIMUM_NUMBER_DUMP_SETS', 'Maximum number of Exported (CCM) Dump sets to be retained in any dump location.','10'),
('Service Configuration', 'MMS2_CONFIG_VOLSNAP_RETRY_COUNT', 'Maximum number to retries on snap operation.','50'),
('Service Configuration', 'MMS2_CONFIG_MANAGED_DISK_SPACE_MAX_PRUNE_SIZE', 'Maximum size per batch to process managed disk space','50000'),
('Service Configuration', 'MMS2_CONFIG_MM_MAINTAINENCE_INTERVAL_MINUTES', 'Media Management Maintenance Check Interval in Minutes','15'),
('Service Configuration', 'MMS2_CONFIG_FAD_MNTPATH_FRAG_THRESHOLD', 'Mount Path Fragmentation Threshold percentage','100'),
('Service Configuration', 'MMCONFIG_DAYS_BEFORE_MAG_LIBRARY_IS_OUT_OF_SPACE', 'Number of days in advance to trigger alert for low disk space for disk library.','0'),
('Service Configuration', 'MMS2_CONFIG_STRING_MAX_MAGNETIC_FOLDERS', 'Number of disk folders to process in a single Data Aging request.','1000'),
('Service Configuration', 'CCM_CONFIG_MAXIMUM_NUMBER_SUBCLIENTS_IN_A_DUMP', 'Number of Subclients to be stored in a single dump file (exported by CCM).','50'),
('Service Configuration', 'MMS2_CONFIG_MAGNETIC_VOLUME_SIZE_UPDATE_COUNT', 'Number of volumes for size update.','1000'),
('Service Configuration', 'MMS2_CONFIG_FAD_FILE_FRAG_THRESHOLD', 'Per-file fragmentation threshold','10'),
('Service Configuration', 'MMCONFIG_STORE_LIMIT_EVENT_PERCENT', 'Percentage for Deduplication reaching limits event.','80'),
('Service Configuration', 'MMCONFIG_STORE_LIMIT_FOR_SUBCLIENT_EVENT_PERCENT', 'Percentage for Store reaching Limit for New Subclient event.','50'),
('Service Configuration', 'MMCONFIG_SNAP_SMART_CLONE_OP', 'Perform Smart Clone operation by snap engines(for V9 and V10 Clients only)','0'),
('Service Configuration', 'MMS2_CONFIG_CHECK_USER_MA_RIGHT', 'Provide user with MediaAgent management rights additional capabilities for libraries, data paths, and storage policies.','1'),
('Service Configuration', 'MMS2_CONFIG_DO_NOT_DELETE_SCRATCH_MEDIA_DURING_LIBRARY_DECONFIG', 'Retain scratch media information when deconfiguring library','0'),
('Service Configuration', 'MMCONFIG_SHOW_HIDDEN_STORAGE_POLICIES', 'Show hidden storage policies.','0'),
('Service Configuration', 'MMS2_CONFIG_SIDB_RECONSTRUCT_REPLAY_BATCH_COUNT', 'SIDB Reconstruction prune replay batch count','1000'),
('Service Configuration', 'MMS2_CONFIG_SIDB_RECONSTRUCT_REPLAY_RETRY_COUNT', 'SIDB Reconstruction prune replay retry count','100000'),
('Service Configuration', 'MMS2_CONFIG_VOLSNAP_PRUNE_INTERVAL_MINUTES', 'Snap Prune Interval in Minutes','1'),
('Data Aging', 'DA_CONFIG_ALLOW_JOB_RETENTION_CHANGE_ON_WORM_COPY', 'Allow administrators to lower job retention on WORM copies','0'),
('Data Aging', 'DA_CONFIG_CONSIDER_INACTIVE_COPY_FOR_AUX_COPY_CHECK', 'Consider inactive copy for Auxiliary Copy check by Data Aging','1'),
('Data Aging', 'DA_CONFIG_DAYS_TO_KEEP_ARCHIVER_RESTORE_HISTORIES', 'Days to keep the archiver restore job histories','0'),
('Data Aging', 'DA_CONFIG_DAYS_TO_KEEP_BACKUP_JOB_HISTORIES', 'Days to keep the failed/killed backup job and other job histories','90'),
('Data Aging', 'DA_CONFIG_DAYS_TO_KEEP_BACKUP_MANAGEMENT_JOB_HISTORIES', 'Days to keep Data Management and Collection Job Histories','90'),
('Data Aging', 'DA_CONFIG_DAYS_TO_KEEP_CN_JOBDATACOSTHISTORY', 'Days to keep Job data cost history','90'),
('Data Aging', 'DA_CONFIG_DAYS_TO_KEEP_INVALID_CHUNKS', 'Days to keep invalid chunks','3'),
('Data Aging', 'DA_CONFIG_DAYS_TO_KEEP_JOB_OPTIONS_IN_JMTABLES', 'Days to keep job options for a completed job.','30'),
('Data Aging', 'DA_CONFIG_DAYS_TO_KEEP_LIBRARY_HISTORY', 'Days to keep Library Histories','30'),
('Data Aging', 'DA_CONFIG_DAYS_TO_KEEP_REPLICATION_BACKUP_JOB_HISTORIES', 'Days to keep Replication Backup Job Histories','90'),
('Data Aging', 'DA_CONFIG_DAYS_TO_KEEP_SUCCESSFUL_BACKUP_JOB_HISTORIES', 'Days to keep the successful backup job histories','7'),
('Data Aging', 'DA_CONFIG_DELETE_DECONFIGURED_CLIENTS_WITH_NO_DATA', 'Delete deconfigured clients that have no protected data','0'),
('Data Aging', 'DA_CONFIG_DELETEDAF_EVENT_DAYS_TO_CONSIDER', 'Days to consider for pending logical pruning for Deduplication pruning threshold event.','7'),
('Data Aging', 'DA_CONFIG_ENABLE_SRM_PRUNING', 'Enable/Disable SRM Pruning.','1'),
('Data Aging', 'DA_CONFIG_HONOR_STORAGE_POLICY_RETENTION_FOR_CONTENT_STORE_DATA', 'Honor Storage Policy Retention for Content Store Data','0'),
('Data Aging', 'DA_CONFIG_IGNORE_COMPLIANCE_POLICY_RULE', 'Ignore Compliance Policy Check For Job Data Aging.','0'),
('Data Aging', 'DA_CONFIG_IGNORE_CWE_OPTION_FOR_EXT_RET', 'Ignore Completed With Errors job option for Extended Retention calculations','0'),
('Data Aging', 'DA_CONFIG_IGNORE_CYCLES_ON_DECONFIGURED_CLIENTS', 'Ignore Cycles Retention On De-Configured Clients','0'),
('Data Aging', 'DA_CONFIG_MAX_DELETEDAF_COUNT_FOR_SIDB', 'Max number of records pending logical pruning for Deduplication pruning threshold event.','10000'),
('Data Aging', 'DA_CONFIG_MEDIAEXTRETCALC_MAXENTRIES', 'Maximum job entries to use for calculation of media retention expire time','5000'),
('Data Aging', 'DA_CONFIG_PRUNE_ALL_DB_AGENT_LOGS_BY_DAYS_ONLY_RETENTION', 'Prune All Database Agent Logs Only By Days Retention Rule','0'),
('Data Aging', 'DA_CONFIG_RETAIN_DDB_BACKUPS_OF_SEALED_STORES', 'Retain DDB Backups of sealed stores','0'),
('Data Aging', 'DA_CONFIG_RETENTION_DAYS_WHEN_CYCLES_IGNORED', 'Days to retain the jobs when cycles are ignored and retention days on copy is 0','30'),
('Data Aging', 'DA_GRC_CONFIG_NUMBER_OF_DAYS_OF_DATA_TO_KEEP_IN_GRCJMJOBDATASTATSTRACKING', 'Days to keep job status change history for GRC','90'),
('Data Aging', 'DA_GRC_CONFIG_NUMBER_OF_DAYS_TO_KEEP_JOB_LIST_IN_DAFOREIGNJOBSTOBEMARKEDAGED', 'Days to keep the list of migrated foreign jobs to be pruned after processing them','7'),
('Data Aging', 'MMCONFIG_CONTENT_INDEXING_PRUN_DAYS', 'Days to keep Content Indexing Pruning Information.','90'),
('Auxiliary Copy Configuration', 'MMCONFIG_AUXCOPY_ALIVE_CHECK_TIMEOUT_MINUTES', 'Time-out (in minutes) for aliveness check.','5'),
('Auxiliary Copy Configuration', 'MMCONFIG_AUXCOPY_CLDEDUP_CACHE_BUFFER_SIZE_KB', 'Source signature cache buffer size (in KB)','4096'),
('Auxiliary Copy Configuration', 'MMCONFIG_AUXCOPY_CLDEDUP_CACHE_DB_SIZE_MB', 'Source signature cache DB size (in MB)','4096'),
('Auxiliary Copy Configuration', 'MMCONFIG_AUXCOPY_COPY_FIRST_FULL_FOR_NEW_SUBCLIENT', 'Copy first full jobs for new subclients on secondary copy with deduplication enabled before copying other data','1'),
('Auxiliary Copy Configuration', 'MMCONFIG_AUXCOPY_FALLEN_BEHIND_ALERT_NUMBER_OF_JOBS_FOR_THROUGHPUT', 'Numbers of jobs for throughput calculation for auxiliary copy fallen behind alert (hours required to copy)','5'),
('Auxiliary Copy Configuration', 'MMCONFIG_AUXCOPY_RETRY_STREAM_INTERVAL_MINUTES', 'Interval (in minutes) to retry a failed stream','15'),
('Auxiliary Copy Configuration', 'MMCONFIG_AUXCOPY_SKIP_UNAVAILABLE_MEDIA', 'Skip unavailable media','0'),
('Auxiliary Copy Configuration', 'MMCONFIG_MAX_BACKUP_JOBS_IN_WAITING_STATE_TO_SKIP_AUXCOPY_RESERVATION', 'Skip AuxCopy Reservation request when backup jobs in waiting state exceeds','0'),
('Auxiliary Copy Configuration', 'MMCONFIG_MAX_BACKUP_JOBS_IN_WAITING_STATE_TO_SKIP_AUXCOPY_RESERVATION_CHECK_INTERVAL_IN_MIN', 'Skip AuxCopy Reservation request when backup jobs in waiting state exceeds check interval in mins','5'),
('Auxiliary Copy Configuration', 'MMCONFIG_MAX_INTERVAL_FOR_ARCH_COPY_DATA_SUMMARY_INTERVAL_HOURS', 'Storage Policy Copy Summary Populate Interval','24'),
('Auxiliary Copy Configuration', 'MMCONFIG_SELECTIVE_COPY_MODIFY_PERIOD', 'Allow user to modify selective copy job selection period start time','0'),
('Auxiliary Copy Configuration', 'MMCONFIG_THREAD_COUNT_DURING_VALIDATE_DDB', 'Maximum number of threads to be used during Validate Dedupe Data phase of Data Verification Job.','5'),
('Auxiliary Copy Configuration', 'MMS2_CONFIG_AUXCOPY_BY_ARCHIVE_FILE_ORDER', 'Allow multiplexed data to be copied to deduplication enabled storage policy copy','0'),
('Auxiliary Copy Configuration', 'MMS2_CONFIG_AUXCOPY_PREEMPT_JOB_ON_NO_RESOURCES_INTERVAL', 'Time (in minutes) after which job will be preempted on continuous resource reservation failures','30'),
('Auxiliary Copy Configuration', 'MMS2_CONFIG_AUXCOPY_STREAM_RETRY_COUNT', 'Maximum number of stream retry count','2'),
('Auxiliary Copy Configuration', 'MMS2_CONFIG_AUXCOPY_UPDATE_PROGRESS_TO_JM_INTERVAL_IN_MINS', 'DDB Recover job progress update to job manager interval (mins)','5'),
('Auxiliary Copy Configuration', 'MMS2_CONFIG_SELECT_DDB_BACKUP_JOB_FOR_AUXCOPY', 'Allow AuxCopy for deduplication database backup jobs','0'),
('Auxiliary Copy Configuration', 'MMS2_CONFIG_STRING_AUXCOPY_FALLEN_BEHIND_ALERTS_INTERVAL_HOURS', 'Interval (Hours) between Auxiliary Copy Fallen Behind alerts.','24'),
('Auxiliary Copy Configuration', 'MMS2_CONFIG_STRING_CONTENT_INDEX_FALLEN_BEHIND_ALERTS_INTERVAL_HOURS', 'Interval (Hours) between Content Index Fallen Behind alerts.','24'),
('Auxiliary Copy Configuration', 'MMS2_CONFIG_STRING_MARK_JOBS_BAD', 'Mark a job bad on encountering corrupt data during auxiliary copy/data verification operation','0'),
('Auxiliary Copy Configuration', 'MMS2_CONFIG_STRING_SKIP_CHUNKS', 'Skip job on read errors during Auxiliary Copy','1'),
('SILO Archive Configuration', 'MMCONFIGS_APPROX_DEDUP_MAG_VOLUME_SIZE_MB_WITH_CLOUD_SILO', 'Approximate Dedup disk volume size in MB for SILO enabled copy.','512'),
('SILO Archive Configuration', 'MMCONFIGS_BACKUP_SILO_AFTER_VOLUME_FULL_HOURS', 'Hours after being marked as Full for archiving SILO volumes to tape','8'),
('SILO Archive Configuration', 'MMS2_CONFIG_SILO_DISKCLEANUP_INTERVAL', 'Interval (in minutes) to free the SILO cache.','1440'),
('Vault Tracker Configuration', 'MMS2_CONFIG_STRING_SHOW_VAULTTRACKER_HISTORY_HOURS', 'Time in hours to show the VaultTracker history in the actions pane.','0'),
('Vault Tracker Configuration', 'MMS2_CONFIG_STRING_VAULTTRACKER_ALERTS_INTERVAL_MIN', 'Interval (Minutes) between VaultTracker alerts.','15'),
('Vault Tracker Configuration', 'MMS2_CONFIG_STRING_VAULTTRACKER_HISTORY_PRUNE_DAYS', 'Days to keep VaultTracker records.','90'),
('Vault Tracker Configuration', 'MMS2_CONFIG_STRING_VAULTTRACKER_RETRY_INTERVAL_MIN', 'VaultTracker export retry interval in minutes.','10'),
('Vault Tracker Configuration', 'MMS2_CONFIG_STRING_VT_CONTAINER_CLEANUP_INTERVAL_DAYS', 'Container cleanup interval days','90'),
('Vault Tracker Configuration', 'MMS2_CONFIG_VT_ACTION_HISTORY_RETENTION_DAYS', 'VaultTracker: Action history retention days','90'),
('Vault Tracker Configuration', 'MMS2_CONFIG_VT_CLEANUP_DANGLING_EXPORTS_INTERVAL_HOURS', 'Hours to keep VaultTracker actions alive','72'),
('Vault Tracker Configuration', 'MMS2_CONFIG_VT_DUEBACK_SELECT_ORIG_LIB', 'VaultTracker due back policy: Treat Library selection as original library and value.','0'),
('Vault Tracker Configuration', 'MMS2_CONFIG_VT_REACH_DEST_MEDIA_IN_LIB', 'VaultTracker: Allow media to reach export location even though media are in library','0'),
('Vault Tracker Configuration', 'VT_CONFIG_CHECK_LIBRARY_EMPTY_SLOTS', 'Vault Tracker Policy option to import tapes based on number of empty slots in library.','0'),
('Resource Manager Configuration', 'Allow Content Indexing jobs to do load-balance among Lan and Lan-Free Media Agents for processing and pushing data', 'Allow Content Indexing jobs to do load-balance among Lan and Lan-Free Media Agents for processing and pushing data','1'),
('Resource Manager Configuration', 'MMCONFIG_RESOURCEMANAGER_ALLOW_BACKUP_DURING_DDB_RECONSTRUCTION', 'Allow backup jobs to run to deduplication storage policy copy when DDB being reconstructed','0'),
('Resource Manager Configuration', 'MMCONFIG_RESOURCEMANAGER_ALLOW_LOADBALANCE_ON_MULTIPLE_DATAPATHS', 'Allow load-balance on multiple data paths within one backup job','0'),
('Resource Manager Configuration', 'MMCONFIG_RESOURCEMANAGER_ALLOW_RESTORE_USE_DIFF_MA_AND_DRIVEPOOL', 'Allow restore jobs to use alternative MediaAgent and Drive Pool to access required media','0'),
('Resource Manager Configuration', 'MMCONFIG_RESOURCEMANAGER_BACKUP_CACHING_TIMEOUT_MINTUES', 'Timeout Interval (in minutes) for cached resources when using reservation backup caching feature','5'),
('Resource Manager Configuration', 'MMCONFIG_RESOURCEMANAGER_CONTENTINDEX_ENGINE_RESERVED_FREESPACE_IN_MB', 'Reserved free disk space (in MB) for Search Engine','1000'),
('Resource Manager Configuration', 'MMCONFIG_RESOURCEMANAGER_CONTENTINDEX_PREFER_LANFREE_ENGINE', 'Prefer using LAN-Free Search Engine for Offline Content Indexing job','0'),
('Resource Manager Configuration', 'MMCONFIG_RESOURCEMANAGER_CONTENTINDEX_PREFER_LOADBALANCE', 'Load-Balance among available Search Engines for Offline Content Indexing job','1'),
('Resource Manager Configuration', 'MMCONFIG_RESOURCEMANAGER_MAXIMUM_ALLOWED_CONNECTION_PER_DDB', 'Maximum number of parallel data transfer operations for deduplication database','50'),
('Resource Manager Configuration', 'MMCONFIG_RESOURCEMANAGER_RETURN_FULL_DETAIL_OF_JOB_FAILURE', 'Return full detail job pending reasons for reservation failure','0'),
('Resource Manager Configuration', 'MMCONFIG_RESOURCEMANAGER_USE_SAME_MA_FOR_INDEX_AND_BACKUP_IN_NASBACKUP', 'Force to use the same MediaAgent for create index and backup phases during NAS backup reservation','1'),
('Resource Manager Configuration', 'MMS2_CONFIG_ALLOW_MEDIA_CONTAIN_DIFF_SIDB_STORE_IN_SILO', 'Allow Media used by SILO Archive job to contain data from different SIDB Stores.','0'),
('Resource Manager Configuration', 'MMS2_CONFIG_MAGNETIC_VOLUME_SIZE_WATERMARK_GB', 'Disk volume physical size high watermark in GB','25'),
('Resource Manager Configuration', 'MMS2_CONFIG_RESOURCEMANAGER_MAXIMUM_ALLOWED_DRIVES_PER_NASFILER', 'Maximum allowed number of drive reservations per NAS Filer','0'),
('Resource Manager Configuration', 'MMS2_CONFIG_STREAM_DATA_CALCULATION_INTERVAL', 'Interval (in minutes) to calculate valid data size for streams.','60'),
('Resource Manager Configuration', 'MMS2_CONFIG_STREAM_DATA_DISTRIBUTION_THRESHOLD', 'Data Threshold (in GB) to decide how to distribute data among streams for backup.','500'),
('Resource Manager Configuration', 'Skip calculation for number of tape media in the library during reservation', 'Skip calculation for number of tape media in the library during reservation','1'),
('Deduplication', 'MMS2_CONFIG_ENABLE_INFINI_STORE', 'Enable horizontal scaling of DDBs', '0')

IF	@ReleaseId < 15
BEGIN
	IF NOT EXISTS (SELECT * FROM MMConfigs WHERE name = 'MMCONFIG_SNAP_SMART_CLONE_OP')
		UPDATE  #MMParams SET Parameter = 'Perform Smart Clone operation by snap engines(for V9 and V10 Clients only)'
		WHERE	Parameter = 'MMCONFIG_SNAP_SMART_CLONE_OP'

	IF NOT EXISTS (SELECT * FROM MMConfigs WHERE name = 'MMCONFIG_RESOURCEMANAGER_USE_SAME_MA_FOR_INDEX_AND_BACKUP_IN_NASBACKUP')
		UPDATE  #MMParams SET Parameter = 'Force to use the same Media Agent for create index and backup phases during NAS backup reservation'
		WHERE	Parameter = 'MMCONFIG_RESOURCEMANAGER_USE_SAME_MA_FOR_INDEX_AND_BACKUP_IN_NASBACKUP'

	IF NOT EXISTS (SELECT * FROM MMConfigs WHERE name = 'MMS2_CONFIG_SIDB_RECONSTRUCT_REPLAY_BATCH_COUNT')
		UPDATE  #MMParams SET Parameter = 'SIDB Reconstruction prune replay batch count'
		WHERE	Parameter = 'MMS2_CONFIG_SIDB_RECONSTRUCT_REPLAY_BATCH_COUNT'

	IF NOT EXISTS (SELECT * FROM MMConfigs WHERE name = 'MMCONFIG_RESOURCEMANAGER_RETURN_FULL_DETAIL_OF_JOB_FAILURE')
		UPDATE  #MMParams SET Parameter = 'Return full detail job pending reasons for reservation failure'
		WHERE	Parameter = 'MMCONFIG_RESOURCEMANAGER_RETURN_FULL_DETAIL_OF_JOB_FAILURE'

	IF NOT EXISTS (SELECT * FROM MMConfigs WHERE name = 'MMCONFIG_RESOURCEMANAGER_ALLOW_BACKUP_DURING_DDB_RECONSTRUCTION')
		UPDATE  #MMParams SET Parameter = 'Allow jobs to run to dedup copy when DDB being reconstructed'
		WHERE	Parameter = 'MMCONFIG_RESOURCEMANAGER_ALLOW_BACKUP_DURING_DDB_RECONSTRUCTION'

	IF NOT EXISTS (SELECT * FROM MMConfigs WHERE name = 'MMCONFIG_RESOURCEMANAGER_ALLOW_RESTORE_USE_DIFF_MA_AND_DRIVEPOOL')
		UPDATE  #MMParams SET Parameter = 'Allow restore jobs to use alternative Media Agent and Drive Pool to access required media'
		WHERE	Parameter = 'MMCONFIG_RESOURCEMANAGER_ALLOW_RESTORE_USE_DIFF_MA_AND_DRIVEPOOL'
END

INSERT	INTO #Param
SELECT	3, P.Category, P.name, C.value, P.DefaultValue
FROM	MMConfigs C INNER JOIN #MMParams P ON C.name = P.Parameter
WHERE	C.bExposeInGUI = 1 AND C.value <> P.DefaultValue
ORDER BY P.name

DROP TABLE #MMParams

INSERT	INTO #Param
SELECT  3, 'Chunk Size', name, chunkSizeMB, 
	CASE WHEN type IN (2,3,4,5,6,9,15,16,22,23,27,31,32,37,51,53,59,61,62,69,70,71,77,79,80,81,89,90,103,104,125,126,128,135) THEN '16384' ELSE '4096' END
FROM	APP_iDAType
WHERE	type IN (2,3,4,5,6,9,15,16,22,23,27,31,32,37,51,53,59,61,62,69,70,71,77,79,80,81,89,90,103,104,125,126,128,135)
	AND chunkSizeMB NOT IN ('Invalid Property', '16384')
OR	type NOT IN (2,3,4,5,6,9,15,16,22,23,27,31,32,37,51,53,59,61,62,69,70,71,77,79,80,81,89,90,103,104,125,126,128,135)
	AND type < 600
 AND chunkSizeMB NOT IN ('Invalid Property', '4096')

SET @surveyXML =
	(SELECT	Category AS '@Category', 
			Property AS '@Property', 
			Name AS '@Name', 
			Value AS '@Value',
			DefaultValue AS '@Default'
	FROM	#Param

	FOR XML PATH ('ParamAudit') 
	-- Replace <<RESULTS_NAME>> with specific name
	)

DROP TABLE #Param

--------- END SURVEY QUERY ---------

--------- BEGIN - GENERATED CODE, PLEASE DO NOT MODIFY ---------

DECLARE @EndTime AS BIGINT = dbo.GetUnixTime(GETUTCDATE())
SET @outputXML = 
(
	SELECT
		@queryId AS '@QueryId',
		@EndTime AS '@LogDate',
		(@EndTime - @LogDate) AS '@QueryRunningTime',
		@surveyXML
	FOR XML PATH('Rpt_CSSXMLDATA')
)
SET NOCOUNT OFF

--------- END - GENERATED CODE ---------