--@querytype    CSV
--Name:- Valid Job Details

SET NOCOUNT ON
SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
SET QUOTED_IDENTIFIER ON

DECLARE @months INT = 26
DECLARE @fromdate DATE = DATEADD(MM, -@months, GETDATE())
DECLARE @fromUTCTIME INT = dbo.GetUnixTime(@fromdate)

DECLARE @isValidJobsCollEnabled INT = 0
SELECT	@isValidJobsCollEnabled = CAST(CAST(value AS VARCHAR(20)) AS INT) FROM GXGlobalParam WITH (NOLOCK) WHERE name = 'CommservSurveyPrivateValidJobsCollEnabled'
IF (@isValidJobsCollEnabled = 1) --No need to collect job details
BEGIN
	SELECT 0 AS jobId, 0 AS DataStatus, CAST(@fromUTCTIME AS NVARCHAR(15)) AS collectionTime
	UNION
	SELECT jobId, dataStatus AS DataStatus, '' AS collectionTime  FROM JMBkpStats WITH(NOLOCK) WHERE servEndDate < @fromUTCTIME 
	ORDER BY jobId
END
ELSE
	SELECT 0 AS jobId, 0 AS DataStatus, CAST(@fromUTCTIME AS NVARCHAR(15)) AS collectionTime

SET NOCOUNT OFF 