--@querytype    CSV
--Name:- Jobs on Media

SET NOCOUNT ON
SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
SET QUOTED_IDENTIFIER ON
BEGIN TRY

	DECLARE @CurrCollectionTime INT = dbo.GetUnixTime(GETUTCDATE())
	DECLARE @LastCollectionTime INT = 0

	DECLARE @isPrivateRunning varchar(256)='';
	DECLARE @frequencyMode   NVARCHAR(MAX) ='0';
	DECLARE @CVA_UNAGED_JOB  BIGINT = 1073741824
	DECLARE @CVA_AGED_DATA_FLAG INT = 256

	IF EXISTS(SELECT * FROM tempdb.dbo.sysobjects WHERE ID = OBJECT_ID(N'tempdb..#MetricsInputParams'))
	    SELECT @frequencyMode = mode from #MetricsInputParams

	IF EXISTS(SELECT name FROM GXGlobalParam WITH (NOLOCK) WHERE name = 'CommservSurveyRunning')
	    SELECT @isPrivateRunning = value from GXGlobalParam WITH (NOLOCK)  where name ='CommservSurveyRunning'

	DECLARE @TIME_STAMP_NAME varchar(80)

	IF ((@isPrivateRunning = 'Metrics Reporting') OR (@frequencyMode = '1'))
	    SET @TIME_STAMP_NAME = 'CommservSurveyPrivateJobsOnMediaCollectionTime'
	ELSE
	    SET @TIME_STAMP_NAME = 'CommservSurveyPublicJobsOnMediaCollectionTime'

	SELECT  @LastCollectionTime = CAST(CAST(value AS VARCHAR(20)) AS INT) 
	  FROM  GXGlobalParam WITH (NOLOCK) WHERE name = @TIME_STAMP_NAME AND ISNUMERIC(CAST(value AS VARCHAR(20))) = 1

	SELECT
		V.MediaId,
		J.jobId,
		CASE WHEN MAX(AC.flags & @CVA_AGED_DATA_FLAG) = 0 THEN 0 ELSE 1 END AS isAged
	FROM JMJobDataStats J 
		INNER JOIN archFile AF WITH(NOLOCK) ON J.jobId = AF.jobId AND J.commCellId = AF.commCellId AND J.dataType = AF.fileType AND AF.isValid = 1
		INNER JOIN archChunkMapping ACM WITH(NOLOCK) ON AF.id = ACM.archFileId AND AF.commcellId = ACM.commcellId AND J.archGrpCopyId = ACM.archCopyId
		INNER JOIN archChunk AC WITH(NOLOCK)  ON ACM.archChunkId = AC.id AND ACM.chunkCommCellId = AC.commCellId
		INNER JOIN MMVolume V WITH(NOLOCK) ON AC.volumeId = V.VolumeId AND (V.Attributes & 512) = 0 AND V.RecordingFormatId <> 10001
	WHERE (@LastCollectionTime = 0 OR (J.copiedTime > @LastCollectionTime OR J.agedTime > @LastCollectionTime OR ((AC.flags & 256) = 0 ) AND (J.agedBy & @CVA_UNAGED_JOB) = @CVA_UNAGED_JOB))
	GROUP BY V.MediaId, J.JobId

	IF NOT EXISTS (SELECT * FROM GXGlobalParam WHERE name = @TIME_STAMP_NAME)
	BEGIN
	    IF EXISTS (SELECT * FROM APP_Client WITH(NOLOCK) WHERE id = 2 AND releaseId < 15)
	        INSERT INTO GXGlobalParam (name, value) SELECT @TIME_STAMP_NAME, ''
	    ELSE
	        EXEC QS_SetKeyIntoGlobalParamTbl @TIME_STAMP_NAME, 'Y', ''
	END
END TRY
BEGIN CATCH
	DECLARE @ErrorMessage NVARCHAR(4000);
	SET @ErrorMessage = ERROR_MESSAGE();
	RAISERROR(@ErrorMessage,16,1)
	RETURN;
END CATCH

UPDATE  GXGlobalParam SET value = CAST(@CurrCollectionTime AS VARCHAR(20)) WHERE   name = @TIME_STAMP_NAME