--@querytype    CSV
--Name:- Tape Media Info

SET NOCOUNT ON
SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
SET QUOTED_IDENTIFIER ON

DECLARE @csTimeZone    NVARCHAR(1024) = ''
SELECT  @csTimeZone = dbo.GetClientTimeZone(2)

IF ISNULL(@csTimeZone, '') = ''
BEGIN
    SELECT @csTimeZone = timeZone FROM APP_CommCell WITH (NOLOCK) WHERE id = 2
    SELECT @csTimeZone = TimeZoneStdName FROM SchedTimeZone WITH (NOLOCK)
    WHERE  TimeZoneName = SUBSTRING(@csTimeZone, CHARINDEX(':', @csTimeZone, CHARINDEX(':', @csTimeZone, 0) + 1) + 1, 255)
END

IF object_id('tempdb.dbo.#MediaReport') IS NOT NULL 
DROP TABLE #MediaReport

CREATE TABLE #MediaReport (
	MediaId					INT
	,BarCode				NVARCHAR(256)	
	,LibraryId				INT
    ,archGroupCopyId		INT
	,MediaGroupId			INT
	,MediaLocation			INT
	,SpareGroupName			NVARCHAR(256)	
	,RetentionExpireTime	BIGINT
	,ExportLocationId		INT				
	,ExportLocation			NVARCHAR(256)	
	,Creationtime			BIGINT				
	,VolumeFlag				INT
	,LocationId				INT
	,LocationName			NVARCHAR(256)
	,LastWriteTime			BIGINT
	,LastReadTime			BIGINT				
	,totalDataMB			BIGINT			
	,Encryption				INT
	,IsInMediaGp			INT
	)

INSERT INTO #MediaReport
SELECT M.MediaId
	,M.BarCode
	,L.LibraryId
	,0
	,V.MediaGroupId
	,M.MediaLocation
	,MSG.SpareGroupName
	,M.retentionExpireTime
	,M.ExportLocationId
	,ME.ExportLocation
	,M.CreationTime
	,V.VolumeFlags
	,0
	,''
	,M.LastBackupTime
	,M.LastRestoreTime
	,0
	,0
	,M.IsInMediaGroup
FROM MMMedia(NOLOCK) M
JOIN MMLibrary(NOLOCK) L ON L.LibraryId = M.LibraryId
JOIN MMVolume(NOLOCK) V ON V.MediaId = M.MediaId
JOIN MMExportLocation(NOLOCK) ME ON ME.ExportLocationId = M.ExportLocationId
JOIN MMSpareGroup(NOLOCK) MSG ON MSG.SpareGroupId= M.SpareGroupId
WHERE M.MediaId <> 0
	AND M.MediaTypeId <> 10001
	AND	M.LibraryId > 0
	
UPDATE 	#MediaReport
SET		archGroupCopyId = AST.ArchGroupCopyId
FROM	ArchStream AS AST
WHERE	AST.MediaGroupId = #MediaReport.MediaGroupId and IsInMediaGp > 0 and (AST.flags & 2) = 0

UPDATE #MediaReport
SET totalDataMB = (
		SELECT ISNULL(SUM(MS.PhysicalBytesMB), 0)
		FROM MMMediaSide(NOLOCK) MS
		WHERE #MediaReport.mediaId = MS.mediaId
		)

UPDATE #MediaReport
SET LocationId = S.SlotId, LocationName = S.SlotName
FROM MMSlot(NOLOCK) S 
WHERE S.MediaId = #MediaReport.MediaId
AND MediaLocation = 1

UPDATE #MediaReport
SET LocationId = D.DriveId, LocationName = D.DriveName
FROM MMDrive(NOLOCK) D 
WHERE D.MediaId = #MediaReport.MediaId
AND MediaLocation = 2

UPDATE #MediaReport
SET LocationId = ExportLocationId, LocationName = ExportLocation
WHERE MediaLocation = 3

IF object_id('tempdb.dbo.#MediaEncryption') IS NOT NULL DROP TABLE #MediaEncryption
CREATE TABLE #MediaEncryption (MediaId INT, SoftwareEnc INT, HardwareEnc INT, NoEnc INT)
INSERT INTO #MediaEncryption
	SELECT MediaId
		,SUM(CASE WHEN AFC.encKeyType > 0 THEN 1 ELSE 0 END) Sw
		,SUM(CASE WHEN AC.hwEncKey <> '' THEN 1 ELSE 0 END) Hw
		,SUM(CASE WHEN AFC.encKeyType = 0 AND AC.hwEncKey = '' THEN 1 ELSE 0 END) NotEncr
	FROM archFile AF
	INNER JOIN archFileCopy(NOLOCK) AFC ON AF.id = AFC.archFileId AND AF.commCellId = AFC.commCellId
	INNER JOIN archChunkMapping(NOLOCK) ACM ON AFC.archFileId = ACM.archFileId AND AFC.commCellId = ACM.commCellId AND AFC.archCopyId = ACM.archCopyId
	INNER JOIN archChunk(NOLOCK) AC ON ACM.archChunkId = AC.id AND ACM.chunkCommCellId = AC.commCellId
	INNER JOIN MMVolume(NOLOCK) V ON AC.volumeId = V.VolumeId
	WHERE AF.isValid = 1 AND AFC.isValid = 1
	GROUP BY V.MediaId

UPDATE MR
SET Encryption = CASE WHEN NoEnc > 0 THEN 2 ELSE 1 END
FROM #MediaReport MR INNER JOIN #MediaEncryption ME ON MR.MediaId = ME.MediaId AND ME.SoftwareEnc + ME.HardwareEnc > 0

IF OBJECT_ID('GetUnixTimeBig', 'FN') IS NOT NULL
	SELECT MediaId AS 'MediaId'
		,BarCode AS 'BarCode'
		,archGroupCopyId AS 'ArchGroupCopyId'
		,LibraryId AS 'LibraryId'
		,LocationId AS 'LocationId'
		,LocationName AS 'LocationName'
		,SpareGroupName AS 'SpareGroupName'
		,VolumeFlag AS 'VolumeFlag'
		,CASE WHEN LastWriteTime > 0 
			THEN dbo.GetUnixTimeBig(dbo.UTCToLocalTime(dbo.GetDateTimeBig(LastWriteTime), @csTimeZone)) 
			ELSE 0
			END AS 'LastWriteTime'
		,CASE WHEN LastReadTime > 0 
			THEN dbo.GetUnixTimeBig(dbo.UTCToLocalTime(dbo.GetDateTimeBig(LastReadTime), @csTimeZone)) 
			ELSE 0
			END AS 'LastReadTime'
		,totalDataMB AS 'TotalDataMB'
		,CASE WHEN RetentionExpireTime > 0 
			THEN dbo.GetUnixTimeBig(dbo.UTCToLocalTime(dbo.GetDateTimeBig(RetentionExpireTime), @csTimeZone)) 
			ELSE RetentionExpireTime
			END AS 'RetentionExpireTime'
		,CASE WHEN Creationtime > 0 
			THEN dbo.GetUnixTimeBig(dbo.UTCToLocalTime(dbo.GetDateTimeBig(Creationtime), @csTimeZone)) 
			ELSE 0
			END AS 'CreationTime'
		,MediaLocation AS 'MediaLocation'
		,Encryption AS 'Encryption'
	FROM #MediaReport
	ORDER BY BarCode
ELSE
	SELECT MediaId AS 'MediaId'
		,BarCode AS 'BarCode'
		,archGroupCopyId AS 'ArchGroupCopyId'
		,LibraryId AS 'LibraryId'
		,LocationId AS 'LocationId'
		,LocationName AS 'LocationName'
		,SpareGroupName AS 'SpareGroupName'
		,VolumeFlag AS 'VolumeFlag'
		,CASE WHEN LastWriteTime > 0 
			THEN dbo.GetUnixTime(dbo.UTCToLocalTime(dbo.GetDateTime(LastWriteTime), @csTimeZone)) 
			ELSE 0
			END AS 'LastWriteTime'
		,CASE WHEN LastReadTime > 0 
			THEN dbo.GetUnixTime(dbo.UTCToLocalTime(dbo.GetDateTime(LastReadTime), @csTimeZone)) 
			ELSE 0
			END AS 'LastReadTime'
		,totalDataMB AS 'TotalDataMB'
		,CASE WHEN RetentionExpireTime > 0 
			THEN dbo.GetUnixTime(dbo.UTCToLocalTime(dbo.GetDateTime(RetentionExpireTime), @csTimeZone)) 
			ELSE RetentionExpireTime
			END AS 'RetentionExpireTime'
		,CASE WHEN Creationtime > 0 
			THEN dbo.GetUnixTime(dbo.UTCToLocalTime(dbo.GetDateTime(Creationtime), @csTimeZone)) 
			ELSE 0
			END AS 'CreationTime'
		,MediaLocation AS 'MediaLocation'
		,Encryption AS 'Encryption'
	FROM #MediaReport
	ORDER BY BarCode


IF object_id('tempdb.dbo.#MediaReport') IS NOT NULL DROP TABLE #MediaReport		
IF object_id('tempdb.dbo.#MediaEncryption') IS NOT NULL DROP TABLE #MediaEncryption

SET NOCOUNT OFF 