--- Please follow the below comments to insert SQL statements.
-- Client version query
--------- BEGIN - GENERATED CODE, PLEASE DO NOT MODIFY ---------

SET NOCOUNT ON

BEGIN TRY

DECLARE @LogDate AS BIGINT = dbo.GetUnixTime(GETUTCDATE())
DECLARE @queryId AS INTEGER = 210
DECLARE @surveyXML  NVARCHAR(MAX)

--------- END - GENERATED CODE ---------



--------- BEGIN SURVEY QUERY ---------

--------- Insert your SQL statements here 

DECLARE @nreleaseId INT =1
SET @nreleaseId =(SELECT releaseId from APP_Client WITH (NOLOCK) where id =2)

DECLARE @LastCollectionAttrName VARCHAR(256)
DECLARE @isPrivateRunning varchar(256)='';
DECLARE @freequencyMode	 NVARCHAR(MAX) ='0';
DECLARE @nstring NVARCHAR(MAX)
DECLARE @IntervalType CHAR = 'D'

IF EXISTS(SELECT * FROM tempdb.dbo.sysobjects WHERE ID = OBJECT_ID(N'tempdb..#MetricsInputParams'))
	SELECT @freequencyMode = mode from #MetricsInputParams

IF EXISTS(SELECT name FROM GXGlobalParam WITH (NOLOCK) WHERE name = 'CommservSurveyRunning')
	SELECT @isPrivateRunning = value from GXGlobalParam WITH (NOLOCK)  where name ='CommservSurveyRunning'

IF ((@isPrivateRunning = 'Metrics Reporting') OR (@freequencyMode = '1'))
	SET @LastCollectionAttrName = 'CommservSurveyPrivateMountPathThroughputCollectionTime'
ELSE
	SET @LastCollectionAttrName = 'CommservSurveyPublicLastMountPathThroughputCollectionTime'

IF @LastCollectionAttrName = 'CommservSurveyPrivateMountPathThroughputCollectionTime'
	SET @IntervalType = 'H'

-- Get the last collection time
DECLARE @CurrCollectionDate DATE = DATEADD(DAY, DATEDIFF(DAY, 0, GETDATE()), 0)
DECLARE @PrevCollectionDate DATE

SELECT  @PrevCollectionDate = CAST(CAST(value AS NVARCHAR(256)) AS DATE) from GXGlobalParam WITH (NOLOCK) where name = @LastCollectionAttrName

IF @PrevCollectionDate IS NULL
	SET @PrevCollectionDate = DATEADD(DAY, DATEDIFF(DAY, 0, GETDATE())-14, 0)

CREATE TABLE #UsedTimeRanges (MediaSideId INT, TimeStart DATETIME, TimeEnd DATETIME, OrderNo INT, UsedSec INT, DataReadMB BIGINT, DataWrittenMB BIGINT)
CREATE TABLE #CombinedStarts (MediaSideId INT, TimeStart DATETIME, OrderNo INT)
CREATE TABLE #CombinedRanges (MediaSideId INT, TimeStart DATETIME, TimeEnd DATETIME)
CREATE TABLE #UsageByInterval(MediaSideId INT, IntervalStart DATETIME, UsedSeconds INT, DataReadMB BIGINT, DataWrittenMB BIGINT)
CREATE TABLE #MediaMountPath (MediaSideId INT, MediaId INT, LibraryId INT, MountPathId INT, MountPathName NVARCHAR(1024))

INSERT INTO #MediaMountPath
SELECT	MS.MediaSideId, MS.MediaId, MPT.LibraryId, MPT.MountPathId, T.MountPathName
FROM	MMMediaSide MS WITH (NOLOCK)
		INNER JOIN MMMountPath MPT WITH (NOLOCK) ON MS.MediaSideId = MPT.MediaSideId
		INNER JOIN MMMountPathToStorageDevice SD WITH (NOLOCK) ON MPT.MountPathId = SD.MountPathId
		INNER JOIN (
		SELECT	'['+C.name+'] '+ DC.Folder AS MountPathName, DC.DeviceId,
				ROW_NUMBER() OVER (
					PARTITION BY DC.DeviceId 
					ORDER BY (CASE WHEN DC.DeviceAccessType&(8|6) = (8|6) THEN 0 WHEN DC.DeviceAccessType&2 = 2 THEN 1 ELSE 2 END), 
							DC.DeviceControllerEnabled DESC, DC.DeviceControllerId ASC) AS RowNo
		FROM	MMDeviceController DC WITH (NOLOCK)
				INNER JOIN APP_Client C WITH (NOLOCK) ON DC.ClientId = C.id
		WHERE DC.Folder <> ''
		) T ON SD.DeviceId = T.DeviceId
WHERE	T.RowNo = 1

DECLARE @IntervalStart DATETIME = @PrevCollectionDate
DECLARE @IntervalEnd   DATETIME = CASE WHEN @IntervalType = 'H' THEN DATEADD(HOUR, 1, @IntervalStart) ELSE DATEADD(DAY, 1, @IntervalStart) END

WHILE @IntervalStart < @CurrCollectionDate
BEGIN
	INSERT	INTO #UsedTimeRanges
	SELECT	MediaSideId, CAST(TimeStart AS SMALLDATETIME), 
			DATEADD(SECOND, 
					MAX(CASE WHEN DataWriteDurationSec > DataReadDurationSec THEN DataWriteDurationSec ELSE DataReadDurationSec END), 
					CAST(TimeStart AS SMALLDATETIME)),
			ROW_NUMBER() OVER (PARTITION BY MediaSideId ORDER BY CAST(TimeStart AS SMALLDATETIME)),
			MAX(CASE WHEN DataWriteDurationSec > DataReadDurationSec THEN DataWriteDurationSec ELSE DataReadDurationSec END), 
			SUM(DataRead), SUM(DataWritten)
	FROM	MMDriveHistory DH WITH (NOLOCK)
			INNER JOIN MMDrive D WITH (NOLOCK) ON DH.DriveId = D.DriveId
			INNER JOIN #MediaMountPath M WITH (NOLOCK) ON D.MediaId = M.MediaId
	WHERE	MediaSideId > 0 AND HistoryType IN (0, 2) AND TimeStart < @IntervalEnd
		AND DATEADD(SECOND, 
					CASE WHEN DataWriteDurationSec > DataReadDurationSec THEN DataWriteDurationSec ELSE DataReadDurationSec END, 
					TimeStart) > @IntervalStart
	GROUP BY MediaSideId, CAST(TimeStart AS SMALLDATETIME)

	UPDATE	#UsedTimeRanges
	SET		TimeStart = @IntervalStart, 
			DataReadMB = (1.0*DATEDIFF(SECOND, @IntervalStart, TimeEnd)/UsedSec)*DataReadMB,
			DataWrittenMB = (1.0*DATEDIFF(SECOND, @IntervalStart, TimeEnd)/UsedSec)*DataWrittenMB
	WHERE	TimeStart < @IntervalStart

	UPDATE	#UsedTimeRanges
	SET		TimeEnd = @IntervalEnd, 
			DataReadMB = (1.0*DATEDIFF(SECOND, TimeStart, @IntervalEnd)/UsedSec)*DataReadMB,
			DataWrittenMB = (1.0*DATEDIFF(SECOND, TimeStart, @IntervalEnd)/UsedSec)*DataWrittenMB
	WHERE	TimeEnd > @IntervalEnd

	INSERT INTO #CombinedStarts
	SELECT	B.MediaSideId, B.TimeStart,
			ROW_NUMBER() OVER (PARTITION BY B.MediaSideId ORDER BY B.TimeStart)
	FROM	#UsedTimeRanges A
			INNER JOIN #UsedTimeRanges B ON A.MediaSideId = B.MediaSideId AND (A.OrderNo + 1) = B.OrderNo AND A.TimeEnd < B.TimeStart
	UNION
	SELECT	MediaSideId, TimeStart, 0
	FROM	#UsedTimeRanges
	WHERE	OrderNo = 1

	INSERT INTO #CombinedRanges
	SELECT	A.MediaSideId, A.TimeStart, MAX(C.TimeEnd)
	FROM	#CombinedStarts A
			INNER JOIN #CombinedStarts B ON A.MediaSideId = B.MediaSideId AND (A.OrderNo + 1) = B.OrderNo 
			INNER JOIN #UsedTimeRanges C ON A.MediaSideId = C.MediaSideId AND A.TimeStart <= C.TimeStart AND B.TimeStart > C.TimeStart
	GROUP BY A.MediaSideId, A.TimeStart
	UNION
	SELECT	A.MediaSideId, A.TimeStart, B.TimeEnd
	FROM	(SELECT MediaSideId, MAX(TimeStart) AS TimeStart FROM #CombinedStarts GROUP BY MediaSideId) A
			INNER JOIN (SELECT MediaSideId, MAX(TimeEnd) AS TimeEnd FROM #UsedTimeRanges GROUP BY MediaSideId) B 
			ON A.MediaSideId = B.MediaSideId

	INSERT	INTO #UsageByInterval
	SELECT	A.MediaSideId, @IntervalStart, A.UsedSec, B.DataReadMB, B.DataWrittenMB
	FROM	(SELECT	MediaSideId, SUM(DATEDIFF(SS, TimeStart, TimeEnd)) AS UsedSec
			FROM	#CombinedRanges
			GROUP BY MediaSideId
			) A
			INNER JOIN
			(SELECT MediaSideId, SUM(DataReadMB) AS DataReadMB, SUM(DataWrittenMB) AS DataWrittenMB
			FROM	#UsedTimeRanges
			GROUP BY MediaSideId
			) B ON A.MediaSideId = B.MediaSideId

	INSERT	INTO #UsageByInterval
	SELECT	MPT.MediaSideId, @IntervalStart, 0, 0, 0
	FROM	#MediaMountPath MPT
			LEFT OUTER JOIN #UsageByInterval U ON MPT.MediaSideId = U.MediaSideId AND U.IntervalStart = @IntervalStart
	WHERE	U.MediaSideId IS NULL

	TRUNCATE TABLE #UsedTimeRanges
	TRUNCATE TABLE #CombinedStarts
	TRUNCATE TABLE #CombinedRanges

	SET @IntervalStart = @IntervalEnd
	SET @IntervalEnd =  CASE WHEN @IntervalType = 'H' THEN DATEADD(HOUR, 1, @IntervalStart) ELSE DATEADD(DAY, 1, @IntervalStart) END
END

SET @surveyXML =(
	SELECT	MPT.LibraryId AS '@LibraryId', 
		MPT.MountPathId AS '@MountPathId',
		MPT.MountPathName AS '@MountPathName',
		@IntervalType AS '@IntervalType',
		IntervalStart AS '@IntervalStart', 
		UsedSeconds AS '@UsedSeconds', 
		DataReadMB AS '@DataReadMB', 
		DataWrittenMB AS '@DataWrittenMB'
	FROM	#UsageByInterval U
		INNER JOIN #MediaMountPath MPT WITH (NOLOCK) ON U.MediaSideId = MPT.MediaSideId
	ORDER BY IntervalStart, MPT.LibraryId

	FOR XML PATH ('MountPathThroughput')
)

DROP TABLE #UsedTimeRanges
DROP TABLE #CombinedStarts
DROP TABLE #CombinedRanges
DROP TABLE #UsageByInterval
DROP TABLE #MediaMountPath

--------- END SURVEY QUERY ---------

--------- BEGIN - GENERATED CODE, PLEASE DO NOT MODIFY ---------

DECLARE @EndTime AS BIGINT = dbo.GetUnixTime(GETUTCDATE())
SET @outputXML = 
(
	SELECT
		@queryId AS '@QueryId',
		@EndTime AS '@LogDate',
		(@EndTime - @LogDate) AS '@QueryRunningTime',
		@surveyXML
	FOR XML PATH('Rpt_CSSXMLDATA')
)

END TRY
BEGIN CATCH	 
  DECLARE @ErrorMessage NVARCHAR(4000);  
  SET @ErrorMessage = ERROR_MESSAGE();
  RAISERROR(@ErrorMessage,16,1);
RETURN
END CATCH

--Update the last collection time
IF EXISTS(SELECT value from GXGlobalParam WITH (NOLOCK) where name = @LastCollectionAttrName)
	UPDATE GXGlobalParam SET value = CAST(@CurrCollectionDate as NVARCHAR(MAX)) where name = @LastCollectionAttrName
ELSE
BEGIN
	IF @nreleaseId >= 15
	BEGIN
		SET @nstring = N'insert into GXGlobalParam values(''' + @LastCollectionAttrName + ''', ''' + CAST(@CurrCollectionDate as NVARCHAR(MAX)) + ''', dbo.GetUnixTime(GetUTCDate()), 0)'
		EXEC sp_executesql @nstring
	END
	ELSE
	BEGIN
		insert into GXGlobalParam (name, value) values(@LastCollectionAttrName, CAST(@CurrCollectionDate as NVARCHAR(MAX)))
	END
END

SET NOCOUNT OFF

--------- END - GENERATED CODE ---------