
--------- BEGIN - GENERATED CODE, PLEASE DO NOT MODIFY ---------
SET NOCOUNT ON

BEGIN TRY

DECLARE @LogDate AS BIGINT = dbo.GetUnixTime(GETUTCDATE())
DECLARE @queryId AS INTEGER = 177
DECLARE @surveyXML NVARCHAR(MAX)

--------- END - GENERATED CODE ---------

--------- BEGIN SURVEY QUERY ---------

--------- Insert your SQL statements here 
-- Query Name: Backup Job Statistics Operation
-- Description: Backup Success and failure statistics


DECLARE	@TimeZoneBias	INT = DATEDIFF(SECOND, GETUTCDATE(), GETDATE())
 
DECLARE @csTimeZone    NVARCHAR(1024) = ''
SELECT  @csTimeZone = dbo.GetClientTimeZone(2)

IF ISNULL(@csTimeZone, '') = ''
BEGIN
    SELECT @csTimeZone = timeZone FROM APP_CommCell WITH (NOLOCK) WHERE id = 2
    SELECT @csTimeZone = TimeZoneStdName FROM SchedTimeZone WITH (NOLOCK)
    WHERE  TimeZoneName = SUBSTRING(@csTimeZone, CHARINDEX(':', @csTimeZone, CHARINDEX(':', @csTimeZone, 0) + 1) + 1, 255)
END

DECLARE @nreleaseId INT =1
SET @nreleaseId =(SELECT releaseId from APP_Client WITH (NOLOCK) where id =2)

DECLARE @LastCollectionAttrName VARCHAR(256)

-- Check if any special group to consider for data collection.
-- Get the list of client group ids if exists
DECLARE @groupStr varchar(256);
DECLARE @groupStrName Nvarchar(MAX)='';
DECLARE @isPrivateRunning varchar(256)='';
DECLARE @freequencyMode	 NVARCHAR(MAX) ='0';
IF EXISTS(SELECT * FROM tempdb.dbo.sysobjects WHERE ID = OBJECT_ID(N'tempdb..#MetricsInputParams'))
BEGIN
    SELECT @freequencyMode = mode from #MetricsInputParams
END
IF EXISTS(SELECT name FROM GXGlobalParam WITH (NOLOCK) WHERE name = 'CommservSurveyRunning')
BEGIN
	SELECT @isPrivateRunning = value from GXGlobalParam WITH (NOLOCK)  where name ='CommservSurveyRunning'
END

IF ((@isPrivateRunning = 'Metrics Reporting')OR  (@freequencyMode ='1'))
BEGIN
	SELECT @groupStr = value from GXGlobalParam WITH (NOLOCK) where name ='CommservSurveyPrivateSpecialClientGroup'
	SET @LastCollectionAttrName = 'CommservSurveyPrivateLastConsumerActivityCollectionTime'
END
ELSE
BEGIN
	SELECT @groupStr = value from GXGlobalParam WITH (NOLOCK) where name ='CommservSurveySpecialClientGroup'
	SET @LastCollectionAttrName = 'CommservSurveyPublicLastConsumerActivityCollectionTime'
END

SET @groupStr = @groupStr + ',';
declare @includeGroups table(groupID int);
DECLARE @endIndex integer=0
DECLARE @startIndex integer=0
DECLARE @groupId integer        

SET @endIndex = CHARINDEX(',', @groupStr, @startIndex)
  
WHILE(@endIndex IS NOT NULL AND @endIndex <> 0)
BEGIN
	SET @groupId = CAST(SUBSTRING(@groupStr,@startIndex,@endIndex-@startIndex) AS INT)
	if(@groupId > 0)
	BEGIN
		insert into @includeGroups values(@groupId);
		DECLARE @tmpStr NVARCHAR(100);
		SELECT @tmpStr = NAME FROM APP_ClientGroup WITH (NOLOCK) WHERE id = @groupId;
		IF(@tmpStr IS NOT NULL)
			SET @groupStrName = @groupStrName + ', ' + @tmpStr
	END
	SET @startIndex = @endIndex + 1
	SET @endIndex = CHARINDEX(',', @groupStr, @startIndex)
END

DECLARE @specialGroupExists INT  =0
DECLARE @includeClients TABLE (clientId INT);

IF EXISTS (SELECT id FROM app_clientgroup WITH (NOLOCK) join @includeGroups on id=groupID)
BEGIN
	SET @specialGroupExists =1
	
	INSERT INTO @includeClients
	SELECT DISTINCT CGA.clientId 
	FROM @includeGroups CG INNER JOIN APP_ClientGroupAssoc CGA WITH (NOLOCK) ON CGA.clientGroupId = CG.groupID	
END

DECLARE @IncludedAppTypeIds TABLE (appTypeId INT)

DECLARE @ExcludedAppIds TABLE (appId INT)

INSERT INTO @ExcludedAppIds
SELECT componentNameId FROM APP_subclientProp WITH (NOLOCK) WHERE attrName IN ('DDB Backup', 'Index SubClient', 'SILO Copy ID') AND attrVal <> '0' AND modified = 0
UNION
SELECT id FROM APP_Application WITH (NOLOCK) 
WHERE clientId IN (SELECT componentNameId FROM APP_ClientProp WITH (NOLOCK) WHERE attrName = 'Content Index Server' AND attrVal = '1' AND modified = 0)

INSERT INTO @IncludedAppTypeIds
SELECT DISTINCT appTypeId FROM APP_Application WITH (NOLOCK) 

-- Get the last collection time
DECLARE @CurrCollectionDate DATETIME = GETDATE()
DECLARE @PrevCollectionDate DATETIME

IF EXISTS(SELECT value from GXGlobalParam WITH (NOLOCK) where name = @LastCollectionAttrName)
BEGIN
	BEGIN TRY 
		SELECT @PrevCollectionDate = CAST(CAST(value AS NVARCHAR(256)) AS DATETIME) from GXGlobalParam WITH (NOLOCK) where name = @LastCollectionAttrName 
	END TRY 
	BEGIN CATCH 
		IF	DAY(GETDATE()) > 16
			SET @PrevCollectionDate = DATEADD(MONTH, DATEDIFF(MONTH, 0, GETDATE()), 0)
		ELSE
			SET @PrevCollectionDate = DATEADD(MONTH, DATEDIFF(MONTH, 0, GETDATE())-1, 0)
	END CATCH
END
ELSE
BEGIN
	IF	DAY(GETDATE()) > 16
		SET @PrevCollectionDate = DATEADD(MONTH, DATEDIFF(MONTH, 0, GETDATE()), 0)
	ELSE
		SET @PrevCollectionDate = DATEADD(MONTH, DATEDIFF(MONTH, 0, GETDATE())-1, 0)
END


IF object_id('tempdb.dbo.#DailyTbl') is not null DROP TABLE #DailyTbl

DECLARE @backupWindow varchar(20) = ISNULL((SELECT value from GXGlobalParam WITH (NOLOCK) where name = 'Backup Window'), '18:00')
--set @backupWindow = '18:00'

DECLARE @ConsumersJob XML 


IF ISNULL(LTRIM(RTRIM(@backupWindow)),'') <> ''
BEGIN

	IF object_id('tempdb.dbo.#JobsData') is not null DROP TABLE #JobsData

	DECLARE @timeFrameEnd DATETIME = CAST(GETDATE() AS VARCHAR(11))+' '+LTRIM(RTRIM(@backupWindow))

	DECLARE @PrevCollectionTimeFrameEnd DATETIME = DATEADD(MILLISECOND,DATEDIFF(MILLISECOND,0,@backupWindow),CAST (@PrevCollectionDate AS VARCHAR(11)))
	
	IF @PrevCollectionDate < @PrevCollectionTimeFrameEnd
		SET @PrevCollectionTimeFrameEnd = DATEADD(DAY, -1, @PrevCollectionTimeFrameEnd)	

	IF @timeFrameEnd > GETDATE()
		SET @timeFrameEnd = DATEADD(DAY, -1, @timeFrameEnd)	
	
	DECLARE @timeFrameBegin DATETIME = DATEADD(DAY,-1,@timeFrameEnd)		

	DECLARE @lastNDays INT = DATEDIFF(DAY, @PrevCollectionTimeFrameEnd, @timeFrameEnd)
		

	DECLARE @fromDt DATETIME = @PrevCollectionDate
	IF OBJECT_ID('IsInvalidTimeManaged') IS NOT NULL
	BEGIN
		WHILE dbo.IsInvalidTimeManaged(@fromDt, @csTimeZone) = 1
	    BEGIN
	       SET @fromDt = DATEADD(HOUR, 1, @fromDt)
		END
	END		

	DECLARE @FromTime INT = dbo.getunixtime(dbo.LocalToUTCTime(@fromDt, @csTimeZone))	

	--SELECT @PrevCollectionDate '@PrevCollectionDate', @PrevCollectionTimeFrameEnd '@PrevCollectionDateWindow', 
	--		@timeFrameEnd '@timeFrameEnd', dbo.UTCToLocalTime(dbo.getdatetime(@FromTime), @csTimeZone) '@FromTime'	

	SELECT appId, JobId, servEndDate, totalUncompBytes, Status, appType
	INTO #JobsData
    FROM JMBkpStats B WITH (NOLOCK)
		WHERE servEndDate >= @FromTime
				AND opType IN (4, 14, 18, 30, 43, 59, 65, 76, 87, 91, 94, 97, 98, 101)
				AND status IN (1,2,3,4,9,14) AND @lastNDays > 0

	IF (@specialGroupExists = 0)
	BEGIN		
		DELETE J 
		FROM #JobsData J
		WHERE J.appId IN (SELECT appId FROM @ExcludedAppIds)
	END 
	ELSE
	BEGIN
		DELETE J 
		FROM #JobsData J
			INNER JOIN APP_Application A WITH (NOLOCK) ON J.appId= A.id		
		WHERE appId IN (SELECT appId FROM @ExcludedAppIds) 
				OR A.clientId NOT IN (SELECT clientId FROM @includeClients)
	END

	IF OBJECT_ID('tempdb.dbo.#BackupTimeWindow') IS NOT NULL DROP TABLE #BackupTimeWindow
	CREATE TABLE #BackupTimeWindow (Cnt INT, TimeFrameBegin DATETIME, TimeFrameEnd DATETIME, UnixTimeFrameBegin INT, UnixTimeFrameEnd INT)
	;WITH BackupTimeWindow(Cnt, TimeFrameBegin , TimeFrameEnd, UnixTimeFrameBegin, UnixTimeFrameEnd) AS
	(
		SELECT 1,@timeFrameBegin, @timeFrameEnd, dbo.getunixtime(dbo.LocalToUTCTime(@timeFrameBegin, @csTimeZone)), dbo.getunixtime(dbo.LocalToUTCTime(@timeFrameEnd, @csTimeZone)) 
		UNION ALL
		SELECT Cnt+1,DATEADD(DAY, -1, TimeFrameBegin),DATEADD(DAY, -1, TimeFrameEnd), dbo.getunixtime(dbo.LocalToUTCTime(DATEADD(DAY, -1, TimeFrameBegin), @csTimeZone)), dbo.getunixtime(dbo.LocalToUTCTime(DATEADD(DAY, -1, TimeFrameBegin), @csTimeZone))
		FROM BackupTimeWindow WHERE Cnt < @lastNDays
	)
	INSERT INTO #BackupTimeWindow SELECT * FROM BackupTimeWindow OPTION(MAXRECURSION 0)

	IF OBJECT_ID('tempdb.dbo.#SuccessfulJobsFrSubClientInTimeFrame') IS NOT NULL DROP TABLE #SuccessfulJobsFrSubClientInTimeFrame
	CREATE TABLE #SuccessfulJobsFrSubClientInTimeFrame (TimeFrameBegin INT, TimeFrameEnd INT, SubclientId INT, SuccessfulJobId INT) 
	
	INSERT INTO #SuccessfulJobsFrSubClientInTimeFrame
        SELECT W.UnixTimeFrameBegin, W.UnixTimeFrameEnd, B.appId, MAX(JobId) 
        FROM #BackupTimeWindow W 
			INNER JOIN #JobsData B WITH (NOLOCK)
				ON B.servEndDate >= W.UnixTimeFrameBegin AND B.servEndDate < W.UnixTimeFrameEnd AND Status IN (1,3,14)		
		WHERE TimeFrameBegin >= @PrevCollectionTimeFrameEnd AND Cnt <= @lastNDays					   
        GROUP BY W.UnixTimeFrameBegin, W.UnixTimeFrameEnd, B.appId

	DELETE J 
    FROM #JobsData J 
        INNER JOIN #SuccessfulJobsFrSubClientInTimeFrame S
            ON J.servEndDate >= S.TimeFrameBegin AND J.servEndDate < S.TimeFrameEnd AND J.appId = S.SubclientId
                AND J.JobId < S.SuccessfulJobId AND Status NOT IN (1,3,14) 


	SET @ConsumersJob = (
		SELECT CAST(dbo.UTCToLocalTime(dbo.getdatetime(servEndDate), @csTimeZone) AS DATE) '@JobEndDate', 
			ISNULL(appType, 0) as '@AppTypeId',
			ISNULL(SUM(CASE WHEN status IN (1,2,3,4,9,14) THEN 1 ELSE 0 END), 0) as '@TotalJobs',
			ISNULL(SUM(CASE WHEN status IN (1) THEN 1 ELSE 0 END), 0) AS '@CompletedJobs',
			ISNULL(SUM(CASE WHEN status IN (3) THEN 1 ELSE 0 END), 0) as '@CWEJobs',
			ISNULL(SUM(CASE WHEN status IN (14) THEN 1 ELSE 0 END), 0) as '@CWWJobs',
			ISNULL(SUM(CASE WHEN status IN (2) THEN 1 ELSE 0 END), 0) as '@FailedJobs',
			ISNULL(SUM(CASE WHEN status IN (4) THEN 1 ELSE 0 END), 0) as '@KilledJobs',
			ISNULL(SUM(CASE WHEN status IN (9) THEN 1 ELSE 0 END), 0) as '@SkippedJobs',
			ISNULL(SUM(CASE WHEN status IN (1,3,14) THEN totalUncompBytes ELSE 0 END), 0) AS '@BackupSize'		
		FROM #JobsData						
		GROUP BY CAST(dbo.UTCToLocalTime(dbo.getdatetime(servEndDate), @csTimeZone) AS DATE), appType
		ORDER BY CAST(dbo.UTCToLocalTime(dbo.getdatetime(servEndDate), @csTimeZone) AS DATE), appType
		FOR XML PATH('DailyJobStats')
	)

	IF object_id('tempdb.dbo.#JobsData') is not null DROP TABLE #JobsData
	IF OBJECT_ID('tempdb.dbo.#BackupTimeWindow') IS NOT NULL DROP TABLE #BackupTimeWindow
	IF OBJECT_ID('tempdb.dbo.#SuccessfulJobsFrSubClientInTimeFrame') IS NOT NULL DROP TABLE #SuccessfulJobsFrSubClientInTimeFrame


END

SET @surveyXML = 
( SELECT @ConsumersJob
	FOR XML PATH ('ConsumerBackupStatsXML') )
	
--------- END SURVEY QUERY ---------

DECLARE @EndTime AS BIGINT = dbo.GetUnixTime(GETUTCDATE())
SET @outputXML = 
(
	SELECT
		@queryId AS '@QueryId',
		@EndTime AS '@LogDate',
		(@EndTime - @LogDate) AS '@QueryRunningTime',
		@surveyXML
	FOR XML PATH('Rpt_CSSXMLDATA')
)

--SELECT cast (@surveyXML AS XML)

	 
END TRY
BEGIN CATCH	 
  DECLARE @ErrorMessage NVARCHAR(4000);  
  SET @ErrorMessage = ERROR_MESSAGE();
  RAISERROR(@ErrorMessage,16,1);
RETURN
END CATCH

IF ISNULL(LTRIM(RTRIM(@backupWindow)),'') <> ''
BEGIN
	--Update the last collection time
	IF EXISTS(SELECT value from GXGlobalParam WITH (NOLOCK) where name = @LastCollectionAttrName)
		UPDATE GXGlobalParam SET value =  CONVERT(nvarchar(max), @CurrCollectionDate,121) where name = @LastCollectionAttrName
	ELSE
	BEGIN
		DECLARE @nstring NVARCHAR(MAX)
		IF(@nreleaseId >= 15 )
		BEGIN
			SET @nstring ='insert into GXGlobalParam values(''' + @LastCollectionAttrName + ''', ''' + CONVERT(nvarchar(max), @CurrCollectionDate,121) + ''', dbo.GetUnixTime(GetUTCDate()), 0)'
			EXEC sp_executesql @nstring
		END
		ELSE IF(@nreleaseId = 14 )
		BEGIN
			insert into GXGlobalParam (name, value) values(@LastCollectionAttrName, CONVERT(nvarchar(max), @CurrCollectionDate,121))
		END
	END
END

SET NOCOUNT OFF
--------- END - GENERATED CODE ---------
