
--------- BEGIN - GENERATED CODE, PLEASE DO NOT MODIFY ---------
SET NOCOUNT ON

BEGIN TRY

DECLARE @LogDate AS BIGINT = dbo.GetUnixTime(GETUTCDATE())
DECLARE @queryId AS INTEGER = 174
DECLARE @surveyXML NVARCHAR(MAX)

--------- END - GENERATED CODE ---------

--------- BEGIN SURVEY QUERY ---------

--------- Insert your SQL statements here 
-- Query Name: Backup Job Statistics Operation
-- Description: Backup Success and failure statistics


DECLARE	@TimeZoneBias	INT = DATEDIFF(SECOND, GETUTCDATE(), GETDATE())
 
DECLARE @csTimeZone    NVARCHAR(1024) = ''
SELECT  @csTimeZone = dbo.GetClientTimeZone(2)

IF ISNULL(@csTimeZone, '') = ''
BEGIN
    SELECT @csTimeZone = timeZone FROM APP_CommCell WITH (NOLOCK) WHERE id = 2
    SELECT @csTimeZone = TimeZoneStdName FROM SchedTimeZone WITH (NOLOCK)
    WHERE  TimeZoneName = SUBSTRING(@csTimeZone, CHARINDEX(':', @csTimeZone, CHARINDEX(':', @csTimeZone, 0) + 1) + 1, 255)
END

DECLARE @nreleaseId INT =1
SET @nreleaseId =(SELECT releaseId from APP_Client WITH (NOLOCK) where id =2)

DECLARE @LastCollectionAttrName VARCHAR(256)

-- Check if any special group to consider for data collection.
-- Get the list of client group ids if exists
DECLARE @groupStr varchar(256);
DECLARE @groupStrName Nvarchar(MAX)='';
DECLARE @isPrivateRunning varchar(256)='';
DECLARE @freequencyMode	 NVARCHAR(MAX) ='0';
DECLARE @nstring NVARCHAR(MAX)
DECLARE @EndTime AS BIGINT

IF EXISTS(SELECT * FROM tempdb.dbo.sysobjects WHERE ID = OBJECT_ID(N'tempdb..#MetricsInputParams'))
BEGIN
    SELECT @freequencyMode = mode from #MetricsInputParams
END
IF EXISTS(SELECT name FROM GXGlobalParam WITH (NOLOCK) WHERE name = 'CommservSurveyRunning')
BEGIN
	SELECT @isPrivateRunning = value from GXGlobalParam WITH (NOLOCK)  where name ='CommservSurveyRunning'
END

IF ((@isPrivateRunning = 'Metrics Reporting') OR (@freequencyMode = '1'))
BEGIN
	SELECT @groupStr = value from GXGlobalParam WITH (NOLOCK) where name ='CommservSurveyPrivateSpecialClientGroup'
	SET @LastCollectionAttrName = 'CommservSurveyPrivateLastDedupedBackupCollectionTime'
END
ELSE
BEGIN
	IF object_id('tempdb.dbo.#GlobalParam') is not null DROP TABLE #GlobalParam 
	CREATE TABLE #GlobalParam (name NVARCHAR(64))
	
	IF @nreleaseId >= 15
	BEGIN
		SET @nstring = N'INSERT INTO #GlobalParam SELECT name FROM GXGlobalParam WITH (NOLOCK) WHERE name = ''EnableDedupeSavingTrendForPublicMetrics'' AND value = ''1'' AND modified = 0'
		EXEC sp_executesql @nstring
	END
	ELSE
		INSERT INTO #GlobalParam SELECT name FROM GXGlobalParam WITH (NOLOCK) WHERE name = 'EnableDedupeSavingTrendForPublicMetrics' AND CAST(value AS NVARCHAR(MAX)) = '1'

	IF NOT EXISTS (SELECT name FROM #GlobalParam)
	BEGIN
		SET @EndTime = dbo.GetUnixTime(GETUTCDATE())
		SET @outputXML = 
		(
			SELECT
				@queryId AS '@QueryId',
				@EndTime AS '@LogDate',
				(@EndTime - @LogDate) AS '@QueryRunningTime',
				NULL
			FOR XML PATH('Rpt_CSSXMLDATA')
		)
		RETURN
	END

	SELECT @groupStr = value from GXGlobalParam WITH (NOLOCK) where name ='CommservSurveySpecialClientGroup'
	SET @LastCollectionAttrName = 'CommservSurveyPublicLastDedupedBackupCollectionTime'
END

SET @groupStr = @groupStr + ',';
declare @includeGroups table(groupID int);
DECLARE @endIndex integer=0
DECLARE @startIndex integer=0
DECLARE @groupId integer        

SET @endIndex = CHARINDEX(',', @groupStr, @startIndex)
  
WHILE(@endIndex IS NOT NULL AND @endIndex <> 0)
BEGIN
	SET @groupId = CAST(SUBSTRING(@groupStr,@startIndex,@endIndex-@startIndex) AS INT)
	if(@groupId > 0)
	BEGIN
		insert into @includeGroups values(@groupId);
		DECLARE @tmpStr NVARCHAR(100);
		SELECT @tmpStr = NAME FROM APP_ClientGroup WITH (NOLOCK) WHERE id = @groupId;
		IF(@tmpStr IS NOT NULL)
			SET @groupStrName = @groupStrName + ', ' + @tmpStr
	END
	SET @startIndex = @endIndex + 1
	SET @endIndex = CHARINDEX(',', @groupStr, @startIndex)
END

DECLARE @specialGroupExists INT  =0
DECLARE @includeClients TABLE (clientId INT);

IF EXISTS (SELECT id FROM app_clientgroup WITH (NOLOCK) join @includeGroups on id=groupID)
BEGIN
	SET @specialGroupExists =1
	
	INSERT INTO @includeClients
	SELECT DISTINCT CGA.clientId 
	FROM @includeGroups CG INNER JOIN APP_ClientGroupAssoc CGA WITH (NOLOCK) ON CGA.clientGroupId = CG.groupID	
END

DECLARE @IncludedAppTypeIds TABLE (appTypeId INT)

DECLARE @ExcludedAppIds TABLE (appId INT)

INSERT INTO @ExcludedAppIds
SELECT componentNameId FROM APP_subclientProp WITH (NOLOCK) WHERE attrName IN ('DDB Backup', 'Index SubClient', 'SILO Copy ID') AND attrVal <> '0' AND modified = 0
UNION
SELECT id FROM APP_Application WITH (NOLOCK) 
WHERE clientId IN (SELECT componentNameId FROM APP_ClientProp WITH (NOLOCK) WHERE attrName = 'Content Index Server' AND attrVal = '1' AND modified = 0)

INSERT INTO @IncludedAppTypeIds
SELECT DISTINCT appTypeId FROM APP_Application WITH (NOLOCK) 

-- Get the last collection time
DECLARE @CurrCollectionDate DATE = DATEADD(DAY, DATEDIFF(DAY, 0, GETDATE()), 0)
DECLARE @PrevCollectionDate DATE
DECLARE	@dtDay              DATE

IF object_id('tempdb.dbo.#TimeRange') is not null DROP TABLE #TimeRange
CREATE TABLE #TimeRange (RangeBeginDT DATE, RangeBegin INT, RangeEnd INT)

SELECT @PrevCollectionDate = CAST(CAST(value AS NVARCHAR(256)) AS DATE) from GXGlobalParam WITH (NOLOCK) where name = @LastCollectionAttrName

IF @PrevCollectionDate IS NULL
	SET @PrevCollectionDate = DATEADD(MONTH, DATEDIFF(MONTH, 0, GETDATE())-3, 0)

DECLARE @fromDt DATETIME
DECLARE @toDt DATETIME

SET     @dtDay  = @CurrCollectionDate
WHILE   @dtDay >= @PrevCollectionDate
BEGIN

	SET @fromDt = @dtDay
	SET @toDt = DATEADD(DAY, 1, @dtDay)
	
	IF OBJECT_ID('IsInvalidTimeManaged') IS NOT NULL
	BEGIN
		WHILE dbo.IsInvalidTimeManaged(@fromDt, @csTimeZone) = 1
		BEGIN
			SET @fromDt = DATEADD(HOUR, 1, @fromDt)
		END
		
		WHILE dbo.IsInvalidTimeManaged(@toDt, @csTimeZone) = 1
		BEGIN
			SET @toDt = DATEADD(HOUR, 1, @toDt)
		END
	END

	INSERT INTO #TimeRange 
	VALUES (@dtDay, 
		dbo.GetUnixTime(dbo.LocalToUTCTime(CONVERT(DATETIME, @fromDt), @csTimeZone)), 
		dbo.GetUnixTime(dbo.LocalToUTCTime(CONVERT(DATETIME, @toDt), @csTimeZone)) - 1)

	SET @dtDay = DATEADD(DAY, -1, @dtDay)
END


IF object_id('tempdb.dbo.#DedupedBackupSize') is not null DROP TABLE #DedupedBackupSize
CREATE TABLE #DedupedBackupSize
(
	RangeBegin DATE,
	AppId INT,
	IsFullBackup INT,
	PrimaryCopyId INT,
	BackupSize BIGINT,
	DataWritten BIGINT
)

IF object_id('tempdb.dbo.#DedupedPrimaryCopy') is not null DROP TABLE #DedupedPrimaryCopy
CREATE TABLE #DedupedPrimaryCopy
(
	ArchGroupId INT,
	PrimaryCopyId INT
)

INSERT INTO #DedupedPrimaryCopy
SELECT AGC.archGroupId, AGC.id
FROM   archGroupCopy AGC WITH (NOLOCK) INNER JOIN archGroup AG WITH (NOLOCK) 
	ON AGC.archGroupId = AG.id AND AGC.id = AG.defaultCopy AND ((AGC.dedupeFlags & 262144 /*$$(CVA_SIDB_STORE_ENABLED_FLAG)*/) > 0)

IF (@specialGroupExists = 0)
BEGIN
	INSERT INTO #DedupedBackupSize 
	SELECT  R.RangeBeginDT, B.appId, CASE WHEN B.bkpLevel IN (1, 64, 128, 16384, 1024, 32768) THEN 1 ELSE 0 END, C.PrimaryCopyId, 
		SUM(B.totalUncompBytes), 0
	FROM #TimeRange R
		INNER JOIN JMBkpStats B WITH (NOLOCK) ON B.servEndDate >= R.RangeBegin AND B.servEndDate <= R.RangeEnd
			AND B.opType IN (4, 14, 18, 30, 43, 59, 65, 76, 87, 91, 94, 97, 98, 101) 
			AND B.status IN (1, 3, 14) AND B.totalUncompBytes > 0
		INNER JOIN #DedupedPrimaryCopy C ON C.ArchGroupId IN (B.dataArchGrpId, B.logArchGrpId)
	WHERE B.appId NOT IN (SELECT appId FROM @ExcludedAppIds)
	GROUP BY R.RangeBeginDT, B.appId, CASE WHEN B.bkpLevel IN (1, 64, 128, 16384, 1024, 32768) THEN 1 ELSE 0 END, C.PrimaryCopyId

	;WITH SizeOnMedia (RangeBegin, AppId, IsFullBackup, PrimaryCopyId, DataWritten) AS
	(
		SELECT  R.RangeBeginDT, B.appId, CASE WHEN B.bkpLevel IN (1, 64, 128, 16384, 1024, 32768) THEN 1 ELSE 0 END, J.archGrpCopyId, 
			SUM(J.sizeOnMedia)
		FROM #TimeRange R
			INNER JOIN JMBkpStats B WITH (NOLOCK) ON B.servEndDate >= R.RangeBegin AND B.servEndDate <= R.RangeEnd
				AND B.opType IN (4, 14, 18, 30, 43, 59, 65, 76, 87, 91, 94, 97, 98, 101) 
				AND B.status IN (1, 3, 14) AND B.totalUncompBytes > 0
			INNER JOIN JMJobDataStats J WITH (NOLOCK) ON J.jobId = B.jobId AND J.commCellId = B.commCellId
			INNER JOIN #DedupedPrimaryCopy C ON C.ArchGroupId IN (B.dataArchGrpId, B.logArchGrpId)
		WHERE B.appId NOT IN (SELECT appId FROM @ExcludedAppIds)
		GROUP BY R.RangeBeginDT, B.appId, CASE WHEN B.bkpLevel IN (1, 64, 128, 16384, 1024, 32768) THEN 1 ELSE 0 END, J.archGrpCopyId
	)
	UPDATE D SET DataWritten = S.DataWritten
	FROM   #DedupedBackupSize D INNER JOIN SizeOnMedia S 
		ON D.RangeBegin = S.RangeBegin AND D.AppId = S.AppId AND D.IsFullBackup = S.IsFullBackup AND D.PrimaryCopyId = S.PrimaryCopyId
END 
ELSE
BEGIN
	INSERT INTO #DedupedBackupSize 
	SELECT  R.RangeBeginDT, B.appId, CASE WHEN B.bkpLevel IN (1, 64, 128, 16384, 1024, 32768) THEN 1 ELSE 0 END, C.PrimaryCopyId, 
		SUM(B.totalUncompBytes), 0
	FROM #TimeRange R
		INNER JOIN JMBkpStats B WITH (NOLOCK) ON B.servEndDate >= R.RangeBegin AND B.servEndDate <= R.RangeEnd
			AND B.opType IN (4, 14, 18, 30, 43, 59, 65, 76, 87, 91, 94, 97, 98, 101) 
			AND B.status IN (1, 3, 14) AND B.totalUncompBytes > 0
		INNER JOIN APP_Application A WITH (NOLOCK) ON B.appId= A.id
		INNER JOIN @includeClients CL ON CL.clientId = A.clientId
		INNER JOIN #DedupedPrimaryCopy C ON C.ArchGroupId IN (B.dataArchGrpId, B.logArchGrpId)
	WHERE B.appId NOT IN (SELECT appId FROM @ExcludedAppIds)
	GROUP BY R.RangeBeginDT, B.appId, CASE WHEN B.bkpLevel IN (1, 64, 128, 16384, 1024, 32768) THEN 1 ELSE 0 END, C.PrimaryCopyId

	;WITH SizeOnMedia (RangeBegin, AppId, IsFullBackup, PrimaryCopyId, DataWritten) AS
	(
		SELECT  R.RangeBeginDT, B.appId, CASE WHEN B.bkpLevel IN (1, 64, 128, 16384, 1024, 32768) THEN 1 ELSE 0 END, J.archGrpCopyId, 
			SUM(J.sizeOnMedia)
		FROM #TimeRange R
			INNER JOIN JMBkpStats B WITH (NOLOCK) ON B.servEndDate >= R.RangeBegin AND B.servEndDate <= R.RangeEnd
				AND B.opType IN (4, 14, 18, 30, 43, 59, 65, 76, 87, 91, 94, 97, 98, 101) 
				AND B.status IN (1, 3, 14) AND B.totalUncompBytes > 0
			INNER JOIN JMJobDataStats J WITH (NOLOCK) ON J.jobId = B.jobId AND J.commCellId = B.commCellId
			INNER JOIN APP_Application A WITH (NOLOCK) ON B.appId= A.id
			INNER JOIN @includeClients CL ON CL.clientId = A.clientId
			INNER JOIN #DedupedPrimaryCopy C ON C.ArchGroupId IN (B.dataArchGrpId, B.logArchGrpId)
		WHERE B.appId NOT IN (SELECT appId FROM @ExcludedAppIds)
		GROUP BY R.RangeBeginDT, B.appId, CASE WHEN B.bkpLevel IN (1, 64, 128, 16384, 1024, 32768) THEN 1 ELSE 0 END, J.archGrpCopyId
	)
	UPDATE D SET DataWritten = S.DataWritten
	FROM   #DedupedBackupSize D INNER JOIN SizeOnMedia S 
		ON D.RangeBegin = S.RangeBegin AND D.AppId = S.AppId AND D.IsFullBackup = S.IsFullBackup AND D.PrimaryCopyId = S.PrimaryCopyId
END
 	
SET @surveyXML = (
	SELECT 
		RangeBegin AS '@RangeBegin',
		AppId AS '@AppId',
		IsFullBackup AS '@IsFullBackup',
		PrimaryCopyId AS '@PrimaryCopyId',
		BackupSize AS '@BackupSize',
		DataWritten AS '@DataWritten'
    FROM #DedupedBackupSize
    ORDER BY RangeBegin, AppId, IsFullBackup
FOR XML PATH ('DedupedBackupSize'))

DROP TABLE #DedupedBackupSize
DROP TABLE #DedupedPrimaryCopy


	
--------- END SURVEY QUERY ---------

SET @EndTime = dbo.GetUnixTime(GETUTCDATE())
SET @outputXML = 
(
	SELECT
		@queryId AS '@QueryId',
		@EndTime AS '@LogDate',
		(@EndTime - @LogDate) AS '@QueryRunningTime',
		@surveyXML
	FOR XML PATH('Rpt_CSSXMLDATA')
)

--SELECT CAST(@surveyXML AS XML)


	 
END TRY
BEGIN CATCH	 
  DECLARE @ErrorMessage NVARCHAR(4000);  
  SET @ErrorMessage = ERROR_MESSAGE();
  RAISERROR(@ErrorMessage,16,1);
RETURN
END CATCH

--Update the last collection time
IF EXISTS(SELECT value from GXGlobalParam WITH (NOLOCK) where name = @LastCollectionAttrName)
	UPDATE GXGlobalParam SET value = CAST(@CurrCollectionDate as NVARCHAR(MAX)) where name = @LastCollectionAttrName
ELSE
BEGIN
	IF @nreleaseId >= 15
	BEGIN
		SET @nstring = N'insert into GXGlobalParam values(''' + @LastCollectionAttrName + ''', ''' + CAST(@CurrCollectionDate as NVARCHAR(MAX)) + ''', dbo.GetUnixTime(GetUTCDate()), 0)'
		EXEC sp_executesql @nstring
	END
	ELSE
	BEGIN
		insert into GXGlobalParam (name, value) values(@LastCollectionAttrName, CAST(@CurrCollectionDate as NVARCHAR(MAX)))
	END
END

SET NOCOUNT OFF
--------- END - GENERATED CODE ---------
