--- Please follow the below comments to insert SQL statements.
-- Client version query
--------- BEGIN - GENERATED CODE, PLEASE DO NOT MODIFY ---------

SET NOCOUNT ON
SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED

DECLARE @LogDate AS BIGINT = dbo.GetUnixTime(GETUTCDATE())
DECLARE @queryId AS INTEGER = 155
DECLARE @surveyXML NVARCHAR(MAX)

--------- BEGIN SURVEY QUERY ---------

IF OBJECT_ID('tempdb..#BackupTask') IS NOT NULL
    DROP TABLE #BackupTask

CREATE TABLE #BackupTask (taskId INT, taskName NVARCHAR(255), taskType INT, disabled INT, subTaskId INT, subTaskName NVARCHAR(255), maxRunningSec INT)

INSERT  INTO #BackupTask
SELECT  DISTINCT T.taskId, T.taskName, T.taskType, T.disabled, ST.SubTaskId, ST.subTaskName, 0
FROM    TM_SubTask ST
        INNER JOIN TM_Task T
            ON T.taskId = ST.taskId AND ST.subTaskType = 2
            AND T.deleted = 0 AND T.invalid = 0 AND T.uninstalled = 0 
        INNER JOIN TM_SubTaskOptions STO
            ON STO.subTaskId = ST.SubTaskId
            AND STO.optionId = 458405394 AND STO.value IN ('1', '2', '3', '4', '6', '7')
WHERE   T.taskType IN (2, 4)
UNION
SELECT  DISTINCT T.taskId, T.taskName, T.taskType, T.disabled, ST.SubTaskId, ST.subTaskName, 0
FROM    TM_SubTask ST
        INNER JOIN TM_Task T
            ON T.taskId = ST.taskId AND ST.subTaskType = 1 AND ST.operationType=4002 --- DRBACKUP = 4002,
            AND T.deleted = 0 AND T.invalid = 0 AND T.uninstalled = 0         
WHERE   T.taskType=2

UPDATE  #BackupTask SET maxRunningSec = CAST(T.value AS INT)
FROM    TM_joboptions T
WHERE   #BackupTask.subTaskId = T.subTaskId
    AND T.optionId = 65063328 AND T.modified = 0 AND T.subTaskId IN (
        SELECT subTaskId FROM TM_joboptions WHERE optionId = 1374792515 AND value = '1' AND modified = 0)

IF OBJECT_ID('tempdb..#TaskAssoc') IS NOT NULL
    DROP TABLE #TaskAssoc

CREATE TABLE #TaskAssoc (taskId INT, taskName NVARCHAR(255), taskType INT, disabled INT, subTaskId INT, subTaskName NVARCHAR(255), maxRunningSec INT, 
        assocType INT, clientGroupId INT, clientId INT, appTypeId INT, instanceId INT, backupsetId INT, appId INT, exclude INT)

INSERT  INTO #TaskAssoc
SELECT  DISTINCT T.taskId, T.taskName, T.taskType, T.disabled, T.subTaskId, ISNULL(T.subTaskName, ''), T.maxRunningSec, 
        AE.assocType, AE.clientGroupId, AE.clientId, 
        AE.apptypeId, AE.instanceId, AE.backupsetId, AE.subclientId, AE.exclude
FROM    TM_AssocEntity AE
        INNER JOIN #BackupTask T ON AE.taskId = T.taskId
WHERE   (T.taskType = 2 OR T.taskType = 4 AND AE.assocType NOT IN (2, 28))
        AND AE.taskId NOT IN (SELECT DISTINCT taskId FROM TM_AssocFilter WHERE filter_type = 2 AND filter_value = 124)
UNION
SELECT  DISTINCT T.taskId, T.taskName, T.taskType, T.disabled, T.SubTaskId, T.subTaskName, T.maxRunningSec, 
        AE.assocType, AE.clientGroupId, 0, 
        CASE WHEN ISNULL(AF.filter_type, 0) = 1 THEN ISNULL(ATGA.appTypeId, 0) ELSE ISNULL(AF.filter_value, 0) END, 0, 0, 0, AE.exclude
FROM    TM_AssocEntity AE
        INNER JOIN #BackupTask T ON AE.taskId = T.taskId AND T.taskType = 4
        LEFT OUTER JOIN TM_AssocFilter AF ON AF.taskId = T.taskId
        LEFT OUTER JOIN APP_AppTypeGroup ATG ON ATG.appTypeGroupId = AF.filter_value AND AF.filter_type = 1
        LEFT OUTER JOIN APP_AppTypeGroupAssoc ATGA ON ATGA.appGroupId = ATG.appTypeGroupId
WHERE   AE.assocType IN (2, 28) AND (ISNULL(AF.filter_type, 0) <> 2 OR ISNULL(AF.filter_value, 0) <> 124)
UNION
SELECT  DISTINCT T.taskId, T.taskName, T.taskType, T.disabled, T.subTaskId, ISNULL(T.subTaskName, ''), T.maxRunningSec, 
        0, 0, 0,0, 0, 0, 0, 0
FROM    #BackupTask T       
INNER JOIN TM_SubTask ST ON T.subTaskId = ST.subTaskId
AND ST.subTaskType = 1 AND ST.operationType=4002

IF OBJECT_ID('tempdb..#BackupTask') IS NOT NULL
    DROP TABLE #BackupTask

DECLARE @CStimezone varchar(128) = dbo.GetClientTimeZone(2)

SET @surveyXML = (SELECT
    (SELECT
        TASK.taskname AS '@schedulePolicy',
        TASK.subtaskname AS '@scheduleName',
        TASK.disabled AS '@disabled',
        TASK.maxRunningSec AS '@maxRunningSec', 
        
        CASE CONVERT(int, SOPT.value)
            WHEN 1 THEN 'Full'
            WHEN 2 THEN 'Incremental'
            WHEN 3 THEN 'Differential'
            WHEN 4 THEN 'Synthetic Full'
            WHEN 5 THEN 'ASR'
            WHEN 6 THEN 'Transaction Log'
            WHEN 7 THEN 'Pre-Selected Backup Type'
            WHEN 8 THEN 'Snapshot'
            WHEN 9 THEN 'Create OSSV Replica(s)'
            WHEN 10 THEN 'Incrementally update OSSV volumes'
            WHEN 11 THEN 'SRM Analysis'
            WHEN 12 THEN 'SRM Discovery'
            ELSE 'Unknown'
        END AS '@schedBackupType',
        
        CASE PAT.freq_type
            WHEN 1   THEN 'One time'
            WHEN 4   THEN 'Daily'
            WHEN 8   THEN 'Weekly'
            WHEN 16  THEN 'Monthly'
            WHEN 32  THEN 'Monthly'
            WHEN 64  THEN 'Yearly'
            WHEN 128 THEN 'Yearly'
            ELSE 'Unknown'
        END AS '@schedPattern',
        
        CASE PAT.freq_type
            WHEN 128 THEN 'Every 1'
            ELSE 'Every ' + CONVERT(varchar(2),PAT.freq_recurrence_factor)
        END AS '@schedInterval',

        CASE PAT.freq_type
            WHEN 1 THEN 'One Time'
            WHEN 4 THEN 'Daily'
            WHEN 8 THEN LTRIM(t3.sunday + ' ' + t3.monday + ' ' + t3.tuesday + ' ' + t3.wednesday + ' ' + t3.thursday + ' ' + t3.friday + ' ' + t3.saturday)
            WHEN 16 THEN CONVERT(varchar(2), PAT.freq_interval) 
            WHEN 32 THEN 
                CASE PAT.freq_relative_interval
                    WHEN 5 THEN 'Last'
                    ELSE LTRIM(CONVERT(char(1), (PAT.freq_relative_interval)) +
                        CASE PAT.freq_relative_interval WHEN 1 THEN 'st' WHEN 2 THEN 'nd' WHEN 3 THEN 'rd' ELSE 'th' END)
                END 
                + ' ' +
                CASE PAT.freq_interval
                    WHEN 1 THEN 'Sunday'
                    WHEN 2 THEN 'Monday'
                    WHEN 3 THEN 'Tuesday'
                    WHEN 4 THEN 'Wednesday'
                    WHEN 5 THEN 'Thursday'
                    WHEN 6 THEN 'Friday'
                    WHEN 7 THEN 'Saturday'
                    WHEN 8 THEN 'Week Day'
                    WHEN 9 THEN 'Day'
                    WHEN 10 THEN 'Weekend Day'
                    ELSE 'Unknown'
                END
            WHEN 64 THEN 
                CONVERT(varchar(2), PAT.freq_interval) 
                + ' of ' +
                CASE PAT.freq_recurrence_factor
                    WHEN 1 THEN 'January'
                    WHEN 2 THEN 'February'
                    WHEN 3 THEN 'March'
                    WHEN 4 THEN 'April'
                    WHEN 5 THEN 'May'
                    WHEN 6 THEN 'June'
                    WHEN 7 THEN 'July'
                    WHEN 8 THEN 'August'
                    WHEN 9 THEN 'September'
                    WHEN 10 THEN 'October'
                    WHEN 11 THEN 'November'
                    WHEN 12 THEN 'December'
                END
            WHEN 128 THEN
                CASE PAT.freq_relative_interval 
                WHEN 5 THEN 'Last'
                ELSE LTRIM(CONVERT(char(1), (PAT.freq_relative_interval)) +
                  CASE  PAT.freq_relative_interval WHEN 1 THEN 'st' WHEN 2 THEN 'nd' WHEN 3 THEN 'rd' ELSE 'th' END)
                END 
                + ' ' +
                CASE PAT.freq_interval
                    WHEN 1 THEN 'Sunday'
                    WHEN 2 THEN 'Monday'
                    WHEN 3 THEN 'Tuesday'
                    WHEN 4 THEN 'Wednesday'
                    WHEN 5 THEN 'Thursday'
                    WHEN 6 THEN 'Friday'
                    WHEN 7 THEN 'Saturday'
                    WHEN 8 THEN 'Week Day'
                    WHEN 9 THEN 'Day'
                    WHEN 10 THEN 'Weekend Day'
                    ELSE 'Unknown'
                END
                + ' ' + 'of' + ' ' +
                CASE PAT.freq_recurrence_factor
                    WHEN 1 THEN 'January'
                    WHEN 2 THEN 'February'
                    WHEN 3 THEN 'March'
                    WHEN 4 THEN 'April'
                    WHEN 5 THEN 'May'
                    WHEN 6 THEN 'June'
                    WHEN 7 THEN 'July'
                    WHEN 8 THEN 'August'
                    WHEN 9 THEN 'September'
                    WHEN 10 THEN 'October'
                    WHEN 11 THEN 'November'
                    WHEN 12 THEN 'December'
                END
            ELSE ' '
        END AS '@schedBackupDay',
        
        CONVERT(varchar(12), DATEADD(second, PAT.active_start_time , '01/01/1970 00:00:00AM'), 108 ) AS '@schedBackupTime',
        CASE WHEN RT.nextRunTime IS NULL THEN NULL ELSE dbo.UTCToLocalStringTime(RT.nextRunTime, @CStimezone) END AS '@schedNextBackupTime',
        TASK.clientGroupId AS '@clientGroupId',
        TASK.clientid AS '@clientId',
        TASK.appTypeId AS '@appTypeId',
        TASK.instanceId AS '@instanceId',
        TASK.backupsetId AS '@backupsetId',
        TASK.appId AS '@appId',
        TASK.assocType AS '@assocType',
        TASK.exclude AS '@exclude'
    FROM
        #TaskAssoc TASK
        INNER JOIN TM_PatternAssoc AS PATASSOC ON PATASSOC.subTaskId = TASK.subTaskId
        INNER JOIN TM_Pattern AS PAT ON PAT.patternId = PATASSOC.patternId
		INNER JOIN TM_SubTask AS ST ON ST.subTaskId = TASK.subTaskId
        LEFT OUTER JOIN TM_RunTime AS RT ON RT.patternId = PAT.patternId        
        LEFT OUTER JOIN TempCvView3 t3 ON PAT.PatternId = t3.patternid
		LEFT JOIN TM_SubTaskOptions AS SOPT ON TASK.subTaskId = SOPT.subTaskId AND ST.operationType <> 4002
    WHERE
        (ST.operationType = 4002 OR SOPT.optionId = 458405394)   
        AND ISNULL(RT.processed, 0) = 0 AND ISNULL(RT.firing, 0) =  0
    FOR XML PATH('Schedule'), TYPE),

    (SELECT O.appTypeType AS '@appTypeId', 
            MAX(P.totalRunningTime) AS '@maxRunningSec'
    FROM    JMPhase P INNER JOIN JMOpTable O ON P.opTableId = O.id AND O.operation = 4
    WHERE   P.enableTotalRunningTime = 1 AND P.name = 'Backup'
    GROUP BY O.appTypeType
    FOR XML PATH('MaxRunningTime'), TYPE),

    (SELECT startYear AS '@startYear', startMonth AS '@startMonth', startDay AS '@startDay', 
            startHour AS '@startHour', startMinute AS '@startMinute', startSecond AS '@startSecond', 
            endYear AS '@endYear', endMonth AS '@endMonth', endDay AS '@endDay', 
            endHour AS '@endHour', endMinute AS '@endMinute', endSecond AS '@endSecond',
            description AS '@description', groupId AS '@clientGroupId', clientId AS '@clientId'
    FROM    SchedHoliday
    FOR XML PATH('Holiday'), TYPE)

FOR XML PATH ('')
-- Replace <<RESULTS_NAME>> with specific name
)

IF OBJECT_ID('tempdb..#TaskAssoc') IS NOT NULL
    DROP TABLE #TaskAssoc

--------- END SURVEY QUERY ---------

--------- BEGIN - GENERATED CODE, PLEASE DO NOT MODIFY ---------

DECLARE @EndTime AS BIGINT = dbo.GetUnixTime(GETUTCDATE())
SET @outputXML = 
(
	SELECT
		@queryId AS '@QueryId',
		@EndTime AS '@LogDate',
		(@EndTime - @LogDate) AS '@QueryRunningTime',
		@surveyXML
	FOR XML PATH('Rpt_CSSXMLDATA')
)
SET NOCOUNT OFF

--------- END - GENERATED CODE ---------
