--- Please follow the below comments to insert SQL statements.
-- Client version query
--------- BEGIN - GENERATED CODE, PLEASE DO NOT MODIFY ---------

SET NOCOUNT ON
SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED

DECLARE @LogDate AS BIGINT = dbo.GetUnixTime(GETUTCDATE())
DECLARE @EndTime AS BIGINT 
DECLARE @queryId AS INTEGER = 154
DECLARE @surveyXML NVARCHAR(MAX)

IF OBJECT_ID('tempdb.dbo.#GlobalFilter') IS NOT NULL DROP TABLE #GlobalFilter
CREATE TABLE #GlobalFilter (name NVARCHAR(64), value NVARCHAR(MAX))

IF COL_LENGTH('GXGlobalParam', 'modified') IS NOT NULL
	EXEC sp_executesql N'INSERT INTO #GlobalFilter SELECT name, CAST(value AS NVARCHAR(MAX)) FROM GXGlobalParam WHERE name LIKE ''%Filters%'' AND CAST(value AS NVARCHAR(MAX)) <> '''' AND modified = 0'
ELSE
	INSERT INTO #GlobalFilter SELECT name, CAST(value AS NVARCHAR(MAX)) FROM GXGlobalParam WHERE name LIKE '%Filters%' AND CAST(value AS NVARCHAR(MAX)) <> ''

DECLARE	@csReleaseId INT
SELECT	@csReleaseId = releaseId FROM APP_Client WHERE id = 2

IF @csReleaseId > 16 
OR @csReleaseId = 16 AND EXISTS (SELECT 1 FROM simInstalledPackages WHERE ClientId = 2 AND HighestSP >= 12)
BEGIN
	SET @surveyXML = (SELECT
		(SELECT
			name  AS '@name',
			value AS '@value'
		FROM 	#GlobalFilter
		FOR XML PATH('GlobalFilter'), TYPE)
	
	FOR XML PATH (''))

	SET @EndTime = dbo.GetUnixTime(GETUTCDATE())
	SET @outputXML = 
	(
		SELECT
			@queryId AS '@QueryId',
			@EndTime AS '@LogDate',
			(@EndTime - @LogDate) AS '@QueryRunningTime',
			@surveyXML
		FOR XML PATH('Rpt_CSSXMLDATA')
	)
 	RETURN
END

--------- BEGIN SURVEY QUERY ---------

CREATE TABLE #TblContent (appId INT, Type INT, content NVARCHAR(MAX), created INT, excludeStr NVARCHAR(MAX), exceptStr NVARCHAR(MAX))

CREATE TABLE #TblSubclient (
	appId INT, clientId INT, appTypeId INT, instance INT, backupset INT, subclientName NVARCHAR(128), subclientStatus INT, 
	dataArchGrpId INT, logArchGrpId INT, subclientPolicyAppId INT, excludeStr NVARCHAR(MAX), exceptStr NVARCHAR(MAX),useLocalContent INT DEFAULT(0))

INSERT INTO #TblSubclient (
		appId, clientId, appTypeId, instance, backupset, subclientName, subclientStatus, 
		dataArchGrpId, logArchGrpId, subclientPolicyAppId)
SELECT	A.id, clientId, appTypeId, instance, backupset, subclientName, subclientStatus, 
		dataArchGrpId, logArchGrpId, CAST(ISNULL(SCP.attrVal, '0') AS INT)
FROM	App_Application A
		LEFT OUTER JOIN APP_SubClientProp SCP
		ON SCP.componentNameId = A.id AND SCP.attrName = 'Associated subclient Policy' AND SCP.modified = 0
WHERE	A.subclientStatus&(16|32) = 0 
	AND (A.appTypeId < 600 OR A.appTypeId = 1030) AND A.appTypeId NOT IN (72, 84, 85, 107, 121, 122, 127) 
	AND (A.appTypeId NOT IN (24, 25, 40, 47, 48, 50, 65, 66, 67, 68, 73, 75, 76) OR A.subclientStatus&8 = 0)

CREATE CLUSTERED INDEX #TblSubclient_appId_idx ON #TblSubclient (appId)

UPDATE  TSC SET useLocalContent = attrval
FROM #TblSubclient TSC
INNER JOIN APP_SubclientProp SCP ON SCP.componentNameId = TSC.appId AND attrname='Use Local Content' AND modified = 0

INSERT	INTO #TblContent
SELECT	SCP.componentNameId, 2, '', 0, 
		(SELECT	DISTINCT a.fileName + ' ' AS [text()] 
		FROM	APP_ScFilterFile a 
		WHERE	a.modified = 0 AND type = 3 AND a.componentNameId = SCP.componentNameID FOR XML PATH ('')),
		(SELECT	DISTINCT b.FileName + ' ' AS [text()] 
		FROM	APP_ScFilterFile b 
		WHERE	b.modified = 0 AND type = 2 AND b.componentNameId = SCP.componentNameID FOR XML PATH (''))
FROM	APP_ScFilterFile SCP 
		INNER JOIN #TblSubclient S ON S.appID = SCP.componentNameId   
WHERE	SCP.modified = 0 AND SCP.fileName IS NOT NULL AND SCP.type IN (2,3) 
GROUP BY SCP.componentNameId 
	
INSERT	INTO #TblContent
SELECT	A.appId, 
		1, 
		F.fileName, 
		MAX(F.created), '', ''
FROM	#TblSubclient A
		INNER JOIN APP_SCFilterFile F ON A.appId = F.componentNameId AND F.type = 1 AND F.modified = 0
WHERE	(A.subclientPolicyAppId = 0 OR A.useLocalContent = 1 )  AND (A.subclientStatus & 0x10000) = 0 
	AND A.appTypeId NOT IN (2,4,5,8,9,14,15,16,22,23,45,53,54,56,57,59,60,61,67,68,70,72,80,81,104,105,106,128, 1030)
GROUP BY A.appId, F.fileName

INSERT	INTO #TblContent -- Subclient Policy
SELECT	A.appId, 
		1, 
		F.fileName, 
		MAX(F.created), '', ''
FROM	#TblSubclient A
		INNER JOIN APP_SCFilterFile F ON A.appId = F.componentNameId AND F.type = 1 AND F.modified = 0
WHERE	A.appTypeId = 1030
GROUP BY A.appId, F.fileName

INSERT	INTO #TblContent -- Documentum
SELECT	A.appId, 
		1, 
		(SELECT name FROM APP_Client WHERE id = SUBSTRING(filename, 1, CHARINDEX(' ', filename)-1)) + ' '
			+ REPLACE(SUBSTRING(filename, CHARINDEX(' ', filename) + 1, LEN(filename) - CHARINDEX(filename, ' ')), '+1',' '), 
		MAX(F.created), '', ''
FROM	#TblSubclient A
		INNER JOIN APP_SCFilterFile F ON A.appId = F.componentNameId AND F.type = 1 AND F.modified = 0
WHERE	A.subclientPolicyAppId = 0 AND A.appTypeId = 128
GROUP BY A.appId, F.fileName

INSERT	INTO #TblContent -- Recovery Director
SELECT	A.appId, 1, 
		ISNULL((SELECT	Path FROM QRMountPoint WHERE deviceNameId =	(
				SELECT	TOP 1 id FROM QRPhysicalDevice
				WHERE SNRVolumeId = CAST(SUBSTRING(filename, 1, CHARINDEX(NCHAR(0x0015), filename)-1) AS INT))), 'Unknown')
		+ ' -> '
		+ ISNULL(SUBSTRING(filename, CHARINDEX(NCHAR(0x0015), filename) + 1, CHARINDEX(NCHAR(0x0015), 
				 SUBSTRING(filename, CHARINDEX(NCHAR(0x0015), filename) + 1, 255)) -1), 'Unknown'),
		MAX(F.created), '', ''
FROM	#TblSubclient A
		INNER JOIN APP_SCFilterFile F ON A.appId = F.componentNameId AND F.type = 1 AND F.modified = 0
WHERE	A.subclientPolicyAppId = 0 AND A.appTypeId = 72
GROUP BY A.appId, F.fileName

INSERT	INTO #TblContent --SubClient content of SQL iDAs
SELECT	A.appId, 1, F.attrName, MAX(F.created), '', ''
FROM	#TblSubclient A
		INNER JOIN APP_SubClientProp F ON A.appId = F.componentNameId AND F.attrType IN (118, 119) AND F.modified = 0
WHERE	A.subclientPolicyAppId = 0 AND A.appTypeId IN (4, 16, 70, 81)
GROUP BY A.appId, F.attrName

INSERT	INTO #TblContent --SubClient content of Sybase iDAs
SELECT	A.appId, 1, F.attrName, MAX(F.created), '', ''
FROM	#TblSubclient A
		INNER JOIN APP_SubClientProp F ON A.appId = F.componentNameId AND F.attrType = 116 AND F.modified = 0
WHERE	A.subclientPolicyAppId = 0 AND A.appTypeId = 5
GROUP BY A.appId, F.attrName

INSERT	INTO #TblContent --SubClient content of Notes Document and Domino Mailbox Archiver iDAs
SELECT	A.appId, 1, F.attrName, MAX(F.created), '', ''
FROM	#TblSubclient A
		INNER JOIN APP_SubClientProp F ON A.appId = F.componentNameId AND F.modified = 0
WHERE	A.subclientPolicyAppId = 0 
	AND (A.appTypeId = 59 AND F.attrType = 102 OR A.appTypeId IN (60, 90) AND F.attrType = 101)
GROUP BY A.appId, F.attrName

INSERT	INTO #TblContent --SubClient content of Exchange MB iDAs
SELECT	A.appId, 1, 
		REPLACE(REPLACE(SUBSTRING(F.attrName, 1, CHARINDEX(NCHAR(0x12), F.attrName)-1), NCHAR(0x16), ''''), NCHAR(0x15), ''''), 
		MAX(F.created), '', ''
FROM	#TblSubclient A
		INNER JOIN APP_SubClientProp F ON A.appId = F.componentNameId AND F.attrType IN (111) AND F.modified = 0
WHERE	A.subclientPolicyAppId = 0 AND A.appTypeId IN (67, 68, 54, 8, 14, 56, 45, 57, 105)
GROUP BY A.appId, F.attrName

INSERT	INTO #TblContent --SubClient content of Exchange DB and MySQL iDAs
SELECT	A.appId, 1, '\'+F.attrName, MAX(F.created), '', ''
FROM	#TblSubclient A
		INNER JOIN APP_SubClientProp F ON A.appId = F.componentNameId AND F.modified = 0
WHERE	A.subclientPolicyAppId = 0 
	AND (A.appTypeId IN (9, 15, 53) AND F.attrType = 112 OR A.appTypeId = 104 AND F.attrType = 120)
GROUP BY A.appId, F.attrName

INSERT	INTO #TblContent --SubClient content of SMTP address for mailboxes
SELECT	A.appId, 1, CP.stringVal, MAX(CP.created), '', ''
FROM	#TblSubclient A
		INNER JOIN APP_SubClientProp SCP ON A.appId = SCP.componentNameId AND SCP.attrType IN (101, 111) AND SCP.modified = 0
		INNER JOIN APP_ComponentProp CP ON SCP.id = CP.componentId AND CP.propertyTypeId IN (1100, 1400) AND CP.modified = 0
		LEFT OUTER JOIN (SELECT appId FROM JMJobAction WHERE appId > 1 AND action = 1) D ON A.appId = D.appId
WHERE	A.subclientPolicyAppId = 0 AND D.appId IS NULL
	AND (A.dataArchGrpID > 1 OR A.logArchGrpID > 1) AND (A.subclientStatus & 6) = 0
GROUP BY A.appId, CP.stringVal

INSERT	INTO #TblContent --SubClient content of Oracle iDAs
SELECT	A.appId, 1, O.name, MAX(O.created), '', ''
FROM	#TblSubclient A,
		(SELECT	APP.id, OTS.name, OTS.created
		FROM	oracleTableSpaces OTS INNER JOIN APP_Application APP ON OTS.instId = APP.instance
		WHERE	APP.id NOT IN (SELECT subClientId FROM oracleObjects)
		UNION
		SELECT	oracleObjects.subClientId, oracleTableSpaces.name, oracleTableSpaces.created
		FROM	oracleObjects INNER JOIN oracleTableSpaces ON oracleObjects.objId = oracleTableSpaces.id
		WHERE	oracleObjects.type = 5 AND oracleTableSpaces.deleteFlag = 0
		) AS O
WHERE	A.subclientPolicyAppId = 0 AND A.appId = O.id AND A.appTypeId in (2,22,23,61,80)
GROUP BY A.appId, O.name

INSERT	INTO #TblContent --SubClient content of VSA clients
SELECT	A.appId, 1, F.attrVal, MAX(F.created), '', ''
FROM	#TblSubclient A
		INNER JOIN APP_SubClientProp F ON A.appId = F.componentNameId AND F.attrType IN (121) AND F.modified = 0
WHERE	A.subclientPolicyAppId = 0 AND A.appTypeId IN (106)
GROUP BY A.appId, F.attrVal

INSERT	INTO #TblContent -- Virtual Server
SELECT	A.appId, 1, 
		CASE WHEN dx.c.exist('children') = 1 
			 THEN 'Rule: Backup VM whose ' + 
				  STUFF(
					(SELECT (case c.x.value('@allOrAnyChildren','INT') when 1 then ' and ' when 0 then ' or ' end)
						+ (case c.x.value('@type','INT')
							when 1  then 'Server Host'
							when 2  then 'Resource Pool'
							when 3  then 'vApp'
							when 4  then 'Datacenter'
							when 5  then 'Folder'
							when 6  then 'Cluster'
							when 7  then 'Datastore'
							when 8  then 'DatastoreCluster'
							when 9  then 'VM'
							when 10 then 'VM Name'
							when 11 then 'VM Guest OS'
							when 12 then 'VM Guest Host Name'
							when 13 then 'Cluster Shared Volumes'
							when 14 then 'Local Disk'
							when 15 then 'Cluster Disk'
							when 18 then 'File Server'
							when 19 then 'Share'
							else 'Unknown' end)
						+ (case c.x.value('@equalsOrNotEquals', '[int]') when 1 then ' equals ' when 0 then ' does not match ' end)
						+ c.x.value('@displayName', 'nvarchar(512)')
					FROM vmXML.nodes('/VirtualServer_VMSubClientEntity/children/children') AS c(x) FOR xml path ('')
					),
					1,
					(case vmXML.value('(/VirtualServer_VMSubClientEntity/children/@allOrAnyChildren)[1]','INT') when 1 then 4 when 0 then 3 end),
					''
				)
			ELSE dx.c.value('@displayName', 'NVARCHAR(512)')
		END, 
		F.created, '', ''
FROM	#TblSubclient A
		INNER JOIN (
			SELECT	componentNameId, 
					CASE WHEN LEFT(attrVal, 5) = '<?xml' THEN CAST(SUBSTRING(attrVal, CHARINDEX('>', attrVal)+1, LEN(attrVal)) AS XML) 
						ELSE attrVal 
					END AS vmXML,
					created
			FROM	APP_SubClientProp
			WHERE	attrName = 'Virtual Server Dyanimc Content' AND attrType = 1 AND modified = 0
			) F ON A.appId = F.componentNameId
			CROSS APPLY F.vmXML.nodes('/VirtualServer_VMSubClientEntity/children') AS dx(c) 
WHERE	A.subclientPolicyAppId = 0 AND A.appTypeId IN (106) AND (A.subclientStatus & 6) = 0

DROP TABLE #TblSubclient

SET @surveyXML = (SELECT
	(SELECT appId      AS '@appId', 
			type       AS '@type', 
			dbo.NormalizeForXML(content) AS '@content',
			created    AS '@created',
			excludestr AS '@excludestr',
			exceptstr  AS '@exceptstr'
	FROM	#TblContent
	FOR XML PATH('Content'), TYPE),
	
	(SELECT
		name  AS '@name',
		value AS '@value'
	 FROM	#GlobalFilter
	FOR XML PATH('GlobalFilter'), TYPE)
	
FOR XML PATH ('')
-- Replace <<RESULTS_NAME>> with specific name
)

DROP TABLE #TblContent
--------- END SURVEY QUERY ---------

--------- BEGIN - GENERATED CODE, PLEASE DO NOT MODIFY ---------

SET @EndTime = dbo.GetUnixTime(GETUTCDATE())
SET @outputXML = 
(
	SELECT
		@queryId AS '@QueryId',
		@EndTime AS '@LogDate',
		(@EndTime - @LogDate) AS '@QueryRunningTime',
		@surveyXML
	FOR XML PATH('Rpt_CSSXMLDATA')
)
SET NOCOUNT OFF

--------- END - GENERATED CODE ---------
 