--@querytype 	CSV
--Name:- MailboxQuotaUsage

SET NOCOUNT ON

-- We need to cast column 'value' to 'varchar' as its type is 'ntext' on V9 CS DB.
IF NOT EXISTS (SELECT * FROM GXGlobalParam WHERE name = 'EnableQuotaManagement' AND CAST(value AS varchar(20)) = '0')
	AND OBJECT_ID('APP_MailboxUsages', 'U') IS NOT NULL
BEGIN
	--------- BEGIN SURVEY QUERY ---------
	SELECT	
	G.GUID AS 'UserGUID', 
	G.name AS 'UserName', 
	ISNULL(Q.quotaEnabled, 0) AS 'QuotaEnabled', 
	ISNULL(CASE WHEN Q.quotaSize = 0 /* CV_DEFAULT_EXMB_QUOTA_LIMIT_MB */ THEN 10240 ELSE Q.quotaSize END, 0) AS 'QuotaSizeMB', 
	L.SpaceConsumed AS 'SpaceConsumed', 
	ISNULL(U.GlobalSpaceConsumed, 0) AS 'GlobalSpaceConsumed', 
	U.LastUpdateTime AS 'LastUpdateTime'
	FROM
		(SELECT	userGUID AS UserGUID, SUM(LocalSpaceConsumed) AS SpaceConsumed
		FROM	APP_MailboxUsages U WITH (NOLOCK)
		GROUP BY userGUID) L
		INNER JOIN (
		SELECT	UserGUID, appId, GlobalSpaceConsumed, LastUpdateTime,
				ROW_NUMBER() OVER (PARTITION BY UserGUID ORDER BY LastUpdateTime DESC) AS RowId 
		FROM	APP_MailboxUsages WITH (NOLOCK)
		) U ON L.UserGUID = U.userGuid AND U.RowId = 1
		INNER JOIN (
		SELECT	GUID, name, ROW_NUMBER() OVER (PARTITION BY GUID ORDER BY (SELECT 0) DESC) AS RowId 
		FROM	APP_GUID WITH (NOLOCK) WHERE status = 1
		) G ON G.GUID = REPLACE(U.userGuid, 'X', '-') AND G.RowId = 1
		LEFT OUTER JOIN (
		SELECT	componentNameId, 
				MAX(CASE WHEN attrName = 'Mailbox Quota Based On Disk Usage' THEN CAST(attrVal AS INT) ELSE 0 END) AS quotaEnabled,
				MAX(CASE WHEN attrName = 'Size Of Mailbox Quota Based On Disk Usage' THEN CAST(attrVal AS INT) ELSE 0 END) AS quotaSize
		FROM	APP_subclientprop WITH (NOLOCK)
		WHERE	attrName IN ('Mailbox Quota Based On Disk Usage', 'Size Of Mailbox Quota Based On Disk Usage')
			AND modified = 0
		GROUP BY componentNameId
	) Q ON U.appId = Q.componentNameId
	--------- END SURVEY QUERY ---------
END

SET NOCOUNT OFF
