import os

#Registry path
CVREG = None
if (os.getuid() == 0):
	CVREG = r'/etc/CommVaultRegistry'
else:
	CVREG = os.path.join(expanduser("~"), 'CommVaultRegistry')

#get the instance
sInstance = ''
dir_path = os.path.dirname(os.path.realpath(__file__ + '/../../'))
with open(dir_path + "/galaxy_vm") as fp:
	lines = fp.read().split("\n")
	for line in lines:
		if "GALAXY_INST" in line:
			sInstance = line.split('"')[1]
	fp.close()

#append Galaxy and Instance number
CVREG = os.path.join(CVREG, 'Galaxy', sInstance)

KEY_ALL_ACCESS = "dummy def"
HKEY_LOCAL_MACHINE = "dummy def"
REG_DWORD = "dummy def"

class Key:
	def __init__(self, keyname, regValues):
		self.keyname = keyname
		self.regValues = regValues

def ConnectRegistry(a,b):
	#dummy wrapper function
	return True

def OpenKey(aReg, registryPath, dummyint = 0, dummystr = 'just to match wrapper'):
	'''
	return a list of all keys and values in the specified path
	in windows, if the registryPath parameter is given as "HKEY_LOCAL_MACHINE\SOFTWARE\CommVault Systems\Galaxy\Instance001\Database",
	it returns all keys and values inside Database section
	here we should only consider the subkey
	'''
	#splice registryPath  to have only subkey
	registryPath = registryPath [registryPath .rfind('\\')+1:]
	regValues = []
	key_obj = Key(registryPath, regValues)
	sRegistryFile = os.path.join(CVREG, registryPath, ".properties")
	if os.path.exists(sRegistryFile):
		#print("found regfile ["+sRegistryFile+"]!")
		with open(sRegistryFile, "r") as hRegistryFileHandle:
			for line in hRegistryFileHandle.readlines():
				if not line.strip():
					continue
				tempLine = line.split()
				regKey = tempLine[0]
				regKeyValue = ' '.join(tempLine[1:])
				key_obj.regValues.append((regKey, regKeyValue, ))
	#else:
			#print("!!! Regfile ["+sRegistryFile+" does not exist!!!")
	return key_obj

def QueryValueEx(key_obj, key):	
	listOfRegistryEntries = key_obj.regValues
	for entry in listOfRegistryEntries:
		if (entry[0].lower() == key.lower()):
			return (entry[1], True)
	

	# hardcoding for now while we get this file added by install team
	if(key == "nXMLPATH"):
		#print ("FOUND REGISTRY VALUE FOR KEY "+key)
		return ("/opt/commvault/Reports/MetricsUpload/Upload", True)

	#print ("UNIX_WINREG: registry entry not found for key "+key)
	raise KeyError ("entry not found!, either hardcode teporarily or handle")

def SetValueEx(key_obj, sRegistryKey, dummyint, dummytype, sRegistryValue):
	"""
	Sets a new registry key.
	"""
	sRegistryPath = key_obj.keyname
	if not isinstance(sRegistryValue, str):
		sRegistryValue = str(sRegistryValue)
	sPropertiesFile = os.path.join(CVREG, sRegistryPath, ".properties")
	dirname = os.path.dirname(sPropertiesFile)

	if not os.path.exists(dirname):
		os.makedirs(dirname)

	regDict = {}
	if os.path.exists(sPropertiesFile):
		with open(sPropertiesFile, "r") as hRegistryFileHandle:
			for line in hRegistryFileHandle.readlines():
				line = line.strip()
				if len(line) > 0:
					try:
						tempLine = line.split()
						regKey = tempLine[0]
						regKeyValue = ' '.join(tempLine[1:])
						regDict[regKey.strip()] = regKeyValue.strip()
					except ValueError as e:
						regKey = line.strip()
						if regKey == sRegistryKey:
							regValue = ''
							regDict[regKey.strip()] = regValue.strip()
	regDict[sRegistryKey] = sRegistryValue
	with open(sPropertiesFile, "w") as hRegistryFileHandle:
		for key, value in regDict.items():
			sRegistryEntry = "%s %s\n" % (key, value)
			hRegistryFileHandle.write(sRegistryEntry)
	#print("Registry item added : "+(os.path.join(CVREG, sRegistryPath, sRegistryKey) + "=" + str(sRegistryValue)))
