'''
/******************************************************************************/
/*  Copyright (c) CommVault Systems                                           */
/*  All Rights Reserved                                                       */
/*                                                                            */
/*  THIS IS UNPUBLISHED PROPRIETARY SOURCE CODE OF CommVault Systems          */
/*  The copyright notice above does not evidence any                          */
/*  actual or intended publication of such source code.                       */
/******************************************************************************/
'''
from Common import *
import os
import optparse
import Logger
import sys
import shutil
import winreg as _winreg
from Database import Database
from MetricsConfig import MetricsConfig

class ProcessUpgrade(object):
    def __init__(self, Log):
        self.Log = Log
        self.MetricsConfigObj = MetricsConfig('MetricsUpgrade').get_instance()
        self.SetPaths()
        self.FetchDisabledOfflineQueries()

    def SetPaths(self):
        self.Log.info("Get environmental variables and settings")
                
        try:
            SimpanaBaseRegPath = self.MetricsConfigObj.sSimpanaBaseRegPath
            SimpanaCloudRegPath = self.MetricsConfigObj.sSimpanaCloudRegPath
            
            aReg = _winreg.ConnectRegistry(None,_winreg.HKEY_LOCAL_MACHINE)
            baseRegKey = _winreg.OpenKey(aReg, SimpanaBaseRegPath)
            value, Success = _winreg.QueryValueEx(baseRegKey, r"dGALAXYHOME")
            self.galaxyHome = value 
            self.baseFolderContainingScript = os.path.join(self.galaxyHome, 'WebConsole')
            self.baseFolderContainingScript = os.path.join(self.baseFolderContainingScript, 'survey')
            Log.info("Metrics sql scripts Folder %s" % (self.baseFolderContainingScript))
            
            try:
                cloudRegKey = _winreg.OpenKey(aReg, SimpanaCloudRegPath, 0, _winreg.KEY_ALL_ACCESS)
                value, Success = _winreg.QueryValueEx(cloudRegKey, r"nXMLPATH")
                self.FolderContainingXmlFile = value
            except Exception as err:
                self.FolderContainingXmlFile = ''
                        
            Log.info("nXMLPATH value is [%s]" % (self.FolderContainingXmlFile))
            baseXMLPath = os.path.join(self.galaxyHome, 'Base')
            baseXMLPath = os.path.join(baseXMLPath, 'Cloud')
            baseXMLPath = os.path.join(baseXMLPath, 'HttpUpload')
            baseXMLPath = os.path.join(baseXMLPath, 'Upload')
            Log.info("baseXMLPath is [%s]" % baseXMLPath)   
            if baseXMLPath == self.FolderContainingXmlFile:
                newXMLPATH = os.path.join(self.galaxyHome, 'Reports')
                newXMLPATH = os.path.join(newXMLPATH, 'MetricsUpload')
                newXMLPATH = os.path.join(newXMLPATH, 'Upload')
                Log.info("Updating nXMLPATH value to [%s]" % newXMLPATH)
                try:
                    _winreg.SetValueEx(cloudRegKey, "nXMLPATH", 0, _winreg.REG_SZ, newXMLPATH)
                except Exception as err:
                    Log.error(err)
                    Log.error("Failed to update key nXMLPATH to [%s]" % newXMLPATH)
            
        except:
            e = sys.exc_info()[0]
            Log.exception("Exception while reading from registry file.[%s].Setting default path" % e )
            self.baseFolderContainingScript = os.path.join(self.galaxyHome, "WebConsole")
            self.baseFolderContainingScript = os.path.join(self.baseFolderContainingScript, "survey")
            Log.info("Metrics sql scripts Folder %s" % (self.baseFolderContainingScript))

    def FetchDisabledOfflineQueries(self):    
        self.CloudDBConnStr = self.MetricsConfigObj.sCLOUDDBCONNSTR
        self.CloudDBName = self.MetricsConfigObj.sCLOUDDBNAME
        self.CloudDBDSN = self.MetricsConfigObj.sCLOUDCONNECTION
        self.CloudDB = Database(logFile='MetricsUpgrade', ConnStr = self.CloudDBConnStr, DSNName = self.CloudDBDSN, Dbname = self.CloudDBName)
        #connect to cloud DB
        try:
            if self.CloudDB.OpenSimpleDSN() == True:
                self.Log.info("Connection to database [%s] successful" % self.CloudDBName)
            else:
                self.Log.error("Unable to connect to the database [%s] with DSN [%s]" % (self.CloudDBName, self.CloudDBDSN))
                self.Log.error("Exiting metrics upgrade as connection to cloud DB failed.")
                sys.exit(1)
        except Exception as err:
            self.Log.error("Exception caught while connecting to the database [%s] : %s" % (self.CloudDBName, err))
            sys.exit(err)

        #fetch all enabled offline queries
        self.enabledOfflineQueries = []
        sqlStatement = "SELECT QueryId FROM cf_CommservSurveyQueries WITH (NOLOCK) WHERE flags & 2 = 2 and QueryId >= 10000"
        try:
            self.CloudDB.Execute(sqlStatement);
            result = self.CloudDB.m_cursor.fetchall()
            for x in result:
                self.enabledOfflineQueries.append(int(x[0]))
            self.Log.info("Obtained collection queries %s " % self.enabledOfflineQueries)
        except Exception as err:
            self.Log.error("Exception caught while fetching enabled offline queries: % s" % (err))			 
            sys.exit(err)

    def GetQueryIdFromFileName(self, filename):
        
        qid = None
         
        fileNamePattern = 'CommservSurveyQuery_(.[0-9]*)\.sql'
        qid = re.findall(fileNamePattern, filename, re.I)
        
        if len(qid) == 1:
            return int(qid[0])
        else:
            return 0
                         
    def compareAndMoveFile(self):
        try:
            CloudCopyScripts = ["csvErrorsList.xml", "BlockedIPs.txt", "IncludeIPs.txt", "HttpServer.xml", "Parameters.config", "CommCellGroups.csv"]
            SimpanaObsoleteCloudScriptsDir = os.path.dirname(os.path.realpath(__file__))
            SimpanaNewCloudScriptsDir = self.galaxyHome
            SimpanaNewCloudScriptsDir = os.path.join(SimpanaNewCloudScriptsDir, "Reports")
            SimpanaNewCloudScriptsDir = os.path.join(SimpanaNewCloudScriptsDir, "MetricsUpload")
            for item in CloudCopyScripts:
                oldPath = os.path.join(SimpanaObsoleteCloudScriptsDir, item)
                newpath = os.path.join(SimpanaNewCloudScriptsDir, item)
                if os.path.isfile(oldPath) and os.path.isfile(newpath) == False:
                    if not os.path.exists(SimpanaNewCloudScriptsDir):
                        os.makedirs(SimpanaNewCloudScriptsDir)
                    shutil.copyfile(oldPath,newpath)

            for item in self.oldSqlFiles:
                try:
                    pathDir, fileName = os.path.split(item)

                    queryId = 0
                    queryId = self.GetQueryIdFromFileName(fileName)
                    if queryId >= 10000 and queryId in self.enabledOfflineQueries:
                        #offline query. Copy it over to scripts folder if not disabled 
                        newpath = item.replace("scripts.old", "scripts")
                        shutil.copyfile(item,newpath)
                        self.Log.info("Found offline collection script. Copying from [%s] to [%s]"% (item,newpath))
                    elif queryId >= 10000:
                        #delete both disabled and deleted from table offline queries 
                        os.remove(item)
                        self.Log.info("Deleting old offline collection script %d" % queryId)
                                                
                    #if fileName is included in custom folder -> then copy fileName from scripts/custom to current file
                    if fileName in self.customSqlFiles:
                        newpath = item.replace("scripts.old", "scripts")
                        rightPath = os.path.join(self.baseFolderContainingScript, 'scripts')
                        rightPath = os.path.join(rightPath, 'Custom')
                        rightPath = os.path.join(rightPath, fileName)
                        if newpath != rightPath:
                            shutil.copyfile(rightPath,newpath)
                            self.Log.info("Found custom sql script. Copying from [%s] to [%s]"% (rightPath,newpath))
                            
                except:
                    e = sys.exc_info()[0]
                    Log.exception("Exception while copying file.[%s]" % e )
        except:
            e = sys.exc_info()[0]
            Log.exception("Exception in compareAndMoveFile.[%s]" % e )

    def processDirectory(self):
        try:
            self.oldSqlFiles = list()
            self.customSqlFiles = list()
            FolderContainingOldScript = os.path.join(self.baseFolderContainingScript, 'scripts.old')
            FolderContainingCustomScript = os.path.join(self.baseFolderContainingScript, 'scripts')
            FolderContainingCustomScript = os.path.join(FolderContainingCustomScript, 'Custom')
            #Prepare the list of old files    
            for filename in os.listdir(FolderContainingOldScript):
                fullFileName = os.path.join(FolderContainingOldScript, filename)
                fName, fExtension = os.path.splitext(fullFileName)
                if fExtension.lower() == ".sql":
                    self.oldSqlFiles.append(fullFileName)
                    self.Log.info("Adding old sql file to list %s" % (fullFileName))
                elif os.path.isdir(fullFileName) and filename != 'Custom':
                    for subfilename in os.listdir(fullFileName):
                        subfullFileName = os.path.join(fullFileName, subfilename)
                        subfName, subfExtension = os.path.splitext(subfullFileName)
                        if subfExtension.lower() == ".sql":
                            self.oldSqlFiles.append(subfullFileName)
                            self.Log.info("Adding old sql file to the list %s" % (subfullFileName))
            #Prepare the list of newly installed files    
            for filename in os.listdir(FolderContainingCustomScript):
                fullFileName = os.path.join(FolderContainingCustomScript, filename)
                fName, fExtension = os.path.splitext(fullFileName)
                if fExtension.lower() == ".sql":
                    self.customSqlFiles.append(filename)
                    self.Log.info("Adding custom sql file to the list %s" % (fullFileName))
                  
            #Mov file based on modified time                    
            self.compareAndMoveFile()

        except:
            e = sys.exc_info()[0]
            Log.exception("Exception while processing directory.[%s]" % e )

if __name__ == '__main__':
    #initialize logger
    Log = Logger.InitLogger('MetricsUpgrade')
    Log.info("Starting upgrade script")
    try:
        handler = ProcessUpgrade(Log)
        handler.processDirectory()
    except BaseException as err:
        if (err.args[0] != 0):
            Log.exception("Exception while processing sql file.")
    except:
        e = sys.exc_info()[0]
        Log.exception("Exception in main.[%s]" % e )