'''
/******************************************************************************/
/*  Copyright (c) CommVault Systems                                           */
/*  All Rights Reserved                                                       */
/*                                                                            */
/*  THIS IS UNPUBLISHED PROPRIETARY SOURCE CODE OF CommVault Systems          */
/*  The copyright notice above does not evidence any                          */
/*  actual or intended publication of such source code.                       */
/******************************************************************************/
Created on Mar 21, 2012
Revision: $Id: Table.py,v 1.3 2013/04/03 21:32:31 sgupta Exp $
$Date: 2013/04/03 21:32:31 $
@author: David Maisonave
'''
from win32com.client import Dispatch

class Table:
    '''
    classdocs
    '''
    m_Rec = None
    m_ErrStr = ''


    def __init__(self):
        '''
        Constructor
        '''
        #self.m_Rec = Dispatch('ADODB.Recordset')

    def GetErrorErrStr(self):
        return self.m_ErrStr

    def Open(self, Mode, CmdStr, con):
        self.m_ErrStr = 'Error opening recordset with cmdstr %s' % (CmdStr)
        self.m_Rec.Open(CmdStr, con, 3, 3, Mode)
        self.m_ErrStr = 'Success'

    def MoveFirst(self):
        self.m_ErrStr = "Success"
        try:
            return self.m_Rec.MoveFirst()
        except:
            self.m_ErrStr = "MoveFirst failed!"
        return None

    def MoveLast(self):
        self.m_ErrStr = "Success"
        try:
            return self.m_Rec.MoveLast()
        except:
            self.m_ErrStr = "MoveLast failed!"
        return None

    def MoveNext(self):
        self.m_ErrStr = "Success"
        try:
            return self.m_Rec.MoveNext()
        except:
            self.m_ErrStr = "MoveNext failed!"
        return None

    def MovePrevious(self):
        self.m_ErrStr = "Success"
        try:
            return self.m_Rec.MovePrevious()
        except:
            self.m_ErrStr = "MovePrevious failed!"
        return None

    def Get(self, FieldName):
        self.m_ErrStr = "Success"
        try:
            vtValue = self.m_Rec.Fields.Item(FieldName).Value
            return True, vtValue
        except:
            self.m_ErrStr = "DB GetItem failed for FieldName %s!" % FieldName
        return False, None