'''
/******************************************************************************/
/*  Copyright (c) CommVault Systems                                           */
/*  All Rights Reserved                                                       */
/*                                                                            */
/*  THIS IS UNPUBLISHED PROPRIETARY SOURCE CODE OF CommVault Systems          */
/*  The copyright notice above does not evidence any                          */
/*  actual or intended publication of such source code.                       */
/******************************************************************************/
Created on Sep 21, 2020
Revision: $Id: MetricsConfig.py,v 1.1.2.2 2020/12/16 12:31:06 dnavaneethan Exp $
$Date: 2020/12/16 12:31:06 $
@author: Dinesh B Navaneethan
'''
#Global Metrics server configuration variables to be used in all the necessary modules
import Logger
import base64
from Common import getSimpanaRegPath, GetMetricsData, GetEnvVar
try:
    import winreg as _winreg
except ImportError:
    import unix_winreg as _winreg
    
#Singleton class
class MetricsConfig:
    __instance__ = None
    
    #begin declare static configuration variables
    Log = None
    sSimpanaInstallPath = ''
    sSimpanaDatabaseRegPath = '', 
    dbRegKey = ''
    sSimpanaCloudRegPath = ''
    cloudRegKey = ''
    sSimpanaBaseRegPath = ''
    baseRegKey = ''
    
    #SQL parameters
    iSQLAuthType = 0
    
    #CVCloud db parameters
    sCLOUDDBNAME = ''
    sCLOUDINSTANCE = ''
    sCLOUDCONNECTION = ''
    sCLOUDDBUser = ''
    sCLOUDDBPassword = ''
    sCLOUDDBTrustedConnection = 'yes' 
    sCLOUDDBCONNSTR = ''
    
    #CS db parameters
    sCSDBNAME = ''
    sINSTANCE = ''
    sCONNECTION = ''
    sCSDBUser = ''
    sCSDBPassword = ''
    sCSDBTrustedConnection = 'yes' 
    sCSDBCONNSTR = ''
    
    #license db parameters
    bContactLicDB = False       #used for both License database and cloudservices database    
    sLICDBNAME = ''
    sLICINSTANCE = ''
    sLICCONNECTION = ''
    sLICDBUser = ''
    sLICDBPassword = ''
    sLICDBTrustedConnection = 'yes' 
    sLICDBCONNSTR = ''
    iUpdateGUIDInLicDB = 0
    
    #CloudServices db parameters
    sCLOUDSERVICESDBNAME = ''
    sCLOUDSERVICESCONNECTION = ''
    sCLOUDSERVICESUser = ''
    sCLOUDSERVICESPassword = ''
    sCLOUDSERVICESTrustedConnection = 'yes' 
    sCLOUDSERVICESCONNSTR = ''
    #end declare static configuration variables
    
    @staticmethod
    def get_instance(logFile="CVSurvey"):
        """ Static method to fetch the current instance.
        """
        if not MetricsConfig.__instance__:
            MetricsConfig(logFile)
            MetricsConfig.__instance__.Log.debug(__name__ + " :: get_instance :: New object created")
        #else:
            #MetricsConfig.__instance__.Log.debug(__name__ + " :: get_instance :: Object already exist")
            
        return MetricsConfig.__instance__
        
    def __init__(self, logFile="CVSurvey"):
        """ Constructor.
        """
        if MetricsConfig.__instance__ is None:
            
            self.Log = Logger.InitLogger(logFile)
    
            self.Log.info(__name__ + " :: Start initializing registry key values")
            try:
                self.sSimpanaInstallPath = getSimpanaRegPath()
                self.Log.info(__name__ + " :: sSimpanaInstallPath [%s]" % self.sSimpanaInstallPath)
                
                aReg = _winreg.ConnectRegistry(None,_winreg.HKEY_LOCAL_MACHINE)
                
                self.sSimpanaDatabaseRegPath = self.sSimpanaInstallPath + "\\Database"
                self.Log.info(__name__ + " :: sSimpanaDatabaseRegPath [%s]" % self.sSimpanaDatabaseRegPath)
                
                self.dbRegKey = _winreg.OpenKey(aReg, self.sSimpanaDatabaseRegPath)
                
                self.sSimpanaCloudRegPath = self.sSimpanaInstallPath + "\\Cloud"
                self.Log.info(__name__ + " :: sSimpanaCloudRegPath [%s]" % self.sSimpanaCloudRegPath)
                
                self.cloudRegKey = _winreg.OpenKey(aReg, self.sSimpanaCloudRegPath)
                
                self.sSimpanaBaseRegPath = self.sSimpanaInstallPath + "\\Base"
                self.Log.info(__name__ + " :: sSimpanaBaseRegPath [%s]" % self.sSimpanaBaseRegPath)
                
                self.baseRegKey = _winreg.OpenKey(aReg, self.sSimpanaBaseRegPath)
                
            except Exception as err:
                self.Log.exception(__name__ + " :: Failed to init registry key values Exception [%s]. Return." % str(err))
                return
            self.Log.info(__name__ + " :: End initializing registry key values")
            
            value = None
            Success = False
            #DSN parameters
            try:
                value, Success = _winreg.QueryValueEx(self.dbRegKey, r"nSQLAuthType")
                if Success == True:
                    self.iSQLAuthType = int(value)
            except Exception as err:
                self.iSQLAuthType = 0
            self.Log.info(__name__ + " :: iSQLAuthType [%s]" % self.iSQLAuthType)
                
            self.Log.info(__name__ + " :: Start initializing CVCloud db parameters")
            try:
                Success = False
                value, Success = _winreg.QueryValueEx(self.dbRegKey, r"sCLOUDDBNAME")
                if Success == True:
                    self.sCLOUDDBNAME = value
                self.Log.info(__name__ + " :: sCLOUDDBNAME [%s]" % self.sCLOUDDBNAME)
                Success = False
                
                value, Success = _winreg.QueryValueEx(self.dbRegKey, r"sCLOUDINSTANCE")
                if Success == True:
                    self.sCLOUDINSTANCE = value
                self.Log.info(__name__ + " :: sCLOUDINSTANCE [%s]" % self.sCLOUDINSTANCE)
                
                Success = False
                value, Success = _winreg.QueryValueEx(self.dbRegKey, r"sCLOUDCONNECTION")
                if Success == True:
                    self.sCLOUDCONNECTION = value
                self.Log.info(__name__ + " :: sCLOUDCONNECTION [%s]" % self.sCLOUDCONNECTION)
                
                value, Success = _winreg.QueryValueEx(self.dbRegKey, r"pCLOUDACCESS")
                if Success == True:
                    Success, self.sCLOUDDBUser, self.sCLOUDDBPassword = GetMetricsData(value, self.Log)
                    if Success == False:
                        self.sCLOUDDBUser = ''
                        self.sCLOUDDBPassword = '' 
            except Exception as err:
                self.sCLOUDDBNAME = ''
                self.sCLOUDINSTANCE = ''
                self.sCLOUDCONNECTION = ''
                self.sCLOUDDBUser = ''
                self.sCLOUDDBPassword = ''
                self.Log.exception(__name__ + " :: Failed to initialize CVCloud db parameters. Exception [%s]. Return." % str(err))
                return
            
            try:
                self.sCLOUDDBTrustedConnection = GetEnvVar("Trusted_Connection", "yes")
                self.Log.info(__name__ + " :: sCLOUDDBTrustedConnection [%s]" % self.sCLOUDDBTrustedConnection)
                
                if self.iSQLAuthType == 1:
                    self.sCLOUDDBCONNSTR = "DSN="+self.sCLOUDCONNECTION +";Integrated Security=True;"
                    self.Log.info(__name__ + " :: Integrated Security Enabled. Using Windows Authentication to connect to database.")
                else:
                    if self.sCLOUDDBUser != '' and self. sCLOUDDBPassword != '':
                        self.sCLOUDDBCONNSTR = "DSN="+self.sCLOUDCONNECTION +";UID="+self.sCLOUDDBUser.decode('utf-8')+";PWD="+self.sCLOUDDBPassword.decode('utf-8')
                    else:
                        self.sCLOUDDBCONNSTR = "DSN="+self.sCLOUDCONNECTION +";Trusted_Connection="+self.sCLOUDDBTrustedConnection                
            except Exception as err:
                self.Log.exception(__name__ + " :: Exception [%s]" % str(err))
            self.Log.info(__name__ + " :: End initializing CVCloud db parameters")
            
            self.Log.info(__name__ + " :: Start initializing CS db parameters")
            try:
                Success = False
                value, Success = _winreg.QueryValueEx(self.dbRegKey, r"sCSDBNAME")
                if Success == True:
                    self.sCSDBNAME = value
                self.Log.info(__name__ + " :: sCSDBNAME [%s]" % self.sCSDBNAME)
                
                Success = False
                value, Success = _winreg.QueryValueEx(self.dbRegKey, r"sINSTANCE")
                if Success == True:
                    self.sINSTANCE = value
                self.Log.info(__name__ + " :: sINSTANCE [%s]" % self.sINSTANCE)
                
                Success = False
                value, Success = _winreg.QueryValueEx(self.dbRegKey, r"sCONNECTION")
                if Success == True:
                    self.sCONNECTION = value
                self.Log.info(__name__ + " :: sCONNECTION [%s]" % self.sCONNECTION)
                
                value, Success = _winreg.QueryValueEx(self.dbRegKey, r"pACCESS")
                if Success == True:
                    Success, self.sCSDBUser, self.sCSDBPassword = GetMetricsData(value, self.Log)
                    if Success == False:
                        self.sCSDBUser = ''
                        self.sCSDBPassword = '' 
            except Exception as err:
                self.sCSDBNAME = ''
                self.sINSTANCE = ''
                self.sCONNECTION = ''
                self.sCSDBUser = ''
                self.sCSDBPassword = ''
                self.Log.exception(__name__ + " :: Failed to initialize CVCloud db parameters. Exception [%s]. Return" % str(err))
                return
            
            try:
                self.sCSDBTrustedConnection = GetEnvVar("Trusted_Connection", "yes")
                self.Log.info(__name__ + " :: sCSDBTrustedConnection [%s]" % self.sCSDBTrustedConnection)
                
                if self.iSQLAuthType == 1:
                    self.sCSDBCONNSTR = "DSN="+self.sCONNECTION +";Integrated Security=True;"
                    self.Log.info(__name__ + " :: Integrated Security Enabled. Using Windows Authentication to connect to database.")
                else:
                    if self.sCSDBUser != '' and self.sCSDBPassword != '':
                        self.sCSDBCONNSTR = "DSN="+self.sCONNECTION +";UID="+self.sCSDBUser.decode('utf-8')+";PWD="+self.sCSDBPassword.decode('utf-8')
                    else:
                        self.sCSDBCONNSTR = "DSN="+self.sCONNECTION +";Trusted_Connection="+self.sCSDBTrustedConnection                
            except Exception as err:
                self.Log.exception(__name__ + " :: Exception [%s]" % str(err))                  
            self.Log.info(__name__ + " :: End initializing CS db parameters")                 
            
            try:
                Success = False
                value, Success = _winreg.QueryValueEx(self.cloudRegKey, r"nContactLGDB")
                if Success == True and value == 'yes':
                    self.bContactLicDB = True
            except Exception as err:
                self.bContactLicDB = False
            self.Log.info(__name__ + " :: bContactLicDB [%s]" % self.bContactLicDB)
            
            if self.bContactLicDB == True:
                #license db parameters
                self.Log.info(__name__ + " :: Start initializing license db parameters")
                try:
                    Success = False
                    value, Success = _winreg.QueryValueEx(self.dbRegKey, r"sLICDBNAME")
                    if Success == True:
                        self.sLICDBNAME = value
                    self.Log.info(__name__ + " :: sLICDBNAME [%s]" % self.sLICDBNAME)
                    
                    Success = False
                    value, Success = _winreg.QueryValueEx(self.dbRegKey, r"sLICINSTANCE")
                    if Success == True:
                        self.sLICINSTANCE = value
                    self.Log.info(__name__ + " :: sLICINSTANCE [%s]" % self.sLICINSTANCE)
                    
                    Success = False
                    value, Success = _winreg.QueryValueEx(self.dbRegKey, r"sLICCONNECTION")
                    if Success == True:
                        self.sLICCONNECTION = value 
                    self.Log.info(__name__ + " :: sLICCONNECTION [%s]" % self.sLICCONNECTION)
                       
                except Exception as err:
                    self.Log.exception(__name__ + " :: Failed to initialize license DB parameters. Exception [%s]. Return." % str(err))
                    return
                    self.sLICDBNAME = ''
                    self.sLICINSTANCE = ''
                    self.sLICCONNECTION = ''
                    
                try:
                    Success = False
                    value, Success = _winreg.QueryValueEx(self.cloudRegKey, r"UpdateGUIDInLicDB")
                    if Success == True:
                        self.iUpdateGUIDInLicDB = int(value)
                except Exception as err:
                    self.iUpdateGUIDInLicDB = 0
                self.Log.info(__name__ + " :: iUpdateGUIDInLicDB [%s]" % self.iUpdateGUIDInLicDB)
                
                try:
                    self.sLICDBUser = GetEnvVar("LicDBUser", "")
                    self.sLICDBPassword = GetEnvVar("LicDBPWD", "")
                    self.sLICDBTrustedConnection = GetEnvVar("LicDB_Trusted_Connection", "yes")            
                    if self.sLICDBUser != '' and self.sLICDBPassword != '':
                        self.sLICDBPassword = base64.b64decode(self.sLICDBPassword).decode("utf-8")
                        self.sLICDBCONNSTR = "DSN="+self.sLICCONNECTION +";Trusted_Connection="+self.sLICDBTrustedConnection+";UID="+self.sLICDBUser+";PWD="+self.sLICDBPassword
                    else:
                        self.sLICDBCONNSTR = "DSN="+self.sLICCONNECTION +";Trusted_Connection="+self.sLICDBTrustedConnection
                except Exception as err:
                    self.Log.exception(__name__ + " :: Exception [%s]" % str(err))
                self.Log.info(__name__ + " :: End initializing license db parameters")
                
                #CloudServices db parameters
                self.Log.info(__name__ + " :: Start initializing CloudServices db parameters")
        
                try:
                    Success = False
                    value, Success = _winreg.QueryValueEx(self.dbRegKey, r"sCLOUDSERVICESDBNAME")
                    if Success == True:
                        self.sCLOUDSERVICESDBNAME = value
                    self.Log.info(__name__ + " :: sCLOUDSERVICESDBNAME [%s]" % self.sCLOUDSERVICESDBNAME)
                    
                    Success = False
                    value, Success = _winreg.QueryValueEx(self.dbRegKey, r"sCLOUDSERVICESCONNECTION")
                    if Success == True:
                        self.sCLOUDSERVICESCONNECTION = value
                    self.Log.info(__name__ + " :: sCLOUDSERVICESCONNECTION [%s]" % self.sCLOUDSERVICESCONNECTION)
                    
                    value, Success = _winreg.QueryValueEx(self.dbRegKey, r"pCLOUDSERVICESACCESS")
                    if Success == True:
                        Success, self.sCLOUDSERVICESUser, self.sCLOUDSERVICESPassword = GetMetricsData(value, self.Log)
                        if Success == False:
                            self.sCLOUDSERVICESUser = ''
                            self.sCLOUDSERVICESPassword = '' 
                except Exception as err:
                    self.Log.exception(__name__ + " :: Failed to initialize CloudServices DB parameters. Exception [%s]. Return." % str(err))
                    #return                    
                    self.sCLOUDSERVICESDBNAME = ''
                    self.sCLOUDSERVICESCONNECTION = ''
                    self.sCLOUDSERVICESUser = ''
                    self.sCLOUDSERVICESPassword = ''
                
                try:    
                    self.sCLOUDSERVICESTrustedConnection = GetEnvVar("Trusted_Connection", "yes")
                    self.Log.info(__name__ + " :: sCLOUDSERVICESTrustedConnection [%s]" % self.sCLOUDSERVICESTrustedConnection)
                    
                    if self.iSQLAuthType == 1:
                        self.sCLOUDSERVICESCONNSTR = "DSN="+self.sCLOUDSERVICESCONNECTION +";Integrated Security=True;"
                        self.Log.info(__name__ + " :: Integrated Security Enabled. Using Windows Authentication to connect to database.")
                    else:
                        if self.sCLOUDSERVICESUser != '' and self.sCLOUDSERVICESPassword != '':
                            self.sCLOUDSERVICESCONNSTR = "DSN="+self.sCLOUDSERVICESCONNECTION +";UID="+self.sCLOUDSERVICESUser.decode('utf-8')+";PWD="+self.sCLOUDSERVICESPassword.decode('utf-8')
                        else:
                            self.sCLOUDSERVICESCONNSTR = "DSN="+self.sCLOUDSERVICESCONNECTION +";Trusted_Connection="+self.sCLOUDSERVICESTrustedConnection
                except Exception as err:
                    self.Log.exception(__name__ + " :: Exception [%s]" % str(err))                                            
                self.Log.info(__name__ + " :: End initializing CloudServices db parameters")    
                                
            else:
                self.Log.info(__name__ + " :: License and CloudServices DB parameters are not required")          
            
            #All success. Set the singleton class variable 
            MetricsConfig.__instance__ = self #set the value for class variable
            
        #else:
            #MetricsConfig.__instance__.Log.debug(__name__ + " __init__ :: Object already exist")
    

#Create single object for MetricsConfig
#MetricsConfigObj = MetricsConfig.get_instance('MetricsConfig')
