'''
/******************************************************************************/
/*  Copyright (c) CommVault Systems                                           */
/*  All Rights Reserved                                                       */
/*                                                                            */
/*  THIS IS UNPUBLISHED PROPRIETARY SOURCE CODE OF CommVault Systems          */
/*  The copyright notice above does not evidence any                          */
/*  actual or intended publication of such source code.                       */
/******************************************************************************/
'''

import logging
import os
import Common
from logging.handlers import RotatingFileHandler
try:
    import winreg as _winreg
except ImportError:
    import unix_winreg as _winreg
import sys
import traceback
import re
import platform

LogLevels = [logging.ERROR, logging.WARNING, logging.INFO, logging.DEBUG]

DefLogLevel = logging.INFO

format_string = '%(process)d  %(thread)d  %(asctime)s %(levelname)-5s "%(message)s"'

def unicodeFriendlyException(msg, *args, **kwargs):
    """
    Prevents all non ascii characters from being printed while logging
    """
    trace = traceback.format_exc()
    formattedTrace = re.sub(r'[^\u0000-\u0FFF]','?', trace)
    logging.log(logging.ERROR, formattedTrace)

class StreamToLogger(object):
   """
   Fake file-like stream object that redirects writes to a logger instance.
   """
   def __init__(self, logger, log_level=logging.INFO):
      self.logger = logger
      self.log_level = log_level
      self.linebuf = ''
 
   def write(self, buf):
      for line in buf.rstrip().splitlines():
         self.logger.log(self.log_level, line.rstrip().encode('utf-8'))
    
   def flush(self):
      pass


def GetDebugLevel(cloudRegKey, debugregname):
    try:
         value, Success = _winreg.QueryValueEx(cloudRegKey, debugregname)
         loglevelset = int(value)
         if loglevelset <= 0:
            loglevelset = logging.WARN
         elif loglevelset == 1:
            loglevelset = logging.INFO
         else:   #Anything greater than 1 is Debug level
            loglevelset = logging.DEBUG
    except:
            loglevelset = logging.INFO
    return loglevelset

def GetFileSize(cloudRegKey, fileSizeRegName):
    try:
         value, Success = _winreg.QueryValueEx(cloudRegKey, fileSizeRegName)
         fileSize = int(value)
    except:
         fileSize = 5
    return fileSize

def GetFileVersions(cloudRegKey, fileVersionsRegName):
    try:
         value, Success = _winreg.QueryValueEx(cloudRegKey, fileVersionsRegName)
         fileVersions= int(value)
    except:
         fileVersions = 5
    return fileVersions

def GetLoggerRegInfo(logfilename):
    logpath = ""
    filename = logfilename + '.log'
    debugregname = logfilename + "_DEBUGLEVEL"
    fileSizeRegName = logfilename + "_MAXLOGFILESIZE"
    fileVersionsRegName = logfilename + "_MAXLOGFILEBACKUPS"
    resultsXMLFilePath = Common.getSimpanaRegPath() + "\\Base"
    loglevelset = logging.INFO
    try:
         aReg = _winreg.ConnectRegistry(None,_winreg.HKEY_LOCAL_MACHINE)
         simpanacloudregdir = Common.getSimpanaRegPath() + "\\EventManager"
         try:
            cloudRegKey = _winreg.OpenKey(aReg, simpanacloudregdir)
            loglevelset = GetDebugLevel(cloudRegKey, debugregname)
            fileSize = GetFileSize(cloudRegKey, fileSizeRegName)
            fileVersions = GetFileVersions(cloudRegKey, fileVersionsRegName)
         except:
            loglevelset = logging.INFO
            fileSize = 5
            fileVersions = 5
         if(platform.system() == "Windows"):
             aKey1 = _winreg.OpenKey(aReg, resultsXMLFilePath)
             value, Success = _winreg.QueryValueEx(aKey1, r"dGALAXYHOME")
             if Success == True:
                logpath = value + "\\Log Files"
         else:
            aKey = _winreg.OpenKey(0, "EventManager")
            logpath, Success = _winreg.QueryValueEx(aKey, r"dEVLOGDIR")
    except Exception as ex:
         print (ex)
         logpath = 'log'
         if(platform.system() == "Linux"):
            logpath = '/var/log/commvault/Log_Files'
    if not os.path.exists(logpath):
         os.makedirs(logpath)
    logfilefullpath = os.path.abspath(os.path.join(logpath, filename))
    return logfilefullpath, fileSize, fileVersions, loglevelset

def GetRegistryInfo(logfilename,Logger):
    flag = False
    if not hasattr(GetRegistryInfo, 'logfileSize'):
        GetRegistryInfo.logfileSize = 5
    if not hasattr(GetRegistryInfo, 'logfileVersions'):
        GetRegistryInfo.logfileVersions = 5
    if not hasattr(GetRegistryInfo, 'loglevel'):
        GetRegistryInfo.loglevel = logging.INFO
    logfilefullpath, fileSize, fileVersions, loglevelset = GetLoggerRegInfo(logfilename)
    if GetRegistryInfo.logfileSize != fileSize :
        flag = True
        GetRegistryInfo.logfileSize = fileSize
        Logger.info("Log fileSize is been set to %d MB",fileSize)
    if GetRegistryInfo.logfileVersions != fileVersions :
        flag = True
        GetRegistryInfo.logfileVersions = fileVersions
        Logger.info("Number of log backup copies is been set to %d",fileVersions)
    if GetRegistryInfo.loglevel != loglevelset :
        flag = True
        GetRegistryInfo.loglevel = loglevelset
        Logger.info("Log level has been set to %d", loglevelset)
    return flag, logfilefullpath, fileSize, fileVersions, loglevelset
    
def InitLogger(logfilename):
    if not hasattr(InitLogger,'loginit'):
         flag, logfilefullpath, fileSize, fileVersions, loglevelset = GetRegistryInfo(logfilename,logging.Logger('CVSurvey'))
         try:
            InitLogger.logger = logging.Logger(logfilename)
            InitLogger.logger.exception = unicodeFriendlyException
            fh = RotatingFileHandler(logfilefullpath, 'a', fileSize*1024*1024, fileVersions)
            fh.setLevel(loglevelset)
            fh.setFormatter(logging.Formatter(fmt=format_string, datefmt='%m/%d %H:%M:%S'))
            InitLogger.logger.addHandler(fh)
            setattr(InitLogger, 'handler', fh)
            stdout_logger = logging.getLogger('STDOUT')
            sl = StreamToLogger(InitLogger.logger, logging.INFO)
            sys.stdout = sl
            stderr_logger = logging.getLogger('STDERR')
            sl = StreamToLogger(InitLogger.logger, logging.ERROR)
            sys.stderr = sl            

            InitLogger.loginit = True
         except Exception as erno:
            print (erno)
            sys.exit(1)
    return InitLogger.logger

def ModifyHandler(logfilefullpath, fileSize, fileVersions, loglevelset,Logger):
         fh = RotatingFileHandler(logfilefullpath, 'a', fileSize*1024*1024, fileVersions)
         fh.setLevel(loglevelset)
         fh.setFormatter(logging.Formatter(fmt=format_string, datefmt='%m/%d %H:%M:%S'))
         InitLogger.handler.close()
         Logger.removeHandler(InitLogger.handler)
         Logger.addHandler(fh)
         delattr(InitLogger, 'handler')
         setattr(InitLogger, 'handler', fh)
         return Logger

def GetLogger():
    return InitLogger()
