'''
Created on Mar 21, 2012
Revision: $Id: Database.py,v 1.16.12.11 2020/09/26 02:32:50 dnavaneethan Exp $
$Date: 2020/09/26 02:32:50 $
@author: David Maisonave
'''
 
from MetricsConfig import MetricsConfig
import pyodbc
import time
import sys
import Logger

class Database:
    '''
    classdocs
    '''
    m_connection_timeout = 3600 #timeout in sec for the sql query (1 HR)
    m_login_timeout  = 60 #timeout in sec for the connection attempt
    SQL_ATTR_QUERY_TIMEOUT = 0
    SQL_ATTR_CONNECTION_TIMEOUT = 113    
    
    def __init__(self, logFile="CVSurvey", ConnStr = None, DSNName = '', Dbname = ''):
        '''
        Constructor
        '''
        self.Log = Logger.InitLogger(logFile)
        self.MetricsConfigObj = MetricsConfig(logFile).get_instance()
        self.m_ErrStr = ''
        self.m_cursor = None
        self.m_ConnStr = ConnStr
        self.m_DSNName = DSNName
        self.m_Dbname = Dbname
        self.m_dbConnection = None       

    def SetErrorErrStr(self,ErrStr):
        self.m_ErrStr = ErrStr
        
    def GetErrorErrStr(self):
        return self.m_ErrStr
    
    def OpenSimpleDSN(self):
        self.m_ErrStr = ''
        self.Log.debug(__name__ + " :: Connecting to Database with DSN [%s]" % self.m_DSNName)
        self.m_dbConnection = pyodbc.connect(self.m_ConnStr, autocommit = True, timeout=self.m_login_timeout, attrs_before={self.SQL_ATTR_CONNECTION_TIMEOUT : self.m_connection_timeout})
        self.m_dbConnection.set_attr(self.SQL_ATTR_CONNECTION_TIMEOUT, self.m_connection_timeout)
        self.m_cursor = self.m_dbConnection.cursor()
        self.m_cursor.execute("use [%s]" % self.m_Dbname)
        self.Log.info(__name__ + " :: Connection Successful with DSN [%s]" % self.m_DSNName)
        self.m_ErrStr = "Success"
        return True        

    def OpenDSN(self, DSNName, Dbname, isLicDB = 0, sz_DBUser = '', sz_DBPWD = ''): 
        #DSNName, sz_DBUser and sz_DBPWD are not going to be used anymore. we can remove these variables in future after making changes in all references.
        if self.m_ConnStr is None or len(self.m_ConnStr) <= 0:           
            if Dbname.lower() == 'cvcloud':
                self.m_ConnStr = self.MetricsConfigObj.sCLOUDDBCONNSTR
                self.m_DSNName = self.MetricsConfigObj.sCLOUDCONNECTION
                self.m_Dbname = self.MetricsConfigObj.sCLOUDDBNAME
            elif Dbname.lower() == 'commserv':
                self.m_ConnStr = self.MetricsConfigObj.sCSDBCONNSTR
                self.m_DSNName = self.MetricsConfigObj.sCONNECTION
                self.m_Dbname = self.MetricsConfigObj.sCSDBNAME
            elif Dbname.lower() == 'cloudservices':
                self.m_ConnStr = self.MetricsConfigObj.sCLOUDSERVICESCONNSTR
                self.m_DSNName = self.MetricsConfigObj.sCLOUDSERVICESCONNECTION
                self.m_Dbname = self.MetricsConfigObj.sCLOUDSERVICESDBNAME                                        
            elif isLicDB == 0 or  Dbname.lower() == 'cvlicgen':
                self.m_ConnStr = self.MetricsConfigObj.sLICDBCONNSTR
                self.m_DSNName = self.MetricsConfigObj.sLICCONNECTION
                self.m_Dbname = self.MetricsConfigObj.sLICDBNAME 
            else:
                self.Log.error(__name__ + " :: Unknown database [%s]. Couldn't find the connection string." % Dbname)
                return False
        return self.OpenSimpleDSN(self.m_ConnStr, self.m_DSNName, self.m_Dbname)

    def CloseDSN(self):
        self.m_cursor.close()
        self.m_dbConnection.close()
        self.Log.debug(__name__ + " :: Close Successful")
        self.m_ErrStr = "Success"    
    
    def Commit(self):
        self.m_dbConnection.commit()
        self.Log.debug(__name__ + " :: Commit Successful ")
        self.m_ErrStr = "Success"
    
    def Rollback(self):
        self.m_dbConnection.rollback()
        self.Log.debug(__name__ + " :: Rollback Successful ")
        self.m_ErrStr = "Success"

    def Execute(self, QueryStr):
        count = 0
        while(count<4):
            try:
                if count>=1 or self.m_cursor is None:
                    self.Log.info(__name__ + " :: Retrying Database connection with DSN " + self.m_DSNName)
                    self.OpenSimpleDSN()
                self.m_cursor.execute(QueryStr)
                break
            except Exception as dberr:
                self.Log.exception(__name__ + " :: Caught exception while executing query [%s] exception [%s]." % (QueryStr, dberr.args[1]))
                if ((dberr.args[0] =='08001') or (dberr.args[0] =='08002') or (dberr.args[0] =='08003') or (dberr.args[0] =='08004') or (dberr.args[0] =='08007') or (dberr.args[0] =='08S01') or (dberr.args[0] =='42000') or ( len(dberr.args) > 1 and 'network error' in dberr.args[1]) ):
                    count =count+ 1
                    time.sleep(60)
                else:
                    raise
        if(count==4):
            self.Log.error(__name__ + " :: Metrics processing will stop as Database connection failed.")
            sys.exit(0)

        return True

