'''
/******************************************************************************/
/*  Copyright (c) CommVault Systems                                           */
/*  All Rights Reserved                                                       */
/*                                                                            */
/*  THIS IS UNPUBLISHED PROPRIETARY SOURCE CODE OF CommVault Systems          */
/*  The copyright notice above does not evidence any                          */
/*  actual or intended publication of such source code.                       */
/******************************************************************************/
Created on Mar 22, 2012
Revision: $Id: CustomerFeedbackDatabase.py,v 1.50.2.36 2020/09/29 19:31:54 raleti Exp $
$Date: 2020/09/29 19:31:54 $
@author: David Maisonave
'''
import datetime
from Database import Database
from Common import *
if(platform.system() == "Windows"):
    import win32com.client                          #is it needed?
    from win32com.client import DispatchBaseClass   #is it needed?

from CommCellLicDatabase import CommCellLicDatabase
from CSSXMLDATA_FileData import CSSXMLDATA_FileData
from Rpt_CSSXMLDATAROOT import Rpt_CSSXMLDATAROOT
from CssXmlData import CssXmlData
import Logger
import time
from MetricsConfig import MetricsConfig

class CommcellInfo:
    '''
    classdocs
    '''
    commServGUID= ''
    commcellIP = ''
    MetricsNamemapID = ''

    def __init__(self):
        '''
        Constructor
        '''
class CustomerFeedbackDatabase:
    '''
    classdocs
    '''
    sz_VerifyCommcell = ''  #TODO: aquire lock
    allCommcells = dict()   #TODO: aquire lock

    def __init__(self, logFile="CVSurvey"):
        '''
        Constructor
        '''
        
        self.Log = Logger.InitLogger(logFile)
        self.MetricsConfigObj = MetricsConfig(logFile).get_instance()
        self._sz_DbConnStr = self.MetricsConfigObj.sCLOUDDBCONNSTR
        self._sz_DbName = self.MetricsConfigObj.sCLOUDDBNAME
        self._sz_DbDSN = self.MetricsConfigObj.sCLOUDCONNECTION
        self._db = Database(logFile=logFile, ConnStr = self._sz_DbConnStr, DSNName = self._sz_DbDSN, Dbname = self._sz_DbName)
        
        self._commcellLicdatabase = None

        if self.MetricsConfigObj.bContactLicDB == True:
            self._commcellLicdatabase = CommCellLicDatabase(logFile)            

        self._bOpenConnection = False
        try:
            if self._db.OpenSimpleDSN() == True:
                self._bOpenConnection = True
        except Exception as dberr:
            if self._bOpenConnection == False:
                self._db.SetErrorErrStr(dberr.args[1])
                self.Log.error(__name__ + " :: Failed to open DB '%s', with error %s" %(self._sz_DbName, self._db.GetErrorErrStr()))

        self.sz_VerifyCommcell = GetEnvVar("VerifyCommcell", "")
        if self.sz_VerifyCommcell != '':
            self.ReadCommcell()
    
    def __del__(self):
        self._db.CloseDSN()
        
    def GetCommCellNameMapId(self, CommCellid, CommServIP, CommServGUID):
        if self.sz_VerifyCommcell != '':
            GetSucces, ccNameMapId = self.VerifyCommcell(CommServGUID,CommServIP)
            if GetSucces == True:
                return ccNameMapId
      
        query = "select ID from dbo.cf_CommcellIdNameMap WITH(NOLOCK) where CommServGUID = '%s';" % (CommServGUID)

        if self._db.Execute(query) == True:
            while 1:
                row = self._db.m_cursor.fetchone()
                if row:
                    return row.ID
                else:
                    break
        return 0

    def EnableCommcell(self, ccmapid, isEnabled = True):
        flags = 0
        if isEnabled == False:
            flags = 1
        query = "update cf_CommcellIdNameMap set flags = %d where id = %s" % (flags, str(ccmapid))

        try:
            if self._db.Execute(query) == False:
                self.Log.error(__name__ + " :: Error: Query '%s' failed with error: '%s'" % (query, self._db.GetErrorErrStr()))
                return False
        except:
            self.Log.exception(__name__ + "Exception happened while executing query '%s'" % query)
            return False
        
        return True
        
    def AddOrUpdateCommCellNameMapId(self, CSInfo):
        CustomerName = ''
        ContactName = ''
        CustomerDbNotes = ''
        CommCellName = ''
        
        if self.MetricsConfigObj.bContactLicDB == True:
            GetSucces, CustomerName, ContactName, CustomerDbNotes = self._commcellLicdatabase.GetCommCellCustomerInfo(CSInfo.CommcellID, CSInfo.CommServGUID)
            if GetSucces == False:
                self.Log.debug(__name__ + " :: Warning: Could not find CommCell Details from LG Database. Cannot add other CommCell details to cf_CommcellIdNameMap!!!")
                CustomerName = CSInfo.RegInfoCompanyName
                ContactName = CSInfo.RegInfoCustomerName
                CustomerDbNotes = ''
        else:
            CustomerName = CSInfo.RegInfoCompanyName
            ContactName = CSInfo.RegInfoCustomerName
            CustomerDbNotes = ''
        if len(CSInfo.CommServAliasName) > 0:
            CommCellName = CSInfo.CommServAliasName.decode('utf-8')
        else:
            if len(CSInfo.RegInfoCommCellName) > 0:
                CommCellName = CSInfo.RegInfoCommCellName.decode('utf-8')
            else:
                CommCellName = CSInfo.CommcellID
        if len(CustomerName) <= 0:
            CustomerName = CommCellName
        CustomerName = CustomerName.replace("'", "''") #Escape any single quote characters
        ContactName = ContactName.replace("'", "''") #Escape any single quote characters
        CustomerDbNotes = CustomerDbNotes.replace("'", "''") #Escape any single quote characters
        CommCellName = CommCellName.replace("'", "''") #Escape any single quote characters
        CSInfo.RegInfoAddress = CSInfo.RegInfoAddress.replace("'", "''") #Escape any single quote characters
        CSInfo.RegInfoDescription = CSInfo.RegInfoDescription.replace("'", "''") #Escape any single quote characters
        CSInfo.RegInfoEmailAddress = CSInfo.RegInfoEmailAddress.replace("'", "''") #Escape any single quote characters
        CSInfo.RegInfoMiniBrand = CSInfo.RegInfoMiniBrand.replace("'", "''") #Escape any single quote characters
        CSInfo.RegInfoMajorBrand = CSInfo.RegInfoMajorBrand.replace("'", "''") #Escape any single quote characters
        CSInfo.RegInfoInstallTime = CSInfo.RegInfoInstallTime.replace("'", "''") #Escape any single quote characters
        ccNameMapId = self.GetCommCellNameMapId(CSInfo.CommcellID, CSInfo.CommServIP, CSInfo.CommServGUID)
        
        if ccNameMapId == -1:
            return False, 0

        if ccNameMapId == 0:
            query = "INSERT INTO [cf_CommcellIdNameMap]\
           ([CommCellID]\
           ,[CommServIP]\
           ,[CommServGUID]\
           ,[CustomerName]\
           ,[CustomerLicContactName]\
           ,[CustomerLicContactEmail]\
           ,[CustomerLicNotes]\
           ,[CustomerDetails]\
           ,[CustomerPhone]\
           ,[CommServName]\
           ,[CommServTZ]\
           ,[CommServVersion]\
           ,[CSDBIPAddr]\
           ,[CSDescription]\
           ,[CommServEdition]\
           ,[ModifiedTime]\
           ,[CommCellMiniBrand]\
           ,[CommCellMajorBrand]\
           ,[CommCellInstallTime]\
            ,[CommCellSurveyServices]\
            ,[APPCommCellID])\
            VALUES ('" + CSInfo.CommcellID + "', '" + CSInfo.CommServIP + "', '" + CSInfo.CommServGUID + "', '" + CustomerName + "', '" + ContactName + "', '" + CSInfo.RegInfoEmailAddress + "', '" + CustomerDbNotes + "', '" + CSInfo.RegInfoAddress + "', '" + CSInfo.RegInfoPhone + "', '" + CommCellName + "', '" + CSInfo.CommServTZ + "', '" + CSInfo.CommServVersion + "', '" + CSInfo.CommServDBIPAddr + "', '" + CSInfo.RegInfoDescription + "', '" + CSInfo.CommServEdition + "', '" + time.strftime("%Y-%m-%d %H:%M:%S", time.gmtime()) + "', " + CSInfo.RegInfoMiniBrand + ", " + CSInfo.RegInfoMajorBrand + ", "  + CSInfo.RegInfoInstallTime + ", "  + CSInfo.CommcellMetricServices + ", 0 );" 
        else:
            query = "update dbo.cf_CommcellIdNameMap SET CommServIP = '%s', CommServGUID = '%s', CustomerName = N'%s', CustomerLicContactName = N'%s', CustomerLicContactEmail = '%s', CustomerLicNotes = N'%s', CustomerDetails = N'%s', CustomerPhone = '%s', CommServName = N'%s',  CommServTZ = '%s', CommServVersion = '%s', CSDBIPAddr = '%s', CSDescription = N'%s', CommServEdition = '%s', ModifiedTime = '%s', CommCellMiniBrand = '%s', CommCellMajorBrand = '%s', CommCellInstallTime = '%s', CommCellSurveyServices = '%s', CommCellID = '%s', Flags = 0 Where  ID = '%s'" % (CSInfo.CommServIP, CSInfo.CommServGUID, CustomerName, ContactName, CSInfo.RegInfoEmailAddress, CustomerDbNotes, CSInfo.RegInfoAddress, CSInfo.RegInfoPhone, CommCellName, CSInfo.CommServTZ, CSInfo.CommServVersion, CSInfo.CommServDBIPAddr, CSInfo.RegInfoDescription, CSInfo.CommServEdition, time.strftime("%Y-%m-%d %H:%M:%S", time.gmtime()), CSInfo.RegInfoMiniBrand, CSInfo.RegInfoMajorBrand, CSInfo.RegInfoInstallTime, CSInfo.CommcellMetricServices, CSInfo.CommcellID, ccNameMapId)
        try:
            if self._db.Execute(query) == False:
                self.Log.error(__name__ + " :: Error: Query '%s' failed with error: '%s'" % (query, self._db.GetErrorErrStr()))
                return False, 0
        except:
            self.Log.exception(__name__ + "Exception while executing Query '%s'" % query)
            return False, 0
        
        return True, self.GetCommCellNameMapId(CSInfo.CommcellID, CSInfo.CommServIP, CSInfo.CommServGUID)

    def getCommcellRegistrationInfo(self, CSInfo):

        accGlobalId = -1
        retStat = False
        query = "SELECT APPCommCellID FROM cf_CommcellIdNameMap WITH(NOLOCK) WHERE CommServGUID = '%s'" % (CSInfo.CommServGUID)

        try:
            if self._db.Execute(query) == False:
                self.Log.error(__name__ + " :: Error: Query '%s' failed with error: '%s'" % (query, self._db.GetErrorErrStr()))                
            else:
                row = self._db.m_cursor.fetchone()
                if row and row.APPCommCellID == 0:                

                    if self.MetricsConfigObj.bContactLicDB == True:
                        accGlobalId = self._commcellLicdatabase.GetCommcellAccountInfo(CSInfo.CommServGUID)
                        if accGlobalId == -1:
                            self.Log.debug(__name__ + " :: Warning: Could not find CommCell Details from LG Database! Skipping check for commcell registration")
                        else:
                            retStat = True
                else:
                    self.Log.debug(__name__ + " :: Commcell already registered: [%s]" % (CSInfo.CommServGUID))

        except Exception as err:
            self.Log.exception(__name__ + "Exception while checking for commcell registration. Error: [%s]" % (query,str(err)))

        return retStat,accGlobalId

    def UpdateAPPCommcellId(self, guid, app_commcell_id):

        query = "UPDATE cf_CommcellIdNameMap SET APPCommCellID = %s WHERE CommServGUID = '%s'" % (app_commcell_id,guid)

        try:
            if self._db.Execute(query) == False:
                self.Log.error(__name__ + " :: Error: Query '%s' failed with error: '%s'" % (query, self._db.GetErrorErrStr()))                
        except:
            self.Log.exception(__name__ + "Exception while executing Query '%s'" % query)            


    def checkForCommcellUpgrade(self,CSInfo):
        query = "SELECT CommServVersion FROM dbo.cf_CommcellIdNameMap WITH(NOLOCK) WHERE CommCellID = %s AND CommServGUID = '%s'" % (CSInfo.commcellID, CSInfo.CommServGUID)
        retStatus = False
        retData = dict()
        try:
            if CSInfo.commcellID == "-1":
                self.Log.debug(__name__ + ":: Skipping upgrade check for Eval commcell [%s]" % (CSInfo.commcellID))        	
                retStatus = False
                return retStatus, retData

            hexccId = hex(int(CSInfo.commcellID))[2:]
        
            if CSInfo.CommServVersion is None or CSInfo.CommServVersion == "":
                self.Log.error(__name__ + " :: Skipping upgrade check for commcell [%s]: Empty version/service pack info collected." % (hexccId))
                retStatus = False
                return retStatus, retData           

            if self._db.Execute(query) == False:
                self.Log.error(__name__ + " :: Error: Query '%s' failed with error: '%s'" % (query, self._db.GetErrorErrStr()))
                retStatus = False
                return retStatus, retData
            else:
                row = self._db.m_cursor.fetchone()
                if row:
                    if CSInfo.CommServVersion != row.CommServVersion:
                        guid = CSInfo.CommServGUID.replace("-","")
                        serial = guid[:22]
                        regCode = guid[22:]
                        m = CSInfo.CommServVersion.split(".")
                        if len(m) > 1:
                            new_version = m[0]
                            new_servicePack = m[1]
                            if len(m) == 3:
                                new_hpk = m[2]
                            else:
                                new_hpk = None
                        else:
                            new_version = m[0]
                            new_servicePack = None
                            new_hpk = None
                        if new_version is None or new_servicePack is None:
                            self.Log.error(__name__ + " :: Error: Invalid version/service pack info collected for the commcell [%s]: [%s]." % (hexccId, CSInfo.CommServVersion))
                            retStatus = False
                        else:
                            m_curr = row.CommServVersion.split(".")
                            if len(m_curr) > 1:
                                curr_version = m_curr[0]
                                curr_servicePack = m_curr[1]
                                if len(m_curr) == 3:
                                    curr_hpk = m_curr[2]
                                else:
                                    curr_hpk = None        
                            else:
                                curr_version = m_curr[0]
                                curr_servicePack = None
                                curr_hpk= None
                            if curr_version is None or curr_servicePack is None:
                                self.Log.error(__name__ + " :: Error: Invalid version/service pack info present in DB for commcell [%s]: [%s]." % (hexccId, CSInfo.CommServVersion))
                                retStatus = False
                                return retStatus, retData
                            if int(new_version) > int(curr_version) or (new_version == curr_version and int(new_servicePack) > int(curr_servicePack)) :
                                #if(new_hpk != None):
                                #    new_servicePack += "." + new_hpk
                                retData = {"serial":serial, "commcellId":hexccId, "registrationCode": regCode, "version":new_version, "servicePack": new_servicePack}
                                retStatus = True
                            else:
                                self.Log.error(__name__ + " :: Skipping upgrade check for commcell [%s]: Lower version/service pack info collected than the already present in DB: Current[%s], Newly collected:[%s]" % (hexccId, row.CommServVersion, CSInfo.CommServVersion))
                                retStatus = False
        except Exception as err:
            self.Log.exception(__name__ + "Exception while executing Query '%s'. Error: [%s]" % (query,str(err)))
            retStatus = False
        return retStatus, retData
    def getlastprocessedtime(self, csguid, ccid):
        fileTime = 0
        try:
            query = "SELECT  ISNULL(MAX( CAST( SUBSTRING(X.FileName, CHARINDEX('CSS', X.FileName)+3, (CHARINDEX('_', X.FileName) - CHARINDEX('CSS', X.FileName) - 3)) AS BIGINT ) ), 0) AS fileTime FROM cf_CommcellIdNameMap C WITH(NOLOCK) INNER JOIN cf_CustomerFeedbackXmlFile X WITH(NOLOCK) ON C.ID = X.CommcellIdNameMap_ID AND C.CommCellID = %d AND C.CommServGUID = '%s';" % (ccid, csguid)
            if self._db.Execute(query) == True:
                while 1:
                    row = self._db.m_cursor.fetchone()
                    if row:
                        fileTime = row.fileTime
                        return fileTime
                    else:
                        break
        except:
            fileTime = 0
            self.Log.exception(__name__ + " :: Caught Exception while trying to get last processed file time for ccid [%d] csGUID [%s]" % (ccid, csguid))
        return fileTime        
          
    def GetId(self, cssxmldata_filedata):
        query = "select ID from dbo.cf_CustomerFeedbackXmlFile WITH(NOLOCK) where FileName = '%s';" % (cssxmldata_filedata.FileName)
        if self._db.Execute(query) == True:
            while 1:
                row = self._db.m_cursor.fetchone()
                if row:
                    ID = row.ID
                    return ID
                else:
                    break
        return 0

    def IsFileRetriedReachMaxLimit(self, sourceFile, TransferXMLFileInfo):
        query = "select * from dbo.cf_MetricTransferXMLFile WITH(NOLOCK) where FileName like '%s' and RetryCount = (select MIN(RetryCount) from dbo.cf_MetricTransferXMLFile WITH(NOLOCK) where FileName like '%s' and Status >0) ;" % (sourceFile, sourceFile)
        if self._db.Execute(query) == True:
            while 1:
                row = self._db.m_cursor.fetchone()
                if row:
                    if row.RetryCount>=TransferXMLFileInfo.MaxRetry:
                        utctimenow = datetime.datetime.utcnow()
                        # file is older than 7 days
                        val = row.LastRetriedDateUTC+ datetime.timedelta(days=TransferXMLFileInfo.RetentionDays)
                        if utctimenow>val:
                            return 1
                        else :
                            return 0
                else:
                    break
        return 0
    
    
    def LastCopyStatus(self, MetricServerURL, sourceFile, TransferXMLFileInfo):
        query = "select * from dbo.cf_MetricTransferXMLFile WITH(NOLOCK) where FileName = '%s' and MetricServerURL = '%s' ;" % (sourceFile, MetricServerURL)
        if self._db.Execute(query) == True:
            while 1:
                row = self._db.m_cursor.fetchone()
                if row:
                    if row.Status == 0:
                        return 2 ,0 # File is copied
                    
                    utctimenow = datetime.datetime.utcnow()
                    # retry after 60 minutes
                    val = row.LastRetriedDateUTC+ datetime.timedelta(minutes=TransferXMLFileInfo.RetryIntervalMinutes)
                    if utctimenow>val:
                        return 0,row.RetryCount # can retry now
                    else :
                        return 1,row.RetryCount #wait till retry interval is reached
                else:
                    break
        return 0 ,0 #first attempt
    
    def UpdateCopyInfo(self, retryCount, status, errorcode, MetricServerURL, sourceFilePath, sourceFileName):
        
        cssxmldata_filedata = None
        cssxmldata_filedata = CSSXMLDATA_FileData()
        cssxmldata_filedata.FileName = sourceFilePath
        fileId = self.GetId(cssxmldata_filedata)
            
        query = "select * from dbo.cf_MetricTransferXMLFile WITH(NOLOCK) where FileName = '%s' and MetricServerURL = '%s' ;" % (sourceFileName, MetricServerURL)
        ID = None

        if self._db.Execute(query) == True:
            while 1:
                row = self._db.m_cursor.fetchone()
                if row:
                    ID = row.id
                else:
                    break
         
        if ID is None:
            query = "insert into cf_MetricTransferXMLFile (CustomerFeedbackXmlFile_ID, LastRetriedDate, LastRetriedDateUTC, RetryCount, Status,errorCode,MetricServerID,MetricServerURL,FilePath,FileName) values ('{0}', \'{1}\', \'{2}\', '{3}', '{4}', '{5}', '{6}', \'{7}\', \'{8}\', \'{9}\')".format(fileId,time.strftime("%Y-%m-%d %H:%M:%S", time.localtime()),time.strftime("%Y-%m-%d %H:%M:%S", time.gmtime()), retryCount,status,errorcode, 0,MetricServerURL,sourceFilePath,sourceFileName)

            if self._db.Execute(query) == False:
                #print __name__ + " :: Query '%s' failed with error: '%s'" % (query, self._db.GetErrorErrStr())
                self.Log.error(__name__ + " :: Query '%s' failed with error: '{0}'".format((query, self._db.GetErrorErrStr())))
                return False
        else:
            query = "update cf_MetricTransferXMLFile set LastRetriedDate = \'{0}\', LastRetriedDateUTC = \'{1}\', RetryCount = {2}, Status = '{3}' , errorCode = '{4}' where id = {5} ".format(time.strftime("%Y-%m-%d %H:%M:%S", time.localtime()), time.strftime("%Y-%m-%d %H:%M:%S", time.gmtime()), retryCount, status, errorcode, ID)

            if self._db.Execute(query) == False:
                #print __name__ + " :: Query '%s' failed with error: '%s'" % (query, self._db.GetErrorErrStr())
                self.Log.error(__name__ + " :: Query '%s' failed with error: '{0}'".format((query, self._db.GetErrorErrStr())))
                return False

        return True
    
    def UpdateCommcellHeartbeat(self, commcellid, surveyenabled, surveyservices, hearbeattime):
        heartbeattimestr = time.strftime("%Y-%m-%d %H:%M:%S", time.localtime(int(hearbeattime)))
        
        query = "select ID from dbo.cf_CommcellIdNameMap WITH(NOLOCK) where CommCellID = %i" % commcellid
        ID = None
        if self._db.Execute(query) == True:
            while 1:
                row = self._db.m_cursor.fetchone()
                if row:
                    ID = row.ID
                else:
                    break
        if ID is None:
            #in this case, if CommCellSurveyEnabled = 0/2, set flags as 1
            flags = 0
            if surveyenabled == 0 or surveyenabled == 2:
                flags = 1
            
            query = "insert into cf_CommcellIdNameMap (CommCellID, CommCellSurveyEnabled, CommCellSurveyServices, flags, ModifiedTime) values ('{0}', '{1}', '{2}', '{3}', \'{4}\')".format(commcellid, surveyenabled, surveyservices, flags, heartbeattimestr)
            if self._db.Execute(query) == False:
                #print __name__ + " :: Query '%s' failed with error: '%s'" % (query, self._db.GetErrorErrStr())
                self.Log.error(__name__ + " :: Query '%s' failed with error: '{0}'".format((query, self._db.GetErrorErrStr())))
                return False
        else:
            query = "update cf_CommcellIdNameMap set CommCellSurveyEnabled = '{0}', CommCellSurveyServices = '{1}', ModifiedTime = \'{2}\' where CommCellId = '{3}'".format(surveyenabled, surveyservices, heartbeattimestr, commcellid)
            if self._db.Execute(query) == False:
                #print __name__ + " :: Query '%s' failed with error: '%s'" % (query, self._db.GetErrorErrStr())
                self.Log.error(__name__ + " :: Query '%s' failed with error: '{0}'".format((query, self._db.GetErrorErrStr())))
                return False

    def Add_CSSXMLDATA_FileData(self, cssxmldata_filedata):
        try:
            CSInfo = Rpt_CSSXMLDATAROOT()
            
            CSInfo.CommcellID             =     cssxmldata_filedata.rpt_cssxmldataroot.commcellID
            CSInfo.CommServAliasName      =     cssxmldata_filedata.rpt_cssxmldataroot.CommServAliasName
            CSInfo.CommServDBIPAddr       =     cssxmldata_filedata.rpt_cssxmldataroot.CommServDBIPAddr
            CSInfo.CommServGUID           =     cssxmldata_filedata.rpt_cssxmldataroot.CommServGUID
            CSInfo.CommServIP             =     cssxmldata_filedata.rpt_cssxmldataroot.CommServIP
            CSInfo.CommServTZ             =     cssxmldata_filedata.rpt_cssxmldataroot.CommServTZ
            CSInfo.CommServVersion        =     cssxmldata_filedata.rpt_cssxmldataroot.CommServVersion
            CSInfo.emailRecipients        =     cssxmldata_filedata.rpt_cssxmldataroot.emailRecipients
            CSInfo.RegInfoAddress         =     cssxmldata_filedata.rpt_cssxmldataroot.RegInfoAddress
            CSInfo.RegInfoCommCellName    =     cssxmldata_filedata.rpt_cssxmldataroot.RegInfoCommCellName
            CSInfo.RegInfoCompanyName     =     cssxmldata_filedata.rpt_cssxmldataroot.RegInfoCompanyName
            CSInfo.RegInfoCustomerName    =     cssxmldata_filedata.rpt_cssxmldataroot.RegInfoCustomerName
            CSInfo.RegInfoDescription     =     cssxmldata_filedata.rpt_cssxmldataroot.RegInfoDescription
            CSInfo.RegInfoEmailAddress    =     cssxmldata_filedata.rpt_cssxmldataroot.RegInfoEmailAddress
            CSInfo.RegInfoPhone           =     cssxmldata_filedata.rpt_cssxmldataroot.RegInfoPhone
            CSInfo.CommServEdition        =     cssxmldata_filedata.rpt_cssxmldataroot.CommServEdition
            CSInfo.RegInfoMiniBrand       =     cssxmldata_filedata.rpt_cssxmldataroot.RegInfoMiniBrand
            CSInfo.RegInfoMajorBrand      =     cssxmldata_filedata.rpt_cssxmldataroot.RegInfoMajorBrand
            CSInfo.RegInfoInstallTime     =     cssxmldata_filedata.rpt_cssxmldataroot.RegInfoInstallTime
            CSInfo.CommcellMetricServices =     cssxmldata_filedata.rpt_cssxmldataroot.CommcellMetricServices            

            GetSucces, ccNameMapId = self.AddOrUpdateCommCellNameMapId(CSInfo)
            if GetSucces == False or ccNameMapId == 0:
                self.Log.error(__name__ + " :: Error: Failed to add or update cf_CommcellIdNameMap! for CommCellId '%s', CommServIP '%s', CommServGUID '%s' " % (cssxmldata_filedata.rpt_cssxmldataroot.commcellID, cssxmldata_filedata.rpt_cssxmldataroot.CommServIP, cssxmldata_filedata.rpt_cssxmldataroot.CommServGUID))
                return False, 0
        
            CommServTZ = cssxmldata_filedata.rpt_cssxmldataroot.CommServTZ
                    
            Id = self.GetId(cssxmldata_filedata)
            if Id != 0:
                self.Log.debug(__name__ + " :: Warn: File '%s' has already been processed (ID=%i)" % (cssxmldata_filedata.FileName, Id))
                return True, Id
            query = "insert into dbo.cf_CustomerFeedbackXmlFile (CommcellIdNameMap_ID, CommServTZ, CommServVersion, EmailRecipients, FileName,  FileTime, Logging) values ( %s, '%s', '%s', '%s', '%s', '%s', '%s' );"\
            % (ccNameMapId, CommServTZ, cssxmldata_filedata.rpt_cssxmldataroot.CommServVersion, cssxmldata_filedata.rpt_cssxmldataroot.emailRecipients, cssxmldata_filedata.FileName, cssxmldata_filedata.FileTime, cssxmldata_filedata.Logging)

            if self._db.Execute(query) == False:
                self.Log.error(__name__ + " :: Query '%s' failed with error: '%s'" % (query, self._db.GetErrorErrStr()))
                return False, 0
        
            Id = self.GetId(cssxmldata_filedata)
            if Id == 0:
                self.Log.error(__name__ + " :: Error: Failed to add cf_CustomerFeedbackXmlData! for file " + cssxmldata_filedata.FileName)
                return False, 0
                
            for cssxmldata in cssxmldata_filedata.rpt_cssxmldataroot.CssXmlDatas:
                if (int(cssxmldata.logDate) < (time.time() + 24*60*60 )):    #skip the result if the collection time on the cs is greater that metrics server time + 24 hours grace time.
                    collResult = cssxmldata.CollectedResults.replace("'", "''") #Escape any single quote characters
                    query = "insert into dbo.cf_CommservSurveyResults (CustomerFeedbackXmlFile_id ,\
                            LogDate,\
                            LogDateUTC,\
                            QueryId,\
                            CollectedResults,\
                            RunningTime,\
                            CommcellIdNameMap_ID\
                            ) values ( '%s', dbo.UTCToLocalDateTimeConversion(dateadd(S, %s, '1970-01-01'), '%s'), dateadd(S, %s , '1970-01-01'), %s, N'%s', %s, %s);" \
                            % (Id, cssxmldata.logDate, CommServTZ, cssxmldata.logDate, cssxmldata.QueryId, collResult, cssxmldata.RunningTime, ccNameMapId )
                    if self._db.Execute(query) == False:
                        self.Log.error(__name__ + " :: Query '%s' failed with error: '%s'" % (query, self._db.GetErrorErrStr()))
                        return False, 0
                else:
                    self.Log.error(__name__ + " :: Skipping query id [%s] from file [%s] since the collection time exceeds current time. Stop processing this file." % (cssxmldata.QueryId, cssxmldata_filedata.FileName))
                    return False, 0
            return True, Id
        except:
            self.Log.exception(__name__ + " :: Caught Exception while processing file" + cssxmldata_filedata.FileName)
            return False, 0
        
    def insertCsvResult(self, queryid, fileid, logdate, data):
        try:
            if (int(logdate) < (time.time() + 24*60*60 )):    #skip the result if the collection time on the cs is greater that metrics server time + 24 hours grace time.
                query = "insert into dbo.cf_CommservSurveyResults (CustomerFeedbackXmlFile_id ,\
                        LogDate,\
                        LogDateUTC,\
                        QueryId,\
                        CollectedResults,\
                        RunningTime,\
                        CommcellIdNameMap_ID)\
                        select ID, dbo.UTCToLocalDateTimeConversion(dateadd(S, %s, '1970-01-01'), CommServTZ), dateadd(S, %s , '1970-01-01'), %s, N'%s', -1, CommcellIdNameMap_ID\
                        from cf_CustomerFeedbackXmlFile where ID = %s;" \
                        % (logdate, logdate, queryid, data, fileid)
                if self._db.Execute(query) == False:
                    self.Log.error(__name__ + " :: Query '%s' failed with error: '%s'" % (query, self._db.GetErrorErrStr()))
                    return False
            else:
                self.Log.error(__name__ + " :: Skipping query id [%s] from file [%s] since the collection time exceeds current time. Stop processing this file." % (queryid, data))
                return False                
            return True
        except:
            self.Log.exception(__name__ + " :: Caught Exception: ")
            return False

    def parseCsvResult(self, fullFileName, fileTime, fileType, ccID, csGUID):
        self.Log.info("Parsing csv file")
        try:
            ProcessCSVFileQuery = "EXEC ProcessCSVFile '%s', %s, '%s', %s, '%s', 0" % (fullFileName, fileTime, fileType, ccID, csGUID)
            self.Log.debug("Executing query '%s'" % ProcessCSVFileQuery)
            if self._db.Execute(ProcessCSVFileQuery) == False:
                self.Log.error(__name__ + " :: Query '%s' failed with error: '%s'" % (ProcessCSVFileQuery, self._db.GetErrorErrStr()))
                return False
            return True
        except:
            self.Log.exception(__name__ + " :: Caught Exception: ")
            return False

    def parseSurverResults(self):
        self.Log.info("Processing collected results in CVCloud database")
        try:
            ProcessXMLQuery = "EXEC ProcessCollectedResults 0"
            self.Log.debug("Executing query '%s'" % ProcessXMLQuery)
            if self._db.Execute(ProcessXMLQuery) == True:
                return True
            else:
                self.Log.error(__name__ + " :: Query '%s' failed with error: '%s'" % (ProcessXMLQuery, self._db.GetErrorErrStr()))
                return False
        except:
            self.Log.exception(__name__ + " :: Caught Exception: ")
            return False
        
    def runDefragmentIndexes(self):
        self.Log.info("Defragment indexes of top tables with high fragmentation")
        try:
            query = "EXEC DefragmentIndexes"
            self.Log.debug("Executing query '%s'" % query)
            if self._db.Execute(query) == True:
                return True
            else:
                self.Log.error(__name__ + " :: Query '%s' failed with error: '%s'" % (query, self._db.GetErrorErrStr()))
                return False
        except:
            self.Log.exception(__name__ + " :: Caught Exception: ")
            return False  
        
    def countPendingXMLResults(self):
        self.Log.debug("Get pending XML results in CVCloud database which are yet to be processed")
        try:
            returnVal = 0
            query = "SELECT COUNT(1) AS NoOfResults FROM cf_CommservSurveyResults R WITH(NOLOCK) INNER JOIN dbo.RptGetMetricsQueryFlags(0) V ON R.QueryId = V.QueryId AND V.QueryEnabled = 1 AND R.QueryId not in (2, 57) AND R.ShredStatus IN (0, 1) INNER JOIN cf_CommcellIdNameMap CC WITH(NOLOCK) ON CC.ID = R.CommcellIdNameMap_ID AND (CC.Flags&1) = 0;"
            if self._db.Execute(query) == True:
                row = self._db.m_cursor.fetchone()
                if row:
                    returnVal = int(row.NoOfResults)
                else:
                    returnVal = -1
                    self.Log.error(__name__ + " :: Query doesn't return any result")
            else:
                self.Log.error(__name__ + " :: Query '%s' failed with error: '%s'" % (query, self._db.GetErrorErrStr()))
                returnVal = -1
        except:
            returnVal = -1
            self.Log.exception(__name__ + " :: Caught Exception: ")
        return returnVal    
    
    def isTransactionPending(self):
        self.Log.debug("Check if there is any pending transaction in CVCloud database")
        try:
            query = "DECLARE @ErrMessage NVARCHAR(MAX) = '', @TranName NVARCHAR(256) = '', @TranCount INT = 0 \
                    SET @ErrMessage = ERROR_MESSAGE() \
                    SET @TranCount = @@TRANCOUNT \
                    IF  @TranCount > 0 \
                        SET @TranName = (SELECT TOP 1 A.name FROM sys.dm_tran_active_transactions A INNER JOIN sys.dm_tran_session_transactions S ON A.transaction_id = S.transaction_id WHERE S.session_id = @@SPID) \
                    SELECT @@SPID AS SPID, ISNULL(@TranName, '') AS TranName, @TranCount AS TranCount, @ErrMessage AS ErrorMessage"
            if self._db.Execute(query) == False:
                self.Log.error(__name__ + " :: Query '%s' failed with error: '%s'" % (query, self._db.GetErrorErrStr()))
                return True
            else:
                rows = self._db.m_cursor.fetchall()
                if len(rows) == 1:
                    rst = rows[0]
                    if (rst.TranCount > 0):
                        self.Log.info("Pending transaction found in CVCloud database. SPID [%d], TranName [%s], TranCount [%d], ErrorMessage [%s]" 
                                  % (rst.SPID, rst.TranName, rst.TranCount, rst.ErrorMessage))
                        return True
                    else:
                        self.Log.debug("No pending transaction found in CVCloud database. Continue.")
                        return False                        
                else:
                    self.Log.debug("No results found while executing query to get transaction details. Continue.") #it shouldn't come here
                    return False
        except:
            self.Log.exception(__name__ + " :: Caught Exception: ")
            return True
        
    def rollbackTransaction(self):
        self.Log.info("Rollback pending transaction in CVCloud database")
        query = "DECLARE @ErrMessage NVARCHAR(MAX) = '', @TranName NVARCHAR(256) = '', @TranCount INT = 0, @LogString    NVARCHAR(MAX) \
                SET @ErrMessage = ERROR_MESSAGE() \
                SET @TranCount = @@TRANCOUNT \
                IF  @TranCount > 0 \
                BEGIN \
                    SET @TranName = (SELECT TOP 1 A.name FROM sys.dm_tran_active_transactions A INNER JOIN sys.dm_tran_session_transactions S ON A.transaction_id = S.transaction_id WHERE S.session_id = @@SPID) \
                    SET @LogString = 'Add back after rollback tran - ' + (SELECT TOP 1 Message FROM cf_SurveyLogger ORDER BY LogDateUTC DESC) \
                    ROLLBACK TRANSACTION \
                    IF @LogString IS NOT NULL \
                        INSERT INTO cf_SurveyLogger(Message) VALUES(@LogString) \
                    SET @LogString = 'Session ' + CAST(@@SPID AS VARCHAR(20)) + ' - Rolled back an uncommitted transaction ' + ISNULL(@TranName, '') + ' (Previous TRANCOUNT = ' + CAST(@TranCount AS VARCHAR(20)) + ') detected by python process. ' + ISNULL(@ErrMessage, '') \
                        INSERT INTO cf_SurveyLogger(Message) VALUES(@LogString) \
                END \
                ELSE \
                BEGIN \
                    SET @LogString = 'No transaction found to do rollback initiated by python process' \
                    INSERT INTO cf_SurveyLogger(Message) VALUES(@LogString) \
                END"
        self.Log.debug("Executing query '%s'" % query)
        if self._db.Execute(query) == False:
            self.Log.error(__name__ + " :: Query '%s' failed with error: '%s'" % (query, self._db.GetErrorErrStr()))
            self._db.Rollback() #call python pyodbc rollback
            self.Log.error(__name__ + " :: Pyodbc rollback done.")
        return True        
    
    def ReadCommcell(self):
        getcommcellId = "SELECT ID, Name, Value FROM cf_SurveyConfig WITH(NOLOCK) WHERE Name like 'Restrict_CommCellid%'"
        if self._db.Execute(getcommcellId) == True:
            rows = self._db.m_cursor.fetchall()
            if len(rows) < 1:
                return False
            for row in rows:        
                #Process each Commcell
                rowId= row.ID
                Data= row.Value
                attributes = Data.split(";")
                obj = CommcellInfo()
                obj.commServGUID = attributes[0].split("=")[1]
                obj.commcellIP = attributes[1].split("=")[1]
                obj.MetricsNamemapID = attributes[2].split("=")[1]
                self.allCommcells[obj.commServGUID]=obj
        return True

    def VerifyCommcell(self, CommServGUID,CommServIP):
        if CommServGUID in self.allCommcells:
            obj = self.allCommcells[CommServGUID]
            if obj.commcellIP == CommServIP:
                return True,obj.MetricsNamemapID
            else:
                self.Log.info('Staged Commcell [%s] with ip [%s] is being skipped' % (str(CommServGUID), str(CommServIP)))
                return True,-1
        return False,0     

    def getTimeStampOfLastRScriptRunTime(self):
        query = "SELECT ID, Name, Value FROM cf_SurveyConfig WITH(NOLOCK) WHERE Name = 'LastRScriptRunTime'"
        if self._db.Execute(query) == True:
            
            row = self._db.m_cursor.fetchone()
            if row:
                return row.Value
            else:
                #Insert a row as it might not exist
                query = "INSERT INTO cf_SurveyConfig(Name, Value) VALUES('LastRScriptRunTime', 0)"

                try:
                    if self._db.Execute(query) == False:
                        #print __name__ + " :: Error: Query '%s' failed with error: '%s'" % (query, self._db.GetErrorErrStr())
                        self.Log.info(__name__ + " :: Error: Query '%s' failed with error: '%s'" % (query, self._db.GetErrorErrStr()))                        
                except:
                    self.Log.exception(__name__ + "Exception happened while executing query '%s'" % query)                                    
            
            return 0

    def updateTimeStampOfLastRScriptRunTime(self, timeStamp):

        query = "update cf_SurveyConfig set Value = '%s' where Name = 'LastRScriptRunTime'" % (timeStamp)

        try:
            if self._db.Execute(query) == False:
                #print __name__ + " :: Error: Query '%s' failed with error: '%s'" % (query, self._db.GetErrorErrStr())
                self.Log.info(__name__ + " :: Error: Query '%s' failed with error: '%s'" % (query, self._db.GetErrorErrStr()))
                return False
        except:
            self.Log.exception(__name__ + "Exception happened while executing query '%s'" % query)
            return False
        
        return True

    def copytoHttpServer(self, sourceFile, iFileName, copytoHttpServerlist, RestrictQuery, ScrubCC, RegEx, ExclusionDict, sz_SimpanaTemp, httpProxyHost, httpProxyPort, httpProxyUser, httpProxyPasswd, TransferXMLFileInfo):
        #sourceFile - full name with path , iFileName - file name
        fName, fExtension = os.path.splitext(sourceFile)   
        if(fExtension.lower() != ".xml" and fExtension.lower() != ".csv"):
            self.Log.debug("File [%s] is not required to be uploaded " % (iFileName))
            return True
    
        csvFile  = False
        if fExtension.lower() == ".csv" :
            csvFile = True
        
        fccid = None
        fnamesplit = sourceFile.split("_")
        if (len(fnamesplit)>=2):
            fccid = fnamesplit[1].split(".")[0]    
        else:
            self.Log.debug("CommCell id is not found from file name.")
                        
        doScrubbing = False
        if(len(ScrubCC)>0):
            if "ALL" in ScrubCC:
                doScrubbing = True
                self.Log.info("Scrubbing is enabled for file [%s] - " % sourceFile)
            else:
                if fccid in ScrubCC:
                    doScrubbing = True
                    self.Log.info("Scrubbing on file [%s] is enabled for CommCell [%s] - " % (sourceFile,fccid))
                else:
                    self.Log.debug("CommCell id is not found from file name. Scrubbing disabled.")
    
        if((len(RestrictQuery)>0 or doScrubbing == True) and (fExtension.lower() != ".csv")):
            FilteredFile = os.path.join(sz_SimpanaTemp, iFileName)
            if FilteredQuerySourceFiles(sourceFile, FilteredFile, RestrictQuery, doScrubbing, RegEx, ExclusionDict, self.Log)== False:
                return False
        else:
            FilteredFile = sourceFile
            
        retVal = True
        
        copytoHttpServerSSLVer = ''
        
        try:
            if  httpProxyHost is not None:
                self.Log.debug("Using Proxy Host "+httpProxyHost + ':' + str(httpProxyPort))
                proxycommand =  ' -x ' + httpProxyHost + ':' + str(httpProxyPort) 
                if (httpProxyUser is not None) and (httpProxyPasswd is not None) and (len(httpProxyUser)>0):
                    self.Log.debug("Using Proxy User Authentication  Proxy [http://%s:%s] proxyUser [%s] " %(str(httpProxyHost),str(httpProxyPort),str(httpProxyUser)))
                    proxycommand = proxycommand + ' -U ' + httpProxyUser +':'+httpProxyPasswd
        except:
            self.Log.debug("HTTP proxy information can't be loaded")
            httpProxyHost = None
    
        for server,info in copytoHttpServerlist.items():
            isCopyFailed = False
            #get the list of CommCells in info[4] and check if the forwarding is enabled for this CommCell
            if len(info['ForwardingCommCells']) > 0 and fccid not in info['ForwardingCommCells']:
                self.Log.debug("Skipping file %s for Metric URL %s, because it is not required to be forwarded to this metrics server: ..."  % (sourceFile,info['httpServerURL']))
                continue      
    
            copyStatus, retryCount = self.LastCopyStatus(info['httpServerURL'], iFileName, TransferXMLFileInfo)
            if copyStatus == 1:
                self.Log.debug("Skipping file %s for Metric URL %s, because it has been recently tried. Retry count [%d]..."  % (iFileName, info['httpServerURL'], retryCount))
                retVal = False
                continue
            elif  copyStatus == 2:
                self.Log.debug("Skipping file %s for Metric URL %s, because it is already copied: ..."  % (sourceFile,info['httpServerURL']))
                continue       
            
            if re.match(r'[^\s]*/$',info['httpServerURL']) is None:
                info['httpServerURL'] = info['httpServerURL'] + '/'
    
            if  info['isPublic'] == 0:
                uploadurl = info['httpServerURL']+'metrics/metricsUpload.do'
            else:
                uploadurl = info['httpServerURL']+'upload.asp'
            self.Log.debug("Copying filtered File %s to Server %s" % (iFileName, uploadurl))
    
            try:
                # without -f, HTTP errors will result in a successful return code
                precommand = 'curl -f -F "mode=go" -F "ccid=" -F "username=%s" -F "password=%s" -F "logfile=@' % (info['user'], info['pwd'])
                postcommand ='" '+ uploadurl + ' -k ' + ' -s -u '+ info['user']+ ':'+ info['pwd'] + copytoHttpServerSSLVer
     
                if (httpProxyHost is None) or (len(httpProxyHost)==0):
                    command = precommand +FilteredFile + postcommand 
                else:
                    command = precommand +FilteredFile + postcommand + proxycommand
    
                ret = os.system(command)
                if ret == 35:
                    self.Log.error("Retrying source File %s with sslv3" % (FilteredFile))
                    copytoHttpServerSSLVer = ' -3 '
                    command += copytoHttpServerSSLVer
                    postcommand += copytoHttpServerSSLVer
                    ret = os.system(command)
                if ret != 0:
                    self.Log.error("File copy failed for source file %s to URL [%s] - error code %s " % (FilteredFile,uploadurl, str(ret)))
                    isCopyFailed = True
                else:         
                    self.Log.debug("XML File [%s] uploaded successfully to URL [%s]" % (FilteredFile, uploadurl))
            except:
                self.Log.exception("Failed to upload file [%s] to URL [%s] " % (iFileName, uploadurl))
                isCopyFailed = True
                
            statusFail = 0
            if(isCopyFailed == True):
                statusFail = 1
                retVal = False
                
            self.UpdateCopyInfo(retryCount + 1,statusFail,ret,info['httpServerURL'],sourceFile,iFileName)
    
        if(len(RestrictQuery)>0 or doScrubbing == True) and (FilteredFile != sourceFile):
            command = 'del /Q "' + FilteredFile+ '"'
            os.system(command)
            
        return retVal

