'''
/******************************************************************************/
/*  Copyright (c) CommVault Systems                                           */
/*  All Rights Reserved                                                       */
/*                                                                            */
/*  THIS IS UNPUBLISHED PROPRIETARY SOURCE CODE OF CommVault Systems          */
/*  The copyright notice above does not evidence any                          */
/*  actual or intended publication of such source code.                       */
/******************************************************************************/
Created on Mar 22, 2012
Revision: $Id: CommCellLicDatabase.py,v 1.16.46.11 2020/09/26 02:32:58 dnavaneethan Exp $
$Date: 2020/09/26 02:32:58 $
@author: David Maisonave
'''
from Database import Database
import Logger
from MetricsConfig import MetricsConfig

class CommCellLicDatabase:
    '''
    classdocs
    '''

    def __init__(self, logFile="CVSurvey"):
        '''
        Constructor
        '''

        #initialize logger
        self.Log = Logger.InitLogger(logFile)
        self.MetricsConfigObj = MetricsConfig(logFile).get_instance()
        self._sz_DbConnStr = self.MetricsConfigObj.sLICDBCONNSTR
        self._sz_DbName = self.MetricsConfigObj.sLICDBNAME
        self._sz_DbDSN = self.MetricsConfigObj.sLICCONNECTION
        self._db = Database(logFile=logFile, ConnStr = self._sz_DbConnStr, DSNName = self._sz_DbDSN, Dbname = self._sz_DbName)
               
        self._bOpenConnection = False
        try:
            if self._db.OpenSimpleDSN() == True:
                self._bOpenConnection = True
        except Exception as dberr:
            if self._bOpenConnection == False:
                self._db.SetErrorErrStr(dberr.args[1])
                self.Log.error(__name__ + " :: Failed to open DB '%s', with error %s" %(self._sz_DbName, self._db.GetErrorErrStr()))                    

    def GetCommCellCustomerInfo(self, CommCellId, CSGuid):
        Organization = ""
        OwnerName = ""
        Notes = ""
        retStatus = True
        
        if (CommCellId == '-1'):
            Organization = "Eval CommCell"
        query = "SELECT ISNULL(A.Name, '') AS Name, ISNULL(A.OwnerName, '') AS OwnerName FROM LACCMCommcellInfo CC WITH(NOLOCK) INNER JOIN LACCMAccount A WITH(NOLOCK) ON CC.AccountGlobalId = A.AccountGlobalId WHERE (REPLACE(CC.SerialCode, '-', '') + REPLACE(CC.RegistrationCode, '-', '')) = REPLACE('%s', '-', '')" % (CSGuid)
               
        if self._bOpenConnection == True and self._db.Execute(query) == True:
            row = self._db.m_cursor.fetchone()

            if not row:
                if (CommCellId == '-1'):
                    retStatus = True
                else:
                    retStatus = False
            else:
                if not row.Name:
                    retStatus = False
                else:
                    Organization = row.Name
                    if row.OwnerName:
                        OwnerName = row.OwnerName
                    retStatus = True
                    
                if (CommCellId != '-1'): 
                    LAServerInfoQuery = "SELECT RTRIM(LTRIM(ISNULL(CCGuid, ''))) AS CCGuid FROM LAServerInfo WITH(NOLOCK) WHERE FinanceId = '%s';" % (CommCellId)
                    if self._bOpenConnection == True and self._db.Execute(LAServerInfoQuery) == True:
                        row = self._db.m_cursor.fetchone()
                        if row:
                            if row.CCGuid == '' and self.MetricsConfigObj.iUpdateGUIDInLicDB == 1:
                                self.Log.info(__name__ + " :: Updating CommServ GUID '%s' in license database for CommCell ID '%s';" % (CSGuid, CommCellId))
                                updateQuery = "UPDATE LAServerInfo SET CCGuid = '%s' WHERE FinanceId = '%s';" % (CSGuid, CommCellId)    #TODO: acquire lock 
                                if self._bOpenConnection == True and self._db.Execute(updateQuery) == False:
                                    self.Log.error(__name__ + " :: Updating CommServ GUID '%s' for CommCell ID '%s' is failed with error: '%s'" % (CSGuid, CommCellId, self._db.GetErrorErrStr()))
                            elif row.CCGuid.lower() != CSGuid.lower():
                                self.Log.error(__name__ + " :: Duplicate CommCell found for CommCellID [%s]. Notify Dev-Licensing. GUID in License Database [%s]. GUID in Metrics Server [%s]" % (CSGuid, row.CCGuid, CSGuid))
                
        return retStatus, Organization, OwnerName, Notes


    def GetCommcellAccountInfo(self, CSGuid):
        accGlobalId = -1
        query = "SELECT AccountGlobalId FROM LACCMCommcellInfo CC WITH(NOLOCK) WHERE (REPLACE(CC.SerialCode, '-', '') + REPLACE(CC.RegistrationCode, '-', '')) = REPLACE('%s', '-', '')" % (CSGuid)
        
        try:     
            if self._bOpenConnection == True and self._db.Execute(query) == True:
                row = self._db.m_cursor.fetchone()

                if row:
                    accGlobalId = int(row.AccountGlobalId)

        except Exception as err:
            self.Log.exception(__name__ + "Exception while executing Query '%s'. Error: [%s]" % (query,str(err)))

        return accGlobalId
