#!/bin/sh

printf "\n############################################################"
printf "\nCommvault Backup and Restore Utility for Greenplum Database"
printf "\n############################################################\n"

commvault_base_path=`dirname $PWD`
commvault_install_path=`dirname $commvault_base_path`

if [ ! -f "$commvault_install_path/galaxy_vm"  -o ! -f "$commvault_base_path/cvprofile" ]
then
    echo "Unable to locate files in current location ($commvault_install_path/galaxy_vm, $commvault_base_path/cvprofile)."
    echo "Fetching Commvault install location from registry ..."
    commvault_base_path=`grep dBASEHOME /etc/CommVaultRegistry/Galaxy/Instance001/Base/.properties  | awk '{print $2}'`
    commvault_install_path=`grep dGALAXYHOME /etc/CommVaultRegistry/Galaxy/Instance001/Base/.properties | awk '{print $2}'`

    if [  ! -f "$commvault_install_path/galaxy_vm"   -o ! -f "$commvault_base_path/cvprofile" ]
    then
        echo "Unable to locate files ($commvault_install_path/galaxy_vm, $commvault_base_path/cvprofile). Please run the tool from <Commvault base location>/CVGreenplumBkpRstUtility"
        python CVMain.py -h
        exit 1
    fi
fi
#echo "Setting Commvault specific environment ($commvault_install_path/galaxy_vm, $commvault_base_path/cvprofile)"

. $commvault_base_path/cvprofile
. $commvault_install_path/galaxy_vm


#-- for non-root user
if [ $EUID -ne 0 ]
then
	if [ ! -z "$GPHOME" ]
	then
	. $GPHOME/greenplum_path.sh 2> /dev/null
	else
		echo "GPHOME env is NOT set. Please export GPHOME env in gpadmin user session"
	fi
fi

printf "\nCommvault install location: $commvault_install_path"
printf "\nCommvault Base location: $commvault_base_path"
export LD_LIBRARY_PATH=$commvault_base_path:$LD_LIBRARY_PATH
export commvault_base_path=$commvault_base_path
python $commvault_base_path/CVGreenplumBkpRstUtility/CVMain.py "$@"
printf "\n####################### END ############################"
printf "\n"

