#! /usr/bin/env python

#############################################################################################################
# Name          : main.py
# Created By    : Saamaja Vupputuri 10/01/2017
#
# Description   : Commvault backup and restore utility for Greenplum
#                    Return code 0 -- successful
#                    Return code 1 -- Failed
#############################################################################################################

import CVHelperUtils

from sys import argv
#try:
#    import argparse
#except ImportError:
#    print ('Unable to import argparse. Exiting')
#    raise
try:
    from CVGreenplumBkpRstClient import *
except ImportError:
    print ('Unable to import CVGreenplumBkpRstClient. Exiting')
    raise
import logging
import getopt

cvgpclient = CVGreenplumBkpRstClient()

def processInputArguments():

    global cvgpclient
    try:
        (options, values) = getopt.getopt(sys.argv[1:], 'hs:i:d:t:p:n:f:g:b:r:u:c:')
    except Exception, e:
        #log.error('Exception raised while parsing input arguments: %s %s' % (sys.exc_info()[0],  sys.exc_info()[1]))
        print('\nException raised while parsing input arguments: %s %s' % (sys.exc_info()[0], sys.exc_info()[1]))
        usage(1)

    for opt,val in options:
        if opt in ('-h'):
            usage(0)

        # Commvault specific inputs
        elif opt in ('-s'):
            cvgpclient.cvSrcClientName = val
        elif opt in ('-i'):
            cvgpclient.cvSrcInstance = val
        elif opt in ('-d'):
            cvgpclient.cvDestClientName = val
        elif opt in ('-t'):
            cvgpclient.cvDestInstance = val
        elif opt in ('-p'):
            cvgpclient.cvProxyHostName = val
        elif opt in ('-n'):
            cvgpclient.cvProxyCvdPort = val
        elif opt in ('-f'):
            cvgpclient.cvLogFilePath = val
        elif opt in ('-g'):
            cvgpclient.cvEnableDebugLogging = val
        elif opt in ('-c'):
            cvgpclient.cvStorageCopyPrec = val

        # Greenplum commands options
        elif opt in ('-b'):
            cvgpclient.gpcrondumpOptions  = val
        elif opt in ('-r'):
            cvgpclient.gpdbrestoreOptions  = val


    print ("\nInput Arguments:")
    print_usage=0

    if cvgpclient.cvSrcClientName is not None:
        print('\tCommvault source client name: %s' % cvgpclient.cvSrcClientName)
    else:
        print('\tCommvault source client name: NOT SET')
        print_usage = 1


    if cvgpclient.cvSrcInstance is not None:
        print ('\tCommvault source instance name: %s' % cvgpclient.cvSrcInstance)
    else:
        print('\tCommvault source instance name: NOT SET')
        print_usage = 1

    if cvgpclient.cvDestClientName is not None:
        print ('\tCommvault dest client name: %s' % cvgpclient.cvDestClientName)
    if cvgpclient.cvDestInstance is not None:
        print ('\tCommvault dest instance name: %s' % cvgpclient.cvDestInstance)

    print ('\tCommvault proxy host: %s'%cvgpclient.cvProxyHostName)
    print ('\tCommvault proxy port: %s'%cvgpclient.cvProxyCvdPort)
    print('\tCommvault utility logfile path: %s' % cvgpclient.cvLogFilePath)
    print ('\tCommvault debug enabled: %s'%cvgpclient.cvEnableDebugLogging)
    print ('\tCommvault storage copy precedence: %s'%cvgpclient.cvStorageCopyPrec)


    print ('\tGreenplum admin user: %s' % cvgpclient.gpAdminUser)

    if cvgpclient.gpcrondumpOptions is not None:
        print('\tGreenplum gpcrondump options: %s' % cvgpclient.gpcrondumpOptions)
    else:
        print('\tGreenplum gpcrondump options: NOT SET')

    if cvgpclient.gpdbrestoreOptions is not None:
        print('\tGreenplum gpdbrestore options: %s' % cvgpclient.gpdbrestoreOptions)
    else:
        print('\tGreenplum gpdbestore options: NOT SET')

    if cvgpclient.gpcrondumpOptions is None and cvgpclient.gpdbrestoreOptions is None:
        print_usage = 1

    if print_usage == 1:
        print('\n\tPlease SET required inputs.')
        usage(1)

    return True

def usage(exitarg):
    """

Usage: ./CVMain.sh [-h] [-s cvSrcClientName]  [-i cvSrcInstanceName] [-p cvProxyHostName] [-n cvProxyPort]
        [-f cvLogFilePath] [ -g cvDebugLevel ] [ -c cvstoragecopyPrec ]
        [-b gpcrondumpOptionsString] [-r gpdbrestoreOptionsString] [-u gpAdminUser]


         -h                               : print this help screen
         -s <cvSourceClientName>          : Commvault source client name
         -i <cvSourceInstanceName>        : Commvault source instance name
         -p <cvProxyHostName>             : Commvault proxy full host name or ip. Default is "localhost"
         -n <cvProxyPort>                 : Commvault proxy host CVD service listening port number. Default is "8400"
         -f <cvLogFilePath>               : Commvault utility log file path. Default is "/tmp/CVGreenplumBkpRstUtility.log"
         -g <cvDebugLevel>                : Commvault logging is enabled with debug information. Default is "0"
         -c <cvStorageCopyPrec>           : Commvault Storage copy precedence. Default is "0"
         -b <gpcrondumpOptions>           : Greenplum gpcrondump options
         -r <gpdbrestoreOptions>          : Greenplum gpdbrestore options
         -u <gpAdminUserName>             : Greenplum database admin user. Default is "gpadmin"

    """

    print( usage.__doc__)
    sys.exit(exitarg)

def main(argv):

    ret = processInputArguments()
    if not ret:
        print("\nFailed to process input arguments. Exiting the utility ...")
        usage(1)

    log = CVHelperUtils.getLoggerObject(cvgpclient.cvLogFilePath)
    cvgpclient.setLoggerObject(log)

    log.info("############################################################")
    log.info("Commvault Backup and Restore Utility for Greenplum Database")
    log.info("############################################################")
    if cvgpclient.cvEnableDebugLogging:
        log.setLevel(logging.DEBUG)

    ret = cvgpclient.run()
    if not ret:
        log.info("Failed to complete the process. Exiting the utility ...")
        print("\nFailed to complete the process. Exiting the utility ...")
        usage(1)

    print("\n\nCompleted the process.\n" )


    sys.exit(0)
    
if __name__ ==  "__main__":
    main(argv)
