# !/usr/bin/env python
#############################################################################################################
# Name          : CVGreenplumBkpRstClient.py
# Created By    : Saadmin   amaja Vupputuri 10/01/2017
#
# Description   : Greenplum backup and restore classs

#############################################################################################################

import CVHelperUtils
import os, errno, time, sys, signal
import threading
from threading import Thread
from CVHelperUtils import ExecuteCommand


MONITOR_PERIOD_CNT = 120  # MONITOR_PERIOD_CNT * MONITOR_POLLING_INTERVAL = 600 secs = 10 mins
MONITOR_POLLING_INTERVAL = 5  # every 5 secs
CV_QUIT_SIGNAL_FILE = "/tmp/CVBKPRSTWRAPPER_EXIT_IMMEDIATELY"

commvault_base_path = None
CVBKPRSTWRAPPER = 'CVBkpRstWrapper'
GP_ENV_CMD_ESC = ". \$GPHOME/greenplum_path.sh;"  # gpadmin user env script
GP_ENV_CMD = ". $GPHOME/greenplum_path.sh;"  # gpadmin user env script
DEFAULT_LOG_FILE_PATH = "/tmp/CVGreenplumBkpRstUtility.log" # default log path for the tool

class CVGreenplumBkpRstClient:
    """
    Class for Greenplum backup and restore
    """

    def __init__(self):
        """
        Constructor
        """
        self.cvSrcInstance = None
        self.cvDestInstance = None
        self.cvSrcClientName = None
        self.cvDestClientName = None
        self.cvProxyHostName = "localhost"
        self.cvProxyCvdPort = "8400"
        self.cvLogFilePath = DEFAULT_LOG_FILE_PATH
        self.cvEnableDebugLogging = "0"
        self.cvStorageCopyPrec = "0"

        self.gpAdminUser = "gpadmin"
        self.databaseName = None
        self.mode = "RESTORE"
        self.subMode = "TABLE"
        self.tableList = None

        self.pit = None
        self.gpcrondumpOptions = None
        self.gpdbrestoreOptions = None
        

        self.execHandler = None
        self._backup_file_guids = {}
        self.node_to_fileList = {}
        self.gpBackupDirectory = None
        self.gpTableTruncate = True
        self.gpdbrestoreCmdRet = 1
        self.cvCommcellid = "2" #default value is 2

        # -- backup directory used for backups, if not defaults to instance data directory
        # -- assume GP admin user login env is setup correctly in respective
        # -- or else GP instance properties  are needed  to set the env

    def setLoggerObject(self, logger):
        self.logger = logger

    def setCvOpenBackupClientPath(self):
        global commvault_base_path
        global CVBKPRSTWRAPPER
        for key in os.environ.keys():
            if key == "commvault_base_path":
                commvault_base_path = os.environ[key]
                self.logger.info('Using Commvault install path [%s]' % commvault_base_path)
                break
        if commvault_base_path is  None:
            self.logger.error('Unable to find Commvault install path. Using default install location %s'%CVBKPRSTWRAPPER)

        CVBKPRSTWRAPPER = commvault_base_path+"/"+"CVGreenplumBkpRstUtility/CVBkpRstWrapper"

    def run(self):
        retValue = True
        #-- Set the execute interface. default timeout timer for any command is 60 secs
        self.execHandler = ExecuteCommand(self.logger, 60)
        self.setCvOpenBackupClientPath()

        if self.gpdbrestoreOptions is not None:
            return self.runGreenplumRestore()
        elif self.gpcrondumpOptions is not None:
            return self.runGreenplumBackup()
        else:
            print('\nInvalid Greenplum options. Please provide correct inputs')
            return False


    def runGreenplumRestore(self):
        self.logger.info('gpdbrestore options \"%s\"' % (self.gpdbrestoreOptions))
        optionsList = self.gpdbrestoreOptions.split()
        index = 0

        for opt in optionsList:

            #-- database name of the backup dump
            if opt in '-s':
                self.databaseName = optionsList[index+1]

            #-- point in time backup timestamp
            if opt in '-t':
                self.pit = optionsList[index + 1]

            index = index + 1

        # get Cv restore context ---> (commcellId, clientId, instanceId, backupsetid,subClientid)
        if not self.getCvContext():
            self.logger.info('Failed to get CV context.')
            return False

        # get list of files backed up
        if self.getBackupFilesListInCycle() is False:
            self.logger.info('Failed to get list of backup files.')
            return False

        # restore the Greenplum metadata files of the backup
        if self.restoreGreenplumBkpMetadataFiles() is False:
            self.logger.info('Failed to restore metadata files of the backup.')
            return False

        # prepare the Greenplum environment for restore using named pipes
        if self.prepareRestore() is False:
            self.logger.info('Failed to configure named pipes for restores')
            return False

        if self.runGpRestore() is False:
            self.logger.info('Failed in Greenplum restore process.')
            return False

        return True

    def runGreenplumBackup(self):
        print('\nGreenplum backups are not supported yet')
        return False


    def runGpRestore(self):
        global commvault_base_path
        segment_threads = []
        # -- launch segment restore threads
        for key in self.node_to_fileList.keys():
            for fifo in self.node_to_fileList[key]:

                pipeCmd = self.genWriteToPipeCommand(fifo)
                # -- localhost
                self.logger.info('localhostname=%s' % os.uname()[1])
                if os.uname()[1] == key.strip():
                    cmdToWaitForGPRestoreAgent = pipeCmd
                # -- remote host
                else:
                    ld_path_command = "export LD_LIBRARY_PATH=%s:$LD_LIBRARY_PATH"%commvault_base_path
                    cmdToWaitForGPRestoreAgent =  " ssh " + key.strip() + " \" "+ ld_path_command + ";" + pipeCmd + " \" "

                t = threading.Thread(target=WaitForGpRestoreAgent, name='WaitForGpRestoreAgent',
                                     args=[self, fifo, key.strip(), cmdToWaitForGPRestoreAgent])
                segment_threads.append(t)
                t.start()


        # -- wait for remote clients to block in FIFO write
        time.sleep(10)

        # -- launch gpdbrestore command thread
        gpdbrestoreCmd = self.genGpDBRestoreCmd()
        gpdbrestoreThread = threading.Thread(target=RunGPDBRestoreCmd, name='RunGPDBRestoreCmd',
                                             args=[self, gpdbrestoreCmd])
        segment_threads.append(gpdbrestoreThread)
        gpdbrestoreThread.start()

        print ('\nLaunched Greenplum command: %s' %gpdbrestoreCmd)
        self.logger.info('Inside Main thread... Waiting for all restore processes')

        monitorLimit = 0
        # while monitorLimit < MONITOR_PERIOD_CNT:
        # below is infinite loop, if CV agents and gpdbrestore are both running
        # gpdbrestore exits after 5 mins  if no data is provided  to it.
        while 1:
            self.logger.debug('Monitoring restore threads ... %s' % str(monitorLimit))
            for restoreThread in segment_threads:
                if not restoreThread.isAlive():
                    segment_threads.remove(restoreThread)

            if not gpdbrestoreThread.isAlive():
                self.logger.info('gpdbrestore exited. retcode = %d' % self.gpdbrestoreCmdRet)
                break

            if len(segment_threads) == 0:
                self.logger.info('CV restore agents have exited, but gpdbrestore is still running. Wait for a minute on gpdbrestore to exit ....')
                time.sleep(60)  # wait for 1 minute.. for any post processing from gpdbrestore
                break

            self.logger.debug('gpdbrestore is running ... CV restore agents are running .... ')

            # sleep for 5 seconds before polling
            time.sleep(MONITOR_POLLING_INTERVAL)
            monitorLimit += 1

        #if monitorLimit >= MONITOR_PERIOD_CNT:
        #   self.logger.error('Maximum monitoring period %s secs reached. Clean up the restore agents ...' % str(monitorLimit * MONITOR_POLLING_INTERVAL))

        # -- Cleanup restore processes
        # -- 1. Kill the ssh login processes
        for pid in self.execHandler.pidsListToMonitor:
            if self.isPidAlive(pid) and self.killProcess(pid):
                self.logger.info('Killed process %d' % pid)
        # -- 2. Send quit signal to CVBkpRstWrapper restore processes
        self.logger.debug('Sending quit signal to CV restore agents  ...')
        for key in self.node_to_fileList.keys():
            cmdToSignalQuit = "touch " + CV_QUIT_SIGNAL_FILE
            if not (os.uname()[1] == key.strip()):
                cmdToSignalQuit = "ssh " + key.strip() + " \" " + cmdToSignalQuit + " \" "
            (retp, outp, errp) = self.execHandler.runCommand(cmdToSignalQuit)

        # -- wait for remote CVBkpRstWrappers to read the quit signal
        time.sleep(5)

        # -- Remove the quit signal on greenplum nodes
        for key in self.node_to_fileList.keys():
            cmdToSignalQuit = "rm -f " + CV_QUIT_SIGNAL_FILE
            if not (os.uname()[1] == key.strip()):
                cmdToSignalQuit = "ssh " + key.strip() + " \" " + cmdToSignalQuit + " \" "
            (retp, outp, errp) = self.execHandler.runCommand(cmdToSignalQuit)

        if self.gpdbrestoreCmdRet == 0:
            return True
        else:
            return False

    def isPidAlive(self, pid):
        try:
            os.kill(pid, 0)
            return True
        except OSError, e:
            if e.errno == errno.EPERM:
                return True
        return False

    def killProcess(self, pid):
        try:
            os.kill(pid, signal.SIGKILL)
            return True
        except OSError, e:
            if e.errno != errno.ESRCH:
                self.logger.info('Failed to kill pid=%d. errno=%d' % (pid, e.errno))
            pass
        except:
            self.logger.info('Exception occurred to kill pid=%d  exception=%s' % (pid, sys.exc_info()[0]))
            pass
        return False

    def genGpDBRestoreCmd(self):

        gpdbrestoreCmd = " gpdbrestore " + self.gpdbrestoreOptions + \
                         " --prefix " + self.cvPrefix + \
                         " -u " + self.gpBackupDirectory + \
                         " -a --verbose "

        if os.geteuid() == 0:
            su_command = "su  - " + self.gpAdminUser + " -c  \"" + GP_ENV_CMD_ESC + gpdbrestoreCmd + " \""
        else:
            su_command =   GP_ENV_CMD + gpdbrestoreCmd
        self.logger.info("Command for gpdbrestore: %s" % gpdbrestoreCmd)
        return su_command

    def genWriteToPipeCommand(self, pipeFullPath):

        version_guid = self.getBackupFileCvguid(pipeFullPath)
        wrtie_to_pipe_cmd = CVBKPRSTWRAPPER + " -restore --cv-proxy-host " + str(self.cvProxyHostName) + \
                            " --cv-proxy-port " + str(self.cvProxyCvdPort) + " --cv-clientid " + str(self.cvClientid) + \
                            " --cv-apptype Q_DISTRIBUTED_IDA " + \
                            " --cv-filename " + pipeFullPath + \
                            " --cv-guid " + version_guid + " --cv-appid " + str(self.cvAppid) + \
                            " --cv-jobid 0 --cv-jobtoken 0  --cv-debuglvl " + str(self.cvEnableDebugLogging) + " --cv-copyprecedence " + str(self.cvStorageCopyPrec)

        self.logger.debug("Command to write into pipe: %s" % wrtie_to_pipe_cmd)
        return wrtie_to_pipe_cmd

    def prepareRestore(self):

        fifo_files = []
        # -- parse the _pipes metadata files in the cycle
        for file in self._backup_file_list:
            if "_pipes" in file:
                self.logger.info('Found fifo file %s' % file)
                with open(file)  as f:
                    fifo_files += f.readlines()
                f.close()

        # -- create FIFO files on all the Greenplum nodes
        if self.createFIFOFilesOnNodes(fifo_files) is False:
            return False

        # -- launch CVBKPRSTWRAPPER on all nodes. They should block on FIFO write()

        return True

    def createFIFOFilesOnNodes(self, fifo_files_list):

        # -- create map of node -- > fifolist
        for fifo in fifo_files_list:
            (node, fifo_file) = fifo.strip().split(":")
            self.logger.info('%s --> %s' % (node, fifo_file))
            try:
                self.node_to_fileList[node].append(fifo_file)
            except KeyError:
                self.node_to_fileList[node] = [fifo_file]

        # -- SSH to node and create the FIFO files
        for key in self.node_to_fileList.keys():

            script_command_str = "ssh " + key.strip()
            # -- opening quote
            script_command_str += " \""
            firstTime = True
            for fifo in self.node_to_fileList[key]:
                if firstTime:
                    script_command_str += "mkdir -p " + os.path.dirname(fifo.strip()) + ";"
                    firstTime = False
                script_command_str += "rm -f " + fifo.strip() + ";" + "mkfifo " + fifo.strip() + ";" + "chmod 664 " + fifo.strip() + ";"
            # -- closing quote
            script_command_str += "\""
            # -- open script file in pwd
            self.logger.info('Script for node %s ---> %s' % (key, script_command_str))
            script_file = "CVTmpScriptFile_%s.sh" % key
            with open(script_file, "w") as fd:
                fd.write('%s' % script_command_str)

            try:
                os.chmod(script_file, 0775)
            except OSError, e:
                self.logger.info('Unable to set execute permissions on file %s errno=%d' % (script_file, e.errno))
                pass
            except:
                self.logger.info('Exception encountered to set execute permissions on file %s exception: %s' % (
                script_file, sys.exc_info()[0]))
                pass
            script_file = os.path.abspath(script_file)

            if os.geteuid() == 0:
                su_command = "su - " + self.gpAdminUser + " -c " +  "\"" + GP_ENV_CMD_ESC + script_file + "\""
            else:
                su_command = GP_ENV_CMD + script_file

            (ret1, out1, err1) = self.execHandler.runCommand(su_command)

            # cleanup script files
            os.remove(script_file)

            if ret1 == 0:
                self.logger.info('Successfully created FIFO files on Greenplum nodes')
            else:
                self.logger.info('Failed to create FIFO files on Greenplum nodes')
                return False

        return True

    def getBackupFilesListInCycle(self):
        self.restoreGPtimestamp = 0  # restore timestamp

        # -- for point in time restore
        if self.pit > 0:
            self.restoreGPtimestamp = self.pit
            self.logger.debug(
                "Find Commvault backup start/end time for Greenplum backup timestamp %s" % self.restoreGPtimestamp)

            regex = ("*%s.rpt") % str(self.restoreGPtimestamp)
            query_string = self.genCvBrowseQueryCmd(regex)
            (ret, out, err) = self.execHandler.runCommand(query_string)

            if ret == 0:
                out = out.strip()
                if len(out) == 0:
                    self.logger.error("No backup files found for backup timestamp %s" % (self.pit))
                    return False

                file_info = out.split('\n')
                for line in file_info:
                    if len(line.strip()) > 0:
                        (fname, oguid, cvguid, fromtime, totime, self.cvCommcellid,
                         self.cvSubClientId) = line.strip().split(':')
                        self.cvPrefix = fname[(fname.rfind("/") + 1):fname.rfind("_gp_")]
                        self.cvAppid = self.cvCommcellid + ":" + self.cvSubClientId

                regex = self.cvPrefix + "_gp_dump_*"
                command_string = self.genCvBrowseQueryCmd(regex, fromtime, totime)
            else:
                self.logger.info(
                    "Failed to find Commvault backup start/end times for Greenplum backup timestamp %s" % self.pit)
                return False

        elif self.databaseName is not None:
            regex = "cv%s_gp_dump_*" % self.databaseName
            command_string = self.genCvBrowseQueryCmd(regex)
        else:
            command_string = self.genCvBrowseQueryCmd("*")

        (ret1, out1, err1) = self.execHandler.runCommand(command_string)

        if ret1 == 0:
            out1 = out1.strip()

            if len(out1) == 0:
                self.logger.error("No backup files found")
                return False
            files_list = out1.split('\n')

            for line in files_list:
                if len(line.strip()) > 0:
                    (fileFullPath, objGuid, versionGuid, fromTime, toTime, commcellid, appid) = line.split(':')
                    self._backup_file_guids[fileFullPath] = versionGuid
                    self.logger.debug("Caching file [%s] with GUID [%s]" % (fileFullPath, versionGuid))
                    self.cvAppid = self.cvCommcellid + ":" + self.cvSubClientId
        else:
            self.logger.error("Failed to get list of backup files")
            return False
        self._backup_file_list = sorted(self._backup_file_guids.keys(), None, None, True)

        # For latest restore
        # set the restore timestamp from the latest backup report file name
        if self.restoreGPtimestamp == 0:
            for file in self._backup_file_list:
                if ".rpt" in file:
                    list = file.split('.')
                    list2 = list[0].split('_')
                    self.restoreGPtimestamp = list2.pop()
                    self.logger.debug(
                        "Found restore timestamp=%s for database=%s" % (self.restoreGPtimestamp, self.databaseName))
                    break
            self.cvPrefix = "cv" + str(self.databaseName)

        return True

    def IsMetaDataFile(self, file):
        if ".rpt" in file or "_increments" in file or "_pipes" in file or "_regular_files" in file or "_state_file" in file or "_last_operation" in file or "_cdatabase_" in file or "_status_" in file:
            return True
        return False

    def getBackupFileCvguid(self, fname):
        fname.strip()
        for file in self._backup_file_list:
            if os.path.basename(fname) == os.path.basename(file):
                return self._backup_file_guids[file]
        return 'not_found'

    def restoreGreenplumBkpMetadataFiles(self):
        retVal = True
        firstTime = True
        self.logger.info("Inside  restoreGreenplumBkpMetadataFiles %d"% len(self._backup_file_list) )
        for file in self._backup_file_list:
            if self.IsMetaDataFile(file):
                versionGuid = self.getBackupFileCvguid(file)
                if versionGuid == False:
                    raise Exception("Unable to get CV version guid for file. Failing the restore. file %s" % file)

                (restoreFileCmd, restoredFilePath) = self.genCvRestoreFileCmd(self.cvClientid, self.cvAppid, file,
                                                                              versionGuid)

                if os.path.exists(restoredFilePath):
                    self.logger.info("File exists. Skipping restore for file %s" % restoredFilePath)
                else:
                    (ret1, out1, err1) = self.execHandler.runCommand(restoreFileCmd)
                    if ret1 == 0:
                        if os.path.exists(restoredFilePath):
                            self.logger.info("Successfully restored file %s" % restoredFilePath)
                        else:
                            self.logger.info("Failed to restore file %s" % restoredFilePath)
                            retVal = False
                    else:
                        retVal = False
                        self.logger.info("Failed to restore file %s" % restoredFilePath)
            else:
                if firstTime:
                    parentdirectory = os.path.dirname(file)
                    db_dumpsstr = "/db_dumps/"
                    self.gpBackupDirectory = parentdirectory[0:parentdirectory.find(db_dumpsstr)]
                    self.logger.info("Identified backup directory %s" % self.gpBackupDirectory)
                    firstTime = False

        return retVal

    def getCvContext(self):
        retValue = True

        restoreContextCommand = self.genCvContextCmd()

        (ret2, wrapperOutput, err2) = self.execHandler.runCommand(restoreContextCommand)


        if ret2 == 0:
            wrapperOutput = wrapperOutput.strip()
            for cmdToken in wrapperOutput.split(','):
                (tokId, tokVal) = cmdToken.split('=')
                if tokId == 'commcellId':
                    self.cvCommcellid = tokVal
                elif tokId == 'clientId':
                    self.cvClientid = tokVal
                elif tokId == 'instanceId':
                    self.cvInstanceid = tokVal
                elif tokId == 'appId':
                    self.cvSubClientId = tokVal
                elif tokId == 'backupsetId':
                    self.cvBackupsetid = tokVal
                elif tokId == 'jobId':
                    self.cvJobId = tokVal
                elif tokId == 'jobToken':
                    self.cvJobToken = tokVal
            self.cvAppid = self.cvCommcellid + ":" + self.cvSubClientId
        else:
            self.logger.info('Failed to get Commvault context (commcellId, clientId, appId, instanceId)')
            retValue = False

        return retValue

    def genCvRestoreFileCmd(self, clientid, appid, fileFullPath, versionGuid, destPath=None):
        restoredFilePath = ""
        if destPath is not None and destPath is not empty:
            restoredFilePath = destPath + "/" + os.path.basename(fileFullPath)
        else:
            destPath = os.path.dirname(fileFullPath)
            restoredFilePath = fileFullPath

        restoreCmd = CVBKPRSTWRAPPER + " -restore --cv-proxy-host " + str(self.cvProxyHostName) + \
                     " --cv-proxy-port " + str(self.cvProxyCvdPort) + " --cv-clientid " + clientid + \
                     " --cv-apptype Q_DISTRIBUTED_IDA " + \
                     " --cv-filename " + os.path.basename(fileFullPath) + " --cv-destpath " + destPath + \
                     " --cv-guid " + versionGuid + " --cv-appid " + str(self.cvAppid) + \
                     " --cv-jobid 0 --cv-jobtoken 0  --cv-debuglvl " + str(self.cvEnableDebugLogging) + " --cv-copyprecedence " + str(self.cvStorageCopyPrec)

        self.logger.debug("Command to restore file: %s" % restoreCmd)
        return (restoreCmd, restoredFilePath)

    def genCvBrowseQueryCmd(self, regex, browseFrom=None, browseTo=None):

        regex = "\"" + regex + "\""

        self.logger.info("Querying CV Browse server with regex %s" % regex)

        queryCmd = CVBKPRSTWRAPPER + " -query --cv-proxy-host " + str(self.cvProxyHostName) + \
                   " --cv-proxy-port " + str(self.cvProxyCvdPort) + " --cv-clientid " + str(self.cvClientid) + \
                   " --cv-apptype Q_DISTRIBUTED_IDA --cv-instanceId " + str(self.cvInstanceid) + \
                   " --cv-appid " + str(self.cvAppid) + " --cv-backupsetId " + str(self.cvBackupsetid) + \
                   " --cv-filename " + regex + " --cv-search-allcycles 1  --cv-browse-viewname GREENPLUM_SEGMENTS " + \
                   " --cv-debuglvl " + str(self.cvEnableDebugLogging) + " --cv-copyprecedence " + str(self.cvStorageCopyPrec)
        if browseFrom is not None and browseTo is not None:
            queryCmd += " --cv-browse-fromtime " + browseFrom + " --cv-browse-totime " + browseTo

        self.logger.debug("Command to query CV Browse server: %s" % queryCmd)
        return queryCmd

    def genCvContextCmd(self):
        # context --- > (clientid:commcellid:subclientid:greenplumInstanceId:backupsetid:jobid:jobtoken)
        command_string = CVBKPRSTWRAPPER
        if self.gpdbrestoreOptions is not None:
            command_string += " -jobStart --cv-jobtype RESTORE "
        elif self.gpcrondumpOptions is not None:
            command_string += " -jobStart --cv-jobtype BACKUP "
            if incremental:
                command_string += " --cv-bkplvl INCR"
            else:
                command_string += " --cv-bkplvl FULL"
        else:
            command_string += " -restore --cv-jobtype RESTORE "

        # TODO subclient name "default" is hardcoded
        command_string += " --cv-subclient default "
        command_string +=  " --cv-copyprecedence " + str(self.cvStorageCopyPrec)
        command_string += " --cv-proxy-host %s --cv-proxy-port %s --cv-clientname %s --cv-instance %s  --cv-apptype Q_DISTRIBUTED_IDA --cv-debuglvl %s" % (
        self.cvProxyHostName, self.cvProxyCvdPort, str(self.cvSrcClientName), str(self.cvSrcInstance),str(self.cvEnableDebugLogging))
        self.logger.debug("Command to query CV context: %s" % command_string)
        return command_string


def WaitForGpRestoreAgent(cv_context, writeFifo, hostname, cmdToWaitForGpRestoreAgent):
    cv_context.logger.debug('Inside thread --- > WaitForGpRestoreAgent to read from pipe %s' % writeFifo)
    (ret2, wrapperOutput, err2) = cv_context.execHandler.runCommand(cmdToWaitForGpRestoreAgent, True)
    if ret2 == 0:
        cv_context.logger.info('Completed restore on %s pipe %s' % (hostname, writeFifo))
    else:
        cv_context.logger.info('Failed to restore on %s pipe %s' % (hostname, writeFifo))


def RunGPDBRestoreCmd(cv_context, gpRestoreDBComd):
    cv_context.logger.debug('Inside thread --- > RunGPDBRestoreCmd')
    (ret2, wrapperOutput, err2) = cv_context.execHandler.runCommand(gpRestoreDBComd, True)
    if ret2 == 0:
        if '--list-backup' in gpRestoreDBComd:
            output_lines = wrapperOutput.split('\n')
            for line in output_lines:
                if 'List of backup timestamps required for the restore time stamp' in line:
                    print_line = line.find('List of backup timestamps required for the restore time stamp')
                    print('\n%s' % line[print_line:])
                if 'Backup Timestamp:' in line:
                    print_line = line.find('Backup Timestamp:')
                    print ('%s'%line[print_line:])

        cv_context.logger.info('Successfully completed gpdbrestore command')
        print('\nSuccessfully completed gpdbrestore command.')
        cv_context.gpdbrestoreCmdRet = 0
    else:
        cv_context.logger.info('Failed in gpdbrestore command')
        print('\nFailed in gpdbrestore command.')

