function BusinessRuleConditionEvalutor(_rule,_row,_oldrow,_operation,_System) {
	var rule = _rule;
	var row = _row;
	var oldrow = _oldrow;
	var operation = _operation;
	var System = _System;
	
	//constants
	var FORMS_CUSTOM_OPERATION_FIELD = "$custom$";
	var FORMS_RECORD_OPERATION_FIELD = "$form_type$";
	
	var operatorMap = {
		EQUALS : "==",
		NOT_EQUALS : "!=",
		LESS_THAN : "<",
		LESS_THAN_EQUALS : "<=",
		GREATER_THAN : ">",
		GREATER_THAN_EQUALS : ">=",
	}

	var nullCheckOpsMap = {
			IS_EMPTY : "isEmptyValue({0}) === true",
			IS_NOT_EMPTY : "isEmptyValue({0}) === false",		
	}

	var stringOpsMap = {
			STARTS_WITH : '.toLowerCase().startsWith("{0}".toLowerCase())',
			ENDS_WITH : '.toLowerCase().endsWith("{0}.toLowerCase()")',
			CONTAINS : '.toLowerCase().indexOf("{0}".toLowerCase())!=-1',
			NOT_CONTAINS : '.toLowerCase().indexOf("{0}".toLowerCase())==-1'	
	}
	
	var dateOpsMap = {
			EQUALS : "!isEmptyValue(row.{0}) && !isEmptyValue(condition['value'])?getConditionFieldDateValue(row.{0}).isSame(getConditionDateValue(row.{0},condition['value'])):false",
			NOT_EQUALS : "!isEmptyValue(row.{0}) && !isEmptyValue(condition['value'])?!getConditionFieldDateValue(row.{0}).isSame(getConditionDateValue(row.{0},condition['value'])):false",
			LESS_THAN : "!isEmptyValue(row.{0}) && !isEmptyValue(condition['value'])?getConditionFieldDateValue(row.{0}).isBefore(getConditionDateValue(row.{0},condition['value'])):false",
			LESS_THAN_EQUALS : "!isEmptyValue(row.{0}) && !isEmptyValue(condition['value'])?getConditionFieldDateValue(row.{0}).isSame(getConditionDateValue(row.{0},condition['value'])) || moment(row.{0}).isBefore(getConditionDateValue(row.{0},condition['value'])):false",
			GREATER_THAN : "!isEmptyValue(row.{0}) && !isEmptyValue(condition['value'])?getConditionFieldDateValue(row.{0}).isAfter(getConditionDateValue(row.{0},condition['value'])):false",
			GREATER_THAN_EQUALS : "!isEmptyValue(row.{0}) && !isEmptyValue(condition['value'])?getConditionFieldDateValue(row.{0}).isSame(getConditionDateValue(row.{0},condition['value'])) || moment(row.{0}).isAfter(getConditionDateValue(row.{0},condition['value'])):false",
			CHANGED : "getDateValue(oldrow.{0}) != getDateValue(row.{0})",
			CHANGED_TO : "getDateValue(oldrow.{0}) != getDateValue(row.{0}) && getDateValue(row.{0}) == getDateValue({1},row.{0})" ,
			CHANGED_FROM : "getDateValue(oldrow.{0}) != getDateValue(row.{0}) && getDateValue(oldrow.{0}) == getValue({1},row.{0})"
	}
	
	var dateTimeOpsMap = {
			EQUALS : "!isEmptyValue(row.{0}) && !isEmptyValue(condition['value'])?getConditionFieldDateTimeValue(row.{0}).isSame(getConditionDateTimeValue(row.{0},condition['value'])):false",
			NOT_EQUALS : "!isEmptyValue(row.{0}) && !isEmptyValue(condition['value'])?!getConditionFieldDateTimeValue(row.{0}).isSame(getConditionDateTimeValue(row.{0},condition['value'])):false",
			LESS_THAN : "!isEmptyValue(row.{0}) && !isEmptyValue(condition['value'])?getConditionFieldDateTimeValue(row.{0}).isBefore(getConditionDateTimeValue(row.{0},condition['value'])):false",
			LESS_THAN_EQUALS : "!isEmptyValue(row.{0}) && !isEmptyValue(condition['value'])?getConditionFieldDateTimeValue(row.{0}).isSame(getConditionDateTimeValue(row.{0},condition['value'])) || moment(row.{0}).isBefore(getConditionDateTimeValue(row.{0},condition['value'])):false",
			GREATER_THAN : "!isEmptyValue(row.{0}) && !isEmptyValue(condition['value'])?getConditionFieldDateTimeValue(row.{0}).isAfter(getConditionDateTimeValue(row.{0},condition['value'])):false",
			GREATER_THAN_EQUALS : "!isEmptyValue(row.{0}) && !isEmptyValue(condition['value'])?getConditionFieldDateTimeValue(row.{0}).isSame(getConditionDateTimeValue(row.{0},condition['value'])) || moment(row.{0}).isAfter(getConditionDateTimeValue(row.{0},condition['value'])):false",
			CHANGED : "getDateTimeValue(oldrow.{0}) != getDateTimeValue(row.{0})",
			CHANGED_TO : "getDateTimeValue(oldrow.{0}) != getDateTimeValue(row.{0}) && getDateTimeValue(row.{0}) == getDateTimeValue({1},row.{0})" ,
			CHANGED_FROM : "getDateTimeValue(oldrow.{0}) != getDateTimeValue(row.{0}) && getDateTimeValue(oldrow.{0}) == getValue({1},row.{0})"
	}
	
	var isEmptyValue = function(value){
		return value == undefined || value == null  || value == "";
	}
	
	var getValue = function(value){
		if(isEmptyValue(value)){
			return undefined;
		}
		return value;
	}
	
	var getDateValue = function(value,inputVal){
		if(isEmptyValue(value)){
			return undefined;
		}
		
		return getConditionDateValue(value,inputVal).toDate().getTime();
	}
	
	var getDateTimeValue = function(value,inputVal){
		if(isEmptyValue(value)){
			return undefined;
		}
		
		return getConditionDateTimeValue(value,inputVal).toDate().getTime();
	}
	
	var getConditionFieldDateTimeValue = function(inputVal){
		return moment(inputVal,'MM/DD/YYYY hh:mm A');
	}
	
	var getConditionFieldDateValue = function(inputVal){
		return moment(inputVal,'YYYY-MM-DD');
	}

	var getConditionDateValue = function(inputVal,value){
			if(isNaN(value) === false)
				return moment(inputVal,'YYYY-MM-DD').add(parseInt(value),'days');
			else if(typeof value === "string"){	
				return moment(value);
			}
		return value;	
	}

	var getConditionDateTimeValue = function(inputVal,value){
		if(isNaN(value) === false)
			return moment(inputVal,'MM/DD/YYYY hh:mm A').add(parseInt(value),'days');
		else if(typeof value === "string"){	
			return moment(value);
		}
	return value;	
}

	
	var changeOpsMap = {
		"CHANGED" : "getValue(oldrow.{0}) != getValue(row.{0})",
		"CHANGED_TO" : "getValue(oldrow.{0}) != getValue(row.{0}) && getValue(row.{0}) == getValue({1})" ,
		"CHANGED_FROM" : "getValue(oldrow.{0}) != getValue(row.{0}) && getValue(oldrow.{0}) == getValue({1})"
	}
	
	var recordOperations = {
		"RECORD_ADDED" : 'operation == "insert"',
		"RECORD_MODIFIED" : 'operation == "update"',
		"RECORD_DELETED" : 'operation == "delete"'
	};
	
	var ruleTypes = {
		ANY : "ANY",
		ALL : "ALL"
	};
		
	var getOperator = function(operator){
		return operator?operatorMap[operator]?operatorMap[operator]:undefined:undefined;
	}	
	
	var getConditionExpression = function(condition){
			var expression = undefined;
			var operator = condition["op"];
			var field = condition["field"];
			var value = condition["value"];
			var fieldType = condition["fieldType"];
			
			if(value && value.trim().startsWith("="))
			{
				try{
					value = value.trim();
					value = eval(value.substring(value.indexOf("=") + 1));
				}
				catch(e){
					value = value;
				}
			}
		
			if(field === FORMS_CUSTOM_OPERATION_FIELD)
			{
				expression = value;
				expression = expression && expression!=""?"(function(){" + expression + "})();":expression;
			}			
			else if(field === FORMS_RECORD_OPERATION_FIELD)
			{
				expression = recordOperations[value];
			}
			else if(nullCheckOpsMap[operator])
			{
				field = "row['" + field + "']";
				expression = nullCheckOpsMap[operator].replace("{0}",field);
			}
			else if(fieldType && fieldType == "java.util.Date"){
				condition["value"] = value;
				expression = dateOpsMap[operator].replace("{0}",field).replace("{0}",field).replace("{0}",field);
			}
			else if(fieldType && fieldType == "java.util.Calendar"){
				condition["value"] = value;
				expression = dateTimeOpsMap[operator].replace("{0}",field).replace("{0}",field).replace("{0}",field);
			}
			else if(stringOpsMap[operator])
			{
				//if(field)
					expression = "row['" + field + "']" + stringOpsMap[operator].replace("{0}",value);
			}
			else if(changeOpsMap[operator]){
				expression = changeOpsMap[operator];
				expression = expression.replace(/\{0\}/g,field).replace(/\{1\}/g,value);
			}
			else
			{
				operator = getOperator(condition["op"]);
				if(operator)
				{
					expression = "row['" + field + "']" + operator + (value == undefined || value == "undefined" || value === "true" || value === "false"?eval(value):isNaN(parseInt(value))? "\"" + value + "\"":value);
				}
			}
		
		return expression;
	}
	
	var isConditionValid = function(condition) 
	{
		var expression = getConditionExpression(condition);
		if(expression){
			expression = expression.replace(/\\/g,"\\\\");
			try
			{
				if(eval(expression) === true)
					return true;
			}
			catch(exception){
				return false;
			}
		}
		return false;
	}

	var processCondGroup = function(condGroup){
		var condGroupValid = true;	
		if(condGroup)
		{
			var conditions = condGroup["conditions"];
			var condGroupType = condGroup["allOrAny"]?condGroup["allOrAny"]:ruleTypes.ALL;
			var noOfCondsMet = 0;
			if(conditions && conditions.length > 0){
				var noOfConditions = conditions.length;
				for(var i = 0 ;i < noOfConditions;i++){		
					if(isConditionValid(conditions[i]) === true)
					{
						noOfCondsMet++;
					}
				}
				
				if(condGroupType === ruleTypes.ALL){
					if(noOfCondsMet !== noOfConditions)
						condGroupValid = false;
				}
				else
				{
					if(noOfCondsMet === 0)
						condGroupValid = false;
				}
			}
		}
		return condGroupValid;
	}	
	var processCondGroups = function(condGroups,condGroupsType){
		var noOfCondsGrpsMet = 0;
		var condGroupsValid = true;
		if(condGroups && condGroups.length > 0)
		{
			var noOfConditiongroups = condGroups.length;
			for(var i = 0 ;i < noOfConditiongroups;i++){
				if(processCondGroup(condGroups[i]))
					noOfCondsGrpsMet++;
			}
		
			if(condGroupsType === ruleTypes.ALL){
				if(noOfCondsGrpsMet !== noOfConditiongroups)
					condGroupsValid = false;
			}
			else
			{
				if(noOfCondsGrpsMet === 0)
					condGroupsValid = false;
			}
		}
		return condGroupsValid
	} 
	
	this.isRuleValid = function(){
		var ruleValid = true;
		if(rule && rule.enabled === true)
		{
			var condGroupsType = rule["allOrAny"]?rule["allOrAny"]:ruleTypes.ALL;
			var conditionGroups = rule["conditionGroups"];
			ruleValid = processCondGroups(conditionGroups,condGroupsType);
				
		}
		return ruleValid;
	}

	this.isBusinessRuleForDate = function(){
				var isDateRule = false;
				var condGroups = rule["conditionGroups"];
				if(condGroups && condGroups.length > 0)
				{
					var noOfConditiongroups = condGroups.length;
					for(var i = 0 ;i < noOfConditiongroups;i++){
						var condGroup = condGroups[i];
						var conditions = condGroup["conditions"];
						if(conditions && conditions.length > 0){
							var noOfConditions = conditions.length;
							for(var i = 0 ;i < noOfConditions;i++){		
								var cond = conditions[i];
								var fieldType = conditions[i]["fieldType"];
								if(fieldType && (fieldType == "java.util.Date" || fieldType == "java.util.Calendar"))
									{
									isDateRule = true;
									break;
									}
							}
						}
						
						if(isDateRule === true)
							break;
					}
				}
				return isDateRule;
	}
	
}

function evaluateBusinessRule(ruleDef,row,oldrow,operation,context,businessRule){
	var ruleCondEvalutor = new BusinessRuleConditionEvalutor(ruleDef,row,oldrow,operation,context);
	
	if(businessRule === true){
		if(ruleCondEvalutor.isBusinessRuleForDate()){
			try{
				loadMomentJS();
			}
			catch(e){
				
			}
		}
	}
	
	return ruleCondEvalutor.isRuleValid();
}

function isValueChanged(fieldName,formDefaultVals,formUpdatedVals){
    var ruleDef = {
                    "enabled":true,
                    "conditionGroups":[{
                                                    "conditions":[{
                                                                    "field": fieldName,
                                                                    "op": "CHANGED"
                                                                    }],
                                                    "allOrAny":"ANY"
                                                    }],
                    "allOrAny":"ANY"
    }
    var ruleCondEvalutor = new BusinessRuleConditionEvalutor(ruleDef,formUpdatedVals,formDefaultVals,"",{},false);
    return ruleCondEvalutor.isRuleValid();
}
