/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.rest;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.apache.solr.common.util.SimpleOrderedMap;
import org.apache.solr.rest.BaseFieldTypeResource;
import org.apache.solr.rest.BaseSchemaResource;
import org.apache.solr.rest.GETable;
import org.apache.solr.schema.FieldType;
import org.apache.solr.schema.SchemaField;
import org.restlet.representation.Representation;
import org.restlet.resource.ResourceException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FieldTypeCollectionResource
extends BaseFieldTypeResource
implements GETable {
    private static final Logger log = LoggerFactory.getLogger(FieldTypeCollectionResource.class);
    private static final String FIELD_TYPES = "fieldTypes";
    private Map<String, List<String>> fieldsByFieldType;
    private Map<String, List<String>> dynamicFieldsByFieldType;

    @Override
    public void doInit() throws ResourceException {
        super.doInit();
        if (this.isExisting()) {
            this.fieldsByFieldType = this.getFieldsByFieldType();
            this.dynamicFieldsByFieldType = this.getDynamicFieldsByFieldType();
        }
    }

    @Override
    public Representation get() {
        try {
            ArrayList<SimpleOrderedMap<Object>> props = new ArrayList<SimpleOrderedMap<Object>>();
            TreeMap<String, FieldType> sortedFieldTypes = new TreeMap<String, FieldType>(this.getSchema().getFieldTypes());
            for (FieldType fieldType : sortedFieldTypes.values()) {
                props.add(this.getFieldTypeProperties(fieldType));
            }
            this.getSolrResponse().add(FIELD_TYPES, props);
        }
        catch (Exception e) {
            this.getSolrResponse().setException(e);
        }
        this.handlePostExecution(log);
        return new BaseSchemaResource.SolrOutputRepresentation();
    }

    @Override
    protected List<String> getFieldsWithFieldType(FieldType fieldType) {
        List<String> fields = this.fieldsByFieldType.get(fieldType.getTypeName());
        if (null == fields) {
            fields = Collections.emptyList();
        }
        return fields;
    }

    @Override
    protected List<String> getDynamicFieldsWithFieldType(FieldType fieldType) {
        List<String> dynamicFields = this.dynamicFieldsByFieldType.get(fieldType.getTypeName());
        if (null == dynamicFields) {
            dynamicFields = Collections.emptyList();
        }
        return dynamicFields;
    }

    private Map<String, List<String>> getFieldsByFieldType() {
        HashMap<String, List<String>> fieldsByFieldType = new HashMap<String, List<String>>();
        for (SchemaField schemaField : this.getSchema().getFields().values()) {
            String fieldType = schemaField.getType().getTypeName();
            ArrayList<String> fields = (ArrayList<String>)fieldsByFieldType.get(fieldType);
            if (null == fields) {
                fields = new ArrayList<String>();
                fieldsByFieldType.put(fieldType, fields);
            }
            fields.add(schemaField.getName());
        }
        for (List fields : fieldsByFieldType.values()) {
            Collections.sort(fields);
        }
        return fieldsByFieldType;
    }

    private Map<String, List<String>> getDynamicFieldsByFieldType() {
        HashMap<String, List<String>> dynamicFieldsByFieldType = new HashMap<String, List<String>>();
        for (SchemaField schemaField : this.getSchema().getDynamicFieldPrototypes()) {
            String fieldType = schemaField.getType().getTypeName();
            ArrayList<String> dynamicFields = (ArrayList<String>)dynamicFieldsByFieldType.get(fieldType);
            if (null == dynamicFields) {
                dynamicFields = new ArrayList<String>();
                dynamicFieldsByFieldType.put(fieldType, dynamicFields);
            }
            dynamicFields.add(schemaField.getName());
        }
        return dynamicFieldsByFieldType;
    }
}

