/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.highlight;

import java.io.IOException;
import java.text.BreakIterator;
import java.util.Collections;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.apache.lucene.document.Document;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.ScoreDoc;
import org.apache.lucene.search.TopDocs;
import org.apache.lucene.search.postingshighlight.PassageFormatter;
import org.apache.lucene.search.postingshighlight.PassageScorer;
import org.apache.lucene.search.postingshighlight.PostingsHighlighter;
import org.apache.solr.common.params.SolrParams;
import org.apache.solr.common.util.NamedList;
import org.apache.solr.common.util.SimpleOrderedMap;
import org.apache.solr.core.PluginInfo;
import org.apache.solr.core.SolrConfig;
import org.apache.solr.highlight.SolrHighlighter;
import org.apache.solr.request.SolrQueryRequest;
import org.apache.solr.schema.IndexSchema;
import org.apache.solr.schema.SchemaField;
import org.apache.solr.search.DocIterator;
import org.apache.solr.search.DocList;
import org.apache.solr.search.SolrIndexSearcher;
import org.apache.solr.util.plugin.PluginInfoInitialized;

public class PostingsSolrHighlighter
extends SolrHighlighter
implements PluginInfoInitialized {
    protected PostingsHighlighter highlighter;

    @Override
    public void initalize(SolrConfig config) {
    }

    @Override
    public void init(PluginInfo info) {
        String ellipsis;
        String postTag;
        Map<String, String> attributes = info.attributes;
        BreakIterator breakIterator = BreakIterator.getSentenceInstance(Locale.ROOT);
        PassageScorer scorer = new PassageScorer();
        String preTag = attributes.get("preTag");
        if (preTag == null) {
            preTag = "<em>";
        }
        if ((postTag = attributes.get("postTag")) == null) {
            postTag = "</em>";
        }
        if ((ellipsis = attributes.get("ellipsis")) == null) {
            ellipsis = "... ";
        }
        PassageFormatter formatter = new PassageFormatter(preTag, postTag, ellipsis);
        int maxLength = 10000;
        if (attributes.containsKey("maxLength")) {
            maxLength = Integer.parseInt(attributes.get("maxLength"));
        }
        this.highlighter = new PostingsHighlighter(maxLength, breakIterator, scorer, formatter);
    }

    @Override
    public NamedList<Object> doHighlighting(DocList docs, Query query, SolrQueryRequest req, String[] defaultFields) throws IOException {
        SolrParams params = req.getParams();
        if (this.isHighlightingEnabled(params)) {
            SolrIndexSearcher searcher = req.getSearcher();
            TopDocs topDocs = this.toTopDocs(docs);
            String[] keys = this.getUniqueKeys(searcher, topDocs);
            String[] fieldNames = this.getHighlightFields(query, req, defaultFields);
            int numSnippets = params.getInt("hl.snippets", 1);
            Map snippets = this.highlighter.highlightFields(fieldNames, query, (IndexSearcher)searcher, topDocs, numSnippets);
            return this.encodeSnippets(keys, fieldNames, snippets);
        }
        return null;
    }

    protected NamedList<Object> encodeSnippets(String[] keys, String[] fieldNames, Map<String, String[]> snippets) {
        SimpleOrderedMap list = new SimpleOrderedMap();
        for (int i = 0; i < keys.length; ++i) {
            SimpleOrderedMap summary = new SimpleOrderedMap();
            for (String field : fieldNames) {
                String snippet = snippets.get(field)[i];
                if (snippet == null) {
                    summary.add(field, (Object)new String[0]);
                    continue;
                }
                summary.add(field, (Object)new String[]{snippet});
            }
            list.add(keys[i], (Object)summary);
        }
        return list;
    }

    protected TopDocs toTopDocs(DocList docs) {
        ScoreDoc[] scoreDocs = new ScoreDoc[docs.size()];
        DocIterator iterator = docs.iterator();
        for (int i = 0; i < scoreDocs.length; ++i) {
            if (!iterator.hasNext()) {
                throw new AssertionError();
            }
            scoreDocs[i] = new ScoreDoc(iterator.nextDoc(), Float.NaN);
        }
        if (iterator.hasNext()) {
            throw new AssertionError();
        }
        return new TopDocs(docs.matches(), scoreDocs, Float.NaN);
    }

    protected String[] getUniqueKeys(SolrIndexSearcher searcher, TopDocs topDocs) throws IOException {
        IndexSchema schema = searcher.getSchema();
        SchemaField keyField = schema.getUniqueKeyField();
        if (keyField != null) {
            Set<String> selector = Collections.singleton(keyField.getName());
            String[] uniqueKeys = new String[topDocs.scoreDocs.length];
            for (int i = 0; i < topDocs.scoreDocs.length; ++i) {
                String id;
                int docid = topDocs.scoreDocs[i].doc;
                Document doc = searcher.doc(docid, selector);
                uniqueKeys[i] = id = schema.printableUniqueKey(doc);
            }
            return uniqueKeys;
        }
        return new String[topDocs.scoreDocs.length];
    }
}

