/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.cloud;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.solr.client.solrj.SolrResponse;
import org.apache.solr.cloud.DistributedQueue;
import org.apache.solr.cloud.Overseer;
import org.apache.solr.cloud.OverseerSolrResponse;
import org.apache.solr.common.SolrException;
import org.apache.solr.common.cloud.Aliases;
import org.apache.solr.common.cloud.ClosableThread;
import org.apache.solr.common.cloud.ClusterState;
import org.apache.solr.common.cloud.DocCollection;
import org.apache.solr.common.cloud.Slice;
import org.apache.solr.common.cloud.ZkNodeProps;
import org.apache.solr.common.cloud.ZkStateReader;
import org.apache.solr.common.cloud.ZooKeeperException;
import org.apache.solr.common.params.CoreAdminParams;
import org.apache.solr.common.params.ModifiableSolrParams;
import org.apache.solr.common.params.SolrParams;
import org.apache.solr.common.util.NamedList;
import org.apache.solr.common.util.SimpleOrderedMap;
import org.apache.solr.common.util.StrUtils;
import org.apache.solr.handler.component.ShardHandler;
import org.apache.solr.handler.component.ShardRequest;
import org.apache.solr.handler.component.ShardResponse;
import org.apache.zookeeper.KeeperException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OverseerCollectionProcessor
implements Runnable,
ClosableThread {
    public static final String NUM_SLICES = "numShards";
    public static final String REPLICATION_FACTOR = "replicationFactor";
    public static final String MAX_SHARDS_PER_NODE = "maxShardsPerNode";
    public static final String CREATE_NODE_SET = "createNodeSet";
    public static final String DELETECOLLECTION = "deletecollection";
    public static final String CREATECOLLECTION = "createcollection";
    public static final String RELOADCOLLECTION = "reloadcollection";
    public static final String CREATEALIAS = "createalias";
    public static final String DELETEALIAS = "deletealias";
    private static final String QUEUE_OPERATION = "operation";
    private static Logger log = LoggerFactory.getLogger(OverseerCollectionProcessor.class);
    private DistributedQueue workQueue;
    private String myId;
    private ShardHandler shardHandler;
    private String adminPath;
    private ZkStateReader zkStateReader;
    private boolean isClosed;

    public OverseerCollectionProcessor(ZkStateReader zkStateReader, String myId, ShardHandler shardHandler, String adminPath) {
        this(zkStateReader, myId, shardHandler, adminPath, Overseer.getCollectionQueue(zkStateReader.getZkClient()));
    }

    protected OverseerCollectionProcessor(ZkStateReader zkStateReader, String myId, ShardHandler shardHandler, String adminPath, DistributedQueue workQueue) {
        this.zkStateReader = zkStateReader;
        this.myId = myId;
        this.shardHandler = shardHandler;
        this.adminPath = adminPath;
        this.workQueue = workQueue;
    }

    @Override
    public void run() {
        log.info("Process current queue of collection creations");
        while (this.amILeader() && !this.isClosed) {
            try {
                DistributedQueue.QueueEvent head = this.workQueue.peek(true);
                ZkNodeProps message = ZkNodeProps.load((byte[])head.getBytes());
                log.info("Overseer Collection Processor: Get the message id:" + head.getId() + " message:" + message.toString());
                String operation = message.getStr(QUEUE_OPERATION);
                SolrResponse response = this.processMessage(message, operation);
                head.setBytes(SolrResponse.serializable((SolrResponse)response));
                this.workQueue.remove(head);
                log.info("Overseer Collection Processor: Message id:" + head.getId() + " complete, response:" + response.getResponse().toString());
            }
            catch (KeeperException e) {
                if (e.code() == KeeperException.Code.SESSIONEXPIRED || e.code() == KeeperException.Code.CONNECTIONLOSS) {
                    log.warn("Overseer cannot talk to ZK");
                    return;
                }
                SolrException.log((Logger)log, (String)"", (Throwable)e);
                throw new ZooKeeperException(SolrException.ErrorCode.SERVER_ERROR, "", (Throwable)e);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                return;
            }
            catch (Throwable e) {
                SolrException.log((Logger)log, (String)"", (Throwable)e);
            }
        }
    }

    public void close() {
        this.isClosed = true;
    }

    protected boolean amILeader() {
        try {
            ZkNodeProps props = ZkNodeProps.load((byte[])this.zkStateReader.getZkClient().getData("/overseer_elect/leader", null, null, true));
            if (this.myId.equals(props.getStr("id"))) {
                return true;
            }
        }
        catch (KeeperException e) {
            log.warn("", (Throwable)e);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
        log.info("According to ZK I (id=" + this.myId + ") am no longer a leader.");
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected SolrResponse processMessage(ZkNodeProps message, String operation) {
        NamedList results = new NamedList();
        try {
            ShardResponse srsp;
            ModifiableSolrParams params;
            if (CREATECOLLECTION.equals(operation)) {
                this.createCollection(this.zkStateReader.getClusterState(), message, results);
            } else if (DELETECOLLECTION.equals(operation)) {
                params = new ModifiableSolrParams();
                params.set("action", new String[]{CoreAdminParams.CoreAdminAction.UNLOAD.toString()});
                params.set("deleteInstanceDir", true);
                this.collectionCmd(this.zkStateReader.getClusterState(), message, params, results, null);
            } else if (RELOADCOLLECTION.equals(operation)) {
                params = new ModifiableSolrParams();
                params.set("action", new String[]{CoreAdminParams.CoreAdminAction.RELOAD.toString()});
                this.collectionCmd(this.zkStateReader.getClusterState(), message, params, results, "active");
            } else if (CREATEALIAS.equals(operation)) {
                this.createAlias(this.zkStateReader.getAliases(), message);
            } else if (DELETEALIAS.equals(operation)) {
                this.deleteAlias(this.zkStateReader.getAliases(), message);
            } else {
                throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Unknown operation:" + operation);
            }
            int failed = 0;
            do {
                if ((srsp = this.shardHandler.takeCompletedIncludingErrors()) == null) continue;
                Throwable e = srsp.getException();
                if (e != null) {
                    ++failed;
                    log.error("Error talking to shard: " + srsp.getShard(), e);
                    results.add(srsp.getShard(), (Object)e);
                    continue;
                }
                results.add(srsp.getShard(), (Object)srsp.getSolrResponse().getResponse());
            } while (srsp != null);
        }
        catch (Exception ex) {
            SolrException.log((Logger)log, (String)("Collection " + operation + " of " + operation + " failed"), (Throwable)ex);
            results.add("Operation " + operation + " caused exception:", (Object)ex);
            SimpleOrderedMap nl = new SimpleOrderedMap();
            nl.add("msg", (Object)ex.getMessage());
            nl.add("rspCode", (Object)(ex instanceof SolrException ? ((SolrException)((Object)ex)).code() : -1));
            results.add("exception", (Object)nl);
        }
        finally {
            return new OverseerSolrResponse(results);
        }
    }

    private void createAlias(Aliases aliases, ZkNodeProps message) {
        String aliasName = message.getStr("name");
        String collections = message.getStr("collections");
        HashMap newAliasesMap = new HashMap();
        HashMap<String, String> newCollectionAliasesMap = new HashMap<String, String>();
        Map prevColAliases = aliases.getCollectionAliasMap();
        if (prevColAliases != null) {
            newCollectionAliasesMap.putAll(prevColAliases);
        }
        newCollectionAliasesMap.put(aliasName, collections);
        newAliasesMap.put("collection", newCollectionAliasesMap);
        Aliases newAliases = new Aliases(newAliasesMap);
        byte[] jsonBytes = null;
        if (newAliases.collectionAliasSize() > 0) {
            jsonBytes = ZkStateReader.toJSON((Object)newAliases.getAliasMap());
        }
        try {
            this.zkStateReader.getZkClient().setData("/aliases.json", jsonBytes, true);
            this.checkForAlias(aliasName, collections);
            Thread.sleep(100L);
        }
        catch (KeeperException e) {
            log.error("", (Throwable)e);
            throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, (Throwable)e);
        }
        catch (InterruptedException e) {
            log.warn("", (Throwable)e);
            throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, (Throwable)e);
        }
    }

    private void checkForAlias(String name, String value) {
        long now = System.currentTimeMillis();
        long timeout = now + 30000L;
        boolean success = false;
        Aliases aliases = null;
        while (System.currentTimeMillis() < timeout) {
            aliases = this.zkStateReader.getAliases();
            String collections = aliases.getCollectionAlias(name);
            if (collections == null || !collections.equals(value)) continue;
            success = true;
            break;
        }
        if (!success) {
            log.warn("Timeout waiting to be notified of Alias change...");
        }
    }

    private void checkForAliasAbsence(String name) {
        long now = System.currentTimeMillis();
        long timeout = now + 30000L;
        boolean success = false;
        Aliases aliases = null;
        while (System.currentTimeMillis() < timeout) {
            aliases = this.zkStateReader.getAliases();
            String collections = aliases.getCollectionAlias(name);
            if (collections != null) continue;
            success = true;
            break;
        }
        if (!success) {
            log.warn("Timeout waiting to be notified of Alias change...");
        }
    }

    private void deleteAlias(Aliases aliases, ZkNodeProps message) {
        String aliasName = message.getStr("name");
        HashMap newAliasesMap = new HashMap();
        HashMap newCollectionAliasesMap = new HashMap();
        newCollectionAliasesMap.putAll(aliases.getCollectionAliasMap());
        newCollectionAliasesMap.remove(aliasName);
        newAliasesMap.put("collection", newCollectionAliasesMap);
        Aliases newAliases = new Aliases(newAliasesMap);
        byte[] jsonBytes = null;
        if (newAliases.collectionAliasSize() > 0) {
            jsonBytes = ZkStateReader.toJSON((Object)newAliases.getAliasMap());
        }
        try {
            this.zkStateReader.getZkClient().setData("/aliases.json", jsonBytes, true);
            this.checkForAliasAbsence(aliasName);
            Thread.sleep(100L);
        }
        catch (KeeperException e) {
            log.error("", (Throwable)e);
            throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, (Throwable)e);
        }
        catch (InterruptedException e) {
            log.warn("", (Throwable)e);
            throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, (Throwable)e);
        }
    }

    private void createCollection(ClusterState clusterState, ZkNodeProps message, NamedList results) {
        String collectionName = message.getStr("name");
        if (clusterState.getCollections().contains(collectionName)) {
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "collection already exists: " + collectionName);
        }
        try {
            ShardResponse srsp;
            int requestedShardsToCreate;
            int maxShardsAllowedToCreate;
            List createNodeList;
            int repFactor = this.msgStrToInt(message, REPLICATION_FACTOR, 1);
            Integer numSlices = this.msgStrToInt(message, NUM_SLICES, null);
            if (numSlices == null) {
                throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "collection already exists: " + collectionName);
            }
            int maxShardsPerNode = this.msgStrToInt(message, MAX_SHARDS_PER_NODE, 1);
            String createNodeSetStr = message.getStr(CREATE_NODE_SET);
            List list = createNodeList = createNodeSetStr == null ? null : StrUtils.splitSmart((String)createNodeSetStr, (String)",", (boolean)true);
            if (repFactor <= 0) {
                throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "numShards is a required paramater");
            }
            if (numSlices <= 0) {
                throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "numShards must be > 0");
            }
            String configName = message.getStr("collection.configName");
            Set nodes = clusterState.getLiveNodes();
            ArrayList nodeList = new ArrayList(nodes.size());
            nodeList.addAll(nodes);
            if (createNodeList != null) {
                nodeList.retainAll(createNodeList);
            }
            Collections.shuffle(nodeList);
            if (nodeList.size() <= 0) {
                throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Cannot create collection " + collectionName + ". No live Solr-instances" + (createNodeList != null ? " among Solr-instances specified in createNodeSet:" + createNodeSetStr : ""));
            }
            if (repFactor > nodeList.size()) {
                log.warn("Specified replicationFactor of " + repFactor + " on collection " + collectionName + " is higher than or equal to the number of Solr instances currently live or part of your " + CREATE_NODE_SET + "(" + nodeList.size() + "). Its unusual to run two replica of the same slice on the same Solr-instance.");
            }
            if ((maxShardsAllowedToCreate = maxShardsPerNode * nodeList.size()) < (requestedShardsToCreate = numSlices * repFactor)) {
                throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Cannot create collection " + collectionName + ". Value of " + MAX_SHARDS_PER_NODE + " is " + maxShardsPerNode + ", and the number of live nodes is " + nodeList.size() + ". This allows a maximum of " + maxShardsAllowedToCreate + " to be created. Value of " + NUM_SLICES + " is " + numSlices + " and value of " + REPLICATION_FACTOR + " is " + repFactor + ". This requires " + requestedShardsToCreate + " shards to be created (higher than the allowed number)");
            }
            for (int i = 1; i <= numSlices; ++i) {
                for (int j = 1; j <= repFactor; ++j) {
                    String nodeName = (String)nodeList.get((repFactor * (i - 1) + (j - 1)) % nodeList.size());
                    String sliceName = "shard" + i;
                    String shardName = collectionName + "_" + sliceName + "_replica" + j;
                    log.info("Creating shard " + shardName + " as part of slice " + sliceName + " of collection " + collectionName + " on " + nodeName);
                    ModifiableSolrParams params = new ModifiableSolrParams();
                    params.set("action", new String[]{CoreAdminParams.CoreAdminAction.CREATE.toString()});
                    params.set("name", new String[]{shardName});
                    params.set("collection.configName", new String[]{configName});
                    params.set("collection", new String[]{collectionName});
                    params.set("shard", new String[]{sliceName});
                    params.set(NUM_SLICES, numSlices.intValue());
                    ShardRequest sreq = new ShardRequest();
                    sreq.nodeName = nodeName;
                    params.set("qt", new String[]{this.adminPath});
                    sreq.purpose = 1;
                    String replica = this.zkStateReader.getZkClient().getBaseUrlForNodeName(nodeName);
                    if (replica.startsWith("http://")) {
                        replica = replica.substring(7);
                    }
                    sreq.shards = new String[]{replica};
                    sreq.actualShards = sreq.shards;
                    sreq.params = params;
                    this.shardHandler.submit(sreq, replica, sreq.params);
                }
            }
            do {
                if ((srsp = this.shardHandler.takeCompletedOrError()) == null) continue;
                this.processResponse(results, srsp);
            } while (srsp != null);
            log.info("Finished create command on all shards for collection: " + collectionName);
        }
        catch (SolrException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, null, (Throwable)ex);
        }
    }

    private void collectionCmd(ClusterState clusterState, ZkNodeProps message, ModifiableSolrParams params, NamedList results, String stateMatcher) {
        ShardResponse srsp;
        log.info("Executing Collection Cmd : " + params);
        String collectionName = message.getStr("name");
        DocCollection coll = clusterState.getCollection(collectionName);
        if (coll == null) {
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Could not find collection:" + collectionName);
        }
        for (Map.Entry entry : coll.getSlicesMap().entrySet()) {
            Slice slice = (Slice)entry.getValue();
            Map shards = slice.getReplicasMap();
            Set shardEntries = shards.entrySet();
            for (Map.Entry shardEntry : shardEntries) {
                ZkNodeProps node = (ZkNodeProps)shardEntry.getValue();
                if (!clusterState.liveNodesContain(node.getStr("node_name")) || stateMatcher != null && !node.getStr("state").equals(stateMatcher)) continue;
                ModifiableSolrParams cloneParams = new ModifiableSolrParams();
                cloneParams.add((SolrParams)params);
                cloneParams.set("core", new String[]{node.getStr("core")});
                String replica = node.getStr("base_url");
                ShardRequest sreq = new ShardRequest();
                sreq.nodeName = node.getStr("node_name");
                cloneParams.set("qt", new String[]{this.adminPath});
                sreq.purpose = 1;
                if (replica.startsWith("http://")) {
                    replica = replica.substring(7);
                }
                sreq.shards = new String[]{replica};
                sreq.actualShards = sreq.shards;
                sreq.params = cloneParams;
                log.info("Collection Admin sending CoreAdmin cmd to " + replica + " params:" + sreq.params);
                this.shardHandler.submit(sreq, replica, sreq.params);
            }
        }
        do {
            if ((srsp = this.shardHandler.takeCompletedOrError()) == null) continue;
            this.processResponse(results, srsp);
        } while (srsp != null);
    }

    private void processResponse(NamedList results, ShardResponse srsp) {
        Throwable e = srsp.getException();
        if (e != null) {
            log.error("Error from shard: " + srsp.getShard(), e);
            SimpleOrderedMap failure = (SimpleOrderedMap)results.get("failure");
            if (failure == null) {
                failure = new SimpleOrderedMap();
                results.add("failure", (Object)failure);
            }
            failure.add(srsp.getNodeName(), (Object)(e.getClass().getName() + ":" + e.getMessage()));
        } else {
            SimpleOrderedMap success = (SimpleOrderedMap)results.get("success");
            if (success == null) {
                success = new SimpleOrderedMap();
                results.add("success", (Object)success);
            }
            success.add(srsp.getNodeName(), (Object)srsp.getSolrResponse().getResponse());
        }
    }

    private int msgStrToInt(ZkNodeProps message, String key, Integer def) throws Exception {
        String str = message.getStr(key);
        try {
            return str == null ? def : Integer.parseInt(str);
        }
        catch (Exception ex) {
            SolrException.log((Logger)log, (String)("Could not parse " + key), (Throwable)ex);
            throw ex;
        }
    }

    public boolean isClosed() {
        return this.isClosed;
    }
}

