/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.analysis;

import java.io.IOException;
import java.io.Reader;
import org.apache.lucene.analysis.NumericTokenStream;
import org.apache.lucene.analysis.Tokenizer;
import org.apache.lucene.analysis.tokenattributes.CharTermAttribute;
import org.apache.lucene.analysis.tokenattributes.CharTermAttributeImpl;
import org.apache.lucene.analysis.tokenattributes.OffsetAttribute;
import org.apache.lucene.util.AttributeSource;
import org.apache.solr.common.SolrException;
import org.apache.solr.schema.DateField;
import org.apache.solr.schema.TrieField;

final class TrieTokenizer
extends Tokenizer {
    protected static final DateField dateField = new DateField();
    protected final TrieField.TrieTypes type;
    protected final NumericTokenStream ts;
    private final CharTermAttribute termAtt = new CharTermAttributeImpl();
    protected final OffsetAttribute ofsAtt = (OffsetAttribute)this.addAttribute(OffsetAttribute.class);
    protected int startOfs;
    protected int endOfs;
    protected boolean hasValue;

    static NumericTokenStream getNumericTokenStream(int precisionStep) {
        return new NumericTokenStream(precisionStep);
    }

    public TrieTokenizer(Reader input, TrieField.TrieTypes type, NumericTokenStream ts) {
        super((AttributeSource)ts, input);
        this.type = type;
        this.ts = ts;
        this.termAtt.resizeBuffer(type == TrieField.TrieTypes.DATE ? 128 : 32);
    }

    public void reset() {
        try {
            int length;
            int upto = 0;
            char[] buf = this.termAtt.buffer();
            while ((length = this.input.read(buf, upto, buf.length - upto)) != -1) {
                if ((upto += length) != buf.length) continue;
                buf = this.termAtt.resizeBuffer(1 + buf.length);
            }
            this.termAtt.setLength(upto);
            this.startOfs = this.correctOffset(0);
            this.endOfs = this.correctOffset(upto);
            if (upto == 0) {
                this.hasValue = false;
                return;
            }
            String v = new String(buf, 0, upto);
            try {
                switch (this.type) {
                    case INTEGER: {
                        this.ts.setIntValue(Integer.parseInt(v));
                        break;
                    }
                    case FLOAT: {
                        this.ts.setFloatValue(Float.parseFloat(v));
                        break;
                    }
                    case LONG: {
                        this.ts.setLongValue(Long.parseLong(v));
                        break;
                    }
                    case DOUBLE: {
                        this.ts.setDoubleValue(Double.parseDouble(v));
                        break;
                    }
                    case DATE: {
                        this.ts.setLongValue(dateField.parseMath(null, v).getTime());
                        break;
                    }
                    default: {
                        throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Unknown type for trie field");
                    }
                }
            }
            catch (NumberFormatException nfe) {
                throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Invalid Number: " + v);
            }
            this.hasValue = true;
            this.ts.reset();
        }
        catch (IOException e) {
            throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Unable to create TrieIndexTokenizer", (Throwable)e);
        }
    }

    public void close() throws IOException {
        super.close();
        if (this.hasValue) {
            this.ts.close();
        }
    }

    public boolean incrementToken() {
        if (this.hasValue && this.ts.incrementToken()) {
            this.ofsAtt.setOffset(this.startOfs, this.endOfs);
            return true;
        }
        return false;
    }

    public void end() throws IOException {
        if (this.hasValue) {
            this.ts.end();
        }
        this.ofsAtt.setOffset(this.endOfs, this.endOfs);
    }
}

