/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.jdbc.impl;

import java.sql.Array;
import java.sql.Blob;
import java.sql.CallableStatement;
import java.sql.Clob;
import java.sql.DatabaseMetaData;
import java.sql.NClob;
import java.sql.PreparedStatement;
import java.sql.SQLClientInfoException;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.sql.SQLNonTransientConnectionException;
import java.sql.SQLWarning;
import java.sql.SQLXML;
import java.sql.Savepoint;
import java.sql.Statement;
import java.sql.Struct;
import java.util.Map;
import java.util.Properties;
import java.util.TimeZone;
import java.util.concurrent.Executor;
import oadd.net.hydromatic.avatica.AvaticaConnection;
import oadd.net.hydromatic.avatica.AvaticaFactory;
import oadd.net.hydromatic.avatica.AvaticaStatement;
import oadd.net.hydromatic.avatica.Helper;
import oadd.net.hydromatic.avatica.Meta;
import oadd.net.hydromatic.avatica.UnregisteredDriver;
import oadd.org.apache.drill.common.config.DrillConfig;
import oadd.org.apache.drill.common.exceptions.DrillRuntimeException;
import oadd.org.apache.drill.common.exceptions.UserException;
import oadd.org.apache.drill.exec.client.DrillClient;
import oadd.org.apache.drill.exec.exception.OutOfMemoryException;
import oadd.org.apache.drill.exec.memory.BufferAllocator;
import oadd.org.apache.drill.exec.memory.RootAllocatorFactory;
import oadd.org.apache.drill.exec.rpc.RpcException;
import oadd.org.apache.drill.exec.server.Drillbit;
import oadd.org.apache.drill.exec.server.RemoteServiceSet;
import oadd.org.apache.drill.exec.store.StoragePluginRegistry;
import oadd.org.apache.drill.exec.util.TestUtilities;
import org.apache.drill.jdbc.AlreadyClosedSqlException;
import org.apache.drill.jdbc.DrillConnection;
import org.apache.drill.jdbc.DrillConnectionConfig;
import org.apache.drill.jdbc.InvalidParameterSqlException;
import org.apache.drill.jdbc.JdbcApiSqlException;
import org.apache.drill.jdbc.impl.DrillPrepareResult;
import org.apache.drill.jdbc.impl.DrillPreparedStatementImpl;
import org.apache.drill.jdbc.impl.DrillStatementImpl;
import org.apache.drill.jdbc.impl.DrillStatementRegistry;
import org.apache.drill.jdbc.impl.DriverImpl;
import org.apache.drill.jdbc.impl.GlobalServiceSetReference;
import org.apache.drill.jdbc.impl.MetaImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class DrillConnectionImpl
extends AvaticaConnection
implements DrillConnection {
    private static final Logger logger = LoggerFactory.getLogger(DrillConnection.class);
    final DrillStatementRegistry openStatementsRegistry;
    final DrillConnectionConfig config;
    private final DrillClient client;
    private final BufferAllocator allocator;
    private Drillbit bit;
    private RemoteServiceSet serviceSet;

    protected DrillConnectionImpl(DriverImpl driver, AvaticaFactory factory, String url, Properties info) throws SQLException {
        block13: {
            super(driver, factory, url, info);
            this.openStatementsRegistry = new DrillStatementRegistry();
            super.setTransactionIsolation(0);
            super.setAutoCommit(true);
            this.config = new DrillConnectionConfig(info);
            try {
                if (this.config.isLocal()) {
                    try {
                        Class.forName("org.eclipse.jetty.server.Handler");
                    }
                    catch (ClassNotFoundException e) {
                        throw new SQLNonTransientConnectionException("Running Drill in embedded mode using Drill's jdbc-all JDBC driver Jar file alone is not supported.", e);
                    }
                    DrillConfig dConfig = DrillConfig.create(info);
                    this.allocator = RootAllocatorFactory.newRoot(dConfig);
                    RemoteServiceSet set = GlobalServiceSetReference.SETS.get();
                    if (set == null) {
                        set = this.serviceSet = RemoteServiceSet.getLocalServiceSet();
                        try {
                            this.bit = new Drillbit(dConfig, this.serviceSet);
                            this.bit.run();
                        }
                        catch (UserException e) {
                            throw new SQLException("Failure in starting embedded Drillbit: " + e.getMessage(), e);
                        }
                        catch (Exception e) {
                            throw new SQLException("Failure in starting embedded Drillbit: " + e, e);
                        }
                    } else {
                        this.serviceSet = null;
                        this.bit = null;
                    }
                    DrillConnectionImpl.makeTmpSchemaLocationsUnique(this.bit.getContext().getStorage(), info);
                    this.client = new DrillClient(dConfig, set.getCoordinator());
                    this.client.connect(null, info);
                    break block13;
                }
                if (this.config.isDirect()) {
                    DrillConfig dConfig = DrillConfig.forClient();
                    this.allocator = RootAllocatorFactory.newRoot(dConfig);
                    this.client = new DrillClient(dConfig, true);
                    this.client.connect(this.config.getZookeeperConnectionString(), info);
                } else {
                    DrillConfig dConfig = DrillConfig.forClient();
                    this.allocator = RootAllocatorFactory.newRoot(dConfig);
                    this.client = new DrillClient();
                    this.client.connect(this.config.getZookeeperConnectionString(), info);
                }
            }
            catch (OutOfMemoryException e) {
                throw new SQLException("Failure creating root allocator", e);
            }
            catch (RpcException e) {
                throw new SQLException("Failure in connecting to Drill: " + e, e);
            }
        }
    }

    private void throwIfClosed() throws AlreadyClosedSqlException {
        if (this.isClosed()) {
            throw new AlreadyClosedSqlException("Connection is already closed.");
        }
    }

    @Override
    public DrillConnectionConfig getConfig() {
        return this.config;
    }

    @Override
    protected Meta createMeta() {
        return new MetaImpl(this);
    }

    MetaImpl meta() {
        return (MetaImpl)this.meta;
    }

    BufferAllocator getAllocator() {
        return this.allocator;
    }

    @Override
    public DrillClient getClient() {
        return this.client;
    }

    @Override
    public void setAutoCommit(boolean autoCommit) throws SQLException {
        this.throwIfClosed();
        if (!autoCommit) {
            throw new SQLFeatureNotSupportedException("Can't turn off auto-committing; transactions are not supported.  (Drill is not transactional.)");
        }
        assert (this.getAutoCommit()) : "getAutoCommit() = " + this.getAutoCommit();
    }

    @Override
    public void commit() throws SQLException {
        this.throwIfClosed();
        if (this.getAutoCommit()) {
            throw new JdbcApiSqlException("Can't call commit() in auto-commit mode.");
        }
        throw new SQLFeatureNotSupportedException("Connection.commit() is not supported.  (Drill is not transactional.)");
    }

    @Override
    public void rollback() throws SQLException {
        this.throwIfClosed();
        if (this.getAutoCommit()) {
            throw new JdbcApiSqlException("Can't call rollback() in auto-commit mode.");
        }
        throw new SQLFeatureNotSupportedException("Connection.rollback() is not supported.  (Drill is not transactional.)");
    }

    @Override
    public boolean isClosed() {
        try {
            return super.isClosed();
        }
        catch (SQLException e) {
            throw new DrillRuntimeException("Unexpected exception from " + this.getClass().getSuperclass() + ".isClosed(): " + e, e);
        }
    }

    @Override
    public Savepoint setSavepoint() throws SQLException {
        this.throwIfClosed();
        throw new SQLFeatureNotSupportedException("Savepoints are not supported.  (Drill is not transactional.)");
    }

    @Override
    public Savepoint setSavepoint(String name) throws SQLException {
        this.throwIfClosed();
        throw new SQLFeatureNotSupportedException("Savepoints are not supported.  (Drill is not transactional.)");
    }

    @Override
    public void rollback(Savepoint savepoint) throws SQLException {
        this.throwIfClosed();
        throw new SQLFeatureNotSupportedException("Savepoints are not supported.  (Drill is not transactional.)");
    }

    @Override
    public void releaseSavepoint(Savepoint savepoint) throws SQLException {
        this.throwIfClosed();
        throw new SQLFeatureNotSupportedException("Savepoints are not supported.  (Drill is not transactional.)");
    }

    private String isolationValueToString(int level) {
        switch (level) {
            case 0: {
                return "TRANSACTION_NONE";
            }
            case 1: {
                return "TRANSACTION_READ_UNCOMMITTED";
            }
            case 2: {
                return "TRANSACTION_READ_COMMITTED";
            }
            case 4: {
                return "TRANSACTION_REPEATABLE_READ";
            }
            case 8: {
                return "TRANSACTION_SERIALIZABLE";
            }
        }
        return "<Unknown transaction isolation level value " + level + ">";
    }

    @Override
    public void setTransactionIsolation(int level) throws SQLException {
        this.throwIfClosed();
        switch (level) {
            case 0: {
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 8: {
                throw new SQLFeatureNotSupportedException("Can't change transaction isolation level to Connection." + this.isolationValueToString(level) + " (from Connection." + this.isolationValueToString(this.getTransactionIsolation()) + ")." + "  (Drill is not transactional.)");
            }
            default: {
                throw new JdbcApiSqlException("Invalid transaction isolation level value " + level);
            }
        }
    }

    @Override
    public void setNetworkTimeout(Executor executor, int milliseconds) throws AlreadyClosedSqlException, JdbcApiSqlException, SQLFeatureNotSupportedException {
        this.throwIfClosed();
        if (null == executor) {
            throw new InvalidParameterSqlException("Invalid (null) \"executor\" parameter to setNetworkTimeout(...)");
        }
        if (milliseconds < 0) {
            throw new InvalidParameterSqlException("Invalid (negative) \"milliseconds\" parameter to setNetworkTimeout(...) (" + milliseconds + ")");
        }
        if (0 != milliseconds) {
            throw new SQLFeatureNotSupportedException("Setting network timeout is not supported.");
        }
    }

    @Override
    public int getNetworkTimeout() throws AlreadyClosedSqlException {
        this.throwIfClosed();
        return 0;
    }

    @Override
    public DrillStatementImpl createStatement(int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        this.throwIfClosed();
        DrillStatementImpl statement = (DrillStatementImpl)super.createStatement(resultSetType, resultSetConcurrency, resultSetHoldability);
        return statement;
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        this.throwIfClosed();
        try {
            DrillPrepareResult prepareResult = new DrillPrepareResult(sql);
            DrillPreparedStatementImpl statement = (DrillPreparedStatementImpl)this.factory.newPreparedStatement(this, prepareResult, resultSetType, resultSetConcurrency, resultSetHoldability);
            return statement;
        }
        catch (RuntimeException e) {
            throw Helper.INSTANCE.createException("Error while preparing statement [" + sql + "]", e);
        }
        catch (Exception e) {
            throw Helper.INSTANCE.createException("Error while preparing statement [" + sql + "]", e);
        }
    }

    @Override
    public TimeZone getTimeZone() {
        return this.config.getTimeZone();
    }

    @Override
    public AvaticaStatement createStatement() throws SQLException {
        this.throwIfClosed();
        return super.createStatement();
    }

    @Override
    public PreparedStatement prepareStatement(String sql) throws SQLException {
        this.throwIfClosed();
        return super.prepareStatement(sql);
    }

    @Override
    public CallableStatement prepareCall(String sql) throws SQLException {
        this.throwIfClosed();
        try {
            return super.prepareCall(sql);
        }
        catch (UnsupportedOperationException e) {
            throw new SQLFeatureNotSupportedException(e.getMessage(), e);
        }
    }

    @Override
    public String nativeSQL(String sql) throws SQLException {
        this.throwIfClosed();
        try {
            return super.nativeSQL(sql);
        }
        catch (UnsupportedOperationException e) {
            throw new SQLFeatureNotSupportedException(e.getMessage(), e);
        }
    }

    @Override
    public boolean getAutoCommit() throws SQLException {
        this.throwIfClosed();
        return super.getAutoCommit();
    }

    @Override
    public DatabaseMetaData getMetaData() throws SQLException {
        this.throwIfClosed();
        return super.getMetaData();
    }

    @Override
    public void setReadOnly(boolean readOnly) throws SQLException {
        this.throwIfClosed();
        super.setReadOnly(readOnly);
    }

    @Override
    public boolean isReadOnly() throws SQLException {
        this.throwIfClosed();
        return super.isReadOnly();
    }

    @Override
    public void setCatalog(String catalog) throws SQLException {
        this.throwIfClosed();
        super.setCatalog(catalog);
    }

    @Override
    public String getCatalog() {
        try {
            this.throwIfClosed();
        }
        catch (AlreadyClosedSqlException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
        return super.getCatalog();
    }

    @Override
    public int getTransactionIsolation() throws SQLException {
        this.throwIfClosed();
        return super.getTransactionIsolation();
    }

    @Override
    public SQLWarning getWarnings() throws SQLException {
        this.throwIfClosed();
        return super.getWarnings();
    }

    @Override
    public void clearWarnings() throws SQLException {
        this.throwIfClosed();
        super.clearWarnings();
    }

    @Override
    public Statement createStatement(int resultSetType, int resultSetConcurrency) throws SQLException {
        this.throwIfClosed();
        return super.createStatement(resultSetType, resultSetConcurrency);
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
        this.throwIfClosed();
        return super.prepareStatement(sql, resultSetType, resultSetConcurrency);
    }

    @Override
    public CallableStatement prepareCall(String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
        this.throwIfClosed();
        try {
            return super.prepareCall(sql, resultSetType, resultSetConcurrency);
        }
        catch (UnsupportedOperationException e) {
            throw new SQLFeatureNotSupportedException(e.getMessage(), e);
        }
    }

    @Override
    public Map<String, Class<?>> getTypeMap() throws SQLException {
        this.throwIfClosed();
        try {
            return super.getTypeMap();
        }
        catch (UnsupportedOperationException e) {
            throw new SQLFeatureNotSupportedException(e.getMessage(), e);
        }
    }

    @Override
    public void setTypeMap(Map<String, Class<?>> map) throws SQLException {
        this.throwIfClosed();
        try {
            super.setTypeMap(map);
        }
        catch (UnsupportedOperationException e) {
            throw new SQLFeatureNotSupportedException(e.getMessage(), e);
        }
    }

    @Override
    public void setHoldability(int holdability) throws SQLException {
        this.throwIfClosed();
        super.setHoldability(holdability);
    }

    @Override
    public int getHoldability() throws SQLException {
        this.throwIfClosed();
        return super.getHoldability();
    }

    @Override
    public CallableStatement prepareCall(String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        this.throwIfClosed();
        try {
            return super.prepareCall(sql, resultSetType, resultSetConcurrency, resultSetHoldability);
        }
        catch (UnsupportedOperationException e) {
            throw new SQLFeatureNotSupportedException(e.getMessage(), e);
        }
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int autoGeneratedKeys) throws SQLException {
        this.throwIfClosed();
        try {
            return super.prepareStatement(sql, autoGeneratedKeys);
        }
        catch (UnsupportedOperationException e) {
            throw new SQLFeatureNotSupportedException(e.getMessage(), e);
        }
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int[] columnIndexes) throws SQLException {
        this.throwIfClosed();
        try {
            return super.prepareStatement(sql, columnIndexes);
        }
        catch (UnsupportedOperationException e) {
            throw new SQLFeatureNotSupportedException(e.getMessage(), e);
        }
    }

    @Override
    public PreparedStatement prepareStatement(String sql, String[] columnNames) throws SQLException {
        this.throwIfClosed();
        try {
            return super.prepareStatement(sql, columnNames);
        }
        catch (UnsupportedOperationException e) {
            throw new SQLFeatureNotSupportedException(e.getMessage(), e);
        }
    }

    @Override
    public Clob createClob() throws SQLException {
        this.throwIfClosed();
        try {
            return super.createClob();
        }
        catch (UnsupportedOperationException e) {
            throw new SQLFeatureNotSupportedException(e.getMessage(), e);
        }
    }

    @Override
    public Blob createBlob() throws SQLException {
        this.throwIfClosed();
        try {
            return super.createBlob();
        }
        catch (UnsupportedOperationException e) {
            throw new SQLFeatureNotSupportedException(e.getMessage(), e);
        }
    }

    @Override
    public NClob createNClob() throws SQLException {
        this.throwIfClosed();
        try {
            return super.createNClob();
        }
        catch (UnsupportedOperationException e) {
            throw new SQLFeatureNotSupportedException(e.getMessage(), e);
        }
    }

    @Override
    public SQLXML createSQLXML() throws SQLException {
        this.throwIfClosed();
        try {
            return super.createSQLXML();
        }
        catch (UnsupportedOperationException e) {
            throw new SQLFeatureNotSupportedException(e.getMessage(), e);
        }
    }

    @Override
    public boolean isValid(int timeout) throws SQLException {
        this.throwIfClosed();
        try {
            return super.isValid(timeout);
        }
        catch (UnsupportedOperationException e) {
            throw new SQLFeatureNotSupportedException(e.getMessage(), e);
        }
    }

    @Override
    public void setClientInfo(String name, String value) throws SQLClientInfoException {
        try {
            this.throwIfClosed();
        }
        catch (AlreadyClosedSqlException e) {
            throw new SQLClientInfoException(e.getMessage(), null, (Throwable)e);
        }
        try {
            super.setClientInfo(name, value);
        }
        catch (UnsupportedOperationException e) {
            SQLFeatureNotSupportedException intended = new SQLFeatureNotSupportedException(e.getMessage(), e);
            throw new SQLClientInfoException(e.getMessage(), null, (Throwable)intended);
        }
    }

    @Override
    public void setClientInfo(Properties properties) throws SQLClientInfoException {
        try {
            this.throwIfClosed();
        }
        catch (AlreadyClosedSqlException e) {
            throw new SQLClientInfoException(e.getMessage(), null, (Throwable)e);
        }
        try {
            super.setClientInfo(properties);
        }
        catch (UnsupportedOperationException e) {
            SQLFeatureNotSupportedException intended = new SQLFeatureNotSupportedException(e.getMessage(), e);
            throw new SQLClientInfoException(e.getMessage(), null, (Throwable)intended);
        }
    }

    @Override
    public String getClientInfo(String name) throws SQLException {
        this.throwIfClosed();
        try {
            return super.getClientInfo(name);
        }
        catch (UnsupportedOperationException e) {
            throw new SQLFeatureNotSupportedException(e.getMessage(), e);
        }
    }

    @Override
    public Properties getClientInfo() throws SQLException {
        this.throwIfClosed();
        try {
            return super.getClientInfo();
        }
        catch (UnsupportedOperationException e) {
            throw new SQLFeatureNotSupportedException(e.getMessage(), e);
        }
    }

    @Override
    public Array createArrayOf(String typeName, Object[] elements) throws SQLException {
        this.throwIfClosed();
        try {
            return super.createArrayOf(typeName, elements);
        }
        catch (UnsupportedOperationException e) {
            throw new SQLFeatureNotSupportedException(e.getMessage(), e);
        }
    }

    @Override
    public Struct createStruct(String typeName, Object[] attributes) throws SQLException {
        this.throwIfClosed();
        try {
            return super.createStruct(typeName, attributes);
        }
        catch (UnsupportedOperationException e) {
            throw new SQLFeatureNotSupportedException(e.getMessage(), e);
        }
    }

    @Override
    public void setSchema(String schema) throws SQLException {
        this.throwIfClosed();
        super.setSchema(schema);
    }

    @Override
    public String getSchema() {
        try {
            this.throwIfClosed();
        }
        catch (AlreadyClosedSqlException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
        return super.getSchema();
    }

    @Override
    public void abort(Executor executor) throws SQLException {
        this.throwIfClosed();
        try {
            super.abort(executor);
        }
        catch (UnsupportedOperationException e) {
            throw new SQLFeatureNotSupportedException(e.getMessage(), e);
        }
    }

    UnregisteredDriver getDriver() {
        return this.driver;
    }

    AvaticaFactory getFactory() {
        return this.factory;
    }

    private static void closeOrWarn(AutoCloseable autoCloseable, String message, Logger logger) {
        if (autoCloseable == null) {
            return;
        }
        try {
            autoCloseable.close();
        }
        catch (Exception e) {
            logger.warn(message, e);
        }
    }

    void cleanup() {
        this.openStatementsRegistry.close();
        DrillConnectionImpl.closeOrWarn(this.client, "Exception while closing client.", logger);
        DrillConnectionImpl.closeOrWarn(this.allocator, "Exception while closing allocator.", logger);
        if (this.bit != null) {
            this.bit.close();
        }
        DrillConnectionImpl.closeOrWarn(this.serviceSet, "Exception while closing service set.", logger);
    }

    private static void makeTmpSchemaLocationsUnique(StoragePluginRegistry pluginRegistry, Properties props) {
        try {
            if (props != null && "true".equalsIgnoreCase(props.getProperty("drillJDBCUnitTests"))) {
                String tmpDirPath = TestUtilities.createTempDir();
                TestUtilities.updateDfsTestTmpSchemaLocation(pluginRegistry, tmpDirPath);
                TestUtilities.makeDfsTmpSchemaImmutable(pluginRegistry);
            }
        }
        catch (Throwable e) {
            logger.warn("Failed to update tmp schema locations. This step is purely for testing purpose. Shouldn't be seen in production code.");
        }
    }
}

