/*
 * Decompiled with CFR 0.152.
 */
package oadd.org.eigenbase.util.property;

import java.util.Properties;
import oadd.org.eigenbase.util.property.Property;

public class BooleanProperty
extends Property {
    public BooleanProperty(Properties properties, String path, boolean defaultValue) {
        super(properties, path, defaultValue ? "true" : "false");
    }

    public BooleanProperty(Properties properties, String path) {
        super(properties, path, null);
    }

    public boolean get() {
        return this.booleanValue();
    }

    public boolean get(boolean defaultValue) {
        String value = this.getInternal(Boolean.toString(defaultValue), false);
        if (value == null) {
            return defaultValue;
        }
        return BooleanProperty.toBoolean(value);
    }

    public boolean set(boolean value) {
        String prevValue = this.setString(Boolean.toString(value));
        if (prevValue == null && (prevValue = this.getDefaultValue()) == null) {
            return false;
        }
        return BooleanProperty.toBoolean(prevValue);
    }
}

