/*
 * Decompiled with CFR 0.152.
 */
package oadd.org.apache.drill.exec.work.fragment;

import java.io.IOException;
import java.security.PrivilegedExceptionAction;
import java.util.Set;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import oadd.org.apache.drill.common.DeferredException;
import oadd.org.apache.drill.common.SerializedExecutor;
import oadd.org.apache.drill.common.concurrent.ExtendedLatch;
import oadd.org.apache.drill.common.exceptions.UserException;
import oadd.org.apache.drill.exec.coord.ClusterCoordinator;
import oadd.org.apache.drill.exec.exception.OutOfMemoryException;
import oadd.org.apache.drill.exec.ops.FragmentContext;
import oadd.org.apache.drill.exec.physical.base.FragmentRoot;
import oadd.org.apache.drill.exec.physical.impl.ImplCreator;
import oadd.org.apache.drill.exec.physical.impl.RootExec;
import oadd.org.apache.drill.exec.proto.BitControl;
import oadd.org.apache.drill.exec.proto.CoordinationProtos;
import oadd.org.apache.drill.exec.proto.ExecProtos;
import oadd.org.apache.drill.exec.proto.UserBitShared;
import oadd.org.apache.drill.exec.proto.helper.QueryIdHelper;
import oadd.org.apache.drill.exec.server.DrillbitContext;
import oadd.org.apache.drill.exec.testing.ControlsInjector;
import oadd.org.apache.drill.exec.testing.ControlsInjectorFactory;
import oadd.org.apache.drill.exec.util.ImpersonationUtil;
import oadd.org.apache.drill.exec.work.foreman.DrillbitStatusListener;
import oadd.org.apache.drill.exec.work.fragment.FragmentStatusReporter;
import oadd.org.apache.drill.exec.work.fragment.StateTransitionException;
import org.apache.hadoop.security.UserGroupInformation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FragmentExecutor
implements Runnable {
    private static final Logger logger = LoggerFactory.getLogger(FragmentExecutor.class);
    private static final ControlsInjector injector = ControlsInjectorFactory.getInjector(FragmentExecutor.class);
    private final AtomicBoolean hasCloseoutThread = new AtomicBoolean(false);
    private final String fragmentName;
    private final FragmentContext fragmentContext;
    private final FragmentStatusReporter statusReporter;
    private final DeferredException deferredException = new DeferredException();
    private final BitControl.PlanFragment fragment;
    private final FragmentRoot rootOperator;
    private final ReceiverExecutor receiverExecutor;
    private volatile RootExec root;
    private final AtomicReference<UserBitShared.FragmentState> fragmentState = new AtomicReference<UserBitShared.FragmentState>(UserBitShared.FragmentState.AWAITING_ALLOCATION);
    private final ExtendedLatch acceptExternalEvents = new ExtendedLatch();
    private final AtomicReference<Thread> myThreadRef = new AtomicReference<Object>(null);

    public FragmentExecutor(FragmentContext context, BitControl.PlanFragment fragment, FragmentStatusReporter statusReporter) {
        this(context, fragment, statusReporter, null);
    }

    public FragmentExecutor(FragmentContext context, BitControl.PlanFragment fragment, FragmentStatusReporter statusReporter, FragmentRoot rootOperator) {
        this.fragmentContext = context;
        this.statusReporter = statusReporter;
        this.fragment = fragment;
        this.rootOperator = rootOperator;
        this.fragmentName = QueryIdHelper.getQueryIdentifier(context.getHandle());
        this.receiverExecutor = new ReceiverExecutor(this.fragmentName, this.fragmentContext.getExecutor());
        context.setExecutorState(new ExecutorStateImpl());
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("FragmentExecutor [fragmentContext=");
        builder.append(this.fragmentContext);
        builder.append(", fragmentState=");
        builder.append(this.fragmentState);
        builder.append("]");
        return builder.toString();
    }

    public BitControl.FragmentStatus getStatus() {
        if (this.fragmentState.get() != UserBitShared.FragmentState.RUNNING) {
            return null;
        }
        return this.statusReporter.getStatus(UserBitShared.FragmentState.RUNNING);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cancel() {
        boolean thisIsOnlyThread = this.hasCloseoutThread.compareAndSet(false, true);
        if (!thisIsOnlyThread) {
            this.acceptExternalEvents.awaitUninterruptibly();
            this.updateState(UserBitShared.FragmentState.CANCELLATION_REQUESTED);
            AtomicReference<Thread> atomicReference = this.myThreadRef;
            synchronized (atomicReference) {
                Thread myThread = this.myThreadRef.get();
                if (myThread != null) {
                    logger.debug("Interrupting fragment thread {}", (Object)myThread.getName());
                    myThread.interrupt();
                }
            }
        } else {
            this.acceptExternalEvents.countDown();
            this.updateState(UserBitShared.FragmentState.CANCELLATION_REQUESTED);
            this.cleanup(UserBitShared.FragmentState.FINISHED);
        }
    }

    private void cleanup(UserBitShared.FragmentState state) {
        this.closeOutResources();
        this.updateState(state);
        this.sendFinalState();
    }

    public synchronized void unpause() {
        this.fragmentContext.getExecutionControls().unpauseAll();
    }

    public void receivingFragmentFinished(ExecProtos.FragmentHandle handle) {
        this.receiverExecutor.submitReceiverFinished(handle);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        if (!this.hasCloseoutThread.compareAndSet(false, true)) {
            return;
        }
        Thread myThread = Thread.currentThread();
        this.myThreadRef.set(myThread);
        String originalThreadName = myThread.getName();
        ExecProtos.FragmentHandle fragmentHandle = this.fragmentContext.getHandle();
        DrillbitContext drillbitContext = this.fragmentContext.getDrillbitContext();
        ClusterCoordinator clusterCoordinator = drillbitContext.getClusterCoordinator();
        FragmentDrillbitStatusListener drillbitStatusListener = new FragmentDrillbitStatusListener();
        String newThreadName = QueryIdHelper.getExecutorThreadName(fragmentHandle);
        try {
            myThread.setName(newThreadName);
            Object rootOperator = this.rootOperator != null ? this.rootOperator : drillbitContext.getPlanReader().readFragmentOperator(this.fragment.getFragmentJson());
            this.root = ImplCreator.getExec((FragmentContext)this.fragmentContext, (FragmentRoot)rootOperator);
            if (this.root == null) {
                return;
            }
            clusterCoordinator.addDrillbitStatusListener(drillbitStatusListener);
            this.updateState(UserBitShared.FragmentState.RUNNING);
            this.acceptExternalEvents.countDown();
            injector.injectPause(this.fragmentContext.getExecutionControls(), "fragment-running", logger);
            CoordinationProtos.DrillbitEndpoint endpoint = drillbitContext.getEndpoint();
            logger.debug("Starting fragment {}:{} on {}:{}", fragmentHandle.getMajorFragmentId(), fragmentHandle.getMinorFragmentId(), endpoint.getAddress(), endpoint.getUserPort());
            UserGroupInformation queryUserUgi = this.fragmentContext.isImpersonationEnabled() ? ImpersonationUtil.createProxyUgi(this.fragmentContext.getQueryUserName()) : ImpersonationUtil.getProcessUserUGI();
            queryUserUgi.doAs((PrivilegedExceptionAction)new PrivilegedExceptionAction<Void>(){

                @Override
                public Void run() throws Exception {
                    injector.injectChecked(FragmentExecutor.this.fragmentContext.getExecutionControls(), "fragment-execution", IOException.class);
                    while (FragmentExecutor.this.shouldContinue() && FragmentExecutor.this.root.next()) {
                    }
                    return null;
                }
            });
        }
        catch (OutOfMemoryError | OutOfMemoryException e) {
            if (!(e instanceof OutOfMemoryError) || "Direct buffer memory".equals(e.getMessage())) {
                this.fail(UserException.memoryError(e).build(logger));
            } else {
                System.err.println("Node ran out of Heap memory, exiting.");
                e.printStackTrace(System.err);
                System.err.flush();
                System.exit(-2);
            }
        }
        catch (AssertionError | Exception e) {
            this.fail((Throwable)e);
        }
        finally {
            AtomicReference<Thread> e = this.myThreadRef;
            synchronized (e) {
                this.myThreadRef.set(null);
                Thread.interrupted();
            }
            this.acceptExternalEvents.countDown();
            this.cleanup(UserBitShared.FragmentState.FINISHED);
            clusterCoordinator.removeDrillbitStatusListener(drillbitStatusListener);
            myThread.setName(originalThreadName);
        }
    }

    private boolean shouldContinue() {
        return !this.isCompleted() && UserBitShared.FragmentState.CANCELLATION_REQUESTED != this.fragmentState.get();
    }

    private boolean isCompleted() {
        return this.isTerminal(this.fragmentState.get());
    }

    private void sendFinalState() {
        UserBitShared.FragmentState outcome = this.fragmentState.get();
        if (outcome == UserBitShared.FragmentState.FAILED) {
            ExecProtos.FragmentHandle handle = this.getContext().getHandle();
            UserException uex = UserException.systemError(this.deferredException.getAndClear()).addIdentity(this.getContext().getIdentity()).addContext("Fragment", handle.getMajorFragmentId() + ":" + handle.getMinorFragmentId()).build(logger);
            this.statusReporter.fail(uex);
        } else {
            this.statusReporter.stateChanged(outcome);
        }
    }

    private void closeOutResources() {
        try {
            if (this.root != null) {
                this.root.close();
            }
        }
        catch (Exception e) {
            this.fail(e);
        }
        this.fragmentContext.close();
    }

    private void warnStateChange(UserBitShared.FragmentState current, UserBitShared.FragmentState target) {
        logger.warn(this.fragmentName + ": Ignoring unexpected state transition {} --> {}", (Object)current.name(), (Object)target.name());
    }

    private void errorStateChange(UserBitShared.FragmentState current, UserBitShared.FragmentState target) {
        String msg = "%s: Invalid state transition %s --> %s";
        throw new StateTransitionException(String.format("%s: Invalid state transition %s --> %s", this.fragmentName, current.name(), target.name()));
    }

    /*
     * Unable to fully structure code
     */
    private synchronized boolean updateState(UserBitShared.FragmentState target) {
        current = this.fragmentState.get();
        FragmentExecutor.logger.info(this.fragmentName + ": State change requested {} --> {}", (Object)current, (Object)target);
        switch (2.$SwitchMap$org$apache$drill$exec$proto$UserBitShared$FragmentState[target.ordinal()]) {
            case 4: {
                switch (2.$SwitchMap$org$apache$drill$exec$proto$UserBitShared$FragmentState[current.ordinal()]) {
                    case 1: 
                    case 2: 
                    case 3: {
                        this.fragmentState.set(target);
                        this.statusReporter.stateChanged(target);
                        return true;
                    }
                }
                this.warnStateChange(current, target);
                return false;
            }
            case 5: {
                if (current != UserBitShared.FragmentState.CANCELLATION_REQUESTED) ** GOTO lbl16
                target = UserBitShared.FragmentState.CANCELLED;
                ** GOTO lbl18
lbl16:
                // 1 sources

                if (current == UserBitShared.FragmentState.FAILED) {
                    target = UserBitShared.FragmentState.FAILED;
                }
            }
lbl18:
            // 5 sources

            case 6: {
                if (!this.isTerminal(current)) {
                    this.fragmentState.set(target);
                    return true;
                }
                if (current == UserBitShared.FragmentState.FAILED) {
                    return false;
                }
                if (current == UserBitShared.FragmentState.CANCELLED && target == UserBitShared.FragmentState.FAILED) {
                    this.fragmentState.set(UserBitShared.FragmentState.FAILED);
                    return true;
                }
                this.warnStateChange(current, target);
                return false;
            }
            case 3: {
                if (current == UserBitShared.FragmentState.AWAITING_ALLOCATION) {
                    this.fragmentState.set(target);
                    this.statusReporter.stateChanged(target);
                    return true;
                }
                this.errorStateChange(current, target);
            }
        }
        this.errorStateChange(current, target);
        throw new IllegalStateException();
    }

    private boolean isTerminal(UserBitShared.FragmentState state) {
        return state == UserBitShared.FragmentState.CANCELLED || state == UserBitShared.FragmentState.FAILED || state == UserBitShared.FragmentState.FINISHED;
    }

    private void fail(Throwable excep) {
        this.deferredException.addThrowable(excep);
        this.updateState(UserBitShared.FragmentState.FAILED);
    }

    public FragmentContext getContext() {
        return this.fragmentContext;
    }

    static class 2 {
        static final /* synthetic */ int[] $SwitchMap$org$apache$drill$exec$proto$UserBitShared$FragmentState;

        static {
            $SwitchMap$org$apache$drill$exec$proto$UserBitShared$FragmentState = new int[UserBitShared.FragmentState.values().length];
            try {
                2.$SwitchMap$org$apache$drill$exec$proto$UserBitShared$FragmentState[UserBitShared.FragmentState.SENDING.ordinal()] = 1;
            }
            catch (NoSuchFieldError ex) {
                // empty catch block
            }
            try {
                2.$SwitchMap$org$apache$drill$exec$proto$UserBitShared$FragmentState[UserBitShared.FragmentState.AWAITING_ALLOCATION.ordinal()] = 2;
            }
            catch (NoSuchFieldError ex) {
                // empty catch block
            }
            try {
                2.$SwitchMap$org$apache$drill$exec$proto$UserBitShared$FragmentState[UserBitShared.FragmentState.RUNNING.ordinal()] = 3;
            }
            catch (NoSuchFieldError ex) {
                // empty catch block
            }
            try {
                2.$SwitchMap$org$apache$drill$exec$proto$UserBitShared$FragmentState[UserBitShared.FragmentState.CANCELLATION_REQUESTED.ordinal()] = 4;
            }
            catch (NoSuchFieldError ex) {
                // empty catch block
            }
            try {
                2.$SwitchMap$org$apache$drill$exec$proto$UserBitShared$FragmentState[UserBitShared.FragmentState.FINISHED.ordinal()] = 5;
            }
            catch (NoSuchFieldError ex) {
                // empty catch block
            }
            try {
                2.$SwitchMap$org$apache$drill$exec$proto$UserBitShared$FragmentState[UserBitShared.FragmentState.FAILED.ordinal()] = 6;
            }
            catch (NoSuchFieldError ex) {
                // empty catch block
            }
            try {
                2.$SwitchMap$org$apache$drill$exec$proto$UserBitShared$FragmentState[UserBitShared.FragmentState.CANCELLED.ordinal()] = 7;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
        }
    }

    private class ReceiverFinished
    implements Runnable {
        final ExecProtos.FragmentHandle handle;

        public ReceiverFinished(ExecProtos.FragmentHandle handle) {
            this.handle = handle;
        }

        @Override
        public void run() {
            FragmentExecutor.this.acceptExternalEvents.awaitUninterruptibly();
            if (FragmentExecutor.this.root != null) {
                logger.info("Applying request for early sender termination for {} -> {}.", (Object)QueryIdHelper.getFragmentId(FragmentExecutor.this.getContext().getHandle()), (Object)QueryIdHelper.getFragmentId(this.handle));
                FragmentExecutor.this.root.receivingFragmentFinished(this.handle);
            } else {
                logger.warn("Dropping request for early fragment termination for path {} -> {} as no root exec exists.", (Object)QueryIdHelper.getFragmentId(FragmentExecutor.this.getContext().getHandle()), (Object)QueryIdHelper.getFragmentId(this.handle));
            }
        }
    }

    private class ReceiverExecutor
    extends SerializedExecutor {
        public ReceiverExecutor(String name, Executor underlyingExecutor) {
            super(name, underlyingExecutor);
        }

        @Override
        protected void runException(Runnable command, Throwable t) {
            logger.error("Failure running with exception of command {}", (Object)command, (Object)t);
        }

        public void submitReceiverFinished(ExecProtos.FragmentHandle handle) {
            this.execute(new ReceiverFinished(handle));
        }
    }

    private class FragmentDrillbitStatusListener
    implements DrillbitStatusListener {
        private FragmentDrillbitStatusListener() {
        }

        @Override
        public void drillbitRegistered(Set<CoordinationProtos.DrillbitEndpoint> registeredDrillbits) {
        }

        @Override
        public void drillbitUnregistered(Set<CoordinationProtos.DrillbitEndpoint> unregisteredDrillbits) {
            CoordinationProtos.DrillbitEndpoint foremanEndpoint = FragmentExecutor.this.fragmentContext.getForemanEndpoint();
            if (unregisteredDrillbits.contains(foremanEndpoint)) {
                logger.warn("Foreman {} no longer active.  Cancelling fragment {}.", (Object)foremanEndpoint.getAddress(), (Object)QueryIdHelper.getQueryIdentifier(FragmentExecutor.this.fragmentContext.getHandle()));
                FragmentExecutor.this.cancel();
            }
        }
    }

    private class ExecutorStateImpl
    implements FragmentContext.ExecutorState {
        private ExecutorStateImpl() {
        }

        @Override
        public boolean shouldContinue() {
            return FragmentExecutor.this.shouldContinue();
        }

        @Override
        public void fail(Throwable t) {
            FragmentExecutor.this.fail(t);
        }

        @Override
        public boolean isFailed() {
            return FragmentExecutor.this.fragmentState.get() == UserBitShared.FragmentState.FAILED;
        }

        @Override
        public Throwable getFailureCause() {
            return FragmentExecutor.this.deferredException.getException();
        }
    }
}

