/*
 * Decompiled with CFR 0.152.
 */
package oadd.org.apache.drill.exec.work.foreman;

import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import oadd.com.carrotsearch.hppc.IntObjectOpenHashMap;
import oadd.com.dyuproject.protostuff.Schema;
import oadd.com.google.common.base.Preconditions;
import oadd.com.google.common.collect.Lists;
import oadd.com.google.common.collect.Maps;
import oadd.io.netty.buffer.ByteBuf;
import oadd.org.apache.drill.common.exceptions.DrillRuntimeException;
import oadd.org.apache.drill.common.exceptions.UserException;
import oadd.org.apache.drill.common.exceptions.UserRemoteException;
import oadd.org.apache.drill.exec.proto.BitControl;
import oadd.org.apache.drill.exec.proto.CoordinationProtos;
import oadd.org.apache.drill.exec.proto.ExecProtos;
import oadd.org.apache.drill.exec.proto.GeneralRPCProtos;
import oadd.org.apache.drill.exec.proto.SchemaUserBitShared;
import oadd.org.apache.drill.exec.proto.UserBitShared;
import oadd.org.apache.drill.exec.proto.UserProtos;
import oadd.org.apache.drill.exec.proto.helper.QueryIdHelper;
import oadd.org.apache.drill.exec.rpc.RpcException;
import oadd.org.apache.drill.exec.rpc.RpcOutcomeListener;
import oadd.org.apache.drill.exec.rpc.control.Controller;
import oadd.org.apache.drill.exec.server.DrillbitContext;
import oadd.org.apache.drill.exec.store.sys.PStore;
import oadd.org.apache.drill.exec.store.sys.PStoreConfig;
import oadd.org.apache.drill.exec.store.sys.PStoreProvider;
import oadd.org.apache.drill.exec.work.EndpointListener;
import oadd.org.apache.drill.exec.work.foreman.DrillbitStatusListener;
import oadd.org.apache.drill.exec.work.foreman.Foreman;
import oadd.org.apache.drill.exec.work.foreman.ForemanException;
import oadd.org.apache.drill.exec.work.foreman.FragmentData;
import oadd.org.apache.drill.exec.work.foreman.FragmentStatusListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class QueryManager {
    private static final Logger logger = LoggerFactory.getLogger(QueryManager.class);
    public static final PStoreConfig<UserBitShared.QueryProfile> QUERY_PROFILE = PStoreConfig.newProtoBuilder((Schema)SchemaUserBitShared.QueryProfile.WRITE, (Schema)SchemaUserBitShared.QueryProfile.MERGE).name("profiles").blob().max(100).build();
    public static final PStoreConfig<UserBitShared.QueryInfo> RUNNING_QUERY_INFO = PStoreConfig.newProtoBuilder((Schema)SchemaUserBitShared.QueryInfo.WRITE, (Schema)SchemaUserBitShared.QueryInfo.MERGE).name("running").ephemeral().build();
    private final Map<CoordinationProtos.DrillbitEndpoint, NodeTracker> nodeMap = Maps.newHashMap();
    private final Foreman.StateListener stateListener;
    private final UserBitShared.QueryId queryId;
    private final String stringQueryId;
    private final UserProtos.RunQuery runQuery;
    private final Foreman foreman;
    private final IntObjectOpenHashMap<IntObjectOpenHashMap<FragmentData>> fragmentDataMap = new IntObjectOpenHashMap();
    private final List<FragmentData> fragmentDataSet = Lists.newArrayList();
    private final PStore<UserBitShared.QueryProfile> profilePStore;
    private final PStore<UserBitShared.QueryInfo> profileEStore;
    private String planText;
    private long startTime = System.currentTimeMillis();
    private long endTime;
    private final AtomicInteger finishedNodes = new AtomicInteger(0);
    private final AtomicInteger finishedFragments = new AtomicInteger(0);
    private final FragmentStatusListener fragmentStatusListener = new FragmentStatusListener(){

        @Override
        public void statusUpdate(BitControl.FragmentStatus status) {
            logger.debug("New fragment status was provided to QueryManager of {}", (Object)status);
            switch (status.getProfile().getState()) {
                case AWAITING_ALLOCATION: 
                case RUNNING: 
                case CANCELLATION_REQUESTED: {
                    QueryManager.this.updateFragmentStatus(status);
                    break;
                }
                case FAILED: {
                    QueryManager.this.stateListener.moveToState(UserBitShared.QueryResult.QueryState.FAILED, new UserRemoteException(status.getProfile().getError()));
                }
                case FINISHED: 
                case CANCELLED: {
                    QueryManager.this.fragmentDone(status);
                    break;
                }
                default: {
                    throw new UnsupportedOperationException(String.format("Received status of %s", status));
                }
            }
        }
    };
    private final DrillbitStatusListener drillbitStatusListener = new DrillbitStatusListener(){

        @Override
        public void drillbitRegistered(Set<CoordinationProtos.DrillbitEndpoint> registeredDrillbits) {
        }

        @Override
        public void drillbitUnregistered(Set<CoordinationProtos.DrillbitEndpoint> unregisteredDrillbits) {
            StringBuilder failedNodeList = new StringBuilder();
            boolean atLeastOneFailure = false;
            for (CoordinationProtos.DrillbitEndpoint ep : unregisteredDrillbits) {
                NodeTracker tracker = (NodeTracker)QueryManager.this.nodeMap.get(ep);
                if (tracker == null || !tracker.nodeDead()) continue;
                if (atLeastOneFailure) {
                    failedNodeList.append(", ");
                } else {
                    atLeastOneFailure = true;
                }
                failedNodeList.append(ep.getAddress());
                failedNodeList.append(":");
                failedNodeList.append(ep.getUserPort());
            }
            if (atLeastOneFailure) {
                logger.warn("Drillbits [{}] no longer registered in cluster.  Canceling query {}", (Object)failedNodeList, (Object)QueryIdHelper.getQueryId(QueryManager.this.queryId));
                QueryManager.this.stateListener.moveToState(UserBitShared.QueryResult.QueryState.FAILED, new ForemanException(String.format("One more more nodes lost connectivity during query.  Identified nodes were [%s].", failedNodeList)));
            }
        }
    };

    public QueryManager(UserBitShared.QueryId queryId, UserProtos.RunQuery runQuery, PStoreProvider pStoreProvider, Foreman.StateListener stateListener, Foreman foreman) {
        this.queryId = queryId;
        this.runQuery = runQuery;
        this.stateListener = stateListener;
        this.foreman = foreman;
        this.stringQueryId = QueryIdHelper.getQueryId(queryId);
        try {
            this.profilePStore = pStoreProvider.getStore(QUERY_PROFILE);
            this.profileEStore = pStoreProvider.getStore(RUNNING_QUERY_INFO);
        }
        catch (IOException e) {
            throw new DrillRuntimeException(e);
        }
    }

    private static boolean isTerminal(UserBitShared.FragmentState state) {
        return state == UserBitShared.FragmentState.FAILED || state == UserBitShared.FragmentState.FINISHED || state == UserBitShared.FragmentState.CANCELLED;
    }

    private boolean updateFragmentStatus(BitControl.FragmentStatus fragmentStatus) {
        ExecProtos.FragmentHandle fragmentHandle = fragmentStatus.getHandle();
        int majorFragmentId = fragmentHandle.getMajorFragmentId();
        int minorFragmentId = fragmentHandle.getMinorFragmentId();
        FragmentData data = this.fragmentDataMap.get(majorFragmentId).get(minorFragmentId);
        UserBitShared.FragmentState oldState = data.getState();
        boolean inTerminalState = QueryManager.isTerminal(oldState);
        UserBitShared.FragmentState currentState = fragmentStatus.getProfile().getState();
        if (inTerminalState || oldState == UserBitShared.FragmentState.CANCELLATION_REQUESTED && !QueryManager.isTerminal(currentState)) {
            logger.warn(String.format("Received status message for fragment %s after fragment was in state %s. New state was %s", QueryIdHelper.getQueryIdentifier(fragmentHandle), oldState, currentState));
            return false;
        }
        data.setStatus(fragmentStatus);
        return oldState != currentState;
    }

    private void fragmentDone(BitControl.FragmentStatus status) {
        boolean stateChanged = this.updateFragmentStatus(status);
        if (stateChanged) {
            NodeTracker node = this.nodeMap.get(status.getProfile().getEndpoint());
            node.fragmentComplete();
            this.finishedFragments.incrementAndGet();
        }
    }

    private void addFragment(FragmentData fragmentData) {
        ExecProtos.FragmentHandle fragmentHandle = fragmentData.getHandle();
        int majorFragmentId = fragmentHandle.getMajorFragmentId();
        int minorFragmentId = fragmentHandle.getMinorFragmentId();
        IntObjectOpenHashMap<FragmentData> minorMap = this.fragmentDataMap.get(majorFragmentId);
        if (minorMap == null) {
            minorMap = new IntObjectOpenHashMap();
            this.fragmentDataMap.put(majorFragmentId, minorMap);
        }
        minorMap.put(minorFragmentId, fragmentData);
        this.fragmentDataSet.add(fragmentData);
    }

    public String getFragmentStatesAsString() {
        return this.fragmentDataMap.toString();
    }

    void addFragmentStatusTracker(BitControl.PlanFragment fragment, boolean isRoot) {
        CoordinationProtos.DrillbitEndpoint assignment = fragment.getAssignment();
        NodeTracker tracker = this.nodeMap.get(assignment);
        if (tracker == null) {
            tracker = new NodeTracker(assignment);
            this.nodeMap.put(assignment, tracker);
        }
        tracker.addFragment();
        this.addFragment(new FragmentData(fragment.getHandle(), assignment, isRoot));
    }

    void cancelExecutingFragments(DrillbitContext drillbitContext) {
        Controller controller = drillbitContext.getController();
        for (FragmentData data : this.fragmentDataSet) {
            switch (data.getState()) {
                case SENDING: 
                case AWAITING_ALLOCATION: 
                case RUNNING: {
                    ExecProtos.FragmentHandle handle = data.getHandle();
                    CoordinationProtos.DrillbitEndpoint endpoint = data.getEndpoint();
                    controller.getTunnel(endpoint).cancelFragment((RpcOutcomeListener)new SignalListener(endpoint, handle, SignalListener.Signal.CANCEL), handle);
                    break;
                }
            }
        }
    }

    void unpauseExecutingFragments(DrillbitContext drillbitContext) {
        Controller controller = drillbitContext.getController();
        for (FragmentData data : this.fragmentDataSet) {
            CoordinationProtos.DrillbitEndpoint endpoint = data.getEndpoint();
            ExecProtos.FragmentHandle handle = data.getHandle();
            controller.getTunnel(endpoint).unpauseFragment((RpcOutcomeListener)new SignalListener(endpoint, handle, SignalListener.Signal.UNPAUSE), handle);
        }
    }

    UserBitShared.QueryResult.QueryState updateEphemeralState(UserBitShared.QueryResult.QueryState queryState) {
        switch (queryState) {
            case ENQUEUED: 
            case STARTING: 
            case RUNNING: 
            case CANCELLATION_REQUESTED: {
                this.profileEStore.put(this.stringQueryId, (Object)this.getQueryInfo());
                break;
            }
            case COMPLETED: 
            case CANCELED: 
            case FAILED: {
                try {
                    this.profileEStore.delete(this.stringQueryId);
                }
                catch (Exception e) {
                    logger.warn("Failure while trying to delete the estore profile for this query.", e);
                }
                break;
            }
            default: {
                throw new IllegalStateException("unrecognized queryState " + queryState);
            }
        }
        return queryState;
    }

    void writeFinalProfile(UserException ex) {
        try {
            this.profilePStore.put(this.stringQueryId, (Object)this.getQueryProfile(ex));
        }
        catch (Exception e) {
            logger.error("Failure while storing Query Profile", e);
        }
    }

    private UserBitShared.QueryInfo getQueryInfo() {
        return UserBitShared.QueryInfo.newBuilder().setQuery(this.runQuery.getPlan()).setState(this.foreman.getState()).setUser(this.foreman.getQueryContext().getQueryUserName()).setForeman(this.foreman.getQueryContext().getCurrentEndpoint()).setStart(this.startTime).build();
    }

    public UserBitShared.QueryProfile getQueryProfile() {
        return this.getQueryProfile(null);
    }

    private UserBitShared.QueryProfile getQueryProfile(UserException ex) {
        UserBitShared.QueryProfile.Builder profileBuilder = UserBitShared.QueryProfile.newBuilder().setQuery(this.runQuery.getPlan()).setUser(this.foreman.getQueryContext().getQueryUserName()).setType(this.runQuery.getType()).setId(this.queryId).setState(this.foreman.getState()).setForeman(this.foreman.getQueryContext().getCurrentEndpoint()).setStart(this.startTime).setEnd(this.endTime).setTotalFragments(this.fragmentDataSet.size()).setFinishedFragments(this.finishedFragments.get());
        if (ex != null) {
            profileBuilder.setError(ex.getMessage(false));
            profileBuilder.setVerboseError(ex.getVerboseMessage(false));
            profileBuilder.setErrorId(ex.getErrorId());
            if (ex.getErrorLocation() != null) {
                profileBuilder.setErrorNode(ex.getErrorLocation());
            }
        }
        if (this.planText != null) {
            profileBuilder.setPlan(this.planText);
        }
        for (int i = 0; i < this.fragmentDataMap.allocated.length; ++i) {
            if (!this.fragmentDataMap.allocated[i]) continue;
            int majorFragmentId = this.fragmentDataMap.keys[i];
            IntObjectOpenHashMap minorMap = (IntObjectOpenHashMap)this.fragmentDataMap.values[i];
            UserBitShared.MajorFragmentProfile.Builder fb = UserBitShared.MajorFragmentProfile.newBuilder().setMajorFragmentId(majorFragmentId);
            for (int v = 0; v < minorMap.allocated.length; ++v) {
                if (!minorMap.allocated[v]) continue;
                FragmentData data = (FragmentData)minorMap.values[v];
                fb.addMinorFragmentProfile(data.getProfile());
            }
            profileBuilder.addFragmentProfile(fb);
        }
        return profileBuilder.build();
    }

    void setPlanText(String planText) {
        this.planText = planText;
    }

    void markStartTime() {
        this.startTime = System.currentTimeMillis();
    }

    void markEndTime() {
        this.endTime = System.currentTimeMillis();
    }

    private void nodeComplete() {
        int totalNodes;
        int finishedNodes = this.finishedNodes.incrementAndGet();
        Preconditions.checkArgument(finishedNodes <= (totalNodes = this.nodeMap.size()), "The finished node count exceeds the total node count");
        int remaining = totalNodes - finishedNodes;
        if (remaining == 0) {
            this.stateListener.moveToState(UserBitShared.QueryResult.QueryState.COMPLETED, null);
        } else {
            logger.debug("Foreman is still waiting for completion message from {} nodes containing {} fragments", (Object)remaining, (Object)(this.fragmentDataSet.size() - this.finishedFragments.get()));
        }
    }

    public FragmentStatusListener getFragmentStatusListener() {
        return this.fragmentStatusListener;
    }

    public DrillbitStatusListener getDrillbitStatusListener() {
        return this.drillbitStatusListener;
    }

    private class NodeTracker {
        private final CoordinationProtos.DrillbitEndpoint endpoint;
        private final AtomicInteger totalFragments = new AtomicInteger(0);
        private final AtomicInteger completedFragments = new AtomicInteger(0);

        public NodeTracker(CoordinationProtos.DrillbitEndpoint endpoint) {
            this.endpoint = endpoint;
        }

        public void addFragment() {
            this.totalFragments.incrementAndGet();
        }

        public void fragmentComplete() {
            if (this.totalFragments.get() == this.completedFragments.incrementAndGet()) {
                QueryManager.this.nodeComplete();
            }
        }

        public boolean nodeDead() {
            if (this.completedFragments.get() == this.totalFragments.get()) {
                return false;
            }
            while (this.completedFragments.get() < this.totalFragments.get()) {
                this.fragmentComplete();
            }
            return true;
        }
    }

    private static class SignalListener
    extends EndpointListener<GeneralRPCProtos.Ack, ExecProtos.FragmentHandle> {
        private final Signal signal;

        public SignalListener(CoordinationProtos.DrillbitEndpoint endpoint, ExecProtos.FragmentHandle handle, Signal signal) {
            super(endpoint, handle);
            this.signal = signal;
        }

        @Override
        public void failed(RpcException ex) {
            logger.error("Failure while attempting to {} fragment {} on endpoint {} with {}.", new Object[]{this.signal, this.value, this.endpoint, ex});
        }

        @Override
        public void success(GeneralRPCProtos.Ack ack, ByteBuf buf) {
            if (!ack.getOk()) {
                logger.warn("Remote node {} responded negative on {} request for fragment {} with {}.", new Object[]{this.endpoint, this.signal, this.value, ack});
            }
        }

        @Override
        public void interrupted(InterruptedException ex) {
            logger.error("Interrupted while waiting for RPC outcome of action fragment {}. Endpoint {}, Fragment handle {}", new Object[]{this.signal, this.endpoint, this.value, ex});
        }

        public static enum Signal {
            CANCEL,
            UNPAUSE;

        }
    }
}

