/*
 * Decompiled with CFR 0.152.
 */
package oadd.org.apache.drill.exec.vector.complex.impl;

import java.math.BigDecimal;
import java.util.ArrayList;
import oadd.com.google.common.collect.Lists;
import oadd.org.apache.drill.common.types.TypeProtos;
import oadd.org.apache.drill.exec.expr.holders.NullableDecimal38DenseHolder;
import oadd.org.apache.drill.exec.expr.holders.RepeatedDecimal38DenseHolder;
import oadd.org.apache.drill.exec.util.DecimalUtility;
import oadd.org.apache.drill.exec.vector.complex.impl.AbstractFieldReader;

public class RepeatedDecimal38DenseHolderReaderImpl
extends AbstractFieldReader {
    private NullableDecimal38DenseHolder holder = new NullableDecimal38DenseHolder();
    private int index = -1;
    private RepeatedDecimal38DenseHolder repeatedHolder;

    public RepeatedDecimal38DenseHolderReaderImpl(RepeatedDecimal38DenseHolder holder) {
        this.repeatedHolder = holder;
    }

    @Override
    public int size() {
        return this.repeatedHolder.end - this.repeatedHolder.start;
    }

    @Override
    public boolean next() {
        if (this.index + 1 < this.repeatedHolder.end) {
            ++this.index;
            this.repeatedHolder.vector.getAccessor().get(this.repeatedHolder.start + this.index, this.holder);
            return true;
        }
        return false;
    }

    @Override
    public void setPosition(int index) {
        throw new UnsupportedOperationException("You can't call next on a single value reader.");
    }

    @Override
    public TypeProtos.MajorType getType() {
        return RepeatedDecimal38DenseHolder.TYPE;
    }

    @Override
    public boolean isSet() {
        return this.repeatedHolder.end != this.repeatedHolder.start;
    }

    @Override
    public BigDecimal readBigDecimal(int index) {
        this.repeatedHolder.vector.getAccessor().get(this.repeatedHolder.start + index, this.holder);
        BigDecimal value = this.readBigDecimal();
        if (this.index > -1) {
            this.repeatedHolder.vector.getAccessor().get(this.repeatedHolder.start + this.index, this.holder);
        }
        return value;
    }

    @Override
    public BigDecimal readBigDecimal() {
        if (!this.isSet()) {
            return null;
        }
        return DecimalUtility.getBigDecimalFromDense(this.holder.buffer, this.holder.start, 4, this.holder.scale, 38, 16);
    }

    @Override
    public Object readObject() {
        ArrayList<BigDecimal> valList = Lists.newArrayList();
        for (int i = this.repeatedHolder.start; i < this.repeatedHolder.end; ++i) {
            valList.add(this.repeatedHolder.vector.getAccessor().getObject(i));
        }
        return valList;
    }

    private Object readSingleObject() {
        if (!this.isSet()) {
            return null;
        }
        return DecimalUtility.getBigDecimalFromDense(this.holder.buffer, this.holder.start, 4, this.holder.scale, 38, 16);
    }
}

