/*
 * Decompiled with CFR 0.152.
 */
package oadd.org.apache.drill.exec.vector.complex.fn;

import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import oadd.com.fasterxml.jackson.core.JsonParser;
import oadd.com.fasterxml.jackson.core.JsonToken;
import oadd.com.fasterxml.jackson.databind.JsonNode;
import oadd.com.google.common.base.Charsets;
import oadd.com.google.common.base.Preconditions;
import oadd.io.netty.buffer.DrillBuf;
import oadd.org.apache.drill.common.exceptions.UserException;
import oadd.org.apache.drill.common.expression.PathSegment;
import oadd.org.apache.drill.common.expression.SchemaPath;
import oadd.org.apache.drill.exec.physical.base.GroupScan;
import oadd.org.apache.drill.exec.store.easy.json.JsonProcessor;
import oadd.org.apache.drill.exec.store.easy.json.reader.BaseJsonProcessor;
import oadd.org.apache.drill.exec.vector.complex.fn.DrillBufInputStream;
import oadd.org.apache.drill.exec.vector.complex.fn.FieldSelection;
import oadd.org.apache.drill.exec.vector.complex.fn.SeekableBAIS;
import oadd.org.apache.drill.exec.vector.complex.fn.VectorOutput;
import oadd.org.apache.drill.exec.vector.complex.fn.WorkingBuffer;
import oadd.org.apache.drill.exec.vector.complex.writer.BaseWriter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JsonReader
extends BaseJsonProcessor {
    private static final Logger logger = LoggerFactory.getLogger(JsonReader.class);
    public static final int MAX_RECORD_SIZE = 131072;
    private final WorkingBuffer workingBuffer;
    private final List<SchemaPath> columns;
    private final boolean allTextMode;
    private final VectorOutput.MapVectorOutput mapOutput;
    private final VectorOutput.ListVectorOutput listOutput;
    private final boolean extended = true;
    private final boolean readNumbersAsDouble;
    private final boolean skipOuterList;
    private boolean inOuterList;
    private String currentFieldName;
    private FieldSelection selection;

    public JsonReader(DrillBuf managedBuf, boolean allTextMode, boolean skipOuterList, boolean readNumbersAsDouble) {
        this(managedBuf, GroupScan.ALL_COLUMNS, allTextMode, skipOuterList, readNumbersAsDouble);
    }

    public JsonReader(DrillBuf managedBuf, List<SchemaPath> columns, boolean allTextMode, boolean skipOuterList, boolean readNumbersAsDouble) {
        super(managedBuf);
        assert (Preconditions.checkNotNull(columns).size() > 0) : "JSON record reader requires at least one column";
        this.selection = FieldSelection.getFieldSelection(columns);
        this.workingBuffer = new WorkingBuffer(managedBuf);
        this.skipOuterList = skipOuterList;
        this.allTextMode = allTextMode;
        this.columns = columns;
        this.mapOutput = new VectorOutput.MapVectorOutput(this.workingBuffer);
        this.listOutput = new VectorOutput.ListVectorOutput(this.workingBuffer);
        this.currentFieldName = "<none>";
        this.readNumbersAsDouble = readNumbersAsDouble;
    }

    public void ensureAtLeastOneField(BaseWriter.ComplexWriter writer) {
        SchemaPath sp = this.columns.get(0);
        PathSegment fieldPath = sp.getRootSegment();
        BaseWriter.MapWriter fieldWriter = writer.rootAsMap();
        while (fieldPath.getChild() != null && !fieldPath.getChild().isArray()) {
            fieldWriter = fieldWriter.map(((PathSegment)fieldPath).getNameSegment().getPath());
            fieldPath = fieldPath.getChild();
        }
        if (fieldWriter.isEmptyMap()) {
            fieldWriter.integer(((PathSegment)fieldPath).getNameSegment().getPath());
        }
    }

    public void setSource(int start, int end, DrillBuf buf) throws IOException {
        this.setSource(DrillBufInputStream.getStream(start, end, buf));
    }

    public void setSource(InputStream is) throws IOException {
        super.setSource(is);
        this.mapOutput.setParser(this.parser);
        this.listOutput.setParser(this.parser);
    }

    public void setSource(JsonNode node) {
        super.setSource(node);
        this.mapOutput.setParser(this.parser);
        this.listOutput.setParser(this.parser);
    }

    public void setSource(String data) throws IOException {
        this.setSource(data.getBytes(Charsets.UTF_8));
    }

    public void setSource(byte[] bytes) throws IOException {
        this.setSource(new SeekableBAIS(bytes));
    }

    public JsonProcessor.ReadState write(BaseWriter.ComplexWriter writer) throws IOException {
        JsonToken t = this.parser.nextToken();
        while (!this.parser.hasCurrentToken() && !this.parser.isClosed()) {
            t = this.parser.nextToken();
        }
        if (this.parser.isClosed()) {
            return JsonProcessor.ReadState.END_OF_STREAM;
        }
        JsonProcessor.ReadState readState = this.writeToVector(writer, t);
        switch (readState) {
            case END_OF_STREAM: {
                break;
            }
            case WRITE_SUCCEED: {
                break;
            }
            default: {
                throw this.getExceptionWithContext(UserException.dataReadError(), this.currentFieldName, null, new Object[0]).message("Failure while reading JSON. (Got an invalid read state %s )", readState.toString()).build(logger);
            }
        }
        return readState;
    }

    private void confirmLast() throws IOException {
        this.parser.nextToken();
        if (!this.parser.isClosed()) {
            throw this.getExceptionWithContext(UserException.dataReadError(), this.currentFieldName, null, new Object[0]).message("Drill attempted to unwrap a toplevel list in your document.  However, it appears that there is trailing content after this top level list.  Drill only supports querying a set of distinct maps or a single json array with multiple inner maps.", new Object[0]).build(logger);
        }
    }

    private JsonProcessor.ReadState writeToVector(BaseWriter.ComplexWriter writer, JsonToken t) throws IOException {
        switch (t) {
            case START_OBJECT: {
                this.writeDataSwitch(writer.rootAsMap());
                break;
            }
            case START_ARRAY: {
                if (this.inOuterList) {
                    throw this.getExceptionWithContext(UserException.dataReadError(), this.currentFieldName, null, new Object[0]).message("The top level of your document must either be a single array of maps or a set of white space delimited maps.", new Object[0]).build(logger);
                }
                if (this.skipOuterList) {
                    t = this.parser.nextToken();
                    if (t == JsonToken.START_OBJECT) {
                        this.inOuterList = true;
                        this.writeDataSwitch(writer.rootAsMap());
                        break;
                    }
                    throw this.getExceptionWithContext(UserException.dataReadError(), this.currentFieldName, null, new Object[0]).message("The top level of your document must either be a single array of maps or a set of white space delimited maps.", new Object[0]).build(logger);
                }
                this.writeDataSwitch(writer.rootAsList());
                break;
            }
            case END_ARRAY: {
                if (this.inOuterList) {
                    this.confirmLast();
                    return JsonProcessor.ReadState.END_OF_STREAM;
                }
                throw this.getExceptionWithContext(UserException.dataReadError(), this.currentFieldName, null, new Object[0]).message("Failure while parsing JSON.  Ran across unexpected %s.", new Object[]{JsonToken.END_ARRAY}).build(logger);
            }
            case NOT_AVAILABLE: {
                return JsonProcessor.ReadState.END_OF_STREAM;
            }
            default: {
                throw this.getExceptionWithContext(UserException.dataReadError(), this.currentFieldName, null, new Object[0]).message("Failure while parsing JSON.  Found token of [%s].  Drill currently only supports parsing json strings that contain either lists or maps.  The root object cannot be a scalar.", new Object[]{t}).build(logger);
            }
        }
        return JsonProcessor.ReadState.WRITE_SUCCEED;
    }

    private void writeDataSwitch(BaseWriter.MapWriter w) throws IOException {
        if (this.allTextMode) {
            this.writeDataAllText(w, this.selection, true);
        } else {
            this.writeData(w, this.selection, true);
        }
    }

    private void writeDataSwitch(BaseWriter.ListWriter w) throws IOException {
        if (this.allTextMode) {
            this.writeDataAllText(w);
        } else {
            this.writeData(w);
        }
    }

    private void consumeEntireNextValue() throws IOException {
        switch (this.parser.nextToken()) {
            case START_OBJECT: 
            case START_ARRAY: {
                this.parser.skipChildren();
                return;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeData(BaseWriter.MapWriter map, FieldSelection selection, boolean moveForward) throws IOException {
        block22: {
            map.start();
            try {
                block15: while (true) {
                    String fieldName;
                    JsonToken t;
                    if (moveForward) {
                        t = this.parser.nextToken();
                    } else {
                        t = this.parser.getCurrentToken();
                        moveForward = true;
                    }
                    if (t == JsonToken.NOT_AVAILABLE || t == JsonToken.END_OBJECT) {
                        return;
                    }
                    assert (t == JsonToken.FIELD_NAME) : String.format("Expected FIELD_NAME but got %s.", t.name());
                    this.currentFieldName = fieldName = this.parser.getText();
                    FieldSelection childSelection = selection.getChild(fieldName);
                    if (childSelection.isNeverValid()) {
                        this.consumeEntireNextValue();
                        continue;
                    }
                    switch (this.parser.nextToken()) {
                        case START_ARRAY: {
                            this.writeData(map.list(fieldName));
                            break;
                        }
                        case START_OBJECT: {
                            if (this.writeMapDataIfTyped(map, fieldName)) continue block15;
                            this.writeData(map.map(fieldName), childSelection, false);
                            break;
                        }
                        case END_OBJECT: {
                            break block22;
                        }
                        case VALUE_FALSE: {
                            map.bit(fieldName).writeBit(0);
                            break;
                        }
                        case VALUE_TRUE: {
                            map.bit(fieldName).writeBit(1);
                            break;
                        }
                        case VALUE_NULL: {
                            break;
                        }
                        case VALUE_NUMBER_FLOAT: {
                            map.float8(fieldName).writeFloat8(this.parser.getDoubleValue());
                            break;
                        }
                        case VALUE_NUMBER_INT: {
                            if (this.readNumbersAsDouble) {
                                map.float8(fieldName).writeFloat8(this.parser.getDoubleValue());
                                break;
                            }
                            map.bigInt(fieldName).writeBigInt(this.parser.getLongValue());
                            break;
                        }
                        case VALUE_STRING: {
                            this.handleString(this.parser, map, fieldName);
                            break;
                        }
                        default: {
                            throw this.getExceptionWithContext(UserException.dataReadError(), this.currentFieldName, null, new Object[0]).message("Unexpected token %s", new Object[]{this.parser.getCurrentToken()}).build(logger);
                        }
                    }
                }
            }
            finally {
                map.end();
            }
        }
    }

    private void writeDataAllText(BaseWriter.MapWriter map, FieldSelection selection, boolean moveForward) throws IOException {
        map.start();
        block7: while (true) {
            String fieldName;
            JsonToken t;
            if (moveForward) {
                t = this.parser.nextToken();
            } else {
                t = this.parser.getCurrentToken();
                moveForward = true;
            }
            if (t == JsonToken.NOT_AVAILABLE || t == JsonToken.END_OBJECT) {
                return;
            }
            assert (t == JsonToken.FIELD_NAME) : String.format("Expected FIELD_NAME but got %s.", t.name());
            this.currentFieldName = fieldName = this.parser.getText();
            FieldSelection childSelection = selection.getChild(fieldName);
            if (childSelection.isNeverValid()) {
                this.consumeEntireNextValue();
                continue;
            }
            switch (this.parser.nextToken()) {
                case START_ARRAY: {
                    this.writeDataAllText(map.list(fieldName));
                    break;
                }
                case START_OBJECT: {
                    if (this.writeMapDataIfTyped(map, fieldName)) continue block7;
                    this.writeDataAllText(map.map(fieldName), childSelection, false);
                    break;
                }
                case END_OBJECT: {
                    break block7;
                }
                case VALUE_FALSE: 
                case VALUE_TRUE: 
                case VALUE_NUMBER_FLOAT: 
                case VALUE_NUMBER_INT: 
                case VALUE_STRING: 
                case VALUE_EMBEDDED_OBJECT: {
                    this.handleString(this.parser, map, fieldName);
                    break;
                }
                case VALUE_NULL: {
                    break;
                }
                default: {
                    throw this.getExceptionWithContext(UserException.dataReadError(), this.currentFieldName, null, new Object[0]).message("Unexpected token %s", new Object[]{this.parser.getCurrentToken()}).build(logger);
                }
            }
        }
        map.end();
    }

    private boolean writeMapDataIfTyped(BaseWriter.MapWriter writer, String fieldName) throws IOException {
        return this.mapOutput.run(writer, fieldName);
    }

    private boolean writeListDataIfTyped(BaseWriter.ListWriter writer) throws IOException {
        return this.listOutput.run(writer);
    }

    private void handleString(JsonParser parser, BaseWriter.MapWriter writer, String fieldName) throws IOException {
        writer.varChar(fieldName).writeVarChar(0, this.workingBuffer.prepareVarCharHolder(parser.getText()), this.workingBuffer.getBuf());
    }

    private void handleString(JsonParser parser, BaseWriter.ListWriter writer) throws IOException {
        writer.varChar().writeVarChar(0, this.workingBuffer.prepareVarCharHolder(parser.getText()), this.workingBuffer.getBuf());
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void writeData(BaseWriter.ListWriter list) throws IOException {
        block15: {
            list.startList();
            try {
                block13: while (true) {
                    switch (this.parser.nextToken()) {
                        case START_ARRAY: {
                            this.writeData(list.list());
                            break;
                        }
                        case START_OBJECT: {
                            if (this.writeListDataIfTyped(list)) continue block13;
                            this.writeData(list.map(), FieldSelection.ALL_VALID, false);
                            break;
                        }
                        case END_ARRAY: 
                        case END_OBJECT: {
                            break block15;
                        }
                        case VALUE_FALSE: 
                        case VALUE_EMBEDDED_OBJECT: {
                            list.bit().writeBit(0);
                            break;
                        }
                        case VALUE_TRUE: {
                            list.bit().writeBit(1);
                            break;
                        }
                        case VALUE_NULL: {
                            throw UserException.unsupportedError().message("Null values are not supported in lists by default. Please set `store.json.all_text_mode` to true to read lists containing nulls. Be advised that this will treat JSON null values as a string containing the word 'null'.", new Object[0]).build(logger);
                        }
                        case VALUE_NUMBER_FLOAT: {
                            list.float8().writeFloat8(this.parser.getDoubleValue());
                            break;
                        }
                        case VALUE_NUMBER_INT: {
                            if (this.readNumbersAsDouble) {
                                list.float8().writeFloat8(this.parser.getDoubleValue());
                                break;
                            }
                            list.bigInt().writeBigInt(this.parser.getLongValue());
                            break;
                        }
                        case VALUE_STRING: {
                            this.handleString(this.parser, list);
                            break;
                        }
                        default: {
                            throw UserException.dataReadError().message("Unexpected token %s", new Object[]{this.parser.getCurrentToken()}).build(logger);
                        }
                    }
                }
            }
            catch (Exception e) {
                throw this.getExceptionWithContext(e, this.currentFieldName, null, new Object[0]).build(logger);
            }
        }
        list.endList();
    }

    private void writeDataAllText(BaseWriter.ListWriter list) throws IOException {
        list.startList();
        block6: while (true) {
            switch (this.parser.nextToken()) {
                case START_ARRAY: {
                    this.writeDataAllText(list.list());
                    continue block6;
                }
                case START_OBJECT: {
                    if (this.writeListDataIfTyped(list)) continue block6;
                    this.writeDataAllText(list.map(), FieldSelection.ALL_VALID, false);
                    continue block6;
                }
                case END_ARRAY: 
                case END_OBJECT: {
                    break block6;
                }
                case VALUE_FALSE: 
                case VALUE_TRUE: 
                case VALUE_NULL: 
                case VALUE_NUMBER_FLOAT: 
                case VALUE_NUMBER_INT: 
                case VALUE_STRING: 
                case VALUE_EMBEDDED_OBJECT: {
                    this.handleString(this.parser, list);
                    continue block6;
                }
                default: {
                    throw this.getExceptionWithContext(UserException.dataReadError(), this.currentFieldName, null, new Object[0]).message("Unexpected token %s", new Object[]{this.parser.getCurrentToken()}).build(logger);
                }
            }
            break;
        }
        list.endList();
    }

    public DrillBuf getWorkBuf() {
        return this.workingBuffer.getBuf();
    }
}

