/*
 * Decompiled with CFR 0.152.
 */
package oadd.org.apache.drill.exec.vector.complex;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import oadd.com.google.common.base.Preconditions;
import oadd.com.google.common.collect.Lists;
import oadd.io.netty.buffer.DrillBuf;
import oadd.org.apache.drill.common.expression.FieldReference;
import oadd.org.apache.drill.common.expression.PathSegment;
import oadd.org.apache.drill.common.types.TypeProtos;
import oadd.org.apache.drill.common.types.Types;
import oadd.org.apache.drill.exec.exception.OutOfMemoryException;
import oadd.org.apache.drill.exec.expr.BasicTypeHelper;
import oadd.org.apache.drill.exec.expr.holders.ComplexHolder;
import oadd.org.apache.drill.exec.expr.holders.NullableBigIntHolder;
import oadd.org.apache.drill.exec.expr.holders.NullableBitHolder;
import oadd.org.apache.drill.exec.expr.holders.NullableDateHolder;
import oadd.org.apache.drill.exec.expr.holders.NullableFloat4Holder;
import oadd.org.apache.drill.exec.expr.holders.NullableFloat8Holder;
import oadd.org.apache.drill.exec.expr.holders.NullableIntHolder;
import oadd.org.apache.drill.exec.expr.holders.NullableIntervalDayHolder;
import oadd.org.apache.drill.exec.expr.holders.NullableIntervalHolder;
import oadd.org.apache.drill.exec.expr.holders.NullableIntervalYearHolder;
import oadd.org.apache.drill.exec.expr.holders.NullableSmallIntHolder;
import oadd.org.apache.drill.exec.expr.holders.NullableTimeHolder;
import oadd.org.apache.drill.exec.expr.holders.NullableTimeStampHolder;
import oadd.org.apache.drill.exec.expr.holders.NullableTinyIntHolder;
import oadd.org.apache.drill.exec.expr.holders.NullableUInt1Holder;
import oadd.org.apache.drill.exec.expr.holders.NullableUInt2Holder;
import oadd.org.apache.drill.exec.expr.holders.NullableUInt4Holder;
import oadd.org.apache.drill.exec.expr.holders.NullableUInt8Holder;
import oadd.org.apache.drill.exec.expr.holders.NullableVar16CharHolder;
import oadd.org.apache.drill.exec.expr.holders.NullableVarBinaryHolder;
import oadd.org.apache.drill.exec.expr.holders.NullableVarCharHolder;
import oadd.org.apache.drill.exec.expr.holders.UnionHolder;
import oadd.org.apache.drill.exec.memory.BufferAllocator;
import oadd.org.apache.drill.exec.proto.UserBitShared;
import oadd.org.apache.drill.exec.record.MaterializedField;
import oadd.org.apache.drill.exec.record.TransferPair;
import oadd.org.apache.drill.exec.record.TypedFieldId;
import oadd.org.apache.drill.exec.util.CallBack;
import oadd.org.apache.drill.exec.vector.BaseValueVector;
import oadd.org.apache.drill.exec.vector.NullableBigIntVector;
import oadd.org.apache.drill.exec.vector.NullableBitVector;
import oadd.org.apache.drill.exec.vector.NullableDateVector;
import oadd.org.apache.drill.exec.vector.NullableFloat4Vector;
import oadd.org.apache.drill.exec.vector.NullableFloat8Vector;
import oadd.org.apache.drill.exec.vector.NullableIntVector;
import oadd.org.apache.drill.exec.vector.NullableIntervalDayVector;
import oadd.org.apache.drill.exec.vector.NullableIntervalVector;
import oadd.org.apache.drill.exec.vector.NullableIntervalYearVector;
import oadd.org.apache.drill.exec.vector.NullableSmallIntVector;
import oadd.org.apache.drill.exec.vector.NullableTimeStampVector;
import oadd.org.apache.drill.exec.vector.NullableTimeVector;
import oadd.org.apache.drill.exec.vector.NullableTinyIntVector;
import oadd.org.apache.drill.exec.vector.NullableUInt1Vector;
import oadd.org.apache.drill.exec.vector.NullableUInt2Vector;
import oadd.org.apache.drill.exec.vector.NullableUInt4Vector;
import oadd.org.apache.drill.exec.vector.NullableUInt8Vector;
import oadd.org.apache.drill.exec.vector.NullableVar16CharVector;
import oadd.org.apache.drill.exec.vector.NullableVarBinaryVector;
import oadd.org.apache.drill.exec.vector.NullableVarCharVector;
import oadd.org.apache.drill.exec.vector.UInt1Vector;
import oadd.org.apache.drill.exec.vector.ValueVector;
import oadd.org.apache.drill.exec.vector.complex.AbstractContainerVector;
import oadd.org.apache.drill.exec.vector.complex.ListVector;
import oadd.org.apache.drill.exec.vector.complex.MapVector;
import oadd.org.apache.drill.exec.vector.complex.impl.ComplexCopier;
import oadd.org.apache.drill.exec.vector.complex.impl.UnionReader;
import oadd.org.apache.drill.exec.vector.complex.impl.UnionWriter;
import oadd.org.apache.drill.exec.vector.complex.reader.FieldReader;
import oadd.org.apache.drill.exec.vector.complex.writer.FieldWriter;

public class UnionVector
implements ValueVector {
    private MaterializedField field;
    private BufferAllocator allocator;
    private Accessor accessor = new Accessor();
    private Mutator mutator = new Mutator();
    private int valueCount;
    private MapVector internalMap;
    private UInt1Vector typeVector;
    private MapVector mapVector;
    private ListVector listVector;
    private FieldReader reader;
    private NullableBitVector bit;
    private int singleType = 0;
    private ValueVector singleVector;
    private TypeProtos.MajorType majorType;
    private final CallBack callBack;
    private static final TypeProtos.MajorType MAP_TYPE = Types.optional(TypeProtos.MinorType.MAP);
    private NullableTinyIntVector tinyIntVector;
    private static final TypeProtos.MajorType TINYINT_TYPE = Types.optional(TypeProtos.MinorType.TINYINT);
    private NullableUInt1Vector uInt1Vector;
    private static final TypeProtos.MajorType UINT1_TYPE = Types.optional(TypeProtos.MinorType.UINT1);
    private NullableUInt2Vector uInt2Vector;
    private static final TypeProtos.MajorType UINT2_TYPE = Types.optional(TypeProtos.MinorType.UINT2);
    private NullableSmallIntVector smallIntVector;
    private static final TypeProtos.MajorType SMALLINT_TYPE = Types.optional(TypeProtos.MinorType.SMALLINT);
    private NullableIntVector intVector;
    private static final TypeProtos.MajorType INT_TYPE = Types.optional(TypeProtos.MinorType.INT);
    private NullableUInt4Vector uInt4Vector;
    private static final TypeProtos.MajorType UINT4_TYPE = Types.optional(TypeProtos.MinorType.UINT4);
    private NullableFloat4Vector float4Vector;
    private static final TypeProtos.MajorType FLOAT4_TYPE = Types.optional(TypeProtos.MinorType.FLOAT4);
    private NullableTimeVector timeVector;
    private static final TypeProtos.MajorType TIME_TYPE = Types.optional(TypeProtos.MinorType.TIME);
    private NullableIntervalYearVector intervalYearVector;
    private static final TypeProtos.MajorType INTERVALYEAR_TYPE = Types.optional(TypeProtos.MinorType.INTERVALYEAR);
    private NullableBigIntVector bigIntVector;
    private static final TypeProtos.MajorType BIGINT_TYPE = Types.optional(TypeProtos.MinorType.BIGINT);
    private NullableUInt8Vector uInt8Vector;
    private static final TypeProtos.MajorType UINT8_TYPE = Types.optional(TypeProtos.MinorType.UINT8);
    private NullableFloat8Vector float8Vector;
    private static final TypeProtos.MajorType FLOAT8_TYPE = Types.optional(TypeProtos.MinorType.FLOAT8);
    private NullableDateVector dateVector;
    private static final TypeProtos.MajorType DATE_TYPE = Types.optional(TypeProtos.MinorType.DATE);
    private NullableTimeStampVector timeStampVector;
    private static final TypeProtos.MajorType TIMESTAMP_TYPE = Types.optional(TypeProtos.MinorType.TIMESTAMP);
    private NullableIntervalDayVector intervalDayVector;
    private static final TypeProtos.MajorType INTERVALDAY_TYPE = Types.optional(TypeProtos.MinorType.INTERVALDAY);
    private NullableIntervalVector intervalVector;
    private static final TypeProtos.MajorType INTERVAL_TYPE = Types.optional(TypeProtos.MinorType.INTERVAL);
    private NullableVarBinaryVector varBinaryVector;
    private static final TypeProtos.MajorType VARBINARY_TYPE = Types.optional(TypeProtos.MinorType.VARBINARY);
    private NullableVarCharVector varCharVector;
    private static final TypeProtos.MajorType VARCHAR_TYPE = Types.optional(TypeProtos.MinorType.VARCHAR);
    private NullableVar16CharVector var16CharVector;
    private static final TypeProtos.MajorType VAR16CHAR_TYPE = Types.optional(TypeProtos.MinorType.VAR16CHAR);
    private NullableBitVector bitVector;
    private static final TypeProtos.MajorType BIT_TYPE = Types.optional(TypeProtos.MinorType.BIT);
    private static final TypeProtos.MajorType LIST_TYPE = Types.optional(TypeProtos.MinorType.LIST);

    public UnionVector(MaterializedField field, BufferAllocator allocator, CallBack callBack) {
        this.field = field.clone();
        this.allocator = allocator;
        this.internalMap = new MapVector("internal", allocator, callBack);
        this.typeVector = this.internalMap.addOrGet("types", Types.required(TypeProtos.MinorType.UINT1), UInt1Vector.class);
        this.field.addChild(this.internalMap.getField().clone());
        this.majorType = field.getType();
        this.callBack = callBack;
    }

    @Override
    public BufferAllocator getAllocator() {
        return this.allocator;
    }

    public List<TypeProtos.MinorType> getSubTypes() {
        return this.majorType.getSubTypeList();
    }

    public void addSubType(TypeProtos.MinorType type) {
        if (this.majorType.getSubTypeList().contains(type)) {
            return;
        }
        this.majorType = TypeProtos.MajorType.newBuilder(this.majorType).addSubType(type).build();
        this.field = MaterializedField.create(this.field.getPath(), this.majorType);
        if (this.callBack != null) {
            this.callBack.doWork();
        }
    }

    public MapVector getMap() {
        if (this.mapVector == null) {
            int vectorCount = this.internalMap.size();
            this.mapVector = this.internalMap.addOrGet("map", MAP_TYPE, MapVector.class);
            this.addSubType(TypeProtos.MinorType.MAP);
            if (this.internalMap.size() > vectorCount) {
                this.mapVector.allocateNew();
            }
        }
        return this.mapVector;
    }

    public NullableTinyIntVector getTinyIntVector() {
        if (this.tinyIntVector == null) {
            int vectorCount = this.internalMap.size();
            this.tinyIntVector = this.internalMap.addOrGet("tinyInt", TINYINT_TYPE, NullableTinyIntVector.class);
            this.addSubType(TypeProtos.MinorType.TINYINT);
            if (this.internalMap.size() > vectorCount) {
                this.tinyIntVector.allocateNew();
            }
        }
        return this.tinyIntVector;
    }

    public NullableUInt1Vector getUInt1Vector() {
        if (this.uInt1Vector == null) {
            int vectorCount = this.internalMap.size();
            this.uInt1Vector = this.internalMap.addOrGet("uInt1", UINT1_TYPE, NullableUInt1Vector.class);
            this.addSubType(TypeProtos.MinorType.UINT1);
            if (this.internalMap.size() > vectorCount) {
                this.uInt1Vector.allocateNew();
            }
        }
        return this.uInt1Vector;
    }

    public NullableUInt2Vector getUInt2Vector() {
        if (this.uInt2Vector == null) {
            int vectorCount = this.internalMap.size();
            this.uInt2Vector = this.internalMap.addOrGet("uInt2", UINT2_TYPE, NullableUInt2Vector.class);
            this.addSubType(TypeProtos.MinorType.UINT2);
            if (this.internalMap.size() > vectorCount) {
                this.uInt2Vector.allocateNew();
            }
        }
        return this.uInt2Vector;
    }

    public NullableSmallIntVector getSmallIntVector() {
        if (this.smallIntVector == null) {
            int vectorCount = this.internalMap.size();
            this.smallIntVector = this.internalMap.addOrGet("smallInt", SMALLINT_TYPE, NullableSmallIntVector.class);
            this.addSubType(TypeProtos.MinorType.SMALLINT);
            if (this.internalMap.size() > vectorCount) {
                this.smallIntVector.allocateNew();
            }
        }
        return this.smallIntVector;
    }

    public NullableIntVector getIntVector() {
        if (this.intVector == null) {
            int vectorCount = this.internalMap.size();
            this.intVector = this.internalMap.addOrGet("int", INT_TYPE, NullableIntVector.class);
            this.addSubType(TypeProtos.MinorType.INT);
            if (this.internalMap.size() > vectorCount) {
                this.intVector.allocateNew();
            }
        }
        return this.intVector;
    }

    public NullableUInt4Vector getUInt4Vector() {
        if (this.uInt4Vector == null) {
            int vectorCount = this.internalMap.size();
            this.uInt4Vector = this.internalMap.addOrGet("uInt4", UINT4_TYPE, NullableUInt4Vector.class);
            this.addSubType(TypeProtos.MinorType.UINT4);
            if (this.internalMap.size() > vectorCount) {
                this.uInt4Vector.allocateNew();
            }
        }
        return this.uInt4Vector;
    }

    public NullableFloat4Vector getFloat4Vector() {
        if (this.float4Vector == null) {
            int vectorCount = this.internalMap.size();
            this.float4Vector = this.internalMap.addOrGet("float4", FLOAT4_TYPE, NullableFloat4Vector.class);
            this.addSubType(TypeProtos.MinorType.FLOAT4);
            if (this.internalMap.size() > vectorCount) {
                this.float4Vector.allocateNew();
            }
        }
        return this.float4Vector;
    }

    public NullableTimeVector getTimeVector() {
        if (this.timeVector == null) {
            int vectorCount = this.internalMap.size();
            this.timeVector = this.internalMap.addOrGet("time", TIME_TYPE, NullableTimeVector.class);
            this.addSubType(TypeProtos.MinorType.TIME);
            if (this.internalMap.size() > vectorCount) {
                this.timeVector.allocateNew();
            }
        }
        return this.timeVector;
    }

    public NullableIntervalYearVector getIntervalYearVector() {
        if (this.intervalYearVector == null) {
            int vectorCount = this.internalMap.size();
            this.intervalYearVector = this.internalMap.addOrGet("intervalYear", INTERVALYEAR_TYPE, NullableIntervalYearVector.class);
            this.addSubType(TypeProtos.MinorType.INTERVALYEAR);
            if (this.internalMap.size() > vectorCount) {
                this.intervalYearVector.allocateNew();
            }
        }
        return this.intervalYearVector;
    }

    public NullableBigIntVector getBigIntVector() {
        if (this.bigIntVector == null) {
            int vectorCount = this.internalMap.size();
            this.bigIntVector = this.internalMap.addOrGet("bigInt", BIGINT_TYPE, NullableBigIntVector.class);
            this.addSubType(TypeProtos.MinorType.BIGINT);
            if (this.internalMap.size() > vectorCount) {
                this.bigIntVector.allocateNew();
            }
        }
        return this.bigIntVector;
    }

    public NullableUInt8Vector getUInt8Vector() {
        if (this.uInt8Vector == null) {
            int vectorCount = this.internalMap.size();
            this.uInt8Vector = this.internalMap.addOrGet("uInt8", UINT8_TYPE, NullableUInt8Vector.class);
            this.addSubType(TypeProtos.MinorType.UINT8);
            if (this.internalMap.size() > vectorCount) {
                this.uInt8Vector.allocateNew();
            }
        }
        return this.uInt8Vector;
    }

    public NullableFloat8Vector getFloat8Vector() {
        if (this.float8Vector == null) {
            int vectorCount = this.internalMap.size();
            this.float8Vector = this.internalMap.addOrGet("float8", FLOAT8_TYPE, NullableFloat8Vector.class);
            this.addSubType(TypeProtos.MinorType.FLOAT8);
            if (this.internalMap.size() > vectorCount) {
                this.float8Vector.allocateNew();
            }
        }
        return this.float8Vector;
    }

    public NullableDateVector getDateVector() {
        if (this.dateVector == null) {
            int vectorCount = this.internalMap.size();
            this.dateVector = this.internalMap.addOrGet("date", DATE_TYPE, NullableDateVector.class);
            this.addSubType(TypeProtos.MinorType.DATE);
            if (this.internalMap.size() > vectorCount) {
                this.dateVector.allocateNew();
            }
        }
        return this.dateVector;
    }

    public NullableTimeStampVector getTimeStampVector() {
        if (this.timeStampVector == null) {
            int vectorCount = this.internalMap.size();
            this.timeStampVector = this.internalMap.addOrGet("timeStamp", TIMESTAMP_TYPE, NullableTimeStampVector.class);
            this.addSubType(TypeProtos.MinorType.TIMESTAMP);
            if (this.internalMap.size() > vectorCount) {
                this.timeStampVector.allocateNew();
            }
        }
        return this.timeStampVector;
    }

    public NullableIntervalDayVector getIntervalDayVector() {
        if (this.intervalDayVector == null) {
            int vectorCount = this.internalMap.size();
            this.intervalDayVector = this.internalMap.addOrGet("intervalDay", INTERVALDAY_TYPE, NullableIntervalDayVector.class);
            this.addSubType(TypeProtos.MinorType.INTERVALDAY);
            if (this.internalMap.size() > vectorCount) {
                this.intervalDayVector.allocateNew();
            }
        }
        return this.intervalDayVector;
    }

    public NullableIntervalVector getIntervalVector() {
        if (this.intervalVector == null) {
            int vectorCount = this.internalMap.size();
            this.intervalVector = this.internalMap.addOrGet("interval", INTERVAL_TYPE, NullableIntervalVector.class);
            this.addSubType(TypeProtos.MinorType.INTERVAL);
            if (this.internalMap.size() > vectorCount) {
                this.intervalVector.allocateNew();
            }
        }
        return this.intervalVector;
    }

    public NullableVarBinaryVector getVarBinaryVector() {
        if (this.varBinaryVector == null) {
            int vectorCount = this.internalMap.size();
            this.varBinaryVector = this.internalMap.addOrGet("varBinary", VARBINARY_TYPE, NullableVarBinaryVector.class);
            this.addSubType(TypeProtos.MinorType.VARBINARY);
            if (this.internalMap.size() > vectorCount) {
                this.varBinaryVector.allocateNew();
            }
        }
        return this.varBinaryVector;
    }

    public NullableVarCharVector getVarCharVector() {
        if (this.varCharVector == null) {
            int vectorCount = this.internalMap.size();
            this.varCharVector = this.internalMap.addOrGet("varChar", VARCHAR_TYPE, NullableVarCharVector.class);
            this.addSubType(TypeProtos.MinorType.VARCHAR);
            if (this.internalMap.size() > vectorCount) {
                this.varCharVector.allocateNew();
            }
        }
        return this.varCharVector;
    }

    public NullableVar16CharVector getVar16CharVector() {
        if (this.var16CharVector == null) {
            int vectorCount = this.internalMap.size();
            this.var16CharVector = this.internalMap.addOrGet("var16Char", VAR16CHAR_TYPE, NullableVar16CharVector.class);
            this.addSubType(TypeProtos.MinorType.VAR16CHAR);
            if (this.internalMap.size() > vectorCount) {
                this.var16CharVector.allocateNew();
            }
        }
        return this.var16CharVector;
    }

    public NullableBitVector getBitVector() {
        if (this.bitVector == null) {
            int vectorCount = this.internalMap.size();
            this.bitVector = this.internalMap.addOrGet("bit", BIT_TYPE, NullableBitVector.class);
            this.addSubType(TypeProtos.MinorType.BIT);
            if (this.internalMap.size() > vectorCount) {
                this.bitVector.allocateNew();
            }
        }
        return this.bitVector;
    }

    public ListVector getList() {
        if (this.listVector == null) {
            int vectorCount = this.internalMap.size();
            this.listVector = this.internalMap.addOrGet("list", LIST_TYPE, ListVector.class);
            this.addSubType(TypeProtos.MinorType.LIST);
            if (this.internalMap.size() > vectorCount) {
                this.listVector.allocateNew();
            }
        }
        return this.listVector;
    }

    public int getTypeValue(int index) {
        return this.typeVector.getAccessor().get(index);
    }

    public UInt1Vector getTypeVector() {
        return this.typeVector;
    }

    @Override
    public void allocateNew() throws OutOfMemoryException {
        this.internalMap.allocateNew();
        if (this.typeVector != null) {
            this.typeVector.zeroVector();
        }
    }

    @Override
    public boolean allocateNewSafe() {
        boolean safe = this.internalMap.allocateNewSafe();
        if (safe && this.typeVector != null) {
            this.typeVector.zeroVector();
        }
        return safe;
    }

    @Override
    public void setInitialCapacity(int numRecords) {
    }

    @Override
    public int getValueCapacity() {
        return Math.min(this.typeVector.getValueCapacity(), this.internalMap.getValueCapacity());
    }

    @Override
    public void close() {
    }

    @Override
    public void clear() {
        this.internalMap.clear();
    }

    @Override
    public MaterializedField getField() {
        return this.field;
    }

    @Override
    public TransferPair getTransferPair(BufferAllocator allocator) {
        return new TransferImpl(this.field, allocator);
    }

    @Override
    public TransferPair getTransferPair(FieldReference ref, BufferAllocator allocator) {
        return new TransferImpl(this.field.withPath(ref), allocator);
    }

    @Override
    public TransferPair makeTransferPair(ValueVector target) {
        return new TransferImpl((UnionVector)target);
    }

    public void transferTo(UnionVector target) {
        this.internalMap.makeTransferPair(target.internalMap).transfer();
        target.valueCount = this.valueCount;
        target.majorType = this.majorType;
    }

    public void copyFrom(int inIndex, int outIndex, UnionVector from) {
        from.getReader().setPosition(inIndex);
        this.getWriter().setPosition(outIndex);
        ComplexCopier.copy(from.reader, this.mutator.writer);
    }

    public void copyFromSafe(int inIndex, int outIndex, UnionVector from) {
        this.copyFrom(inIndex, outIndex, from);
    }

    public ValueVector addVector(ValueVector v) {
        String name = v.getField().getType().getMinorType().name().toLowerCase();
        TypeProtos.MajorType type = v.getField().getType();
        Preconditions.checkState(this.internalMap.getChild(name) == null, String.format("%s vector already exists", name));
        Object newVector = this.internalMap.addOrGet(name, type, BasicTypeHelper.getValueVectorClass(type.getMinorType(), type.getMode()));
        v.makeTransferPair((ValueVector)newVector).transfer();
        this.internalMap.putChild(name, (ValueVector)newVector);
        this.addSubType(v.getField().getType().getMinorType());
        return newVector;
    }

    @Override
    public Accessor getAccessor() {
        return this.accessor;
    }

    @Override
    public Mutator getMutator() {
        return this.mutator;
    }

    @Override
    public FieldReader getReader() {
        if (this.reader == null) {
            this.reader = new UnionReader(this);
        }
        return this.reader;
    }

    public FieldWriter getWriter() {
        if (this.mutator.writer == null) {
            this.mutator.writer = new UnionWriter(this);
        }
        return this.mutator.writer;
    }

    @Override
    public UserBitShared.SerializedField getMetadata() {
        UserBitShared.SerializedField.Builder b = this.getField().getAsBuilder().setBufferLength(this.getBufferSize()).setValueCount(this.valueCount);
        b.addChild(this.internalMap.getMetadata());
        return b.build();
    }

    @Override
    public int getBufferSize() {
        return this.internalMap.getBufferSize();
    }

    @Override
    public int getBufferSizeFor(int valueCount) {
        if (valueCount == 0) {
            return 0;
        }
        long bufferSize = 0L;
        for (ValueVector v : this) {
            bufferSize += (long)v.getBufferSizeFor(valueCount);
        }
        return (int)bufferSize;
    }

    @Override
    public DrillBuf[] getBuffers(boolean clear) {
        return this.internalMap.getBuffers(clear);
    }

    @Override
    public void load(UserBitShared.SerializedField metadata, DrillBuf buffer) {
        this.valueCount = metadata.getValueCount();
        this.internalMap.load(metadata.getChild(0), buffer);
    }

    @Override
    public Iterator<ValueVector> iterator() {
        ArrayList<ValueVector> vectors = Lists.newArrayList(this.internalMap.iterator());
        vectors.add(this.typeVector);
        return vectors.iterator();
    }

    public TypedFieldId getFieldIdIfMatches(TypedFieldId.Builder builder, boolean addToBreadCrumb, PathSegment seg) {
        if (seg.isNamed()) {
            MapVector v = this.getMap();
            if (v != null) {
                return ((AbstractContainerVector)v).getFieldIdIfMatches(builder, addToBreadCrumb, seg);
            }
            return null;
        }
        if (seg.isArray()) {
            ListVector v = this.getList();
            if (v != null) {
                return v.getFieldIdIfMatches(builder, addToBreadCrumb, seg);
            }
            return null;
        }
        return null;
    }

    public class Mutator
    extends BaseValueVector.BaseMutator {
        UnionWriter writer;

        @Override
        public void setValueCount(int valueCount) {
            UnionVector.this.valueCount = valueCount;
            UnionVector.this.internalMap.getMutator().setValueCount(valueCount);
        }

        public void setSafe(int index, UnionHolder holder) {
            FieldReader reader = holder.reader;
            if (this.writer == null) {
                this.writer = new UnionWriter(UnionVector.this);
            }
            this.writer.setPosition(index);
            TypeProtos.MinorType type = reader.getType().getMinorType();
            switch (type) {
                case TINYINT: {
                    NullableTinyIntHolder tinyIntHolder = new NullableTinyIntHolder();
                    reader.read(tinyIntHolder);
                    this.setSafe(index, tinyIntHolder);
                    break;
                }
                case UINT1: {
                    NullableUInt1Holder uInt1Holder = new NullableUInt1Holder();
                    reader.read(uInt1Holder);
                    this.setSafe(index, uInt1Holder);
                    break;
                }
                case UINT2: {
                    NullableUInt2Holder uInt2Holder = new NullableUInt2Holder();
                    reader.read(uInt2Holder);
                    this.setSafe(index, uInt2Holder);
                    break;
                }
                case SMALLINT: {
                    NullableSmallIntHolder smallIntHolder = new NullableSmallIntHolder();
                    reader.read(smallIntHolder);
                    this.setSafe(index, smallIntHolder);
                    break;
                }
                case INT: {
                    NullableIntHolder intHolder = new NullableIntHolder();
                    reader.read(intHolder);
                    this.setSafe(index, intHolder);
                    break;
                }
                case UINT4: {
                    NullableUInt4Holder uInt4Holder = new NullableUInt4Holder();
                    reader.read(uInt4Holder);
                    this.setSafe(index, uInt4Holder);
                    break;
                }
                case FLOAT4: {
                    NullableFloat4Holder float4Holder = new NullableFloat4Holder();
                    reader.read(float4Holder);
                    this.setSafe(index, float4Holder);
                    break;
                }
                case TIME: {
                    NullableTimeHolder timeHolder = new NullableTimeHolder();
                    reader.read(timeHolder);
                    this.setSafe(index, timeHolder);
                    break;
                }
                case INTERVALYEAR: {
                    NullableIntervalYearHolder intervalYearHolder = new NullableIntervalYearHolder();
                    reader.read(intervalYearHolder);
                    this.setSafe(index, intervalYearHolder);
                    break;
                }
                case BIGINT: {
                    NullableBigIntHolder bigIntHolder = new NullableBigIntHolder();
                    reader.read(bigIntHolder);
                    this.setSafe(index, bigIntHolder);
                    break;
                }
                case UINT8: {
                    NullableUInt8Holder uInt8Holder = new NullableUInt8Holder();
                    reader.read(uInt8Holder);
                    this.setSafe(index, uInt8Holder);
                    break;
                }
                case FLOAT8: {
                    NullableFloat8Holder float8Holder = new NullableFloat8Holder();
                    reader.read(float8Holder);
                    this.setSafe(index, float8Holder);
                    break;
                }
                case DATE: {
                    NullableDateHolder dateHolder = new NullableDateHolder();
                    reader.read(dateHolder);
                    this.setSafe(index, dateHolder);
                    break;
                }
                case TIMESTAMP: {
                    NullableTimeStampHolder timeStampHolder = new NullableTimeStampHolder();
                    reader.read(timeStampHolder);
                    this.setSafe(index, timeStampHolder);
                    break;
                }
                case INTERVALDAY: {
                    NullableIntervalDayHolder intervalDayHolder = new NullableIntervalDayHolder();
                    reader.read(intervalDayHolder);
                    this.setSafe(index, intervalDayHolder);
                    break;
                }
                case INTERVAL: {
                    NullableIntervalHolder intervalHolder = new NullableIntervalHolder();
                    reader.read(intervalHolder);
                    this.setSafe(index, intervalHolder);
                    break;
                }
                case VARBINARY: {
                    NullableVarBinaryHolder varBinaryHolder = new NullableVarBinaryHolder();
                    reader.read(varBinaryHolder);
                    this.setSafe(index, varBinaryHolder);
                    break;
                }
                case VARCHAR: {
                    NullableVarCharHolder varCharHolder = new NullableVarCharHolder();
                    reader.read(varCharHolder);
                    this.setSafe(index, varCharHolder);
                    break;
                }
                case VAR16CHAR: {
                    NullableVar16CharHolder var16CharHolder = new NullableVar16CharHolder();
                    reader.read(var16CharHolder);
                    this.setSafe(index, var16CharHolder);
                    break;
                }
                case BIT: {
                    NullableBitHolder bitHolder = new NullableBitHolder();
                    reader.read(bitHolder);
                    this.setSafe(index, bitHolder);
                    break;
                }
                case MAP: {
                    ComplexCopier.copy(reader, this.writer);
                    break;
                }
                case LIST: {
                    ComplexCopier.copy(reader, this.writer);
                    break;
                }
                default: {
                    throw new UnsupportedOperationException();
                }
            }
        }

        public void setSafe(int index, NullableTinyIntHolder holder) {
            this.setType(index, TypeProtos.MinorType.TINYINT);
            UnionVector.this.getTinyIntVector().getMutator().setSafe(index, holder);
        }

        public void setSafe(int index, NullableUInt1Holder holder) {
            this.setType(index, TypeProtos.MinorType.UINT1);
            UnionVector.this.getUInt1Vector().getMutator().setSafe(index, holder);
        }

        public void setSafe(int index, NullableUInt2Holder holder) {
            this.setType(index, TypeProtos.MinorType.UINT2);
            UnionVector.this.getUInt2Vector().getMutator().setSafe(index, holder);
        }

        public void setSafe(int index, NullableSmallIntHolder holder) {
            this.setType(index, TypeProtos.MinorType.SMALLINT);
            UnionVector.this.getSmallIntVector().getMutator().setSafe(index, holder);
        }

        public void setSafe(int index, NullableIntHolder holder) {
            this.setType(index, TypeProtos.MinorType.INT);
            UnionVector.this.getIntVector().getMutator().setSafe(index, holder);
        }

        public void setSafe(int index, NullableUInt4Holder holder) {
            this.setType(index, TypeProtos.MinorType.UINT4);
            UnionVector.this.getUInt4Vector().getMutator().setSafe(index, holder);
        }

        public void setSafe(int index, NullableFloat4Holder holder) {
            this.setType(index, TypeProtos.MinorType.FLOAT4);
            UnionVector.this.getFloat4Vector().getMutator().setSafe(index, holder);
        }

        public void setSafe(int index, NullableTimeHolder holder) {
            this.setType(index, TypeProtos.MinorType.TIME);
            UnionVector.this.getTimeVector().getMutator().setSafe(index, holder);
        }

        public void setSafe(int index, NullableIntervalYearHolder holder) {
            this.setType(index, TypeProtos.MinorType.INTERVALYEAR);
            UnionVector.this.getIntervalYearVector().getMutator().setSafe(index, holder);
        }

        public void setSafe(int index, NullableBigIntHolder holder) {
            this.setType(index, TypeProtos.MinorType.BIGINT);
            UnionVector.this.getBigIntVector().getMutator().setSafe(index, holder);
        }

        public void setSafe(int index, NullableUInt8Holder holder) {
            this.setType(index, TypeProtos.MinorType.UINT8);
            UnionVector.this.getUInt8Vector().getMutator().setSafe(index, holder);
        }

        public void setSafe(int index, NullableFloat8Holder holder) {
            this.setType(index, TypeProtos.MinorType.FLOAT8);
            UnionVector.this.getFloat8Vector().getMutator().setSafe(index, holder);
        }

        public void setSafe(int index, NullableDateHolder holder) {
            this.setType(index, TypeProtos.MinorType.DATE);
            UnionVector.this.getDateVector().getMutator().setSafe(index, holder);
        }

        public void setSafe(int index, NullableTimeStampHolder holder) {
            this.setType(index, TypeProtos.MinorType.TIMESTAMP);
            UnionVector.this.getTimeStampVector().getMutator().setSafe(index, holder);
        }

        public void setSafe(int index, NullableIntervalDayHolder holder) {
            this.setType(index, TypeProtos.MinorType.INTERVALDAY);
            UnionVector.this.getIntervalDayVector().getMutator().setSafe(index, holder);
        }

        public void setSafe(int index, NullableIntervalHolder holder) {
            this.setType(index, TypeProtos.MinorType.INTERVAL);
            UnionVector.this.getIntervalVector().getMutator().setSafe(index, holder);
        }

        public void setSafe(int index, NullableVarBinaryHolder holder) {
            this.setType(index, TypeProtos.MinorType.VARBINARY);
            UnionVector.this.getVarBinaryVector().getMutator().setSafe(index, holder);
        }

        public void setSafe(int index, NullableVarCharHolder holder) {
            this.setType(index, TypeProtos.MinorType.VARCHAR);
            UnionVector.this.getVarCharVector().getMutator().setSafe(index, holder);
        }

        public void setSafe(int index, NullableVar16CharHolder holder) {
            this.setType(index, TypeProtos.MinorType.VAR16CHAR);
            UnionVector.this.getVar16CharVector().getMutator().setSafe(index, holder);
        }

        public void setSafe(int index, NullableBitHolder holder) {
            this.setType(index, TypeProtos.MinorType.BIT);
            UnionVector.this.getBitVector().getMutator().setSafe(index, holder);
        }

        public void setType(int index, TypeProtos.MinorType type) {
            UnionVector.this.typeVector.getMutator().setSafe(index, type.getNumber());
        }

        @Override
        public void reset() {
        }

        @Override
        public void generateTestData(int values) {
        }
    }

    public class Accessor
    extends BaseValueVector.BaseAccessor {
        @Override
        public Object getObject(int index) {
            byte type = UnionVector.this.typeVector.getAccessor().get(index);
            switch (type) {
                case 0: {
                    return null;
                }
                case 3: {
                    return UnionVector.this.getTinyIntVector().getAccessor().getObject(index);
                }
                case 29: {
                    return UnionVector.this.getUInt1Vector().getAccessor().getObject(index);
                }
                case 30: {
                    return UnionVector.this.getUInt2Vector().getAccessor().getObject(index);
                }
                case 4: {
                    return UnionVector.this.getSmallIntVector().getAccessor().getObject(index);
                }
                case 5: {
                    return UnionVector.this.getIntVector().getAccessor().getObject(index);
                }
                case 31: {
                    return UnionVector.this.getUInt4Vector().getAccessor().getObject(index);
                }
                case 18: {
                    return UnionVector.this.getFloat4Vector().getAccessor().getObject(index);
                }
                case 13: {
                    return UnionVector.this.getTimeVector().getAccessor().getObject(index);
                }
                case 38: {
                    return UnionVector.this.getIntervalYearVector().getAccessor().getObject(index);
                }
                case 6: {
                    return UnionVector.this.getBigIntVector().getAccessor().getObject(index);
                }
                case 32: {
                    return UnionVector.this.getUInt8Vector().getAccessor().getObject(index);
                }
                case 19: {
                    return UnionVector.this.getFloat8Vector().getAccessor().getObject(index);
                }
                case 12: {
                    return UnionVector.this.getDateVector().getAccessor().getObject(index);
                }
                case 16: {
                    return UnionVector.this.getTimeStampVector().getAccessor().getObject(index);
                }
                case 39: {
                    return UnionVector.this.getIntervalDayVector().getAccessor().getObject(index);
                }
                case 17: {
                    return UnionVector.this.getIntervalVector().getAccessor().getObject(index);
                }
                case 26: {
                    return UnionVector.this.getVarBinaryVector().getAccessor().getObject(index);
                }
                case 24: {
                    return UnionVector.this.getVarCharVector().getAccessor().getObject(index);
                }
                case 25: {
                    return UnionVector.this.getVar16CharVector().getAccessor().getObject(index);
                }
                case 20: {
                    return UnionVector.this.getBitVector().getAccessor().getObject(index);
                }
                case 1: {
                    return UnionVector.this.getMap().getAccessor().getObject(index);
                }
                case 40: {
                    return UnionVector.this.getList().getAccessor().getObject(index);
                }
            }
            throw new UnsupportedOperationException("Cannot support type: " + TypeProtos.MinorType.valueOf(type));
        }

        public byte[] get(int index) {
            return null;
        }

        public void get(int index, ComplexHolder holder) {
        }

        public void get(int index, UnionHolder holder) {
            UnionReader reader = new UnionReader(UnionVector.this);
            reader.setPosition(index);
            holder.reader = reader;
        }

        @Override
        public int getValueCount() {
            return UnionVector.this.valueCount;
        }

        @Override
        public boolean isNull(int index) {
            return UnionVector.this.typeVector.getAccessor().get(index) == 0;
        }

        public int isSet(int index) {
            return this.isNull(index) ? 0 : 1;
        }
    }

    private class TransferImpl
    implements TransferPair {
        UnionVector to;

        public TransferImpl(MaterializedField field, BufferAllocator allocator) {
            this.to = new UnionVector(field, allocator, null);
        }

        public TransferImpl(UnionVector to) {
            this.to = to;
        }

        @Override
        public void transfer() {
            UnionVector.this.transferTo(this.to);
        }

        @Override
        public void splitAndTransfer(int startIndex, int length) {
        }

        @Override
        public ValueVector getTo() {
            return this.to;
        }

        @Override
        public void copyValueSafe(int from, int to) {
            this.to.copyFrom(from, to, UnionVector.this);
        }
    }
}

