/*
 * Decompiled with CFR 0.152.
 */
package oadd.org.apache.drill.exec.vector.accessor;

import java.sql.Date;
import oadd.org.apache.drill.common.types.TypeProtos;
import oadd.org.apache.drill.common.types.Types;
import oadd.org.apache.drill.exec.vector.DateVector;
import oadd.org.apache.drill.exec.vector.accessor.AbstractSqlAccessor;
import oadd.org.joda.time.DateTime;
import oadd.org.joda.time.DateTimeZone;

public class DateAccessor
extends AbstractSqlAccessor {
    private static final TypeProtos.MajorType TYPE = Types.required(TypeProtos.MinorType.DATE);
    private final DateVector.Accessor ac;

    public DateAccessor(DateVector vector) {
        this.ac = vector.getAccessor();
    }

    @Override
    public TypeProtos.MajorType getType() {
        return TYPE;
    }

    @Override
    public boolean isNull(int index) {
        return false;
    }

    @Override
    public Class<?> getObjectClass() {
        return Date.class;
    }

    @Override
    public Object getObject(int index) {
        return this.getDate(index);
    }

    @Override
    public Date getDate(int index) {
        DateTime date = new DateTime(this.ac.get(index), DateTimeZone.UTC);
        date = date.withZoneRetainFields(DateTimeZone.getDefault());
        return new Date(date.getMillis());
    }
}

