/*
 * Decompiled with CFR 0.152.
 */
package oadd.org.apache.drill.exec.vector;

import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import oadd.com.google.common.base.Charsets;
import oadd.com.google.common.collect.ObjectArrays;
import oadd.io.netty.buffer.DrillBuf;
import oadd.org.apache.drill.common.exceptions.DrillRuntimeException;
import oadd.org.apache.drill.common.expression.FieldReference;
import oadd.org.apache.drill.common.types.TypeProtos;
import oadd.org.apache.drill.common.types.Types;
import oadd.org.apache.drill.exec.exception.OutOfMemoryException;
import oadd.org.apache.drill.exec.exception.OversizedAllocationException;
import oadd.org.apache.drill.exec.expr.holders.NullableVarCharHolder;
import oadd.org.apache.drill.exec.expr.holders.VarCharHolder;
import oadd.org.apache.drill.exec.memory.BufferAllocator;
import oadd.org.apache.drill.exec.proto.UserBitShared;
import oadd.org.apache.drill.exec.record.MaterializedField;
import oadd.org.apache.drill.exec.record.TransferPair;
import oadd.org.apache.drill.exec.util.Text;
import oadd.org.apache.drill.exec.vector.BaseDataValueVector;
import oadd.org.apache.drill.exec.vector.BaseValueVector;
import oadd.org.apache.drill.exec.vector.UInt4Vector;
import oadd.org.apache.drill.exec.vector.ValueVector;
import oadd.org.apache.drill.exec.vector.VariableWidthVector;
import oadd.org.apache.drill.exec.vector.VectorTrimmer;
import oadd.org.apache.drill.exec.vector.complex.impl.VarCharReaderImpl;
import oadd.org.apache.drill.exec.vector.complex.reader.FieldReader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class VarCharVector
extends BaseDataValueVector
implements VariableWidthVector {
    private static final Logger logger = LoggerFactory.getLogger(VarCharVector.class);
    private static final int DEFAULT_RECORD_BYTE_COUNT = 8;
    private static final int INITIAL_BYTE_COUNT = 32768;
    private static final int MIN_BYTE_COUNT = 4096;
    public static final String OFFSETS_VECTOR_NAME = "$offsets$";
    private final MaterializedField offsetsField = MaterializedField.create("$offsets$", Types.required(TypeProtos.MinorType.UINT4));
    private final UInt4Vector offsetVector = new UInt4Vector(this.offsetsField, this.allocator);
    private final FieldReader reader = new VarCharReaderImpl(this);
    private final Accessor accessor;
    private final Mutator mutator;
    private final UInt4Vector.Accessor oAccessor = this.offsetVector.getAccessor();
    private int allocationSizeInBytes = 32768;
    private int allocationMonitor = 0;

    public VarCharVector(MaterializedField field, BufferAllocator allocator) {
        super(field, allocator);
        this.accessor = new Accessor();
        this.mutator = new Mutator();
    }

    @Override
    public FieldReader getReader() {
        return this.reader;
    }

    @Override
    public int getBufferSize() {
        if (this.getAccessor().getValueCount() == 0) {
            return 0;
        }
        return this.offsetVector.getBufferSize() + this.data.writerIndex();
    }

    @Override
    public int getBufferSizeFor(int valueCount) {
        if (valueCount == 0) {
            return 0;
        }
        int idx = this.offsetVector.getAccessor().get(valueCount);
        return this.offsetVector.getBufferSizeFor(valueCount + 1) + idx;
    }

    @Override
    public int getValueCapacity() {
        return Math.max(this.offsetVector.getValueCapacity() - 1, 0);
    }

    @Override
    public int getByteCapacity() {
        return this.data.capacity();
    }

    @Override
    public int getCurrentSizeInBytes() {
        return this.offsetVector.getAccessor().get(this.getAccessor().getValueCount());
    }

    public int getVarByteLength() {
        int valueCount = this.getAccessor().getValueCount();
        if (valueCount == 0) {
            return 0;
        }
        return this.offsetVector.getAccessor().get(valueCount);
    }

    @Override
    public UserBitShared.SerializedField getMetadata() {
        return this.getMetadataBuilder().addChild(this.offsetVector.getMetadata()).setValueCount(this.getAccessor().getValueCount()).setBufferLength(this.getBufferSize()).build();
    }

    @Override
    public void load(UserBitShared.SerializedField metadata, DrillBuf buffer) {
        UserBitShared.SerializedField offsetField = metadata.getChild(0);
        this.offsetVector.load(offsetField, buffer);
        int capacity = buffer.capacity();
        int offsetsLength = offsetField.getBufferLength();
        this.data = buffer.slice(offsetsLength, capacity - offsetsLength);
        this.data.retain();
    }

    @Override
    public void clear() {
        super.clear();
        this.offsetVector.clear();
    }

    @Override
    public DrillBuf[] getBuffers(boolean clear) {
        DrillBuf[] buffers = ObjectArrays.concat(this.offsetVector.getBuffers(false), super.getBuffers(false), DrillBuf.class);
        if (clear) {
            for (DrillBuf buffer : buffers) {
                buffer.retain(1);
            }
            this.clear();
        }
        return buffers;
    }

    public long getOffsetAddr() {
        return this.offsetVector.getBuffer().memoryAddress();
    }

    public UInt4Vector getOffsetVector() {
        return this.offsetVector;
    }

    @Override
    public TransferPair getTransferPair(BufferAllocator allocator) {
        return new TransferImpl(this.getField(), allocator);
    }

    @Override
    public TransferPair getTransferPair(FieldReference ref, BufferAllocator allocator) {
        return new TransferImpl(this.getField().withPath(ref), allocator);
    }

    @Override
    public TransferPair makeTransferPair(ValueVector to) {
        return new TransferImpl((VarCharVector)to);
    }

    public void transferTo(VarCharVector target) {
        target.clear();
        this.offsetVector.transferTo(target.offsetVector);
        target.data = this.data.transferOwnership((BufferAllocator)target.allocator).buffer;
        target.data.writerIndex(this.data.writerIndex());
        this.clear();
    }

    public void splitAndTransferTo(int startIndex, int length, VarCharVector target) {
        UInt4Vector.Accessor offsetVectorAccessor = this.offsetVector.getAccessor();
        int startPoint = offsetVectorAccessor.get(startIndex);
        int sliceLength = offsetVectorAccessor.get(startIndex + length) - startPoint;
        target.clear();
        target.offsetVector.allocateNew(length + 1);
        offsetVectorAccessor = this.offsetVector.getAccessor();
        UInt4Vector.Mutator targetOffsetVectorMutator = target.offsetVector.getMutator();
        for (int i = 0; i < length + 1; ++i) {
            targetOffsetVectorMutator.set(i, offsetVectorAccessor.get(startIndex + i) - startPoint);
        }
        target.data = this.data.slice((int)startPoint, (int)sliceLength).transferOwnership((BufferAllocator)target.allocator).buffer;
        target.getMutator().setValueCount(length);
    }

    protected void copyFrom(int fromIndex, int thisIndex, VarCharVector from) {
        UInt4Vector.Accessor fromOffsetVectorAccessor = from.offsetVector.getAccessor();
        int start = fromOffsetVectorAccessor.get(fromIndex);
        int end = fromOffsetVectorAccessor.get(fromIndex + 1);
        int len = end - start;
        int outputStart = this.offsetVector.data.getInt(thisIndex * 4);
        from.data.getBytes(start, this.data, outputStart, len);
        this.offsetVector.data.setInt((thisIndex + 1) * 4, outputStart + len);
    }

    public boolean copyFromSafe(int fromIndex, int thisIndex, VarCharVector from) {
        UInt4Vector.Accessor fromOffsetVectorAccessor = from.offsetVector.getAccessor();
        int start = fromOffsetVectorAccessor.get(fromIndex);
        int end = fromOffsetVectorAccessor.get(fromIndex + 1);
        int len = end - start;
        int outputStart = this.offsetVector.data.getInt(thisIndex * 4);
        while (this.data.capacity() < outputStart + len) {
            this.reAlloc();
        }
        this.offsetVector.getMutator().setSafe(thisIndex + 1, outputStart + len);
        from.data.getBytes(start, this.data, outputStart, len);
        return true;
    }

    @Override
    public void setInitialCapacity(int valueCount) {
        long size = 1L * (long)valueCount * 4L;
        if (size > Integer.MAX_VALUE) {
            throw new OversizedAllocationException("Requested amount of memory is more than max allowed allocation size");
        }
        this.allocationSizeInBytes = (int)size;
        this.offsetVector.setInitialCapacity(valueCount + 1);
    }

    @Override
    public void allocateNew() {
        if (!this.allocateNewSafe()) {
            throw new OutOfMemoryException("Failure while allocating buffer.");
        }
    }

    @Override
    public boolean allocateNewSafe() {
        long curAllocationSize = this.allocationSizeInBytes;
        if (this.allocationMonitor > 10) {
            curAllocationSize = Math.max(4096L, curAllocationSize / 2L);
            this.allocationMonitor = 0;
        } else if (this.allocationMonitor < -2) {
            curAllocationSize *= 2L;
            this.allocationMonitor = 0;
        }
        if (curAllocationSize > Integer.MAX_VALUE) {
            return false;
        }
        this.clear();
        try {
            int requestedSize = (int)curAllocationSize;
            this.data = this.allocator.buffer(requestedSize);
            this.allocationSizeInBytes = requestedSize;
            this.offsetVector.allocateNew();
        }
        catch (OutOfMemoryException e) {
            this.clear();
            return false;
        }
        this.data.readerIndex(0);
        this.offsetVector.zeroVector();
        return true;
    }

    @Override
    public void allocateNew(int totalBytes, int valueCount) {
        this.clear();
        assert (totalBytes >= 0);
        try {
            this.data = this.allocator.buffer(totalBytes);
            this.offsetVector.allocateNew(valueCount + 1);
        }
        catch (DrillRuntimeException e) {
            this.clear();
            throw e;
        }
        this.data.readerIndex(0);
        this.allocationSizeInBytes = totalBytes;
        this.offsetVector.zeroVector();
    }

    @Override
    public void reset() {
        this.allocationSizeInBytes = 32768;
        this.allocationMonitor = 0;
        this.data.readerIndex(0);
        this.offsetVector.zeroVector();
        super.reset();
    }

    public void reAlloc() {
        long newAllocationSize = (long)this.allocationSizeInBytes * 2L;
        if (newAllocationSize > Integer.MAX_VALUE) {
            throw new OversizedAllocationException("Unable to expand the buffer. Max allowed buffer size is reached.");
        }
        DrillBuf newBuf = this.allocator.buffer((int)newAllocationSize);
        newBuf.setBytes(0, this.data, 0, this.data.capacity());
        this.data.release();
        this.data = newBuf;
        this.allocationSizeInBytes = (int)newAllocationSize;
    }

    public void decrementAllocationMonitor() {
        if (this.allocationMonitor > 0) {
            this.allocationMonitor = 0;
        }
        --this.allocationMonitor;
    }

    private void incrementAllocationMonitor() {
        ++this.allocationMonitor;
    }

    @Override
    public Accessor getAccessor() {
        return this.accessor;
    }

    @Override
    public Mutator getMutator() {
        return this.mutator;
    }

    public final class Mutator
    extends BaseValueVector.BaseMutator
    implements VariableWidthVector.VariableWidthMutator {
        protected void set(int index, byte[] bytes) {
            assert (index >= 0);
            int currentOffset = VarCharVector.this.offsetVector.getAccessor().get(index);
            VarCharVector.this.offsetVector.getMutator().set(index + 1, currentOffset + bytes.length);
            VarCharVector.this.data.setBytes(currentOffset, bytes, 0, bytes.length);
        }

        public void setSafe(int index, byte[] bytes) {
            assert (index >= 0);
            int currentOffset = VarCharVector.this.offsetVector.getAccessor().get(index);
            while (VarCharVector.this.data.capacity() < currentOffset + bytes.length) {
                VarCharVector.this.reAlloc();
            }
            VarCharVector.this.offsetVector.getMutator().setSafe(index + 1, currentOffset + bytes.length);
            VarCharVector.this.data.setBytes(currentOffset, bytes, 0, bytes.length);
        }

        protected void set(int index, byte[] bytes, int start, int length) {
            assert (index >= 0);
            int currentOffset = VarCharVector.this.offsetVector.getAccessor().get(index);
            VarCharVector.this.offsetVector.getMutator().set(index + 1, currentOffset + length);
            VarCharVector.this.data.setBytes(currentOffset, bytes, start, length);
        }

        public void setSafe(int index, ByteBuffer bytes, int start, int length) {
            assert (index >= 0);
            int currentOffset = VarCharVector.this.offsetVector.getAccessor().get(index);
            while (VarCharVector.this.data.capacity() < currentOffset + length) {
                VarCharVector.this.reAlloc();
            }
            VarCharVector.this.offsetVector.getMutator().setSafe(index + 1, currentOffset + length);
            VarCharVector.this.data.setBytes(currentOffset, bytes, start, length);
        }

        public void setSafe(int index, byte[] bytes, int start, int length) {
            assert (index >= 0);
            int currentOffset = VarCharVector.this.offsetVector.getAccessor().get(index);
            while (VarCharVector.this.data.capacity() < currentOffset + length) {
                VarCharVector.this.reAlloc();
            }
            VarCharVector.this.offsetVector.getMutator().setSafe(index + 1, currentOffset + length);
            VarCharVector.this.data.setBytes(currentOffset, bytes, start, length);
        }

        @Override
        public void setValueLengthSafe(int index, int length) {
            int offset = VarCharVector.this.offsetVector.getAccessor().get(index);
            while (VarCharVector.this.data.capacity() < offset + length) {
                VarCharVector.this.reAlloc();
            }
            VarCharVector.this.offsetVector.getMutator().setSafe(index + 1, VarCharVector.this.offsetVector.getAccessor().get(index) + length);
        }

        public void setSafe(int index, int start, int end, DrillBuf buffer) {
            int len = end - start;
            int outputStart = ((VarCharVector)VarCharVector.this).offsetVector.data.getInt(index * 4);
            while (VarCharVector.this.data.capacity() < outputStart + len) {
                VarCharVector.this.reAlloc();
            }
            VarCharVector.this.offsetVector.getMutator().setSafe(index + 1, outputStart + len);
            buffer.getBytes(start, VarCharVector.this.data, outputStart, len);
        }

        public void setSafe(int index, NullableVarCharHolder holder) {
            assert (holder.isSet == 1);
            int start = holder.start;
            int end = holder.end;
            int len = end - start;
            int outputStart = ((VarCharVector)VarCharVector.this).offsetVector.data.getInt(index * 4);
            while (VarCharVector.this.data.capacity() < outputStart + len) {
                VarCharVector.this.reAlloc();
            }
            holder.buffer.getBytes(start, VarCharVector.this.data, outputStart, len);
            VarCharVector.this.offsetVector.getMutator().setSafe(index + 1, outputStart + len);
        }

        public void setSafe(int index, VarCharHolder holder) {
            int start = holder.start;
            int end = holder.end;
            int len = end - start;
            int outputStart = ((VarCharVector)VarCharVector.this).offsetVector.data.getInt(index * 4);
            while (VarCharVector.this.data.capacity() < outputStart + len) {
                VarCharVector.this.reAlloc();
            }
            holder.buffer.getBytes(start, VarCharVector.this.data, outputStart, len);
            VarCharVector.this.offsetVector.getMutator().setSafe(index + 1, outputStart + len);
        }

        protected void set(int index, int start, int length, DrillBuf buffer) {
            assert (index >= 0);
            int currentOffset = VarCharVector.this.offsetVector.getAccessor().get(index);
            VarCharVector.this.offsetVector.getMutator().set(index + 1, currentOffset + length);
            DrillBuf bb = buffer.slice(start, length);
            VarCharVector.this.data.setBytes(currentOffset, bb);
        }

        protected void set(int index, NullableVarCharHolder holder) {
            int length = holder.end - holder.start;
            int currentOffset = VarCharVector.this.offsetVector.getAccessor().get(index);
            VarCharVector.this.offsetVector.getMutator().set(index + 1, currentOffset + length);
            VarCharVector.this.data.setBytes(currentOffset, holder.buffer, holder.start, length);
        }

        protected void set(int index, VarCharHolder holder) {
            int length = holder.end - holder.start;
            int currentOffset = VarCharVector.this.offsetVector.getAccessor().get(index);
            VarCharVector.this.offsetVector.getMutator().set(index + 1, currentOffset + length);
            VarCharVector.this.data.setBytes(currentOffset, holder.buffer, holder.start, length);
        }

        @Override
        public void setValueCount(int valueCount) {
            int currentByteCapacity = VarCharVector.this.getByteCapacity();
            int idx = VarCharVector.this.offsetVector.getAccessor().get(valueCount);
            VarCharVector.this.data.writerIndex(idx);
            if (valueCount > 0 && currentByteCapacity > idx * 2) {
                VarCharVector.this.incrementAllocationMonitor();
            } else if (VarCharVector.this.allocationMonitor > 0) {
                VarCharVector.this.allocationMonitor = 0;
            }
            VectorTrimmer.trim(VarCharVector.this.data, idx);
            VarCharVector.this.offsetVector.getMutator().setValueCount(valueCount == 0 ? 0 : valueCount + 1);
        }

        @Override
        public void generateTestData(int size) {
            boolean even = true;
            Charset charset = Charsets.UTF_8;
            byte[] evenValue = new String("aaaaa").getBytes(charset);
            byte[] oddValue = new String("bbbbbbbbbb").getBytes(charset);
            for (int i = 0; i < size; ++i) {
                this.set(i, even ? evenValue : oddValue);
                even = !even;
            }
            this.setValueCount(size);
        }
    }

    public final class Accessor
    extends BaseValueVector.BaseAccessor
    implements VariableWidthVector.VariableWidthAccessor {
        final UInt4Vector.Accessor oAccessor;

        public Accessor() {
            this.oAccessor = VarCharVector.this.offsetVector.getAccessor();
        }

        public long getStartEnd(int index) {
            return this.oAccessor.getTwoAsLong(index);
        }

        public byte[] get(int index) {
            assert (index >= 0);
            int startIdx = this.oAccessor.get(index);
            int length = this.oAccessor.get(index + 1) - startIdx;
            assert (length >= 0);
            byte[] dst = new byte[length];
            VarCharVector.this.data.getBytes(startIdx, dst, 0, length);
            return dst;
        }

        @Override
        public int getValueLength(int index) {
            UInt4Vector.Accessor offsetVectorAccessor = VarCharVector.this.offsetVector.getAccessor();
            return offsetVectorAccessor.get(index + 1) - offsetVectorAccessor.get(index);
        }

        public void get(int index, VarCharHolder holder) {
            holder.start = this.oAccessor.get(index);
            holder.end = this.oAccessor.get(index + 1);
            holder.buffer = VarCharVector.this.data;
        }

        public void get(int index, NullableVarCharHolder holder) {
            holder.isSet = 1;
            holder.start = this.oAccessor.get(index);
            holder.end = this.oAccessor.get(index + 1);
            holder.buffer = VarCharVector.this.data;
        }

        @Override
        public Text getObject(int index) {
            Text text = new Text();
            text.set(this.get(index));
            return text;
        }

        @Override
        public int getValueCount() {
            return Math.max(VarCharVector.this.offsetVector.getAccessor().getValueCount() - 1, 0);
        }

        @Override
        public boolean isNull(int index) {
            return false;
        }

        public UInt4Vector getOffsetVector() {
            return VarCharVector.this.offsetVector;
        }
    }

    private class TransferImpl
    implements TransferPair {
        VarCharVector to;

        public TransferImpl(MaterializedField field, BufferAllocator allocator) {
            this.to = new VarCharVector(field, allocator);
        }

        public TransferImpl(VarCharVector to) {
            this.to = to;
        }

        @Override
        public VarCharVector getTo() {
            return this.to;
        }

        @Override
        public void transfer() {
            VarCharVector.this.transferTo(this.to);
        }

        @Override
        public void splitAndTransfer(int startIndex, int length) {
            VarCharVector.this.splitAndTransferTo(startIndex, length, this.to);
        }

        @Override
        public void copyValueSafe(int fromIndex, int toIndex) {
            this.to.copyFromSafe(fromIndex, toIndex, VarCharVector.this);
        }
    }
}

