/*
 * Decompiled with CFR 0.152.
 */
package oadd.org.apache.drill.exec.vector;

import java.nio.ByteBuffer;
import oadd.com.google.common.collect.ObjectArrays;
import oadd.io.netty.buffer.DrillBuf;
import oadd.org.apache.drill.common.exceptions.DrillRuntimeException;
import oadd.org.apache.drill.common.expression.FieldReference;
import oadd.org.apache.drill.common.types.TypeProtos;
import oadd.org.apache.drill.common.types.Types;
import oadd.org.apache.drill.exec.exception.OutOfMemoryException;
import oadd.org.apache.drill.exec.expr.holders.NullableVar16CharHolder;
import oadd.org.apache.drill.exec.expr.holders.Var16CharHolder;
import oadd.org.apache.drill.exec.memory.BufferAllocator;
import oadd.org.apache.drill.exec.proto.UserBitShared;
import oadd.org.apache.drill.exec.record.MaterializedField;
import oadd.org.apache.drill.exec.record.TransferPair;
import oadd.org.apache.drill.exec.vector.BaseDataValueVector;
import oadd.org.apache.drill.exec.vector.BaseValueVector;
import oadd.org.apache.drill.exec.vector.NullableVector;
import oadd.org.apache.drill.exec.vector.NullableVectorDefinitionSetter;
import oadd.org.apache.drill.exec.vector.UInt1Vector;
import oadd.org.apache.drill.exec.vector.ValueVector;
import oadd.org.apache.drill.exec.vector.Var16CharVector;
import oadd.org.apache.drill.exec.vector.VariableWidthVector;
import oadd.org.apache.drill.exec.vector.complex.impl.NullableVar16CharReaderImpl;
import oadd.org.apache.drill.exec.vector.complex.reader.FieldReader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class NullableVar16CharVector
extends BaseDataValueVector
implements VariableWidthVector,
NullableVector {
    private static final Logger logger = LoggerFactory.getLogger(NullableVar16CharVector.class);
    private final FieldReader reader = new NullableVar16CharReaderImpl(this);
    private final MaterializedField bitsField = MaterializedField.create("$bits$", Types.required(TypeProtos.MinorType.UINT1));
    private final UInt1Vector bits = new UInt1Vector(this.bitsField, this.allocator);
    private final Var16CharVector values = new Var16CharVector(this.field, this.allocator);
    private final Mutator mutator = new Mutator();
    private final Accessor accessor = new Accessor();

    public NullableVar16CharVector(MaterializedField field, BufferAllocator allocator) {
        super(field, allocator);
    }

    @Override
    public FieldReader getReader() {
        return this.reader;
    }

    @Override
    public int getValueCapacity() {
        return Math.min(this.bits.getValueCapacity(), this.values.getValueCapacity());
    }

    @Override
    public DrillBuf[] getBuffers(boolean clear) {
        DrillBuf[] buffers = ObjectArrays.concat(this.bits.getBuffers(false), this.values.getBuffers(false), DrillBuf.class);
        if (clear) {
            for (DrillBuf buffer : buffers) {
                buffer.retain(1);
            }
            this.clear();
        }
        return buffers;
    }

    @Override
    public void close() {
        this.bits.close();
        this.values.close();
        super.close();
    }

    @Override
    public void clear() {
        this.bits.clear();
        this.values.clear();
        super.clear();
    }

    @Override
    public int getBufferSize() {
        return this.values.getBufferSize() + this.bits.getBufferSize();
    }

    @Override
    public int getBufferSizeFor(int valueCount) {
        if (valueCount == 0) {
            return 0;
        }
        return this.values.getBufferSizeFor(valueCount) + this.bits.getBufferSizeFor(valueCount);
    }

    @Override
    public DrillBuf getBuffer() {
        return this.values.getBuffer();
    }

    @Override
    public Var16CharVector getValuesVector() {
        return this.values;
    }

    @Override
    public void setInitialCapacity(int numRecords) {
        this.bits.setInitialCapacity(numRecords);
        this.values.setInitialCapacity(numRecords);
    }

    @Override
    public UserBitShared.SerializedField.Builder getMetadataBuilder() {
        return super.getMetadataBuilder().addChild(this.bits.getMetadata()).addChild(this.values.getMetadata());
    }

    @Override
    public void allocateNew() {
        if (!this.allocateNewSafe()) {
            throw new OutOfMemoryException("Failure while allocating buffer.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean allocateNewSafe() {
        boolean success = false;
        try {
            success = this.values.allocateNewSafe() && this.bits.allocateNewSafe();
        }
        finally {
            if (!success) {
                this.clear();
            }
        }
        this.bits.zeroVector();
        this.mutator.reset();
        this.accessor.reset();
        return success;
    }

    @Override
    public void allocateNew(int totalBytes, int valueCount) {
        try {
            this.values.allocateNew(totalBytes, valueCount);
            this.bits.allocateNew(valueCount);
        }
        catch (DrillRuntimeException e) {
            this.clear();
            throw e;
        }
        this.bits.zeroVector();
        this.mutator.reset();
        this.accessor.reset();
    }

    @Override
    public void reset() {
        this.bits.zeroVector();
        this.mutator.reset();
        this.accessor.reset();
        super.reset();
    }

    @Override
    public int getByteCapacity() {
        return this.values.getByteCapacity();
    }

    @Override
    public int getCurrentSizeInBytes() {
        return this.values.getCurrentSizeInBytes();
    }

    @Override
    public void load(UserBitShared.SerializedField metadata, DrillBuf buffer) {
        this.clear();
        UserBitShared.SerializedField bitsField = metadata.getChild(0);
        this.bits.load(bitsField, buffer);
        int capacity = buffer.capacity();
        int bitsLength = bitsField.getBufferLength();
        UserBitShared.SerializedField valuesField = metadata.getChild(1);
        this.values.load(valuesField, buffer.slice(bitsLength, capacity - bitsLength));
    }

    @Override
    public TransferPair getTransferPair(BufferAllocator allocator) {
        return new TransferImpl(this.getField(), allocator);
    }

    @Override
    public TransferPair getTransferPair(FieldReference ref, BufferAllocator allocator) {
        return new TransferImpl(this.getField().withPath(ref), allocator);
    }

    @Override
    public TransferPair makeTransferPair(ValueVector to) {
        return new TransferImpl((NullableVar16CharVector)to);
    }

    public void transferTo(NullableVar16CharVector target) {
        this.bits.transferTo(target.bits);
        this.values.transferTo(target.values);
        target.mutator.lastSet = this.mutator.lastSet;
        this.clear();
    }

    public void splitAndTransferTo(int startIndex, int length, NullableVar16CharVector target) {
        this.bits.splitAndTransferTo(startIndex, length, target.bits);
        this.values.splitAndTransferTo(startIndex, length, target.values);
        target.mutator.lastSet = length - 1;
    }

    @Override
    public Accessor getAccessor() {
        return this.accessor;
    }

    @Override
    public Mutator getMutator() {
        return this.mutator;
    }

    public Var16CharVector convertToRequiredVector() {
        Var16CharVector v = new Var16CharVector(this.getField().getOtherNullableVersion(), this.allocator);
        if (v.data != null) {
            v.data.release(1);
        }
        v.data = this.values.data;
        v.data.retain(1);
        this.clear();
        return v;
    }

    public void copyFrom(int fromIndex, int thisIndex, NullableVar16CharVector from) {
        Accessor fromAccessor = from.getAccessor();
        if (!fromAccessor.isNull(fromIndex)) {
            this.mutator.set(thisIndex, fromAccessor.get(fromIndex));
        }
    }

    public void copyFromSafe(int fromIndex, int thisIndex, Var16CharVector from) {
        this.mutator.fillEmpties(thisIndex);
        this.values.copyFromSafe(fromIndex, thisIndex, from);
        this.bits.getMutator().setSafe(thisIndex, 1);
    }

    public void copyFromSafe(int fromIndex, int thisIndex, NullableVar16CharVector from) {
        this.mutator.fillEmpties(thisIndex);
        this.bits.copyFromSafe(fromIndex, thisIndex, from.bits);
        this.values.copyFromSafe(fromIndex, thisIndex, from.values);
    }

    public final class Mutator
    extends BaseValueVector.BaseMutator
    implements NullableVectorDefinitionSetter,
    VariableWidthVector.VariableWidthMutator {
        private int setCount;
        private int lastSet = -1;

        private Mutator() {
        }

        public Var16CharVector getVectorWithValues() {
            return NullableVar16CharVector.this.values;
        }

        @Override
        public void setIndexDefined(int index) {
            NullableVar16CharVector.this.bits.getMutator().set(index, 1);
        }

        public void set(int index, byte[] value) {
            ++this.setCount;
            Var16CharVector.Mutator valuesMutator = NullableVar16CharVector.this.values.getMutator();
            UInt1Vector.Mutator bitsMutator = NullableVar16CharVector.this.bits.getMutator();
            for (int i = this.lastSet + 1; i < index; ++i) {
                valuesMutator.set(i, BaseDataValueVector.emptyByteArray);
            }
            bitsMutator.set(index, 1);
            valuesMutator.set(index, value);
            this.lastSet = index;
        }

        private void fillEmpties(int index) {
            Var16CharVector.Mutator valuesMutator = NullableVar16CharVector.this.values.getMutator();
            for (int i = this.lastSet; i < index; ++i) {
                valuesMutator.setSafe(i + 1, BaseDataValueVector.emptyByteArray);
            }
            while (index > NullableVar16CharVector.this.bits.getValueCapacity()) {
                NullableVar16CharVector.this.bits.reAlloc();
            }
            this.lastSet = index;
        }

        @Override
        public void setValueLengthSafe(int index, int length) {
            NullableVar16CharVector.this.values.getMutator().setValueLengthSafe(index, length);
            this.lastSet = index;
        }

        public void setSafe(int index, byte[] value, int start, int length) {
            this.fillEmpties(index);
            NullableVar16CharVector.this.bits.getMutator().setSafe(index, 1);
            NullableVar16CharVector.this.values.getMutator().setSafe(index, value, start, length);
            ++this.setCount;
            this.lastSet = index;
        }

        public void setSafe(int index, ByteBuffer value, int start, int length) {
            this.fillEmpties(index);
            NullableVar16CharVector.this.bits.getMutator().setSafe(index, 1);
            NullableVar16CharVector.this.values.getMutator().setSafe(index, value, start, length);
            ++this.setCount;
            this.lastSet = index;
        }

        public void setNull(int index) {
            NullableVar16CharVector.this.bits.getMutator().setSafe(index, 0);
        }

        public void setSkipNull(int index, Var16CharHolder holder) {
            NullableVar16CharVector.this.values.getMutator().set(index, holder);
        }

        public void setSkipNull(int index, NullableVar16CharHolder holder) {
            NullableVar16CharVector.this.values.getMutator().set(index, holder);
        }

        public void set(int index, NullableVar16CharHolder holder) {
            Var16CharVector.Mutator valuesMutator = NullableVar16CharVector.this.values.getMutator();
            for (int i = this.lastSet + 1; i < index; ++i) {
                valuesMutator.set(i, BaseDataValueVector.emptyByteArray);
            }
            NullableVar16CharVector.this.bits.getMutator().set(index, holder.isSet);
            valuesMutator.set(index, holder);
            this.lastSet = index;
        }

        public void set(int index, Var16CharHolder holder) {
            Var16CharVector.Mutator valuesMutator = NullableVar16CharVector.this.values.getMutator();
            for (int i = this.lastSet + 1; i < index; ++i) {
                valuesMutator.set(i, BaseDataValueVector.emptyByteArray);
            }
            NullableVar16CharVector.this.bits.getMutator().set(index, 1);
            valuesMutator.set(index, holder);
            this.lastSet = index;
        }

        public boolean isSafe(int outIndex) {
            return outIndex < NullableVar16CharVector.this.getValueCapacity();
        }

        public void set(int index, int isSet, int startField, int endField, DrillBuf bufferField) {
            Var16CharVector.Mutator valuesMutator = NullableVar16CharVector.this.values.getMutator();
            for (int i = this.lastSet + 1; i < index; ++i) {
                valuesMutator.set(i, BaseDataValueVector.emptyByteArray);
            }
            NullableVar16CharVector.this.bits.getMutator().set(index, isSet);
            valuesMutator.set(index, startField, endField, bufferField);
            this.lastSet = index;
        }

        public void setSafe(int index, int isSet, int startField, int endField, DrillBuf bufferField) {
            this.fillEmpties(index);
            NullableVar16CharVector.this.bits.getMutator().setSafe(index, isSet);
            NullableVar16CharVector.this.values.getMutator().setSafe(index, startField, endField, bufferField);
            ++this.setCount;
            this.lastSet = index;
        }

        public void setSafe(int index, NullableVar16CharHolder value) {
            this.fillEmpties(index);
            NullableVar16CharVector.this.bits.getMutator().setSafe(index, value.isSet);
            NullableVar16CharVector.this.values.getMutator().setSafe(index, value);
            ++this.setCount;
            this.lastSet = index;
        }

        public void setSafe(int index, Var16CharHolder value) {
            this.fillEmpties(index);
            NullableVar16CharVector.this.bits.getMutator().setSafe(index, 1);
            NullableVar16CharVector.this.values.getMutator().setSafe(index, value);
            ++this.setCount;
            this.lastSet = index;
        }

        @Override
        public void setValueCount(int valueCount) {
            assert (valueCount >= 0);
            this.fillEmpties(valueCount);
            NullableVar16CharVector.this.values.getMutator().setValueCount(valueCount);
            NullableVar16CharVector.this.bits.getMutator().setValueCount(valueCount);
        }

        @Override
        public void generateTestData(int valueCount) {
            NullableVar16CharVector.this.bits.getMutator().generateTestDataAlt(valueCount);
            NullableVar16CharVector.this.values.getMutator().generateTestData(valueCount);
            this.lastSet = valueCount;
            this.setValueCount(valueCount);
        }

        @Override
        public void reset() {
            this.setCount = 0;
            this.lastSet = -1;
        }
    }

    public final class Accessor
    extends BaseValueVector.BaseAccessor
    implements VariableWidthVector.VariableWidthAccessor {
        final UInt1Vector.Accessor bAccessor;
        final Var16CharVector.Accessor vAccessor;

        public Accessor() {
            this.bAccessor = NullableVar16CharVector.this.bits.getAccessor();
            this.vAccessor = NullableVar16CharVector.this.values.getAccessor();
        }

        public byte[] get(int index) {
            if (this.isNull(index)) {
                throw new IllegalStateException("Can't get a null value");
            }
            return this.vAccessor.get(index);
        }

        @Override
        public boolean isNull(int index) {
            return this.isSet(index) == 0;
        }

        public int isSet(int index) {
            return this.bAccessor.get(index);
        }

        public long getStartEnd(int index) {
            return this.vAccessor.getStartEnd(index);
        }

        @Override
        public int getValueLength(int index) {
            return NullableVar16CharVector.this.values.getAccessor().getValueLength(index);
        }

        public void get(int index, NullableVar16CharHolder holder) {
            this.vAccessor.get(index, holder);
            holder.isSet = this.bAccessor.get(index);
        }

        @Override
        public String getObject(int index) {
            if (this.isNull(index)) {
                return null;
            }
            return this.vAccessor.getObject(index);
        }

        @Override
        public int getValueCount() {
            return NullableVar16CharVector.this.bits.getAccessor().getValueCount();
        }

        public void reset() {
        }
    }

    private class TransferImpl
    implements TransferPair {
        NullableVar16CharVector to;

        public TransferImpl(MaterializedField field, BufferAllocator allocator) {
            this.to = new NullableVar16CharVector(field, allocator);
        }

        public TransferImpl(NullableVar16CharVector to) {
            this.to = to;
        }

        @Override
        public NullableVar16CharVector getTo() {
            return this.to;
        }

        @Override
        public void transfer() {
            NullableVar16CharVector.this.transferTo(this.to);
        }

        @Override
        public void splitAndTransfer(int startIndex, int length) {
            NullableVar16CharVector.this.splitAndTransferTo(startIndex, length, this.to);
        }

        @Override
        public void copyValueSafe(int fromIndex, int toIndex) {
            this.to.copyFromSafe(fromIndex, toIndex, NullableVar16CharVector.this);
        }
    }
}

