/*
 * Decompiled with CFR 0.152.
 */
package oadd.org.apache.drill.exec.vector;

import java.math.BigDecimal;
import java.nio.ByteBuffer;
import oadd.com.google.common.collect.ObjectArrays;
import oadd.io.netty.buffer.DrillBuf;
import oadd.org.apache.drill.common.expression.FieldReference;
import oadd.org.apache.drill.common.types.TypeProtos;
import oadd.org.apache.drill.common.types.Types;
import oadd.org.apache.drill.exec.exception.OutOfMemoryException;
import oadd.org.apache.drill.exec.expr.holders.Decimal38SparseHolder;
import oadd.org.apache.drill.exec.expr.holders.NullableDecimal38SparseHolder;
import oadd.org.apache.drill.exec.memory.BufferAllocator;
import oadd.org.apache.drill.exec.proto.UserBitShared;
import oadd.org.apache.drill.exec.record.MaterializedField;
import oadd.org.apache.drill.exec.record.TransferPair;
import oadd.org.apache.drill.exec.vector.BaseDataValueVector;
import oadd.org.apache.drill.exec.vector.BaseValueVector;
import oadd.org.apache.drill.exec.vector.Decimal38SparseVector;
import oadd.org.apache.drill.exec.vector.FixedWidthVector;
import oadd.org.apache.drill.exec.vector.NullableVector;
import oadd.org.apache.drill.exec.vector.NullableVectorDefinitionSetter;
import oadd.org.apache.drill.exec.vector.UInt1Vector;
import oadd.org.apache.drill.exec.vector.ValueVector;
import oadd.org.apache.drill.exec.vector.complex.impl.NullableDecimal38SparseReaderImpl;
import oadd.org.apache.drill.exec.vector.complex.reader.FieldReader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class NullableDecimal38SparseVector
extends BaseDataValueVector
implements FixedWidthVector,
NullableVector {
    private static final Logger logger = LoggerFactory.getLogger(NullableDecimal38SparseVector.class);
    private final FieldReader reader = new NullableDecimal38SparseReaderImpl(this);
    private final MaterializedField bitsField = MaterializedField.create("$bits$", Types.required(TypeProtos.MinorType.UINT1));
    private final UInt1Vector bits = new UInt1Vector(this.bitsField, this.allocator);
    private final Decimal38SparseVector values = new Decimal38SparseVector(this.field, this.allocator);
    private final Mutator mutator = new Mutator();
    private final Accessor accessor = new Accessor();

    public NullableDecimal38SparseVector(MaterializedField field, BufferAllocator allocator) {
        super(field, allocator);
    }

    @Override
    public FieldReader getReader() {
        return this.reader;
    }

    @Override
    public int getValueCapacity() {
        return Math.min(this.bits.getValueCapacity(), this.values.getValueCapacity());
    }

    @Override
    public DrillBuf[] getBuffers(boolean clear) {
        DrillBuf[] buffers = ObjectArrays.concat(this.bits.getBuffers(false), this.values.getBuffers(false), DrillBuf.class);
        if (clear) {
            for (DrillBuf buffer : buffers) {
                buffer.retain(1);
            }
            this.clear();
        }
        return buffers;
    }

    @Override
    public void close() {
        this.bits.close();
        this.values.close();
        super.close();
    }

    @Override
    public void clear() {
        this.bits.clear();
        this.values.clear();
        super.clear();
    }

    @Override
    public int getBufferSize() {
        return this.values.getBufferSize() + this.bits.getBufferSize();
    }

    @Override
    public int getBufferSizeFor(int valueCount) {
        if (valueCount == 0) {
            return 0;
        }
        return this.values.getBufferSizeFor(valueCount) + this.bits.getBufferSizeFor(valueCount);
    }

    @Override
    public DrillBuf getBuffer() {
        return this.values.getBuffer();
    }

    @Override
    public Decimal38SparseVector getValuesVector() {
        return this.values;
    }

    @Override
    public void setInitialCapacity(int numRecords) {
        this.bits.setInitialCapacity(numRecords);
        this.values.setInitialCapacity(numRecords);
    }

    @Override
    public UserBitShared.SerializedField.Builder getMetadataBuilder() {
        return super.getMetadataBuilder().addChild(this.bits.getMetadata()).addChild(this.values.getMetadata());
    }

    @Override
    public void allocateNew() {
        if (!this.allocateNewSafe()) {
            throw new OutOfMemoryException("Failure while allocating buffer.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean allocateNewSafe() {
        boolean success = false;
        try {
            success = this.values.allocateNewSafe() && this.bits.allocateNewSafe();
        }
        finally {
            if (!success) {
                this.clear();
            }
        }
        this.bits.zeroVector();
        this.mutator.reset();
        this.accessor.reset();
        return success;
    }

    @Override
    public void allocateNew(int valueCount) {
        try {
            this.values.allocateNew(valueCount);
            this.bits.allocateNew(valueCount + 1);
        }
        catch (OutOfMemoryException e) {
            this.clear();
            throw e;
        }
        this.bits.zeroVector();
        this.mutator.reset();
        this.accessor.reset();
    }

    @Override
    public void reset() {
        this.bits.zeroVector();
        this.mutator.reset();
        this.accessor.reset();
        super.reset();
    }

    @Override
    public void zeroVector() {
        this.bits.zeroVector();
        this.values.zeroVector();
    }

    @Override
    public void load(UserBitShared.SerializedField metadata, DrillBuf buffer) {
        this.clear();
        UserBitShared.SerializedField bitsField = metadata.getChild(0);
        this.bits.load(bitsField, buffer);
        int capacity = buffer.capacity();
        int bitsLength = bitsField.getBufferLength();
        UserBitShared.SerializedField valuesField = metadata.getChild(1);
        this.values.load(valuesField, buffer.slice(bitsLength, capacity - bitsLength));
    }

    @Override
    public TransferPair getTransferPair(BufferAllocator allocator) {
        return new TransferImpl(this.getField(), allocator);
    }

    @Override
    public TransferPair getTransferPair(FieldReference ref, BufferAllocator allocator) {
        return new TransferImpl(this.getField().withPath(ref), allocator);
    }

    @Override
    public TransferPair makeTransferPair(ValueVector to) {
        return new TransferImpl((NullableDecimal38SparseVector)to);
    }

    public void transferTo(NullableDecimal38SparseVector target) {
        this.bits.transferTo(target.bits);
        this.values.transferTo(target.values);
        this.clear();
    }

    public void splitAndTransferTo(int startIndex, int length, NullableDecimal38SparseVector target) {
        this.bits.splitAndTransferTo(startIndex, length, target.bits);
        this.values.splitAndTransferTo(startIndex, length, target.values);
    }

    @Override
    public Accessor getAccessor() {
        return this.accessor;
    }

    @Override
    public Mutator getMutator() {
        return this.mutator;
    }

    public Decimal38SparseVector convertToRequiredVector() {
        Decimal38SparseVector v = new Decimal38SparseVector(this.getField().getOtherNullableVersion(), this.allocator);
        if (v.data != null) {
            v.data.release(1);
        }
        v.data = this.values.data;
        v.data.retain(1);
        this.clear();
        return v;
    }

    public void copyFrom(int fromIndex, int thisIndex, NullableDecimal38SparseVector from) {
        Accessor fromAccessor = from.getAccessor();
        if (!fromAccessor.isNull(fromIndex)) {
            this.mutator.set(thisIndex, fromAccessor.get(fromIndex));
        }
    }

    public void copyFromSafe(int fromIndex, int thisIndex, Decimal38SparseVector from) {
        this.values.copyFromSafe(fromIndex, thisIndex, from);
        this.bits.getMutator().setSafe(thisIndex, 1);
    }

    public void copyFromSafe(int fromIndex, int thisIndex, NullableDecimal38SparseVector from) {
        this.bits.copyFromSafe(fromIndex, thisIndex, from.bits);
        this.values.copyFromSafe(fromIndex, thisIndex, from.values);
    }

    public final class Mutator
    extends BaseValueVector.BaseMutator
    implements NullableVectorDefinitionSetter {
        private int setCount;

        private Mutator() {
        }

        public Decimal38SparseVector getVectorWithValues() {
            return NullableDecimal38SparseVector.this.values;
        }

        @Override
        public void setIndexDefined(int index) {
            NullableDecimal38SparseVector.this.bits.getMutator().set(index, 1);
        }

        public void set(int index, DrillBuf value) {
            ++this.setCount;
            Decimal38SparseVector.Mutator valuesMutator = NullableDecimal38SparseVector.this.values.getMutator();
            UInt1Vector.Mutator bitsMutator = NullableDecimal38SparseVector.this.bits.getMutator();
            bitsMutator.set(index, 1);
            valuesMutator.set(index, value);
        }

        public void setSafe(int index, byte[] value, int start, int length) {
            throw new UnsupportedOperationException();
        }

        public void setSafe(int index, ByteBuffer value, int start, int length) {
            throw new UnsupportedOperationException();
        }

        public void setNull(int index) {
            NullableDecimal38SparseVector.this.bits.getMutator().setSafe(index, 0);
        }

        public void setSkipNull(int index, Decimal38SparseHolder holder) {
            NullableDecimal38SparseVector.this.values.getMutator().set(index, holder);
        }

        public void setSkipNull(int index, NullableDecimal38SparseHolder holder) {
            NullableDecimal38SparseVector.this.values.getMutator().set(index, holder);
        }

        public void set(int index, NullableDecimal38SparseHolder holder) {
            Decimal38SparseVector.Mutator valuesMutator = NullableDecimal38SparseVector.this.values.getMutator();
            NullableDecimal38SparseVector.this.bits.getMutator().set(index, holder.isSet);
            valuesMutator.set(index, holder);
        }

        public void set(int index, Decimal38SparseHolder holder) {
            Decimal38SparseVector.Mutator valuesMutator = NullableDecimal38SparseVector.this.values.getMutator();
            NullableDecimal38SparseVector.this.bits.getMutator().set(index, 1);
            valuesMutator.set(index, holder);
        }

        public boolean isSafe(int outIndex) {
            return outIndex < NullableDecimal38SparseVector.this.getValueCapacity();
        }

        public void set(int index, int isSet, int startField, DrillBuf bufferField) {
            Decimal38SparseVector.Mutator valuesMutator = NullableDecimal38SparseVector.this.values.getMutator();
            NullableDecimal38SparseVector.this.bits.getMutator().set(index, isSet);
            valuesMutator.set(index, startField, bufferField);
        }

        public void setSafe(int index, int isSet, int startField, DrillBuf bufferField) {
            NullableDecimal38SparseVector.this.bits.getMutator().setSafe(index, isSet);
            NullableDecimal38SparseVector.this.values.getMutator().setSafe(index, startField, bufferField);
            ++this.setCount;
        }

        public void setSafe(int index, NullableDecimal38SparseHolder value) {
            NullableDecimal38SparseVector.this.bits.getMutator().setSafe(index, value.isSet);
            NullableDecimal38SparseVector.this.values.getMutator().setSafe(index, value);
            ++this.setCount;
        }

        public void setSafe(int index, Decimal38SparseHolder value) {
            NullableDecimal38SparseVector.this.bits.getMutator().setSafe(index, 1);
            NullableDecimal38SparseVector.this.values.getMutator().setSafe(index, value);
            ++this.setCount;
        }

        @Override
        public void setValueCount(int valueCount) {
            assert (valueCount >= 0);
            NullableDecimal38SparseVector.this.values.getMutator().setValueCount(valueCount);
            NullableDecimal38SparseVector.this.bits.getMutator().setValueCount(valueCount);
        }

        @Override
        public void generateTestData(int valueCount) {
            NullableDecimal38SparseVector.this.bits.getMutator().generateTestDataAlt(valueCount);
            NullableDecimal38SparseVector.this.values.getMutator().generateTestData(valueCount);
            this.setValueCount(valueCount);
        }

        @Override
        public void reset() {
            this.setCount = 0;
        }
    }

    public final class Accessor
    extends BaseValueVector.BaseAccessor {
        final UInt1Vector.Accessor bAccessor;
        final Decimal38SparseVector.Accessor vAccessor;

        public Accessor() {
            this.bAccessor = NullableDecimal38SparseVector.this.bits.getAccessor();
            this.vAccessor = NullableDecimal38SparseVector.this.values.getAccessor();
        }

        public DrillBuf get(int index) {
            if (this.isNull(index)) {
                throw new IllegalStateException("Can't get a null value");
            }
            return this.vAccessor.get(index);
        }

        @Override
        public boolean isNull(int index) {
            return this.isSet(index) == 0;
        }

        public int isSet(int index) {
            return this.bAccessor.get(index);
        }

        public void get(int index, NullableDecimal38SparseHolder holder) {
            this.vAccessor.get(index, holder);
            holder.isSet = this.bAccessor.get(index);
            holder.scale = NullableDecimal38SparseVector.this.getField().getScale();
            holder.precision = NullableDecimal38SparseVector.this.getField().getPrecision();
        }

        @Override
        public BigDecimal getObject(int index) {
            if (this.isNull(index)) {
                return null;
            }
            return this.vAccessor.getObject(index);
        }

        @Override
        public int getValueCount() {
            return NullableDecimal38SparseVector.this.bits.getAccessor().getValueCount();
        }

        public void reset() {
        }
    }

    private class TransferImpl
    implements TransferPair {
        NullableDecimal38SparseVector to;

        public TransferImpl(MaterializedField field, BufferAllocator allocator) {
            this.to = new NullableDecimal38SparseVector(field, allocator);
        }

        public TransferImpl(NullableDecimal38SparseVector to) {
            this.to = to;
        }

        @Override
        public NullableDecimal38SparseVector getTo() {
            return this.to;
        }

        @Override
        public void transfer() {
            NullableDecimal38SparseVector.this.transferTo(this.to);
        }

        @Override
        public void splitAndTransfer(int startIndex, int length) {
            NullableDecimal38SparseVector.this.splitAndTransferTo(startIndex, length, this.to);
        }

        @Override
        public void copyValueSafe(int fromIndex, int toIndex) {
            this.to.copyFromSafe(fromIndex, toIndex, NullableDecimal38SparseVector.this);
        }
    }
}

