/*
 * Decompiled with CFR 0.152.
 */
package oadd.org.apache.drill.exec.vector;

import oadd.com.google.common.base.Preconditions;
import oadd.io.netty.buffer.DrillBuf;
import oadd.org.apache.drill.common.exceptions.DrillRuntimeException;
import oadd.org.apache.drill.common.expression.FieldReference;
import oadd.org.apache.drill.exec.exception.OutOfMemoryException;
import oadd.org.apache.drill.exec.exception.OversizedAllocationException;
import oadd.org.apache.drill.exec.expr.holders.IntervalDayHolder;
import oadd.org.apache.drill.exec.expr.holders.NullableIntervalDayHolder;
import oadd.org.apache.drill.exec.memory.BufferAllocator;
import oadd.org.apache.drill.exec.proto.UserBitShared;
import oadd.org.apache.drill.exec.record.MaterializedField;
import oadd.org.apache.drill.exec.record.TransferPair;
import oadd.org.apache.drill.exec.vector.BaseDataValueVector;
import oadd.org.apache.drill.exec.vector.BaseValueVector;
import oadd.org.apache.drill.exec.vector.FixedWidthVector;
import oadd.org.apache.drill.exec.vector.ValueVector;
import oadd.org.apache.drill.exec.vector.VectorTrimmer;
import oadd.org.apache.drill.exec.vector.complex.impl.IntervalDayReaderImpl;
import oadd.org.apache.drill.exec.vector.complex.reader.FieldReader;
import oadd.org.joda.time.Period;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class IntervalDayVector
extends BaseDataValueVector
implements FixedWidthVector {
    private static final Logger logger = LoggerFactory.getLogger(IntervalDayVector.class);
    private final FieldReader reader = new IntervalDayReaderImpl(this);
    private final Accessor accessor = new Accessor();
    private final Mutator mutator = new Mutator();
    private int allocationSizeInBytes = 49152;
    private int allocationMonitor = 0;

    public IntervalDayVector(MaterializedField field, BufferAllocator allocator) {
        super(field, allocator);
    }

    @Override
    public FieldReader getReader() {
        return this.reader;
    }

    @Override
    public int getBufferSizeFor(int valueCount) {
        if (valueCount == 0) {
            return 0;
        }
        return valueCount * 12;
    }

    @Override
    public int getValueCapacity() {
        return (int)((double)this.data.capacity() * 1.0 / 12.0);
    }

    @Override
    public Accessor getAccessor() {
        return this.accessor;
    }

    @Override
    public Mutator getMutator() {
        return this.mutator;
    }

    @Override
    public void setInitialCapacity(int valueCount) {
        long size = 1L * (long)valueCount * 12L;
        if (size > Integer.MAX_VALUE) {
            throw new OversizedAllocationException("Requested amount of memory is more than max allowed allocation size");
        }
        this.allocationSizeInBytes = (int)size;
    }

    @Override
    public void allocateNew() {
        if (!this.allocateNewSafe()) {
            throw new OutOfMemoryException("Failure while allocating buffer.");
        }
    }

    @Override
    public boolean allocateNewSafe() {
        long curAllocationSize = this.allocationSizeInBytes;
        if (this.allocationMonitor > 10) {
            curAllocationSize = Math.max(8L, curAllocationSize / 2L);
            this.allocationMonitor = 0;
        } else if (this.allocationMonitor < -2) {
            curAllocationSize = (long)this.allocationSizeInBytes * 2L;
            this.allocationMonitor = 0;
        }
        try {
            this.allocateBytes(curAllocationSize);
        }
        catch (DrillRuntimeException ex) {
            return false;
        }
        return true;
    }

    @Override
    public void allocateNew(int valueCount) {
        this.allocateBytes(valueCount * 12);
    }

    @Override
    public void reset() {
        this.allocationSizeInBytes = 4096;
        this.allocationMonitor = 0;
        this.zeroVector();
        super.reset();
    }

    private void allocateBytes(long size) {
        if (size > Integer.MAX_VALUE) {
            throw new OversizedAllocationException("Requested amount of memory is more than max allowed allocation size");
        }
        int curSize = (int)size;
        this.clear();
        this.data = this.allocator.buffer(curSize);
        this.data.readerIndex(0);
        this.allocationSizeInBytes = curSize;
    }

    public void reAlloc() {
        long newAllocationSize = (long)this.allocationSizeInBytes * 2L;
        if (newAllocationSize > Integer.MAX_VALUE) {
            throw new OversizedAllocationException("Unable to expand the buffer. Max allowed buffer size is reached.");
        }
        logger.debug("Reallocating vector [{}]. # of bytes: [{}] -> [{}]", this.field, this.allocationSizeInBytes, newAllocationSize);
        DrillBuf newBuf = this.allocator.buffer((int)newAllocationSize);
        newBuf.setBytes(0, this.data, 0, this.data.capacity());
        int halfNewCapacity = newBuf.capacity() / 2;
        newBuf.setZero(halfNewCapacity, halfNewCapacity);
        newBuf.writerIndex(this.data.writerIndex());
        this.data.release(1);
        this.data = newBuf;
        this.allocationSizeInBytes = (int)newAllocationSize;
    }

    @Override
    public void zeroVector() {
        this.data.setZero(0, this.data.capacity());
    }

    @Override
    public void load(UserBitShared.SerializedField metadata, DrillBuf buffer) {
        Preconditions.checkArgument(this.field.matches(metadata), "The field %s doesn't match the provided metadata %s.", this.field, metadata);
        int actualLength = metadata.getBufferLength();
        int valueCount = metadata.getValueCount();
        int expectedLength = valueCount * 12;
        assert (actualLength == expectedLength) : String.format("Expected to load %d bytes but actually loaded %d bytes", expectedLength, actualLength);
        this.clear();
        if (this.data != null) {
            this.data.release(1);
        }
        this.data = buffer.slice(0, actualLength);
        this.data.retain(1);
        this.data.writerIndex(actualLength);
    }

    @Override
    public TransferPair getTransferPair(BufferAllocator allocator) {
        return new TransferImpl(this.getField(), allocator);
    }

    @Override
    public TransferPair getTransferPair(FieldReference ref, BufferAllocator allocator) {
        return new TransferImpl(this.getField().withPath(ref), allocator);
    }

    @Override
    public TransferPair makeTransferPair(ValueVector to) {
        return new TransferImpl((IntervalDayVector)to);
    }

    public void transferTo(IntervalDayVector target) {
        target.clear();
        target.data = this.data.transferOwnership((BufferAllocator)target.allocator).buffer;
        target.data.writerIndex(this.data.writerIndex());
        this.clear();
    }

    public void splitAndTransferTo(int startIndex, int length, IntervalDayVector target) {
        int startPoint = startIndex * 12;
        int sliceLength = length * 12;
        target.clear();
        target.data = this.data.slice((int)startPoint, (int)sliceLength).transferOwnership((BufferAllocator)target.allocator).buffer;
        target.data.writerIndex(sliceLength);
    }

    public void copyFrom(int fromIndex, int thisIndex, IntervalDayVector from) {
        from.data.getBytes(fromIndex * 12, this.data, thisIndex * 12, 12);
    }

    public void copyFromSafe(int fromIndex, int thisIndex, IntervalDayVector from) {
        while (thisIndex >= this.getValueCapacity()) {
            this.reAlloc();
        }
        this.copyFrom(fromIndex, thisIndex, from);
    }

    public void decrementAllocationMonitor() {
        if (this.allocationMonitor > 0) {
            this.allocationMonitor = 0;
        }
        --this.allocationMonitor;
    }

    private void incrementAllocationMonitor() {
        ++this.allocationMonitor;
    }

    public final class Mutator
    extends BaseValueVector.BaseMutator {
        private Mutator() {
        }

        public void set(int index, DrillBuf value) {
            IntervalDayVector.this.data.setBytes(index * 12, value, 0, 12);
        }

        public void setSafe(int index, DrillBuf value) {
            while (index >= IntervalDayVector.this.getValueCapacity()) {
                IntervalDayVector.this.reAlloc();
            }
            IntervalDayVector.this.data.setBytes(index * 12, value, 0, 12);
        }

        public void set(int index, int days, int milliseconds) {
            int offsetIndex = index * 12;
            IntervalDayVector.this.data.setInt(offsetIndex, days);
            IntervalDayVector.this.data.setInt(offsetIndex + 4, milliseconds);
        }

        protected void set(int index, IntervalDayHolder holder) {
            this.set(index, holder.days, holder.milliseconds);
        }

        protected void set(int index, NullableIntervalDayHolder holder) {
            this.set(index, holder.days, holder.milliseconds);
        }

        public void setSafe(int index, int days, int milliseconds) {
            while (index >= IntervalDayVector.this.getValueCapacity()) {
                IntervalDayVector.this.reAlloc();
            }
            this.set(index, days, milliseconds);
        }

        public void setSafe(int index, IntervalDayHolder holder) {
            this.setSafe(index, holder.days, holder.milliseconds);
        }

        public void setSafe(int index, NullableIntervalDayHolder holder) {
            this.setSafe(index, holder.days, holder.milliseconds);
        }

        @Override
        public void generateTestData(int count) {
            this.setValueCount(count);
            boolean even = true;
            int valueCount = IntervalDayVector.this.getAccessor().getValueCount();
            for (int i = 0; i < valueCount; ++i) {
                byte b = even ? (byte)-128 : 127;
                for (int w = 0; w < 12; ++w) {
                    IntervalDayVector.this.data.setByte(i + w, b);
                }
                even = !even;
            }
        }

        @Override
        public void setValueCount(int valueCount) {
            int currentValueCapacity = IntervalDayVector.this.getValueCapacity();
            int idx = 12 * valueCount;
            while (valueCount > IntervalDayVector.this.getValueCapacity()) {
                IntervalDayVector.this.reAlloc();
            }
            if (valueCount > 0 && currentValueCapacity > valueCount * 2) {
                IntervalDayVector.this.incrementAllocationMonitor();
            } else if (IntervalDayVector.this.allocationMonitor > 0) {
                IntervalDayVector.this.allocationMonitor = 0;
            }
            VectorTrimmer.trim(IntervalDayVector.this.data, idx);
            IntervalDayVector.this.data.writerIndex(valueCount * 12);
        }
    }

    public final class Accessor
    extends BaseValueVector.BaseAccessor {
        @Override
        public int getValueCount() {
            return IntervalDayVector.this.data.writerIndex() / 12;
        }

        @Override
        public boolean isNull(int index) {
            return false;
        }

        public DrillBuf get(int index) {
            return IntervalDayVector.this.data.slice(index * 12, 12);
        }

        public void get(int index, IntervalDayHolder holder) {
            int offsetIndex = index * 12;
            holder.days = IntervalDayVector.this.data.getInt(offsetIndex);
            holder.milliseconds = IntervalDayVector.this.data.getInt(offsetIndex + 4);
        }

        public void get(int index, NullableIntervalDayHolder holder) {
            int offsetIndex = index * 12;
            holder.isSet = 1;
            holder.days = IntervalDayVector.this.data.getInt(offsetIndex);
            holder.milliseconds = IntervalDayVector.this.data.getInt(offsetIndex + 4);
        }

        @Override
        public Period getObject(int index) {
            int offsetIndex = index * 12;
            int millis = IntervalDayVector.this.data.getInt(offsetIndex + 4);
            int days = IntervalDayVector.this.data.getInt(offsetIndex);
            Period p = new Period();
            return p.plusDays(days).plusMillis(millis);
        }

        public StringBuilder getAsStringBuilder(int index) {
            int offsetIndex = index * 12;
            int millis = IntervalDayVector.this.data.getInt(offsetIndex + 4);
            int days = IntervalDayVector.this.data.getInt(offsetIndex);
            int hours = millis / 3600000;
            int minutes = (millis %= 3600000) / 60000;
            int seconds = (millis %= 60000) / 1000;
            String dayString = Math.abs(days) == 1 ? " day " : " days ";
            return new StringBuilder().append(days).append(dayString).append(hours).append(":").append(minutes).append(":").append(seconds).append(".").append(millis %= 1000);
        }
    }

    private class TransferImpl
    implements TransferPair {
        private IntervalDayVector to;

        public TransferImpl(MaterializedField field, BufferAllocator allocator) {
            this.to = new IntervalDayVector(field, allocator);
        }

        public TransferImpl(IntervalDayVector to) {
            this.to = to;
        }

        @Override
        public IntervalDayVector getTo() {
            return this.to;
        }

        @Override
        public void transfer() {
            IntervalDayVector.this.transferTo(this.to);
        }

        @Override
        public void splitAndTransfer(int startIndex, int length) {
            IntervalDayVector.this.splitAndTransferTo(startIndex, length, this.to);
        }

        @Override
        public void copyValueSafe(int fromIndex, int toIndex) {
            this.to.copyFromSafe(fromIndex, toIndex, IntervalDayVector.this);
        }
    }
}

