/*
 * Decompiled with CFR 0.152.
 */
package oadd.org.apache.drill.exec.vector;

import java.math.BigDecimal;
import oadd.com.google.common.base.Preconditions;
import oadd.io.netty.buffer.DrillBuf;
import oadd.org.apache.drill.common.exceptions.DrillRuntimeException;
import oadd.org.apache.drill.common.expression.FieldReference;
import oadd.org.apache.drill.exec.exception.OutOfMemoryException;
import oadd.org.apache.drill.exec.exception.OversizedAllocationException;
import oadd.org.apache.drill.exec.expr.holders.Decimal28SparseHolder;
import oadd.org.apache.drill.exec.expr.holders.NullableDecimal28SparseHolder;
import oadd.org.apache.drill.exec.memory.BufferAllocator;
import oadd.org.apache.drill.exec.proto.UserBitShared;
import oadd.org.apache.drill.exec.record.MaterializedField;
import oadd.org.apache.drill.exec.record.TransferPair;
import oadd.org.apache.drill.exec.util.DecimalUtility;
import oadd.org.apache.drill.exec.vector.BaseDataValueVector;
import oadd.org.apache.drill.exec.vector.BaseValueVector;
import oadd.org.apache.drill.exec.vector.FixedWidthVector;
import oadd.org.apache.drill.exec.vector.ValueVector;
import oadd.org.apache.drill.exec.vector.VectorTrimmer;
import oadd.org.apache.drill.exec.vector.complex.impl.Decimal28SparseReaderImpl;
import oadd.org.apache.drill.exec.vector.complex.reader.FieldReader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class Decimal28SparseVector
extends BaseDataValueVector
implements FixedWidthVector {
    private static final Logger logger = LoggerFactory.getLogger(Decimal28SparseVector.class);
    private final FieldReader reader = new Decimal28SparseReaderImpl(this);
    private final Accessor accessor = new Accessor();
    private final Mutator mutator = new Mutator();
    private int allocationSizeInBytes = 81920;
    private int allocationMonitor = 0;

    public Decimal28SparseVector(MaterializedField field, BufferAllocator allocator) {
        super(field, allocator);
    }

    @Override
    public FieldReader getReader() {
        return this.reader;
    }

    @Override
    public int getBufferSizeFor(int valueCount) {
        if (valueCount == 0) {
            return 0;
        }
        return valueCount * 20;
    }

    @Override
    public int getValueCapacity() {
        return (int)((double)this.data.capacity() * 1.0 / 20.0);
    }

    @Override
    public Accessor getAccessor() {
        return this.accessor;
    }

    @Override
    public Mutator getMutator() {
        return this.mutator;
    }

    @Override
    public void setInitialCapacity(int valueCount) {
        long size = 1L * (long)valueCount * 20L;
        if (size > Integer.MAX_VALUE) {
            throw new OversizedAllocationException("Requested amount of memory is more than max allowed allocation size");
        }
        this.allocationSizeInBytes = (int)size;
    }

    @Override
    public void allocateNew() {
        if (!this.allocateNewSafe()) {
            throw new OutOfMemoryException("Failure while allocating buffer.");
        }
    }

    @Override
    public boolean allocateNewSafe() {
        long curAllocationSize = this.allocationSizeInBytes;
        if (this.allocationMonitor > 10) {
            curAllocationSize = Math.max(8L, curAllocationSize / 2L);
            this.allocationMonitor = 0;
        } else if (this.allocationMonitor < -2) {
            curAllocationSize = (long)this.allocationSizeInBytes * 2L;
            this.allocationMonitor = 0;
        }
        try {
            this.allocateBytes(curAllocationSize);
        }
        catch (DrillRuntimeException ex) {
            return false;
        }
        return true;
    }

    @Override
    public void allocateNew(int valueCount) {
        this.allocateBytes(valueCount * 20);
    }

    @Override
    public void reset() {
        this.allocationSizeInBytes = 4096;
        this.allocationMonitor = 0;
        this.zeroVector();
        super.reset();
    }

    private void allocateBytes(long size) {
        if (size > Integer.MAX_VALUE) {
            throw new OversizedAllocationException("Requested amount of memory is more than max allowed allocation size");
        }
        int curSize = (int)size;
        this.clear();
        this.data = this.allocator.buffer(curSize);
        this.data.readerIndex(0);
        this.allocationSizeInBytes = curSize;
    }

    public void reAlloc() {
        long newAllocationSize = (long)this.allocationSizeInBytes * 2L;
        if (newAllocationSize > Integer.MAX_VALUE) {
            throw new OversizedAllocationException("Unable to expand the buffer. Max allowed buffer size is reached.");
        }
        logger.debug("Reallocating vector [{}]. # of bytes: [{}] -> [{}]", this.field, this.allocationSizeInBytes, newAllocationSize);
        DrillBuf newBuf = this.allocator.buffer((int)newAllocationSize);
        newBuf.setBytes(0, this.data, 0, this.data.capacity());
        int halfNewCapacity = newBuf.capacity() / 2;
        newBuf.setZero(halfNewCapacity, halfNewCapacity);
        newBuf.writerIndex(this.data.writerIndex());
        this.data.release(1);
        this.data = newBuf;
        this.allocationSizeInBytes = (int)newAllocationSize;
    }

    @Override
    public void zeroVector() {
        this.data.setZero(0, this.data.capacity());
    }

    @Override
    public void load(UserBitShared.SerializedField metadata, DrillBuf buffer) {
        Preconditions.checkArgument(this.field.matches(metadata), "The field %s doesn't match the provided metadata %s.", this.field, metadata);
        int actualLength = metadata.getBufferLength();
        int valueCount = metadata.getValueCount();
        int expectedLength = valueCount * 20;
        assert (actualLength == expectedLength) : String.format("Expected to load %d bytes but actually loaded %d bytes", expectedLength, actualLength);
        this.clear();
        if (this.data != null) {
            this.data.release(1);
        }
        this.data = buffer.slice(0, actualLength);
        this.data.retain(1);
        this.data.writerIndex(actualLength);
    }

    @Override
    public TransferPair getTransferPair(BufferAllocator allocator) {
        return new TransferImpl(this.getField(), allocator);
    }

    @Override
    public TransferPair getTransferPair(FieldReference ref, BufferAllocator allocator) {
        return new TransferImpl(this.getField().withPath(ref), allocator);
    }

    @Override
    public TransferPair makeTransferPair(ValueVector to) {
        return new TransferImpl((Decimal28SparseVector)to);
    }

    public void transferTo(Decimal28SparseVector target) {
        target.clear();
        target.data = this.data.transferOwnership((BufferAllocator)target.allocator).buffer;
        target.data.writerIndex(this.data.writerIndex());
        this.clear();
    }

    public void splitAndTransferTo(int startIndex, int length, Decimal28SparseVector target) {
        int startPoint = startIndex * 20;
        int sliceLength = length * 20;
        target.clear();
        target.data = this.data.slice((int)startPoint, (int)sliceLength).transferOwnership((BufferAllocator)target.allocator).buffer;
        target.data.writerIndex(sliceLength);
    }

    public void copyFrom(int fromIndex, int thisIndex, Decimal28SparseVector from) {
        from.data.getBytes(fromIndex * 20, this.data, thisIndex * 20, 20);
    }

    public void copyFromSafe(int fromIndex, int thisIndex, Decimal28SparseVector from) {
        while (thisIndex >= this.getValueCapacity()) {
            this.reAlloc();
        }
        this.copyFrom(fromIndex, thisIndex, from);
    }

    public void decrementAllocationMonitor() {
        if (this.allocationMonitor > 0) {
            this.allocationMonitor = 0;
        }
        --this.allocationMonitor;
    }

    private void incrementAllocationMonitor() {
        ++this.allocationMonitor;
    }

    public final class Mutator
    extends BaseValueVector.BaseMutator {
        private Mutator() {
        }

        public void set(int index, DrillBuf value) {
            Decimal28SparseVector.this.data.setBytes(index * 20, value, 0, 20);
        }

        public void setSafe(int index, DrillBuf value) {
            while (index >= Decimal28SparseVector.this.getValueCapacity()) {
                Decimal28SparseVector.this.reAlloc();
            }
            Decimal28SparseVector.this.data.setBytes(index * 20, value, 0, 20);
        }

        public void set(int index, Decimal28SparseHolder holder) {
            this.set(index, holder.start, holder.buffer);
        }

        void set(int index, NullableDecimal28SparseHolder holder) {
            this.set(index, holder.start, holder.buffer);
        }

        public void setSafe(int index, NullableDecimal28SparseHolder holder) {
            this.setSafe(index, holder.start, holder.buffer);
        }

        public void setSafe(int index, Decimal28SparseHolder holder) {
            this.setSafe(index, holder.start, holder.buffer);
        }

        public void setSafe(int index, int start, DrillBuf buffer) {
            while (index >= Decimal28SparseVector.this.getValueCapacity()) {
                Decimal28SparseVector.this.reAlloc();
            }
            this.set(index, start, buffer);
        }

        public void set(int index, int start, DrillBuf buffer) {
            Decimal28SparseVector.this.data.setBytes(index * 20, buffer, start, 20);
        }

        @Override
        public void generateTestData(int count) {
            this.setValueCount(count);
            boolean even = true;
            int valueCount = Decimal28SparseVector.this.getAccessor().getValueCount();
            for (int i = 0; i < valueCount; ++i) {
                byte b = even ? (byte)-128 : 127;
                for (int w = 0; w < 20; ++w) {
                    Decimal28SparseVector.this.data.setByte(i + w, b);
                }
                even = !even;
            }
        }

        @Override
        public void setValueCount(int valueCount) {
            int currentValueCapacity = Decimal28SparseVector.this.getValueCapacity();
            int idx = 20 * valueCount;
            while (valueCount > Decimal28SparseVector.this.getValueCapacity()) {
                Decimal28SparseVector.this.reAlloc();
            }
            if (valueCount > 0 && currentValueCapacity > valueCount * 2) {
                Decimal28SparseVector.this.incrementAllocationMonitor();
            } else if (Decimal28SparseVector.this.allocationMonitor > 0) {
                Decimal28SparseVector.this.allocationMonitor = 0;
            }
            VectorTrimmer.trim(Decimal28SparseVector.this.data, idx);
            Decimal28SparseVector.this.data.writerIndex(valueCount * 20);
        }
    }

    public final class Accessor
    extends BaseValueVector.BaseAccessor {
        @Override
        public int getValueCount() {
            return Decimal28SparseVector.this.data.writerIndex() / 20;
        }

        @Override
        public boolean isNull(int index) {
            return false;
        }

        public DrillBuf get(int index) {
            return Decimal28SparseVector.this.data.slice(index * 20, 20);
        }

        public void get(int index, Decimal28SparseHolder holder) {
            holder.start = index * 20;
            holder.buffer = Decimal28SparseVector.this.data;
            holder.scale = Decimal28SparseVector.this.getField().getScale();
            holder.precision = Decimal28SparseVector.this.getField().getPrecision();
        }

        public void get(int index, NullableDecimal28SparseHolder holder) {
            holder.isSet = 1;
            holder.start = index * 20;
            holder.buffer = Decimal28SparseVector.this.data;
            holder.scale = Decimal28SparseVector.this.getField().getScale();
            holder.precision = Decimal28SparseVector.this.getField().getPrecision();
        }

        @Override
        public BigDecimal getObject(int index) {
            return DecimalUtility.getBigDecimalFromSparse(Decimal28SparseVector.this.data, index * 20, 5, Decimal28SparseVector.this.getField().getScale());
        }
    }

    private class TransferImpl
    implements TransferPair {
        private Decimal28SparseVector to;

        public TransferImpl(MaterializedField field, BufferAllocator allocator) {
            this.to = new Decimal28SparseVector(field, allocator);
        }

        public TransferImpl(Decimal28SparseVector to) {
            this.to = to;
        }

        @Override
        public Decimal28SparseVector getTo() {
            return this.to;
        }

        @Override
        public void transfer() {
            Decimal28SparseVector.this.transferTo(this.to);
        }

        @Override
        public void splitAndTransfer(int startIndex, int length) {
            Decimal28SparseVector.this.splitAndTransferTo(startIndex, length, this.to);
        }

        @Override
        public void copyValueSafe(int fromIndex, int toIndex) {
            this.to.copyFromSafe(fromIndex, toIndex, Decimal28SparseVector.this);
        }
    }
}

