/*
 * Decompiled with CFR 0.152.
 */
package oadd.org.apache.drill.exec.server.options;

import java.util.Iterator;
import oadd.com.google.common.collect.Iterables;
import oadd.org.apache.drill.exec.server.options.BaseOptionManager;
import oadd.org.apache.drill.exec.server.options.OptionList;
import oadd.org.apache.drill.exec.server.options.OptionManager;
import oadd.org.apache.drill.exec.server.options.OptionValidator;
import oadd.org.apache.drill.exec.server.options.OptionValue;
import oadd.org.apache.drill.exec.server.options.SystemOptionManager;

public abstract class FallbackOptionManager
extends BaseOptionManager {
    protected final OptionManager fallback;

    public FallbackOptionManager(OptionManager fallback) {
        this.fallback = fallback;
    }

    @Override
    public Iterator<OptionValue> iterator() {
        return Iterables.concat(this.fallback, this.getLocalOptions()).iterator();
    }

    @Override
    public OptionValue getOption(String name) {
        OptionValue value = this.getLocalOption(name);
        if (value == null && this.fallback != null) {
            return this.fallback.getOption(name);
        }
        return value;
    }

    abstract Iterable<OptionValue> getLocalOptions();

    abstract OptionValue getLocalOption(String var1);

    abstract boolean setLocalOption(OptionValue var1);

    abstract boolean deleteAllLocalOptions(OptionValue.OptionType var1);

    abstract boolean deleteLocalOption(String var1, OptionValue.OptionType var2);

    @Override
    public void setOption(OptionValue value) {
        OptionValidator validator = SystemOptionManager.getValidator(value.name);
        validator.validate(value);
        if (!this.setLocalOption(value)) {
            this.fallback.setOption(value);
        }
    }

    @Override
    public void deleteOption(String name, OptionValue.OptionType type) {
        SystemOptionManager.getValidator(name);
        if (!this.deleteLocalOption(name, type)) {
            this.fallback.deleteOption(name, type);
        }
    }

    @Override
    public void deleteAllOptions(OptionValue.OptionType type) {
        if (!this.deleteAllLocalOptions(type)) {
            this.fallback.deleteAllOptions(type);
        }
    }

    @Override
    public OptionList getOptionList() {
        OptionList list = new OptionList();
        for (OptionValue value : this.getLocalOptions()) {
            list.add(value);
        }
        return list;
    }
}

