/*
 * Decompiled with CFR 0.152.
 */
package oadd.org.apache.drill.exec.server;

import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import oadd.com.google.common.annotations.VisibleForTesting;
import oadd.com.google.common.base.Stopwatch;
import oadd.org.apache.drill.common.AutoCloseables;
import oadd.org.apache.drill.common.StackTrace;
import oadd.org.apache.drill.common.config.DrillConfig;
import oadd.org.apache.drill.common.scanner.ClassPathScanner;
import oadd.org.apache.drill.common.scanner.persistence.ScanResult;
import oadd.org.apache.drill.exec.coord.ClusterCoordinator;
import oadd.org.apache.drill.exec.coord.zk.ZKClusterCoordinator;
import oadd.org.apache.drill.exec.exception.DrillbitStartupException;
import oadd.org.apache.drill.exec.proto.CoordinationProtos;
import oadd.org.apache.drill.exec.server.BootStrapContext;
import oadd.org.apache.drill.exec.server.DrillbitContext;
import oadd.org.apache.drill.exec.server.RemoteServiceSet;
import oadd.org.apache.drill.exec.server.StartupOptions;
import oadd.org.apache.drill.exec.server.options.OptionValue;
import oadd.org.apache.drill.exec.server.options.SystemOptionManager;
import oadd.org.apache.drill.exec.server.rest.WebServer;
import oadd.org.apache.drill.exec.service.ServiceEngine;
import oadd.org.apache.drill.exec.store.StoragePluginRegistry;
import oadd.org.apache.drill.exec.store.sys.CachingStoreProvider;
import oadd.org.apache.drill.exec.store.sys.PStoreProvider;
import oadd.org.apache.drill.exec.store.sys.PStoreRegistry;
import oadd.org.apache.drill.exec.store.sys.local.LocalPStoreProvider;
import oadd.org.apache.drill.exec.work.WorkManager;
import oadd.org.apache.zookeeper.Environment;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Drillbit
implements AutoCloseable {
    private static final Logger logger = LoggerFactory.getLogger(Drillbit.class);
    private static final String SYSTEM_OPTIONS_NAME = "oadd.org.apache.drill.exec.server.Drillbit.system_options";
    private boolean isClosed = false;
    private final ClusterCoordinator coord;
    private final ServiceEngine engine;
    private final PStoreProvider storeProvider;
    private final WorkManager manager;
    private final BootStrapContext context;
    private final WebServer webServer;
    private ClusterCoordinator.RegistrationHandle registrationHandle;
    private volatile StoragePluginRegistry storageRegistry;

    @VisibleForTesting
    public Drillbit(DrillConfig config, RemoteServiceSet serviceSet) throws Exception {
        this(config, serviceSet, ClassPathScanner.fromPrescan(config));
    }

    public Drillbit(DrillConfig config, RemoteServiceSet serviceSet, ScanResult classpathScan) throws Exception {
        Stopwatch w = new Stopwatch().start();
        logger.debug("Construction started.");
        boolean allowPortHunting = serviceSet != null;
        this.context = new BootStrapContext(config, classpathScan);
        this.manager = new WorkManager(this.context);
        this.engine = new ServiceEngine(this.manager.getControlMessageHandler(), this.manager.getUserWorker(), this.context, this.manager.getWorkBus(), this.manager.getBee(), allowPortHunting);
        this.webServer = new WebServer(config, this.context.getMetrics(), this.manager);
        if (serviceSet != null) {
            this.coord = serviceSet.getCoordinator();
            this.storeProvider = new CachingStoreProvider((PStoreProvider)new LocalPStoreProvider(config));
        } else {
            this.coord = new ZKClusterCoordinator(config);
            this.storeProvider = new PStoreRegistry(this.coord, config).newPStoreProvider();
        }
        logger.info("Construction completed ({} ms).", (Object)w.elapsed(TimeUnit.MILLISECONDS));
    }

    public void run() throws Exception {
        Stopwatch w = new Stopwatch().start();
        logger.debug("Startup begun.");
        this.coord.start(10000L);
        this.storeProvider.start();
        CoordinationProtos.DrillbitEndpoint md = this.engine.start();
        this.manager.start(md, this.engine.getController(), this.engine.getDataConnectionCreator(), this.coord, this.storeProvider);
        DrillbitContext drillbitContext = this.manager.getContext();
        this.storageRegistry = drillbitContext.getStorage();
        this.storageRegistry.init();
        drillbitContext.getOptionManager().init();
        this.javaPropertiesToSystemOptions();
        this.registrationHandle = this.coord.register(md);
        this.webServer.start();
        Runtime.getRuntime().addShutdownHook(new ShutdownThread(this, new StackTrace()));
        logger.info("Startup completed ({} ms).", (Object)w.elapsed(TimeUnit.MILLISECONDS));
    }

    @Override
    public synchronized void close() {
        if (this.isClosed) {
            return;
        }
        Stopwatch w = new Stopwatch().start();
        logger.debug("Shutdown begun.");
        this.manager.waitToExit();
        if (this.coord != null && this.registrationHandle != null) {
            this.coord.unregister(this.registrationHandle);
        }
        try {
            Thread.sleep(this.context.getConfig().getInt("drill.exec.zk.refresh") * 2);
        }
        catch (InterruptedException e) {
            logger.warn("Interrupted while sleeping during coordination deregistration.");
            Thread.currentThread().interrupt();
        }
        try {
            AutoCloseables.close(new AutoCloseable[]{this.webServer, this.engine, this.storeProvider, this.coord, this.manager, this.storageRegistry, this.context});
        }
        catch (Exception e) {
            logger.warn("Failure on close()", e);
        }
        logger.info("Shutdown completed ({} ms).", (Object)w.elapsed(TimeUnit.MILLISECONDS));
        this.isClosed = true;
    }

    private void javaPropertiesToSystemOptions() {
        String[] systemProps;
        String allSystemProps = System.getProperty(SYSTEM_OPTIONS_NAME);
        if (allSystemProps == null || allSystemProps.isEmpty()) {
            return;
        }
        SystemOptionManager optionManager = this.getContext().getOptionManager();
        for (String systemProp : systemProps = allSystemProps.split(",")) {
            OptionValue defaultValue;
            String optionString;
            String optionName;
            String[] keyValue = systemProp.split("=");
            if (keyValue.length != 2) {
                Drillbit.throwInvalidSystemOption(systemProp, "does not contain a key=value assignment");
            }
            if ((optionName = keyValue[0].trim()).isEmpty()) {
                Drillbit.throwInvalidSystemOption(systemProp, "does not contain a key before the assignment");
            }
            if ((optionString = Drillbit.stripQuotes(keyValue[1].trim(), systemProp)).isEmpty()) {
                Drillbit.throwInvalidSystemOption(systemProp, "does not contain a value after the assignment");
            }
            if ((defaultValue = optionManager.getOption(optionName)) == null) {
                Drillbit.throwInvalidSystemOption(systemProp, "does not specify a valid option name");
            }
            if (defaultValue.type != OptionValue.OptionType.SYSTEM) {
                Drillbit.throwInvalidSystemOption(systemProp, "does not specify a SYSTEM option ");
            }
            OptionValue optionValue = OptionValue.createOption(defaultValue.kind, OptionValue.OptionType.SYSTEM, optionName, optionString);
            optionManager.setOption(optionValue);
        }
    }

    public DrillbitContext getContext() {
        return this.manager.getContext();
    }

    public static void main(String[] cli) throws DrillbitStartupException {
        StartupOptions options = StartupOptions.parse(cli);
        Drillbit.start(options);
    }

    public static Drillbit start(StartupOptions options) throws DrillbitStartupException {
        return Drillbit.start(DrillConfig.create(options.getConfigLocation()), null);
    }

    public static Drillbit start(DrillConfig config) throws DrillbitStartupException {
        return Drillbit.start(config, null);
    }

    public static Drillbit start(DrillConfig config, RemoteServiceSet remoteServiceSet) throws DrillbitStartupException {
        Drillbit bit;
        logger.debug("Starting new Drillbit.");
        ScanResult classpathScan = ClassPathScanner.fromPrescan(config);
        try {
            bit = new Drillbit(config, remoteServiceSet, classpathScan);
        }
        catch (Exception ex) {
            throw new DrillbitStartupException("Failure while initializing values in Drillbit.", ex);
        }
        try {
            bit.run();
        }
        catch (Exception e) {
            bit.close();
            throw new DrillbitStartupException("Failure during initial startup of Drillbit.", e);
        }
        logger.debug("Started new Drillbit.");
        return bit;
    }

    private static void throwInvalidSystemOption(String systemProp, String errorMessage) {
        throw new IllegalStateException("Property \"org.apache.drill.exec.server.Drillbit.system_options\" part \"" + systemProp + "\" " + errorMessage + ".");
    }

    private static String stripQuotes(String s, String systemProp) {
        if (s.isEmpty()) {
            return s;
        }
        char cFirst = s.charAt(0);
        char cLast = s.charAt(s.length() - 1);
        if (cFirst == '\"' || cFirst == '\'') {
            if (cLast != cFirst) {
                Drillbit.throwInvalidSystemOption(systemProp, "quoted value does not have closing quote");
            }
            return s.substring(1, s.length() - 2);
        }
        if (cLast == '\"' || cLast == '\'') {
            Drillbit.throwInvalidSystemOption(systemProp, "value has unbalanced closing quote");
        }
        return s;
    }

    static {
        Environment.logEnv("Drillbit environment: ", logger);
    }

    private static class ShutdownThread
    extends Thread {
        private static final AtomicInteger idCounter = new AtomicInteger(0);
        private final Drillbit drillbit;
        private final StackTrace stackTrace;

        public ShutdownThread(Drillbit drillbit, StackTrace stackTrace) {
            this.drillbit = drillbit;
            this.stackTrace = stackTrace;
            this.setName("Drillbit-ShutdownHook#" + idCounter.getAndIncrement());
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            logger.info("Received shutdown request.");
            try {
                AtomicInteger atomicInteger = idCounter;
                synchronized (atomicInteger) {
                    this.drillbit.close();
                }
            }
            catch (Exception e) {
                throw new RuntimeException("Caught exception closing Drillbit started from\n" + this.stackTrace, e);
            }
        }
    }
}

