/*
 * Decompiled with CFR 0.152.
 */
package oadd.org.apache.drill.exec.server;

import java.util.concurrent.ExecutorService;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import oadd.com.codahale.metrics.MetricRegistry;
import oadd.io.netty.channel.EventLoopGroup;
import oadd.org.apache.drill.common.DrillAutoCloseables;
import oadd.org.apache.drill.common.config.DrillConfig;
import oadd.org.apache.drill.common.scanner.persistence.ScanResult;
import oadd.org.apache.drill.exec.memory.BufferAllocator;
import oadd.org.apache.drill.exec.memory.RootAllocatorFactory;
import oadd.org.apache.drill.exec.metrics.DrillMetrics;
import oadd.org.apache.drill.exec.rpc.NamedThreadFactory;
import oadd.org.apache.drill.exec.rpc.TransportCheck;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BootStrapContext
implements AutoCloseable {
    private static final Logger logger = LoggerFactory.getLogger(BootStrapContext.class);
    private final DrillConfig config;
    private final EventLoopGroup loop;
    private final EventLoopGroup loop2;
    private final MetricRegistry metrics;
    private final BufferAllocator allocator;
    private final ScanResult classpathScan;
    private final ExecutorService executor;

    public BootStrapContext(DrillConfig config, ScanResult classpathScan) {
        this.config = config;
        this.classpathScan = classpathScan;
        this.loop = TransportCheck.createEventLoopGroup(config.getInt("drill.exec.rpc.bit.server.threads"), "BitServer-");
        this.loop2 = TransportCheck.createEventLoopGroup(config.getInt("drill.exec.rpc.bit.server.threads"), "BitClient-");
        this.metrics = DrillMetrics.getInstance();
        this.allocator = RootAllocatorFactory.newRoot(config);
        this.executor = new ThreadPoolExecutor(0, Integer.MAX_VALUE, 60L, TimeUnit.SECONDS, new SynchronousQueue(), new NamedThreadFactory("drill-executor-")){

            @Override
            protected void afterExecute(Runnable r, Throwable t) {
                if (t != null) {
                    logger.error("{}.run() leaked an exception.", (Object)r.getClass().getName(), (Object)t);
                }
                super.afterExecute(r, t);
            }
        };
    }

    public ExecutorService getExecutor() {
        return this.executor;
    }

    public DrillConfig getConfig() {
        return this.config;
    }

    public EventLoopGroup getBitLoopGroup() {
        return this.loop;
    }

    public EventLoopGroup getBitClientLoopGroup() {
        return this.loop2;
    }

    public MetricRegistry getMetrics() {
        return this.metrics;
    }

    public BufferAllocator getAllocator() {
        return this.allocator;
    }

    public ScanResult getClasspathScan() {
        return this.classpathScan;
    }

    @Override
    public void close() {
        try {
            DrillMetrics.resetMetrics();
        }
        catch (Error | Exception e) {
            logger.warn("failure resetting metrics.", e);
        }
        if (this.executor != null) {
            this.executor.shutdown();
            try {
                if (!this.executor.awaitTermination(1L, TimeUnit.SECONDS)) {
                    this.executor.shutdownNow();
                    if (!this.executor.awaitTermination(1L, TimeUnit.SECONDS)) {
                        logger.error("Pool did not terminate");
                    }
                }
            }
            catch (InterruptedException ie) {
                logger.warn("Executor interrupted while awaiting termination");
                this.executor.shutdownNow();
                Thread.currentThread().interrupt();
            }
        }
        DrillAutoCloseables.closeNoChecked(this.allocator);
    }
}

