/*
 * Decompiled with CFR 0.152.
 */
package oadd.org.apache.drill.exec.schema;

import java.util.ArrayList;
import java.util.Map;
import oadd.com.google.common.base.Predicate;
import oadd.com.google.common.collect.Iterables;
import oadd.com.google.common.collect.Lists;
import oadd.com.google.common.collect.Maps;
import oadd.org.apache.drill.exec.schema.Field;
import oadd.org.apache.drill.exec.schema.RecordSchema;

public class ObjectSchema
implements RecordSchema {
    private final Map<String, Field> fields = Maps.newHashMap();

    @Override
    public void addField(Field field) {
        this.fields.put(field.getFieldName(), field);
    }

    @Override
    public Field getField(String fieldName, int index) {
        return this.fields.get(fieldName);
    }

    @Override
    public void removeField(Field field, int index) {
        this.fields.remove(field.getFieldName());
    }

    @Override
    public Iterable<? extends Field> getFields() {
        return this.fields.values();
    }

    @Override
    public String toSchemaString() {
        StringBuilder builder = new StringBuilder("Object_fields:[");
        for (Field field : this.fields.values()) {
            builder.append(field.toString()).append(" ");
        }
        builder.append("]");
        return builder.toString();
    }

    @Override
    public void resetMarkedFields() {
        for (Field field : this.fields.values()) {
            field.setRead(false);
        }
    }

    @Override
    public Iterable<? extends Field> removeUnreadFields() {
        final ArrayList removedFields = Lists.newArrayList();
        Iterables.removeIf(this.fields.values(), new Predicate<Field>(){

            @Override
            public boolean apply(Field field) {
                if (!field.isRead()) {
                    removedFields.add(field);
                    return true;
                }
                if (field.hasSchema()) {
                    Iterables.addAll(removedFields, field.getAssignedSchema().removeUnreadFields());
                }
                return false;
            }
        });
        return removedFields;
    }
}

